/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.httpcli.exec;

import java.io.FileNotFoundException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.httpcli.com.SJhtclDef;
import sanproject.sn2.httpcli.com.SJhtclHttpCliUty;
import sanproject.sn2.httpcli.com.SJhtclParameterUty;
import sanproject.sn2.httpcli.com.SJhtclRelocationLogUty;
import sanproject.sn2.httpcli.exec.SJhtclExecBase;
import sanproject.sn2.httpcli.exec.com.SJhtclRelocationLogRMIUtility;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;

public class SJhtclRelocationLogCreate
extends SJhtclExecBase {
    private static final String LOG_FUNCTION = "HTTP_CLI";
    private static final String LOG_TITLE = SJhtclRelocationLogCreate.class.getSimpleName();

    public SJhtclRelocationLogCreate(SJbaseUserSessionInterface session, Map requestMap) {
        super(session, requestMap);
    }

    @Override
    protected boolean checkRole() {
        boolean bResult = false;
        SJcRoleResourceContainer resourceContainer = this.session.getRoleResourceInfo();
        if (resourceContainer.checkAuthority(32)) {
            bResult = true;
        }
        return bResult;
    }

    @Override
    protected boolean checkPP() {
        boolean bResult = false;
        if (this.isEnablePP(SJctrLicenseContainer.PPID_SN)) {
            bResult = true;
        }
        return bResult;
    }

    @Override
    protected HashMap<String, Object> executeCommand() {
        String LOG_SUBTITLE = "executeCommand";
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "executeCommand", "Start.");
        HashMap<String, Object> responseMap = new HashMap();
        try {
            try {
                List<String> strFileList = SJhtclRelocationLogUty.getRelocationLogFileList();
                if (1 <= strFileList.size()) {
                    htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "RelocationLog is Exists.");
                    responseMap = SJhtclHttpCliUty.getErrorMapCmd("107026");
                    return responseMap;
                }
            }
            catch (FileNotFoundException ex) {
                htclLogger.info(LOG_FUNCTION, LOG_TITLE, "executeCommand", "DirectoryNotFound. directoryPath:" + ex.getMessage());
            }
            Date dtCreateTime = new Date();
            String strLogName = SJhtclParameterUty.getStrFromMap(this.requestMap, "logname");
            if (strLogName == null || strLogName.length() == 0) {
                SimpleDateFormat df = new SimpleDateFormat("yyMMdd");
                String strCreateYMD = df.format(dtCreateTime);
                SJmoSubsystemInfo subsysInfo = SJhtclHttpCliUty.getSubsysInfo();
                strLogName = String.format("%s-%s-RelocationLog", strCreateYMD, subsysInfo.getDKCSNString());
            }
            if (32 < strLogName.trim().length()) {
                htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "LOGNAME_MAX_SIZE_ERROR");
                responseMap = SJhtclHttpCliUty.getErrorMapCmd("107021");
                return responseMap;
            }
            for (String strCheck : SJhtclDef.ReportCheckList) {
                if (strLogName.indexOf(strCheck) < 0) continue;
                htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "LOGNAME_INPUT_CHECK_ERROR");
                responseMap = SJhtclHttpCliUty.getErrorMapCmd("107022");
                return responseMap;
            }
            SJhtclRelocationLogRMIUtility.createRelocationLog(strLogName, dtCreateTime);
            HashMap<String, Date> logInfMap = new HashMap<String, Date>();
            logInfMap.put(strLogName, dtCreateTime);
            String strResult = SJhtclRelocationLogUty.createResponseContents(logInfMap, this.session);
            responseMap.put("ResponseKeyType", "TXT");
            responseMap.put("Text", strResult);
        }
        catch (SJcException ex) {
            htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "Catch SJceException ex:" + ex);
            responseMap = SJhtclHttpCliUty.getErrorMap(ex.getMsg());
            return responseMap;
        }
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "executeCommand", "End.");
        return responseMap;
    }
}

