/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.httpcli.exec;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.REPORTReportInfo;
import sanproject.serverux.dataimpl.REPORTgetReportHistory;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.httpcli.com.SJhtclHttpCliUty;
import sanproject.sn2.httpcli.com.SJhtclReportUty;
import sanproject.sn2.httpcli.exec.SJhtclExecBase;
import sanproject.sn2.httpcli.exec.com.SJhtclReportRMIUtility;

public class SJhtclReportList
extends SJhtclExecBase {
    private static final String LOG_FUNCTION = "HTTP_CLI";
    private static final String LOG_TITLE = SJhtclReportList.class.getSimpleName();

    public SJhtclReportList(SJbaseUserSessionInterface session, Map requestMap) {
        super(session, requestMap);
        htclLogger = SJhtclHttpCliUty.getHtclLogger();
    }

    @Override
    protected HashMap<String, Object> executeCommand() {
        String LOG_SUBTITLE = "executeCommand";
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "executeCommand", "Start.");
        HashMap<String, Object> responseMap = new HashMap();
        try {
            REPORTgetReportHistory reportHistory = SJhtclReportRMIUtility.getReportList();
            REPORTReportInfo[] reportArray = reportHistory.getReportList();
            List<REPORTReportInfo> reportList = Arrays.asList(reportArray);
            String result = SJhtclReportUty.reportListFormmat(reportList, this.session, true);
            responseMap = SJhtclHttpCliUty.getTextMap(result);
        }
        catch (SJcException ex) {
            htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "Catch SJceException ex:" + ex);
            responseMap = SJhtclHttpCliUty.getErrorMap(ex.getMsg());
            return responseMap;
        }
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "executeCommand", "End.");
        return responseMap;
    }

    @Override
    protected boolean checkRole() {
        boolean res = false;
        SJcRoleResourceContainer role = this.session.getRoleResourceInfo();
        if (role.checkAuthority(32)) {
            res = true;
        }
        return res;
    }

    @Override
    protected boolean checkPP() {
        boolean res = false;
        if (this.isEnablePP(SJctrLicenseContainer.PPID_SN)) {
            res = true;
        }
        return res;
    }
}

