/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.httpcli.exec.com;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.httpcli.com.SJhtclHttpCliUty;
import sanproject.sn2.httpcli.exec.com.SJhtclRelocationLogApplyTaskManager;
import sanproject.sn2.model.SJmoModelMgr;
import sanproject.sn2.model.inf.SJmoKeyValueDefine_IF;

public class SJhtclRelocationLogRMIUtility
implements SJmoKeyValueDefine_IF {
    private static final String LOG_FUNCTION = "HTTP_CLI";
    private static final String LOG_TITLE = SJhtclRelocationLogRMIUtility.class.getSimpleName();
    public static final long RESOURCE_LOCK_ID_INVALID = -1L;
    public static final int TYPE_RELOCATIONLOG_CLI = 1;
    public static final int KEY_VALUE_NORMAL_END = 0;
    private static final String FUNC_ID_CREATE_RELOCATION_LOG = "VVOLcreateRelocationLog";
    private static final String FUNC_ID_DELETE_RELOCATION_LOG = "VVOLdeleteRelocationLog";
    private static final String LOG_INFO_KEY = "LogInfo";
    private static final String TYPE_KEY = "Type";
    private static final String FILE_KEY = "File";
    private static final String NAME_KEY = "Name";
    private static final String CREATE_TIME_KEY = "CreateTime";

    private static Object applyRelocationLog(SanRequest request) throws SJcException {
        SanResponse retObj = null;
        try {
            retObj = SJmoModelMgr.getModelMgr().getSupplierMgr().getAgent().getDataInf(request, false);
        }
        catch (SJcException sjcEx) {
            SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "applyRelocationLog", "Failed to Apply.", sjcEx);
            throw sjcEx;
        }
        catch (Exception ex) {
            SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "applyRelocationLog", "Failed to Apply. (Internal Error)", ex);
            SJcException sjcEx = new SJcException("205", "25", "107010");
            throw sjcEx;
        }
        return retObj;
    }

    public static void createRelocationLog(String relocLogName, Date date) throws SJcException {
        String LOG_SUBTITLE = "createRelocationLog";
        try {
            int[] cTimeArray = SJhtclRelocationLogRMIUtility.getCalParam(date);
            SanRequest request = SJmoModelMgr.getModelMgr().getSupplierMgr().getAgent().newRequest(FUNC_ID_CREATE_RELOCATION_LOG);
            SanObject logInfo = request.newObj(LOG_INFO_KEY);
            SanObject file = logInfo.newObj(FILE_KEY);
            logInfo.putInt(TYPE_KEY, 1);
            file.putString(NAME_KEY, relocLogName);
            file.putIntArray(CREATE_TIME_KEY, cTimeArray);
            SJhtclRelocationLogApplyTaskManager mgr = SJhtclRelocationLogApplyTaskManager.getRelocationLogApplyTaskMgr();
            Map<String, String> codeMap = mgr.createRelocationLogApplyTask(request, "add", date);
            String errCode = codeMap.get("errCode");
            if (!errCode.equals("")) {
                SJcException sjcEx = new SJcException("205", "25", errCode);
                throw sjcEx;
            }
            String taskCode = codeMap.get("taskCode");
            mgr.execRelocationLogApplyTask(taskCode);
        }
        catch (SJcException sjcEx) {
            SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "createRelocationLog", "Failed to create.", sjcEx);
            throw sjcEx;
        }
        catch (Exception e) {
            SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "createRelocationLog", "Failed to create. (Internal Error)", e);
            SJcException sjcEx = new SJcException("205", "25", "107010");
            throw sjcEx;
        }
    }

    public static void removeRelocationLog(String relocLogName) throws SJcException {
        String LOG_SUBTITLE = "removeRelocationLog";
        Date date = new Date();
        SJhtclRelocationLogApplyTaskManager mgr = SJhtclRelocationLogApplyTaskManager.getRelocationLogApplyTaskMgr();
        String taskCode = "";
        try {
            SanResponse response;
            SanRequest request = SJmoModelMgr.getModelMgr().getSupplierMgr().getAgent().newRequest(FUNC_ID_DELETE_RELOCATION_LOG);
            SanObject logInfo = request.newObj(LOG_INFO_KEY);
            SanObject file = logInfo.newObj(FILE_KEY);
            logInfo.putInt(TYPE_KEY, 1);
            file.putString(NAME_KEY, relocLogName);
            Map<String, String> codeMap = mgr.createRelocationLogApplyTask(request, "delete", date);
            taskCode = codeMap.get("taskCode");
            String errCode = codeMap.get("errCode");
            if (errCode.equals("")) {
                response = (SanResponse)SJhtclRelocationLogRMIUtility.applyRelocationLog(request);
                if (response == null) {
                    SJhtclRelocationLogRMIUtility.putLogThrowExp("removeRelocationLog", "Failed to apply.");
                }
            } else {
                SJcException sjcEx = new SJcException("205", "25", errCode);
                throw sjcEx;
            }
            SJhtclRelocationLogRMIUtility.checkErrorInfo(response);
            mgr.endTask(taskCode);
        }
        catch (SJcException sjcEx) {
            mgr.errorTask(taskCode);
            SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "removeRelocationLog", "Failed to remove.", sjcEx);
            throw sjcEx;
        }
        catch (Exception e) {
            mgr.errorTask(taskCode);
            SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "removeRelocationLog", "Failed to remove. (Internal Error)", e);
            SJcException sjcEx = new SJcException("205", "25", "107010");
            throw sjcEx;
        }
    }

    private static int[] getCalParam(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int[] calParam = new int[]{year, month, day, hour, minute, second};
        return calParam;
    }

    private static void checkErrorInfo(SanResponse response) {
        String LOG_SUBTITLE = "checkErrorInfo";
        try {
            int errCodeNum = response.errorCode();
            if (errCodeNum != 0) {
                SanObject errInfo = response.getObj("ErrorInfo");
                if (errInfo != null) {
                    int[] msgIdList = errInfo.getIntArray("MessageId");
                    if (msgIdList != null && msgIdList.length == 2) {
                        int errorCode = msgIdList[1];
                        if (errorCode != 0) {
                            SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "checkErrorInfo", "errorCode is invalid");
                            String errCode = String.valueOf(errorCode);
                            SJcException sjcEx = new SJcException("205", "25", errCode);
                            throw sjcEx;
                        }
                    } else {
                        SJhtclRelocationLogRMIUtility.putLogThrowExp("checkErrorInfo", "msgIdList is null or msgIdList length is invalid");
                    }
                } else {
                    SJhtclRelocationLogRMIUtility.putLogThrowExp("checkErrorInfo", "errInfo is null");
                }
            }
        }
        catch (SanDataException e) {
            SJhtclRelocationLogRMIUtility.putLogThrowExp("checkErrorInfo", "SanDataException is occured");
        }
    }

    private static void putLogThrowExp(String strMethodName, String strLog) {
        SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, strMethodName, strLog);
        SJcException sjcEx = new SJcException("205", "25", "107010");
        throw sjcEx;
    }
}

