/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.httpcli.exec.com;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import sanproject.common.Robj_interface_AuditUserInfo;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterfaceInternal;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.SJcBitSetUty;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.httpcli.com.SJhtclHttpCliUty;
import sanproject.sn2.httpcli.exec.com.SJhtclReportRMIUtility;
import sanproject.sn2.model.SJmoModelMgr;

public class SJhtclReportApplyTask
extends Thread {
    private static final String LOG_FUNCTION = "HTTP_CLI";
    private static final String LOG_TITLE = SJhtclReportApplyTask.class.getSimpleName();
    public static final int TASK_STATUS_INIT = 0;
    public static final int TASK_STATUS_WAIT = 1;
    public static final int TASK_STATUS_EXEC = 2;
    public static final int TASK_STATUS_END = 3;
    public static final int TASK_STATUS_ERR = 4;
    private ArrayList<Object> applyList = null;
    private String taskName = "";
    private SJbaseUserSessionInterface session = null;
    private Date startDate = null;
    private Date endDate = null;
    private Robj_interface_AuditUserInfo userInfo = null;
    private BitSet lockBit = null;
    private int taskStatus = 0;
    private SJcMessage msg = null;
    private Object result = null;
    private long rscLockId = -1L;

    public SJhtclReportApplyTask(ArrayList<Object> applyList, String taskName, SJbaseUserSessionInterface session, Date startDate) {
        this.applyList = applyList;
        this.taskName = taskName;
        this.session = session;
        this.startDate = startDate;
    }

    public void init() {
        try {
            SJcRoleResourceContainer roleResource = this.session.getRoleResourceInfo();
            if (null == roleResource) {
                SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "init", "The role information does not exist. (Internal Error)");
                SJcException sjcEx = new SJcException("205", "25", "107010");
                throw sjcEx;
            }
            boolean[] resourceArray = roleResource.getResourceGroup();
            this.lockBit = SJcBitSetUty.booolean2bitset(resourceArray);
            this.rscLockId = SJhtclReportRMIUtility.lock((SJbaseUserSessionInterfaceInternal)this.session, this.lockBit);
        }
        catch (SJcException sjcEx) {
            this.endDate = new Date();
            SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "init", "Failed to initialize.", sjcEx);
            this.msg = sjcEx.getMsg();
            this.taskStatus = 4;
            throw sjcEx;
        }
        catch (Exception ex) {
            this.endDate = new Date();
            SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "init", "Failed to initialize. (Internal Error)", ex);
            SJcException sjcEx = new SJcException("205", "25", "107010");
            this.msg = sjcEx.getMsg();
            this.taskStatus = 4;
            throw sjcEx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.taskStatus = 2;
            this.result = SJmoModelMgr.getModelMgr().getSupplierMgr().getAgent().applyStart(this.rscLockId, this.applyList);
            this.endDate = new Date();
            this.taskStatus = 3;
        }
        catch (SJcException ex) {
            this.endDate = new Date();
            SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "run", this.taskName + " : The abnormal end of this execution processing was carried out.", ex);
            this.msg = ex.getMsg();
            this.taskStatus = 4;
        }
        catch (Exception ex) {
            this.endDate = new Date();
            SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "run", this.taskName + "The abnormal end of this execution processing was carried out. (Internal Error)", ex);
            SJcException sjcEx = new SJcException("205", "25", "107010");
            this.msg = sjcEx.getMsg();
            this.taskStatus = 4;
        }
        finally {
            SJcRoleResourceContainer roleResource = this.session.getRoleResourceInfo();
            SJhtclReportRMIUtility.unlock(this.rscLockId, this.lockBit, roleResource);
        }
    }

    public String getTaskName() {
        return this.taskName;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public int getTaskStatus() {
        return this.taskStatus;
    }

    public SJcMessage getMsg() {
        return this.msg;
    }

    public void setMsg(SJcMessage msg) {
        this.msg = msg;
    }

    public Object getResult() {
        return this.result;
    }
}

