/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.httpcli.request;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcWordUty;
import sanproject.sn2.httpcli.com.SJhtclHttpCliUty;
import sanproject.sn2.httpcli.com.SJhtclParameterUty;
import sanproject.sn2.httpcli.request.inf.SJhtclRequestInterface;

public class SJhtclRequestLogout
implements SJhtclRequestInterface {
    private static String LOG_FUNCTION = "HTTP_CLI";
    private static String LOG_TITLE = SJhtclRequestLogout.class.getSimpleName();
    private static SJcLoggerInterface htclLogger = null;

    public SJhtclRequestLogout() {
        htclLogger = SJhtclHttpCliUty.getHtclLogger();
    }

    @Override
    public HashMap<String, Object> processRequest(HttpServletRequest req) {
        String LOG_SUBTITLE = "processRequest";
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "processRequest", "Start.");
        HashMap<String, Object> responseMap = null;
        if (!this.checkParameters(req.getParameterMap())) {
            responseMap = SJhtclHttpCliUty.getErrorMapBase("107003");
        } else {
            String sessionId = req.getParameter("GlobalSessionID");
            try {
                SJhtclHttpCliUty.getSessionManager().logout(sessionId);
            }
            catch (Throwable th) {
                htclLogger.error(LOG_FUNCTION, LOG_TITLE, "processRequest", "Failed to logout. -GlobalSessionID:" + sessionId, th);
            }
            String result = SJcWordUty.getGuidanceInfo("EN").getGuidance("XPDT_CLI_LOGOUT_RESULT");
            responseMap = SJhtclHttpCliUty.getTextMap(result);
        }
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "processRequest", "End.");
        return responseMap;
    }

    private boolean checkParameters(Map<String, Object> map) {
        String LOG_SUBTITLE = "checkParameters";
        boolean res = true;
        if (map == null) {
            htclLogger.error(LOG_FUNCTION, LOG_TITLE, "checkParameters", "map is null.");
            res = false;
        } else if (SJhtclParameterUty.getStrFromMap(map, "GlobalSessionID") == null) {
            htclLogger.error(LOG_FUNCTION, LOG_TITLE, "checkParameters", "GlobalSessionID is null.");
            res = false;
        }
        return res;
    }
}

