/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.kmip.client.convert;

import java.util.ArrayList;
import java.util.Date;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.kms.kmip.SJkmsKmipConst;
import sanproject.sn2.kms.kmip.client.exception.KeyInfoBlankException;
import sanproject.sn2.kms.kmip.client.exception.RequestCommandException;
import sanproject.sn2.kms.kmip.client.exception.ResponseException;
import sanproject.sn2.kms.kmip.client.info.KeyInfo;
import sanproject.sn2.kms.kmip.client.info.OutputInfo;
import sanproject.sn2.kms.kmip.client.info.common.Authentication;
import sanproject.sn2.kms.kmip.client.info.common.RequestHeaderContents;
import sanproject.sn2.kms.kmip.client.ttlv.TTLV;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVBoolean;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVByteString;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVDateTime;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVEnumeration;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVInteger;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVStructure;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVTextString;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public abstract class Converter {
    private static final String module = "Converter";
    public static final int KMIP_VERSION_MAJOR = 1;
    public static final int KMIP_VERSION_MINOR = 0;
    public static final int RS_SUCCESS = 0;
    public static final int RS_OPERATION_FAILED = 1;
    public static final int RS_OPERATION_PENDING = 2;
    public static final int RS_OPERATION_UNDONE = 3;
    protected int verMajor = 0;
    protected int verMinor = 0;
    protected Date date = null;
    protected int responseBatchCount = 0;
    protected String kmsName = null;

    public abstract TTLV makeSendTTLV(KeyInfo var1) throws RequestCommandException, KeyInfoBlankException;

    protected TTLV getRequestHeader(RequestHeaderContents rhc, int bc) throws KeyInfoBlankException {
        String method = "getRequestHeader";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        TTLVStructure tHeader = new TTLVStructure(119);
        TTLVStructure tVer = new TTLVStructure(105);
        tVer.addValue(new TTLVInteger(106, 1));
        tVer.addValue(new TTLVInteger(107, 0));
        tHeader.addValue(tVer);
        if (rhc != null) {
            if (rhc.getContents()[0]) {
                tHeader.addValue(new TTLVInteger(80, rhc.getMaximumResponseSize()));
            }
            if (rhc.getContents()[1]) {
                tHeader.addValue(new TTLVBoolean(7, rhc.getAsynchronousIndicator()));
            }
            if (rhc.getContents()[2]) {
                TTLVStructure tAuth = new TTLVStructure(12);
                tHeader.addValue(tAuth);
                TTLVStructure tCred = new TTLVStructure(35);
                tAuth.addValue(tCred);
                Authentication auth = rhc.getAuthentication();
                tCred.addValue(new TTLVEnumeration(36, auth.getCredentialType()));
                TTLVStructure tCredValue = new TTLVStructure(37);
                tCred.addValue(tCredValue);
                switch (auth.getCredentialType()) {
                    case 1: {
                        if (auth.getUsername() == null || auth.getUsername().length() < 0) {
                            throw new KeyInfoBlankException();
                        }
                        tCredValue.addValue(new TTLVTextString(-103, auth.getUsername()));
                        tCredValue.addValue(new TTLVTextString(-95, auth.getPassword()));
                        break;
                    }
                    case 2: {
                        tCredValue.addValue(new TTLVTextString(-80, auth.getDeviceSerialNumber()));
                        tCredValue.addValue(new TTLVTextString(-95, auth.getPassword()));
                        tCredValue.addValue(new TTLVTextString(-94, auth.getDeviceIdentifier()));
                        tCredValue.addValue(new TTLVTextString(-85, auth.getNetworkIdentifier()));
                        tCredValue.addValue(new TTLVTextString(-87, auth.getMachineIdentifier()));
                        tCredValue.addValue(new TTLVTextString(-86, auth.getMediaIdentifier()));
                    }
                }
            }
            if (rhc.getContents()[3]) {
                tHeader.addValue(new TTLVEnumeration(14, rhc.getBatchErrorContinuationOption()));
            }
            if (rhc.getContents()[4]) {
                tHeader.addValue(new TTLVBoolean(16, rhc.getBatchOrderOption()));
            }
            if (rhc.getContents()[5]) {
                tHeader.addValue(new TTLVDateTime(-110, rhc.getTimeStamp()));
            }
            tHeader.addValue(new TTLVInteger(13, rhc.getBatchCount()));
        } else {
            tHeader.addValue(new TTLVInteger(13, bc));
        }
        STD_LOGGER.info(module, method, " - ", " - end");
        return tHeader;
    }

    protected TTLVStructure getBatchItem(int operation) {
        String method = "getBatchItem";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        TTLVStructure tBI = new TTLVStructure(15);
        tBI.addValue(new TTLVEnumeration(92, operation));
        STD_LOGGER.info(module, method, " - ", " - end");
        return tBI;
    }

    protected TTLVStructure getBatchItem(int operation, int batchItemID) {
        String method = "getBatchItem";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        TTLVStructure tBI = this.getBatchItem(operation);
        TTLVByteString tBIID = new TTLVByteString(-109);
        ArrayList<Byte> batchID = new ArrayList<Byte>();
        TTLV.convertByte((long)batchItemID, batchID);
        tBIID.setValue(batchID);
        tBI.addValue(tBIID);
        STD_LOGGER.info(module, method, " - ", " - end");
        return tBI;
    }

    public void parseResvTTLV(TTLV resvTTLV, KeyInfo ki) {
        String method = "parseResvTTLV";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        try {
            this.checkTT(resvTTLV, (byte)123, (byte)1);
            TTLVStructure tReq = (TTLVStructure)resvTTLV;
            this.kmsName = tReq.getKms();
            if (tReq.getValueSize() < 1) {
                throw new ResponseException();
            }
            TTLV t = tReq.getValue(0);
            this.checkTT(t, (byte)122, (byte)1);
            TTLVStructure th = (TTLVStructure)t;
            this.checkValue(th, (byte)105, (byte)1, 1);
            TTLVStructure tp = (TTLVStructure)th.getValueList((byte)105).get(0);
            this.checkValue(tp, (byte)106, (byte)2, 1);
            TTLVInteger ti = (TTLVInteger)tp.getValueList((byte)106).get(0);
            this.verMajor = ti.getValue();
            STD_LOGGER.info(module, method, " - Protocol Version Major", " - " + this.verMajor);
            this.checkValue(tp, (byte)107, (byte)2, 1);
            ti = (TTLVInteger)tp.getValueList((byte)107).get(0);
            this.verMinor = ti.getValue();
            STD_LOGGER.info(module, method, " - Protocol Version Minor", " - " + this.verMinor);
            this.checkValue(th, (byte)-110, (byte)9, 1);
            TTLVDateTime dt = (TTLVDateTime)th.getValueList((byte)-110).get(0);
            ki.setKmsTimeStamp(dt.getValue());
            this.date = new Date(dt.getValue());
            STD_LOGGER.info(module, method, " - Date Time(Unix Time)", " - " + this.date);
            this.checkValue(th, (byte)13, (byte)2, 1);
            ti = (TTLVInteger)th.getValueList((byte)13).get(0);
            this.responseBatchCount = ti.getValue();
            STD_LOGGER.info(module, method, " - Batch Count", " - " + this.responseBatchCount);
            this.parseBatchItemList(tReq, ki);
        }
        catch (ResponseException exception) {
            OutputInfo outputInfo = new OutputInfo();
            outputInfo.setResultStatus("response error");
            outputInfo.setResultReason(exception.toString());
            STD_LOGGER.error(module, method, " - ", " - " + exception);
            ki.getOutputInfoList().add(outputInfo);
        }
        STD_LOGGER.info(module, method, " - ", " - end");
    }

    public abstract void parseBatchItemList(TTLVStructure var1, KeyInfo var2) throws ResponseException;

    protected void checkTT(TTLV t, byte tag, byte type) throws ResponseException {
        String method = "checkTT";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        if (t == null) {
            STD_LOGGER.info(module, method, " - check TTLV object", " - TTLV object is null");
            throw new ResponseException();
        }
        if (t.getTag() != tag) {
            STD_LOGGER.info(module, method, " - check Tag", " - invalid");
            throw new ResponseException();
        }
        if (t.getType() != type) {
            STD_LOGGER.info(module, method, " - check Type", " - invalid");
            throw new ResponseException();
        }
    }

    protected void checkValue(TTLVStructure ts, byte tag, byte type, int count) throws ResponseException {
        String method = "checkValue";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        if (ts == null) {
            STD_LOGGER.info(module, method, " - check TTLV structure", " - TTLV structure is null");
            throw new ResponseException();
        }
        if (ts.getValueSize(tag) != count) {
            STD_LOGGER.info(module, method, " - check Tag num", " - mismuch Tag num");
            throw new ResponseException();
        }
        ArrayList<TTLV> tList = ts.getValueList(tag);
        if (tList != null) {
            for (int i = 0; i < tList.size(); ++i) {
                if (tList.get(i).getType() == type) continue;
                STD_LOGGER.info(module, method, "check Type", " - mismuch Type");
                throw new ResponseException();
            }
        }
    }

    protected TTLVStructure checkBatchItem(TTLVStructure tBI, OutputInfo oi) throws ResponseException {
        String method = "checkBatchItem";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        this.checkTT(tBI, (byte)15, (byte)1);
        this.checkValue(tBI, (byte)92, (byte)5, 1);
        TTLVEnumeration tOP = (TTLVEnumeration)tBI.getValueList((byte)92).get(0);
        String operation = SJkmsKmipConst.OperationMap.get(tOP.getValue());
        STD_LOGGER.info(module, method, " - Operation", " - " + operation);
        this.checkValue(tBI, (byte)127, (byte)5, 1);
        TTLVEnumeration tRS = (TTLVEnumeration)tBI.getValueList((byte)127).get(0);
        int r = tRS.getValue();
        switch (r) {
            case 0: {
                oi.setResultStatus("0:Success");
                STD_LOGGER.info(module, method, " - Result Status", " - 0:Success");
                break;
            }
            case 1: {
                oi.setResultStatus("1:Operation Failed");
                STD_LOGGER.info(module, method, " - Result Status", " - 1:Operation Failed");
                break;
            }
            case 2: {
                oi.setResultStatus("2:Operation Pending");
                STD_LOGGER.info(module, method, " - Result Status", " - 2:Operation Pending");
                break;
            }
            case 3: {
                oi.setResultStatus("3:Operation Undone");
                STD_LOGGER.info(module, method, " - Result Status", " - 3:Operation Undone");
                break;
            }
            default: {
                oi.setResultStatus("unKnown error");
                STD_LOGGER.info(module, method, " - Result Status", " - unKnown error");
            }
        }
        if (r > 0) {
            TTLV t;
            this.checkValue(tBI, (byte)126, (byte)5, 1);
            TTLVEnumeration tRR = (TTLVEnumeration)tBI.getValueList((byte)126).get(0);
            oi.setResultReason(Integer.toHexString(tRR.getValue()));
            STD_LOGGER.info(module, method, " - Result Reason", " - " + Integer.toHexString(tRR.getValue()));
            if (tBI.getValueSize((byte)125) == 1 && (t = tBI.getValueList((byte)125).get(0)).getType() == 7) {
                TTLVTextString tt = (TTLVTextString)t;
                oi.setResultMessage(tt.getValue());
                STD_LOGGER.info(module, method, " - Result Message", " - " + tt.getValue());
            }
        }
        TTLVStructure ts = null;
        if (r == 0) {
            this.checkValue(tBI, (byte)124, (byte)1, 1);
            ts = (TTLVStructure)tBI.getValueList((byte)124).get(0);
        }
        oi.setKms(this.kmsName);
        return ts;
    }
}

