/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.kmip.client.ttlv;

import java.util.ArrayList;
import java.util.Arrays;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.kms.kmip.client.ttlv.TTLV;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public class TTLVByteString
extends TTLV {
    private static final String module = "TTLVByteString";
    protected byte[] value;
    public static char[] byteTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public TTLVByteString(byte tag) {
        super(tag);
    }

    public TTLVByteString(byte[] data, int pos) {
        super(data, pos);
        int start = pos + 8;
        int end = start + this.length;
        this.value = Arrays.copyOfRange(data, start, end);
    }

    @Override
    protected void init() {
        String method = "init";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        this.length = 0;
        this.value = null;
    }

    @Override
    public byte getType() {
        String method = "getType";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        return 8;
    }

    @Override
    public void makeSendData(byte[] data, int pos) {
        String method = "makeSendData";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        this.makeTTL(data, pos);
        System.arraycopy(this.value, 0, data, pos + 8, this.value.length);
        int goal = this.getBinaryDataSize();
        for (int i = 8 + this.value.length; i < goal; ++i) {
            data[pos + i] = 0;
        }
    }

    public void setValue(byte[] newValue, int pos, int len) {
        String method = "setValue";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        this.length = len;
        this.value = Arrays.copyOfRange(newValue, pos, pos + len);
    }

    public void setValue(byte[] newValue) {
        String method = "setValue";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        this.setValue(newValue, 0, newValue.length);
    }

    public void setValue(ArrayList<Byte> newValue) {
        String method = "setValue";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        this.length = newValue.size();
        if (this.value == null || this.value.length != this.length) {
            this.value = new byte[this.length];
        }
        for (int i = 0; i < this.length; ++i) {
            this.value[i] = newValue.get(i);
        }
    }

    public void setValue(String inValue) {
        int size;
        String method = "setValue";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        String newValue = inValue.toUpperCase();
        this.length = size = newValue.length() / 2;
        if (this.value == null || this.value.length != size) {
            this.value = new byte[size];
        }
        for (int i = 0; i < this.value.length; ++i) {
            this.value[i] = 0;
            block1: for (int j = 0; j < 2; ++j) {
                int n = i;
                this.value[n] = (byte)(this.value[n] << 4);
                char c = newValue.charAt(i * 2 + j);
                for (int k = 0; k < byteTable.length; ++k) {
                    if (c != byteTable[k]) continue;
                    int n2 = i;
                    this.value[n2] = (byte)(this.value[n2] + k);
                    continue block1;
                }
            }
        }
    }

    public byte[] getValueByArray() {
        String method = "getValueByArray";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        return Arrays.copyOfRange(this.value, 0, this.value.length);
    }

    public String getValueByString() {
        String method = "getValueByString";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        String s = "";
        for (int i = 0; i < this.value.length; ++i) {
            s = s + byteTable[(this.value[i] & 0xF0) >> 4];
            s = s + byteTable[this.value[i] & 0xF];
        }
        return s;
    }
}

