/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.kmip.client.ttlv;

import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.kms.kmip.client.ttlv.TTLV;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public class TTLVLongInteger
extends TTLV {
    private static final String module = "TTLVLongInteger";
    protected byte[] value;

    public TTLVLongInteger(byte tag) {
        super(tag);
    }

    public TTLVLongInteger(byte[] data, int pos) {
        super(data, pos);
        System.arraycopy(data, pos + 8, this.value, 0, this.value.length);
    }

    public TTLVLongInteger(byte tag, long value) {
        super(tag);
        this.setValue(value);
    }

    @Override
    protected void init() {
        String method = "init";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        this.length = 8;
        this.value = new byte[this.length];
        for (int i = 0; i < this.value.length; ++i) {
            this.value[i] = 0;
        }
        STD_LOGGER.info(module, method, " - ", " - end");
    }

    @Override
    public byte getType() {
        String method = "getType";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - done");
        return 3;
    }

    @Override
    public void makeSendData(byte[] data, int pos) {
        String method = "makeSendData";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        this.makeTTL(data, pos);
        int goal = this.getBinaryDataSize();
        for (int i = 8 + this.length; i < goal; ++i) {
            data[pos + i] = 0;
        }
        STD_LOGGER.info(module, method, " - ", " - end");
    }

    public void setValue(long newValue) {
        String method = "setValue";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        TTLVLongInteger.convertByte(newValue, this.value);
        STD_LOGGER.info(module, method, " - ", " - end");
    }
}

