/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.util;

import java.security.Key;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.fileuty.exception.SJcFileUtyParameterException;
import sanproject.sn2.kms.common.SJkmsConfiguration;
import sanproject.sn2.kms.common.SJkmsKmipConfiguration;
import sanproject.sn2.kms.exception.SJkmsConfigUtyException;
import sanproject.sn2.kms.exception.SJkmsKeystoreUtyException;
import sanproject.sn2.kms.kmip.client.util.KmsConfiguration;
import sanproject.sn2.kms.kmip.client.util.KmsConfigurationFactory;
import sanproject.sn2.kms.util.SJkmsConfigUtyCom;
import sanproject.sn2.kms.util.SJkmsKeystoreUty;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public class SJkmsConfigUty {
    private static final String LOG_FUNCTION = "Kms";
    private static final String LOG_TITLE = "SJkmsConfigUty";

    private SJkmsConfigUty() {
    }

    public static void setClientCertFile(String servername, String certfile) throws SJkmsConfigUtyException {
        String LOG_SUBTYTLE = "setClientCertFile";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setClientCertFile", "start: " + servername + "." + certfile);
        try {
            SJcFileUty.getUploadFile(certfile, "kms\\tmp\\", servername + ".Kms.keystore");
        }
        catch (SJcFileUtyParameterException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setClientCertFile", "error");
            throw new SJkmsConfigUtyException(ex, "107001");
        }
        catch (SJcException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setClientCertFile", "unknown error");
            throw new SJkmsConfigUtyException(ex, "105002");
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setClientCertFile", "end");
    }

    public static void setServerCertFile(String servername, String certfile) throws SJkmsConfigUtyException {
        String LOG_SUBTYTLE = "setServerCertFile";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setServerCertFile", "start: " + servername + "." + certfile);
        try {
            SJcFileUty.getUploadFile(certfile, "kms\\tmp\\", servername + ".Kms.truststore");
        }
        catch (SJcFileUtyParameterException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setServerCertFile", "error");
            throw new SJkmsConfigUtyException(ex, "107001");
        }
        catch (SJcException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setServerCertFile", "unknown error");
            throw new SJkmsConfigUtyException(ex, "105003");
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setServerCertFile", "end");
    }

    public static String getType() throws SJkmsConfigUtyException {
        String LOG_SUBTYTLE = "getType";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getType", "start");
        String ret = "Nothing";
        Properties properties = null;
        try {
            properties = SJkmsConfigUtyCom.loadProperties();
        }
        catch (SJcException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getType", "Read Property File Error Occured", ex);
            return "Nothing";
        }
        catch (Exception ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getType", "Read Property File Error Occured Ex", ex);
            return "Nothing";
        }
        if (properties == null) {
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getType", "end:Nothing");
            return "Nothing";
        }
        try {
            ret = properties.getProperty("kms.server.type");
        }
        catch (SJcException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getType", "Properties load error Occured", ex);
            return "Nothing";
        }
        catch (Exception ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getType", "Properties load error Occured Ex", ex);
            return "Nothing";
        }
        if (ret == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getType", "Properties load error");
            return "Nothing";
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getType", "end: " + ret);
        return ret;
    }

    public static List<SJkmsConfiguration> getConfiguration(String type) throws SJkmsConfigUtyException {
        String LOG_SUBTITLE = "getConfiguration";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getConfiguration", "start");
        if (type == null || type.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getConfiguration", "Parameter Error");
            return null;
        }
        KmsConfiguration[] confary = null;
        ArrayList<SJkmsConfiguration> conflist = null;
        Properties properties = null;
        Object kmsServerType = null;
        try {
            properties = SJkmsConfigUtyCom.loadProperties();
        }
        catch (SJcException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getConfiguration", "Read Property File Error Occured", ex);
            return null;
        }
        catch (Exception ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getConfiguration", "Read Property File Error Occured Ex", ex);
            return null;
        }
        if (properties == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getConfiguration", "Read Property File Error");
            return null;
        }
        conflist = new ArrayList<SJkmsConfiguration>();
        try {
            if ("kmip".equals(type)) {
                confary = KmsConfigurationFactory.getConfigrations(properties);
            }
            for (int i = 0; i < confary.length; ++i) {
                conflist.add(confary[i]);
            }
        }
        catch (SJcException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getConfiguration", "Convert Properties to Config failed", ex);
            return null;
        }
        catch (Exception ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getConfiguration", "Convert Properties to Config failed Ex", ex);
            return null;
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getConfiguration", "end");
        return conflist;
    }

    public static void setConfiguration(String type, List<SJkmsConfiguration> conflist) throws SJkmsConfigUtyException {
        String LOG_SUBTITLE = "setConfiguration";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setConfiguration", "start");
        if (type == null || type.length() == 0 || conflist == null || conflist.size() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setConfiguration", "parameter is null");
            throw new SJkmsConfigUtyException("107001");
        }
        if (!type.equals("kmip")) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setConfiguration", "Illigal Server Type");
            throw new SJkmsConfigUtyException("107001");
        }
        if (conflist.get(0) == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setConfiguration", "Properties is not set");
            throw new SJkmsConfigUtyException("107001");
        }
        boolean flg = conflist.get(0).getEnabled();
        if (flg) {
            Properties data = null;
            if (type.equals("kmip")) {
                try {
                    data = SJkmsConfigUty.setKmipConfiguration(conflist);
                }
                catch (SJkmsConfigUtyException ex) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setConfiguration", "Create Properties Failed");
                    throw ex;
                }
            }
            if (data != null) {
                try {
                    SJkmsConfigUtyCom.saveProperties(data);
                }
                catch (SJcException ex) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setConfiguration", "Cannot output property to file");
                    throw new SJkmsConfigUtyException(ex, "107001");
                }
            }
            if (type.equals("kmip")) {
                try {
                    SJkmsConfigUty.setKmipCertificate(conflist);
                }
                catch (SJkmsConfigUtyException ex) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setConfiguration", "Read Certificate Failed");
                    throw ex;
                }
            }
        } else {
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setConfiguration", "Delete `Properties");
            SJkmsConfigUtyCom.clearProperties();
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setConfiguration", "end");
    }

    public static Properties setKmipConfiguration(List<SJkmsConfiguration> conflist) throws SJkmsConfigUtyException {
        String LOG_SUBTITLE = "setKmipConfiguration";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setKmipConfiguration", "start");
        if (conflist == null || conflist.size() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setKmipConfiguration", "parameter is null");
            throw new SJkmsConfigUtyException("107001");
        }
        Properties ret = null;
        boolean flg = conflist.get(0).getEnabled();
        if (flg) {
            String basekey = "";
            String key = "";
            String ServerName = "";
            ret = new Properties();
            ret.setProperty("kms.server.enabled", String.valueOf(flg));
            ret.setProperty("kms.server.type", "kmip");
            ret.setProperty("kms.regularbackup.enabled", String.valueOf(conflist.get(0).getRegularbackupEnabled()));
            ret.setProperty("kms.regularbackup.schedule", conflist.get(0).getRegularbackupSchedule());
            ret.setProperty("kms.regularbackup.userid", conflist.get(0).getRegularbackupUserid());
            ret.setProperty("kms.regularbackup.passwd", conflist.get(0).getRegularbackupPasswd());
            for (SJkmsConfiguration kconf : conflist) {
                if (!(kconf instanceof SJkmsKmipConfiguration)) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setKmipConfiguration", "illigal config parameter");
                    throw new SJkmsConfigUtyException("107001");
                }
                SJkmsKmipConfiguration conf = (SJkmsKmipConfiguration)kconf;
                String servername = conf.getServerName();
                if (servername == null || servername.length() == 0) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setKmipConfiguration", "Server Name is null");
                    throw new SJkmsConfigUtyException("107001");
                }
                ServerName = ServerName + servername + ",";
                basekey = "kms.kmip." + conf.getServerName() + ".";
                key = basekey + "hostenabled";
                ret.setProperty(key, String.valueOf(conf.getEnabled()));
                String host = conf.getHost();
                if (host == null && servername.equals("PrimaryServer")) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setKmipConfiguration", "host is null");
                    throw new SJkmsConfigUtyException("107001");
                }
                key = basekey + "host";
                if (conf.getHost() != null) {
                    ret.setProperty(key, conf.getHost());
                } else {
                    ret.setProperty(key, "");
                }
                key = basekey + "hosttype";
                if (conf.getHosttype() != null) {
                    ret.setProperty(key, conf.getHosttype());
                } else {
                    ret.setProperty(key, "Identifier");
                }
                key = basekey + "version";
                ret.setProperty(key, conf.getVersion());
                key = basekey + "port";
                ret.setProperty(key, String.valueOf(conf.getPort()));
                key = basekey + "authentication";
                ret.setProperty(key, String.valueOf(conf.getAuth()));
                key = basekey + "retry.times";
                ret.setProperty(key, String.valueOf(conf.getRetryTimes()));
                key = basekey + "retry.interval";
                ret.setProperty(key, String.valueOf(conf.getRetryInterval()));
                key = basekey + "timeout";
                ret.setProperty(key, String.valueOf(conf.getTimeout()));
            }
            ret.setProperty("kms.server.name", ServerName.substring(0, ServerName.length() - 1));
        } else {
            ret = SJkmsConfigUtyCom.loadProperties();
            if (ret == null) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setKmipConfiguration", "cannnot read properties");
            } else {
                ret.setProperty("kms.server.enabled", String.valueOf(flg));
            }
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setKmipConfiguration", "end");
        return ret;
    }

    public static void setKmipCertificate(List<SJkmsConfiguration> conflist) throws SJkmsConfigUtyException {
        String LOG_SUBTITLE = "setKmipCertificate";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setKmipCertificate", "start");
        if (conflist == null || conflist.size() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setKmipCertificate", "parameter is null");
            throw new SJkmsConfigUtyException("107001");
        }
        for (SJkmsConfiguration config : conflist) {
            SJkmsKmipConfiguration conf = (SJkmsKmipConfiguration)config;
            boolean flg = conf.getEnabled();
            if (flg) {
                if (conf.getKeyupdate()) {
                    try {
                        Key clientkey = SJkmsKeystoreUty.readClientKey(conf.getServerName(), conf.getKeypassword());
                        Certificate[] clientcert = SJkmsKeystoreUty.readClientCert(conf.getServerName(), conf.getKeypassword());
                        SJkmsKeystoreUty.updateClientKeyStore(conf.getServerName(), clientcert, clientkey);
                    }
                    catch (SJkmsKeystoreUtyException ex) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setKmipCertificate", "Cannnot read/update Client Certificate file");
                        throw new SJkmsConfigUtyException(ex, "105002");
                    }
                    catch (SJcException ex) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setKmipCertificate", "Parameter Error");
                        throw new SJkmsConfigUtyException(ex, "107001");
                    }
                }
                if (!conf.getCertupdate()) continue;
                try {
                    Certificate servercert = SJkmsKeystoreUty.readServerCert(conf.getServerName());
                    SJkmsKeystoreUty.updateServerKeyStore(conf.getServerName(), servercert);
                    continue;
                }
                catch (SJkmsKeystoreUtyException ex) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setKmipCertificate", "Cannnot read/update Server Certificate file");
                    throw new SJkmsConfigUtyException(ex, "105003");
                }
                catch (SJcException ex) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setKmipCertificate", "Parameter Error");
                    throw new SJkmsConfigUtyException(ex, "107001");
                }
            }
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setKmipCertificate", "Server Setting is Disable");
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setKmipCertificate", "end");
    }
}

