/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.device;

import sanproject.serverux.dataimpl.RJiCHAInfoDetail;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.model.data.inf.SJmoData_IF;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;

public class SJmoChaDetail
extends SJmoModelData_Base
implements SJmoData_IF {
    static final long serialVersionUID = -918521567710185754L;
    private short sCHAClusterNumber = (short)-1;
    private short sCHANumber = (short)-1;
    private String strCHADisplayName = "";
    private byte byCHAPackageType = (byte)-1;
    private String strChaKey = "";

    public void setSCHAClusterNumber(short clusterNumber) {
        this.sCHAClusterNumber = clusterNumber;
    }

    public void setSCHANumber(short number) {
        this.sCHANumber = number;
    }

    public void setStrCHADisplayName(String strCHADisplayName) {
        this.strCHADisplayName = strCHADisplayName;
    }

    public void setByCHAPackageType(byte byCHAPackageType) {
        this.byCHAPackageType = byCHAPackageType;
    }

    public short getSCHAClusterNumber() {
        return this.sCHAClusterNumber;
    }

    public short getSCHANumber() {
        return this.sCHANumber;
    }

    public String getStrCHADisplayName() {
        return this.strCHADisplayName;
    }

    public byte getByCHAPackageType() {
        return this.byCHAPackageType;
    }

    public SJmoChaDetail() {
    }

    public SJmoChaDetail(RJiCHAInfoDetail rmiData) throws SJmoException {
        if (null == rmiData) {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoChaDetail", "SJmoChaDetail");
        }
        this.setAllData(rmiData);
    }

    public void setAllData(RJiCHAInfoDetail rmiData) throws SJmoException {
        if (null != rmiData) {
            this.setSCHAClusterNumber(rmiData.getSCHAClusterNumber());
            this.setSCHANumber(rmiData.getSCHANumber());
            this.getKey();
            if (null != rmiData.getStrCHADisplayName()) {
                this.setStrCHADisplayName(rmiData.getStrCHADisplayName());
            }
        } else {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoChaDetail", "setAllData");
        }
        this.setByCHAPackageType(rmiData.getByCHAPackageType());
    }

    public int getKeyIndex() {
        int iChaKey = -1;
        if (this.isValidKey()) {
            iChaKey = this.sCHAClusterNumber << 8 | this.sCHANumber;
        }
        return iChaKey;
    }

    public String getKey() {
        if (0 == this.strChaKey.length()) {
            this.strChaKey = this.makeKey();
        }
        return this.strChaKey;
    }

    public boolean isNumKey() {
        return true;
    }

    public boolean isValidKey() {
        boolean bRet = true;
        if (1 > this.sCHAClusterNumber || SJmoDataMacro_IF.NUM_MAX_CLASTER < this.sCHAClusterNumber) {
            bRet = false;
        } else if (1 > this.sCHANumber || SJmoDataMacro_IF.NUM_MAX_CHA < this.sCHANumber) {
            bRet = false;
        }
        return bRet;
    }

    public String makeKey() {
        String strKey = "";
        if (this.isValidKey()) {
            strKey = SJmoUtility.itoh(this.getKeyIndex(), 4);
        }
        return strKey;
    }

    @Override
    public int compareTo(Object KeyObj) {
        return this.getKey().compareTo(KeyObj.toString());
    }

    public String toString() {
        return this.getKey();
    }
}

