/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.huvm;

import sanproject.serverux.dataimpl.HUVMVirtualLdev;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.huvm.SJmoHUVMvboxIndex;
import sanproject.sn2.model.data.inf.SJmoData_IF;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;

public class SJmoHUVMVirtualLdev
extends SJmoLdevIndex
implements SJmoData_IF {
    private static final long serialVersionUID = 1469912494504733561L;
    private SJmoHUVMvboxIndex vBoxIndex = new SJmoHUVMvboxIndex();
    private int iVEmulation = -1;
    private int iVSsid = -1;
    private SJmoLdevIndex virtualLdev = new SJmoLdevIndex();
    private byte byVLuse = (byte)-1;
    private boolean bVCvs = false;
    private short sVAttrHuvm = (short)-1;
    private short sVInfflag = (short)-1;

    public SJmoHUVMVirtualLdev() {
    }

    public SJmoHUVMVirtualLdev(HUVMVirtualLdev rmiData) {
        if (rmiData == null) {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoHUVMVirtualLdev", "SJmoHUVMVirtualLdev(HUVMVirtualLdev)");
        }
        this.setLdevIndex(rmiData.getSLDKC(), rmiData.getSCU(), rmiData.getSLDEV());
        SJmoHUVMvboxIndex vBoxId = new SJmoHUVMvboxIndex();
        vBoxId.setIVboxId(rmiData.getVboxIndex().getVboxId());
        this.setVBoxIndex(vBoxId);
        SJmoLdevIndex vLdevIndex = new SJmoLdevIndex();
        vLdevIndex.setLdevIndex(rmiData.getRobjVirtualLdev().getSLDKC(), rmiData.getRobjVirtualLdev().getSCU(), rmiData.getRobjVirtualLdev().getSLDEV());
        this.setIVEmulation(rmiData.getVEmulation());
        this.setIVSsid(rmiData.getVSsid());
        this.setVirtualLdev(vLdevIndex);
        this.setByVLuse(rmiData.getVLuse());
        this.setSVAttrHuvm(rmiData.getVAttrHuvm());
        this.setSVInfflag(rmiData.getVInfflag());
        this.setVCvs(rmiData.getVCvs());
    }

    public SJmoHUVMvboxIndex getVBoxIndex() {
        return this.vBoxIndex;
    }

    public void setVBoxIndex(SJmoHUVMvboxIndex vBoxIndex) {
        this.vBoxIndex = vBoxIndex;
    }

    public int getIVEmulation() {
        return this.iVEmulation;
    }

    public void setIVEmulation(int emulation) {
        this.iVEmulation = emulation;
    }

    public int getIVSsid() {
        return this.iVSsid;
    }

    public void setIVSsid(int ssid) {
        this.iVSsid = ssid;
    }

    public SJmoLdevIndex getVirtualLdev() {
        return this.virtualLdev;
    }

    public void setVirtualLdev(SJmoLdevIndex virtualLdev) {
        this.virtualLdev = virtualLdev;
    }

    public byte getByVLuse() {
        return this.byVLuse;
    }

    public void setByVLuse(byte byVLuse) {
        this.byVLuse = byVLuse;
    }

    public short getSVAttrHuvm() {
        return this.sVAttrHuvm;
    }

    public void setSVAttrHuvm(short attrHuvm) {
        this.sVAttrHuvm = attrHuvm;
    }

    public short getSVInfflag() {
        return this.sVInfflag;
    }

    public void setSVInfflag(short infflag) {
        this.sVInfflag = infflag;
    }

    public boolean isVCvs() {
        return this.bVCvs;
    }

    public void setVCvs(boolean cvs) {
        this.bVCvs = cvs;
    }

    public boolean isValidIndexVirtualLdev() {
        boolean ret = false;
        SJmoLdevIndex virtualLdev = this.getVirtualLdev();
        if (virtualLdev.getSLdkc() == 0 && 0 <= virtualLdev.getSCu() && virtualLdev.getSCu() <= SJmoDataMacro_IF.NUM_MAX_VIRTUAL_CU_LDKC && 0 <= virtualLdev.getSLdev() && virtualLdev.getSLdev() <= SJmoDataMacro_IF.NUM_MAX_LDEV_CU) {
            ret = true;
        }
        return ret;
    }
}

