/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.lu;

import java.util.Arrays;
import sanproject.sn2.com.utility.SJcSecureUty;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.inf.SJmoData_IF;

public class SJmoIscsiTargetPathInfo
extends SJmoPortIndex
implements SJmoData_IF {
    private static final long serialVersionUID = 8092880700211704694L;
    private int iTargetPathIndex = -1;
    private int iFunction = -1;
    private short sRemoteExtPort = (short)-1;
    private int iIpType = -1;
    private int[] iIpv4Address = new int[4];
    private int[] iIpv6Address = new int[8];
    private int iTcpPortNumber = -1;
    private String strTargetName = "";
    private int iAuthentSwitch = -1;
    private int iAuthentMode = -1;
    private String strTargetUserName = "";
    private String strTargetSecret = "";
    private int iVirtualPortID = -1;
    private String strVirtualPortID = "";

    @Override
    public boolean isNumKey() {
        return false;
    }

    @Override
    public String toString() {
        return this.getIndexKey() + this.getStrVirtualPortID() + this.getITargetPathIndex();
    }

    @Override
    public int compareTo(Object keyObj) {
        return this.toString().compareTo(keyObj.toString());
    }

    public int getITargetPathIndex() {
        return this.iTargetPathIndex;
    }

    public void setITargetPathIndex(int targetPathIndex) {
        this.iTargetPathIndex = targetPathIndex;
    }

    public int getIFunction() {
        return this.iFunction;
    }

    public void setIFunction(int function) {
        this.iFunction = function;
    }

    public short getSRemoteExtPort() {
        return this.sRemoteExtPort;
    }

    public void setSRemoteExtPort(short remoteExtPort) {
        this.sRemoteExtPort = remoteExtPort;
    }

    public int getIIpType() {
        return this.iIpType;
    }

    public void setIIpType(int ipType) {
        this.iIpType = ipType;
    }

    public int[] getIIpv4Address() {
        return this.iIpv4Address;
    }

    public void setIIpv4Address(int[] ipv4Address) {
        this.iIpv4Address = ipv4Address;
    }

    public int[] getIIpv6Address() {
        return this.iIpv6Address;
    }

    public void setIIpv6Address(int[] ipv6Address) {
        this.iIpv6Address = ipv6Address;
    }

    public int getITcpPortNumber() {
        return this.iTcpPortNumber;
    }

    public void setITcpPortNumber(int tcpPortNumber) {
        this.iTcpPortNumber = tcpPortNumber;
    }

    public String getStrTargetName() {
        return this.strTargetName;
    }

    public void setStrTargetName(String strTargetName) {
        this.strTargetName = strTargetName;
    }

    public int getIAuthentSwitch() {
        return this.iAuthentSwitch;
    }

    public void setIAuthentSwitch(int authentSwitch) {
        this.iAuthentSwitch = authentSwitch;
    }

    public int getIAuthentMode() {
        return this.iAuthentMode;
    }

    public void setIAuthentMode(int authentMode) {
        this.iAuthentMode = authentMode;
    }

    public String getStrTargetUserName() {
        return this.strTargetUserName;
    }

    public void setStrTargetUserName(String strTargetUserName) {
        this.strTargetUserName = strTargetUserName;
    }

    public String getStrTargetSecret() {
        if (null != this.strTargetSecret && this.strTargetSecret.length() != 0) {
            return SJcSecureUty.decryptStrToStr(this.strTargetSecret);
        }
        return this.strTargetSecret;
    }

    public void setStrTargetSecret(String strTargetSecret) {
        this.strTargetSecret = null != strTargetSecret && strTargetSecret.length() != 0 ? SJcSecureUty.encryptStrToStr(strTargetSecret) : strTargetSecret;
    }

    public int getIVirtualPortID() {
        return this.iVirtualPortID;
    }

    public String getStrVirtualPortID() {
        return this.strVirtualPortID;
    }

    public void setIVirtualPortID(int virtualPortID) {
        this.iVirtualPortID = virtualPortID;
        this.strVirtualPortID = virtualPortID < 0 ? "FF" : SJmoUtility.itoh(virtualPortID, 2);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SJmoIscsiTargetPathInfo retObj = (SJmoIscsiTargetPathInfo)super.clone();
        retObj.setIIpv4Address(Arrays.copyOf(retObj.getIIpv4Address(), retObj.getIIpv4Address().length));
        retObj.setIIpv6Address(Arrays.copyOf(retObj.getIIpv6Address(), retObj.getIIpv6Address().length));
        return retObj;
    }

    @Override
    public Object clone(byte byDataMode) throws CloneNotSupportedException {
        SJmoModelData_Base retObj = (SJmoModelData_Base)this.clone();
        retObj.setIDataMode(byDataMode);
        return retObj;
    }
}

