/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.replication.local.manager;

import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.model.data.inf.SJmoDataMgr_IF;
import sanproject.sn2.model.data.replication.SJmoConsistencyGroupIndex;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationConsistencyGroupInfo;
import sanproject.sn2.model.data.util.SJmoReplicationUtility;

public class SJmoLocalReplicationConsistencyGroupInfoMgr
extends SJmoModelData_Base
implements SJmoDataMgr_IF {
    private static final long serialVersionUID = -1067966781784104024L;
    private SJmoLocalReplicationConsistencyGroupInfo[] localReplicationCtgInfoList = new SJmoLocalReplicationConsistencyGroupInfo[2048];

    public SJmoLocalReplicationConsistencyGroupInfoMgr(SJmoLocalReplicationConsistencyGroupInfo[] ctgInfoList) {
        if (null == ctgInfoList) {
            throw SJmoUtility.getException(201, 23, 107000, this.getClass().getSimpleName(), "Constructor");
        }
        this.setLocalReplicationCtgInfoList(ctgInfoList);
    }

    public SJmoLocalReplicationConsistencyGroupInfo getLocalReplicationCtgInfo(int iCtgId) {
        SJmoLocalReplicationConsistencyGroupInfo retCtgInf = null;
        if (SJmoReplicationUtility.isValidLocalReplicationCtgId(iCtgId)) {
            retCtgInf = this.localReplicationCtgInfoList[iCtgId];
        }
        return retCtgInf;
    }

    public SJmoLocalReplicationConsistencyGroupInfo getLocalReplicationCtgInfo(SJmoConsistencyGroupIndex ctgIndex) {
        return this.getLocalReplicationCtgInfo(ctgIndex.getIndex());
    }

    public SJmoLocalReplicationConsistencyGroupInfo[] getLocalReplicationCtgInfoList() {
        return this.localReplicationCtgListCopy(this.localReplicationCtgInfoList);
    }

    public void setLocalReplicationCtgInfo(SJmoLocalReplicationConsistencyGroupInfo ctgInfo) {
        if (SJmoReplicationUtility.isValidLocalReplicationCtgId(ctgInfo.getIndex())) {
            this.localReplicationCtgInfoList[ctgInfo.getIndex()] = ctgInfo;
        } else {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "setLocalReplicationCtgInfo", "CTG Index = " + ctgInfo.getIndex());
        }
    }

    public void setLocalReplicationCtgInfoList(SJmoLocalReplicationConsistencyGroupInfo[] ctgInfoList) {
        this.localReplicationCtgInfoList = ctgInfoList;
    }

    private SJmoLocalReplicationConsistencyGroupInfo[] getShallowLocalReplicationCtgInfoList() {
        return this.localReplicationCtgInfoList;
    }

    private SJmoLocalReplicationConsistencyGroupInfo[] localReplicationCtgListCopy(SJmoLocalReplicationConsistencyGroupInfo[] localreplicationCtgList) {
        return this.localReplicaCtgListClone(localreplicationCtgList, false);
    }

    private SJmoLocalReplicationConsistencyGroupInfo[] localReplicationCtgListDeepCopy(SJmoLocalReplicationConsistencyGroupInfo[] localreplicationCtgList) {
        return this.localReplicaCtgListClone(localreplicationCtgList, true);
    }

    private SJmoLocalReplicationConsistencyGroupInfo[] localReplicaCtgListClone(SJmoLocalReplicationConsistencyGroupInfo[] srcList, boolean bCtgInfoDeepCopy) {
        SJmoLocalReplicationConsistencyGroupInfo[] retList = null;
        if (null != srcList) {
            retList = new SJmoLocalReplicationConsistencyGroupInfo[srcList.length];
            for (int iListCnt = 0; iListCnt < srcList.length; ++iListCnt) {
                if (bCtgInfoDeepCopy) {
                    if (null == srcList[iListCnt]) continue;
                    try {
                        retList[iListCnt] = (SJmoLocalReplicationConsistencyGroupInfo)srcList[iListCnt].clone();
                    }
                    catch (Exception e) {
                        SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "localReplicaCtgListClone", "iListCnt = " + iListCnt + ":Exception " + e.toString());
                    }
                    continue;
                }
                retList[iListCnt] = srcList[iListCnt];
            }
        } else {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "localReplicaCtgListClone", "srcList is null.");
        }
        return retList;
    }

    @Override
    public Object getToOutSideObj() {
        Object retObj = null;
        try {
            retObj = super.clone();
        }
        catch (Exception e) {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "getToOutSideObj", "Exception " + e.toString());
        }
        return retObj;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SJmoLocalReplicationConsistencyGroupInfoMgr retObj = (SJmoLocalReplicationConsistencyGroupInfoMgr)super.clone();
        retObj.setLocalReplicationCtgInfoList(retObj.localReplicationCtgListDeepCopy(retObj.getShallowLocalReplicationCtgInfoList()));
        return retObj;
    }

    @Override
    public Object clone(byte byDataMode) throws CloneNotSupportedException {
        SJmoModelData_Base retObj = (SJmoModelData_Base)this.clone();
        retObj.setIDataMode(byDataMode);
        return retObj;
    }
}

