/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.replication.local.manager;

import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.model.data.inf.SJmoDataMgr_IF;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.util.SJmoLdevUtility;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;

public class SJmoLocalReplicationPairVolInfoMgr
extends SJmoModelData_Base
implements SJmoDataMgr_IF {
    private static final long serialVersionUID = 2244274409295344693L;
    private SJmoLocalReplicationPairVolInfo[] localReplicationPairVolInfoList = new SJmoLocalReplicationPairVolInfo[SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC];

    public SJmoLocalReplicationPairVolInfoMgr(SJmoLocalReplicationPairVolInfo[] pairVolInfoList) {
        if (null == pairVolInfoList) {
            throw SJmoUtility.getException(201, 23, 107000, this.getClass().getSimpleName(), "Constructor");
        }
        this.localReplicationPairVolInfoList = pairVolInfoList;
    }

    public SJmoLocalReplicationPairVolInfo getLocalReplicationPairVolInfo(int iLdevId) {
        SJmoLocalReplicationPairVolInfo retPairInfo = null;
        if (SJmoLdevUtility.isValidLdevId(iLdevId)) {
            retPairInfo = this.localReplicationPairVolInfoList[iLdevId];
        }
        return retPairInfo;
    }

    public SJmoLocalReplicationPairVolInfo getLocalReplicationPairVolInfo(SJmoLdevIndex ldevIdx) {
        return this.getLocalReplicationPairVolInfo(ldevIdx.getIndex());
    }

    public SJmoLocalReplicationPairVolInfo[] getLocalReplicationPairVolInfoList() {
        return this.localReplicationPairVolListCopy(this.localReplicationPairVolInfoList);
    }

    public void setLocalReplicationPairVolInfoList(SJmoLocalReplicationPairVolInfo[] pairVolInfoList) {
        this.localReplicationPairVolInfoList = pairVolInfoList;
    }

    public void setLocalReplicationPairVolInfo(SJmoLocalReplicationPairVolInfo pairInfo) {
        if (SJmoLdevUtility.isValidLdevId(pairInfo.getIndex())) {
            this.localReplicationPairVolInfoList[pairInfo.getIndex()] = pairInfo;
        } else {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "setLocalReplicationPairVolInfo", "LDEV Index = " + pairInfo.getIndex());
        }
    }

    private SJmoLocalReplicationPairVolInfo[] getShallowLocalReplicationPairVolInfoList() {
        return this.localReplicationPairVolInfoList;
    }

    private SJmoLocalReplicationPairVolInfo[] localReplicationPairVolListCopy(SJmoLocalReplicationPairVolInfo[] locaReplicaPairVolList) {
        return this.localReplicaPairListClone(locaReplicaPairVolList, false);
    }

    private SJmoLocalReplicationPairVolInfo[] localReplicationPairVolListDeepCopy(SJmoLocalReplicationPairVolInfo[] locaReplicaPairVolList) {
        return this.localReplicaPairListClone(locaReplicaPairVolList, true);
    }

    private SJmoLocalReplicationPairVolInfo[] localReplicaPairListClone(SJmoLocalReplicationPairVolInfo[] srcList, boolean bPairVolInfoDeepCopy) {
        SJmoLocalReplicationPairVolInfo[] retList = null;
        if (null != srcList) {
            retList = new SJmoLocalReplicationPairVolInfo[srcList.length];
            for (int iSrcCnt = 0; iSrcCnt < srcList.length; ++iSrcCnt) {
                if (bPairVolInfoDeepCopy) {
                    if (null == srcList[iSrcCnt]) continue;
                    try {
                        retList[iSrcCnt] = (SJmoLocalReplicationPairVolInfo)srcList[iSrcCnt].clone();
                    }
                    catch (Exception exp) {
                        SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "localReplicaPairListClone", "clone failed iSrcCnt = " + iSrcCnt + exp.toString());
                    }
                    continue;
                }
                retList[iSrcCnt] = srcList[iSrcCnt];
            }
        } else {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "localReplicaPairListClone", "srcList is null.");
        }
        return retList;
    }

    @Override
    public Object getToOutSideObj() {
        Object retObj = null;
        try {
            retObj = super.clone();
        }
        catch (Exception e) {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "getToOutSideObj", "clone failed" + e.toString());
        }
        return retObj;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SJmoLocalReplicationPairVolInfoMgr retObj = (SJmoLocalReplicationPairVolInfoMgr)super.clone();
        retObj.setLocalReplicationPairVolInfoList(retObj.localReplicationPairVolListDeepCopy(retObj.getShallowLocalReplicationPairVolInfoList()));
        return retObj;
    }

    @Override
    public Object clone(byte byDataMode) throws CloneNotSupportedException {
        SJmoModelData_Base retObj = (SJmoModelData_Base)this.clone();
        retObj.setIDataMode(byDataMode);
        return retObj;
    }
}

