/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.system;

import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import sanproject.serverux.dataimpl.DISKgetDKCDKUStatusInfo;
import sanproject.serverux.dataimpl.DISKgetDKCStatusInfoSx;
import sanproject.serverux.dataimpl.DISKgetDKUStatusInfo;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.SJmoModelData_Base;

public class SJmoSubsystemStatusMgr
extends SJmoModelData_Base {
    static final long serialVersionUID = -2983544633015903773L;
    private DISKgetDKCStatusInfoSx dkcInfo = null;
    private DISKgetDKUStatusInfo dkuInfo = null;
    private SanResponse allLockList = null;

    public SJmoSubsystemStatusMgr() {
        this.dkcInfo = new DISKgetDKCStatusInfoSx();
        this.dkcInfo.nDKCAuditLog = -1;
        this.dkcInfo.nDKCAuditLogDKC = -1;
        this.dkcInfo.nDKCAuditLogDKCUsage = -1;
        this.dkcInfo.nDKCAuditLogUsage = -1;
        this.dkcInfo.nDKCConfCheck = -1;
        this.dkcInfo.nDKCHWBattery = -1;
        this.dkcInfo.nDKCHWCache = -1;
        this.dkcInfo.nDKCHWCSW = -1;
        this.dkcInfo.nDKCHWEnvironment = -1;
        this.dkcInfo.nDKCHWFan = -1;
        this.dkcInfo.nDKCHWProcessor = -1;
        this.dkcInfo.nDKCHWPS = -1;
        this.dkcInfo.nDKCHWSM = -1;
        this.dkcInfo.nDKCLockStatus = -1;
        this.dkuInfo = new DISKgetDKUStatusInfo();
        this.dkuInfo.nDKCHWEnvironment = -1;
        this.dkuInfo.nDKCHWFan = -1;
        this.dkuInfo.nDKUHWDrive = -1;
        this.dkuInfo.nDKUHWPS = -1;
    }

    public SJmoSubsystemStatusMgr(DISKgetDKCDKUStatusInfo statInfo, SanResponse allLockList) throws SJmoException {
        this.setAllData(statInfo, allLockList);
    }

    public void setAllData(DISKgetDKCDKUStatusInfo statInfo, SanResponse allLockList) throws SJmoException {
        if (null == statInfo || null == statInfo.dkc || null == statInfo.dku) {
            SJmoUtility.putLogDetail("SJmoSubsystemStatusMgr", "setAllData", "Invalid parameter");
            throw SJmoUtility.getException(201, 23, 107000, "SJmoSubsystemStatusMgr", "setAllData");
        }
        this.dkcInfo = statInfo.dkc;
        this.dkuInfo = statInfo.dku;
        String strLog = null;
        strLog = "AuditLog Stat=SVP:" + statInfo.dkc.nDKCAuditLog + ",DKC:" + statInfo.dkc.nDKCAuditLogDKC;
        SJmoUtility.putLogDetail("SJmoSubsystemStatusMgr", "RMI", strLog);
        strLog = "AuditLog Used=SVP:" + statInfo.dkc.nDKCAuditLogUsage + ",DKC:" + statInfo.dkc.nDKCAuditLogDKCUsage;
        SJmoUtility.putLogDetail("SJmoSubsystemStatusMgr", "RMI", strLog);
        strLog = "DKC=Proc:" + statInfo.dkc.nDKCHWProcessor + ",CSW:" + statInfo.dkc.nDKCHWCSW + ",CM:" + statInfo.dkc.nDKCHWCache + ",SM:" + statInfo.dkc.nDKCHWSM + ",PS:" + statInfo.dkc.nDKCHWPS + ",BAT:" + statInfo.dkc.nDKCHWBattery + ",FAN:" + statInfo.dkc.nDKCHWFan + ",ENV:" + statInfo.dkc.nDKCHWEnvironment + ",SIM:" + statInfo.dkc.nUnconfirmedSIMStatus;
        SJmoUtility.putLogDetail("SJmoSubsystemStatusMgr", "RMI", strLog);
        strLog = "SVP=CNF:" + statInfo.dkc.nDKCConfCheck + ",LCK:" + statInfo.dkc.nDKCLockStatus;
        SJmoUtility.putLogDetail("SJmoSubsystemStatusMgr", "RMI", strLog);
        strLog = "DKU=PS:" + statInfo.dku.nDKUHWPS + ",FAN:" + statInfo.dku.nDKCHWFan + ",ENV:" + statInfo.dku.nDKCHWEnvironment + ",DRV:" + statInfo.dku.nDKUHWDrive;
        SJmoUtility.putLogDetail("SJmoSubsystemStatusMgr", "RMI", strLog);
        strLog = "AuditLog Stat=SVP:" + this.getSvpAuditLogStatus() + ",DKC:" + this.getDkcAuditLogStatus();
        SJmoUtility.putLogDetail("SJmoSubsystemStatusMgr", "this", strLog);
        strLog = "AuditLog Used=SVP:" + this.getSvpAuditLogUsage() + ",DKC:" + this.getDkcAuditLogUsage();
        SJmoUtility.putLogDetail("SJmoSubsystemStatusMgr", "this", strLog);
        strLog = "DKC=Proc:" + this.getDkcProcessorStatus() + ",CSW:" + this.getDkcCSWStatus() + ",CM:" + this.getDkcCacheStatus() + ",SM:" + this.getDkcSMStatus() + ",PS:" + this.getDkcPSStatus() + ",BAT:" + this.getDkcBatteryStatus() + ",FAN:" + this.getDkcFanStatus() + ",ENV:" + this.getDkcEnvStatus() + ",SIM:" + this.getSIMStatus();
        SJmoUtility.putLogDetail("SJmoSubsystemStatusMgr", "this", strLog);
        strLog = "SVP=CNF:" + this.getConfCheck() + ",LCK:" + this.getDkcLockStatus();
        SJmoUtility.putLogDetail("SJmoSubsystemStatusMgr", "this", strLog);
        strLog = "DKU=PS:" + this.getDkuPSStatus() + ",FAN:" + this.getDkuFanStatus() + ",ENV:" + this.getDkuEnvStatus() + ",DRV:" + this.getDkuDriveStatus();
        SJmoUtility.putLogDetail("SJmoSubsystemStatusMgr", "this", strLog);
        strLog = "Merge=Subsystem:" + this.getSubsystemStatus() + ",DKC:" + this.getDkcStatus() + ",DKU:" + this.getDkuStatus() + ",Audit:" + this.getAuditLogStatus();
        SJmoUtility.putLogDetail("SJmoSubsystemStatusMgr", "this", strLog);
        this.allLockList = allLockList;
    }

    public int getSubsystemStatus() {
        int iRet = -1;
        ArrayList<Integer> alLv = new ArrayList<Integer>();
        alLv.add(new Integer(this.getDkcStatus()));
        alLv.add(new Integer(this.getDkuStatus()));
        iRet = this.getMergeResult(alLv);
        return iRet;
    }

    public int getDkcStatus() {
        int iRet = -1;
        ArrayList<Integer> alLv = new ArrayList<Integer>();
        alLv.add(new Integer(this.getDkcProcessorStatus()));
        alLv.add(new Integer(this.getDkcCSWStatus()));
        alLv.add(new Integer(this.getDkcCacheStatus()));
        alLv.add(new Integer(this.getDkcSMStatus()));
        alLv.add(new Integer(this.getDkcPSStatus()));
        alLv.add(new Integer(this.getDkcBatteryStatus()));
        alLv.add(new Integer(this.getDkcFanStatus()));
        alLv.add(new Integer(this.getDkcEnvStatus()));
        iRet = this.getMergeResult(alLv);
        return iRet;
    }

    public int getDkuStatus() {
        int iRet = -1;
        ArrayList<Integer> alLv = new ArrayList<Integer>();
        alLv.add(new Integer(this.getDkuPSStatus()));
        alLv.add(new Integer(this.getDkuFanStatus()));
        alLv.add(new Integer(this.getDkuEnvStatus()));
        alLv.add(new Integer(this.getDkuDriveStatus()));
        iRet = this.getMergeResult(alLv);
        return iRet;
    }

    public int getAuditLogStatus() {
        int iRet = -1;
        int iSvpAudit = this.getSvpAuditLogStatus();
        int iDkcAudit = this.getDkcAuditLogStatus();
        if (this.isValidAuditLogState(iSvpAudit) && this.isValidAuditLogState(iDkcAudit)) {
            iRet = iSvpAudit < iDkcAudit ? iDkcAudit : iSvpAudit;
        } else {
            SJmoUtility.putLogDetail("SJmoSubsystemStatusMgr", "getAuditLogStatus", "Invalid Status svp:" + iSvpAudit + " dkc:" + iDkcAudit);
        }
        return iRet;
    }

    public int getDkcProcessorStatus() {
        return this.dkcInfo.nDKCHWProcessor;
    }

    public int getDkcCSWStatus() {
        return this.dkcInfo.nDKCHWCSW;
    }

    public int getDkcCacheStatus() {
        return this.dkcInfo.getNDKCHWCache();
    }

    public int getDkcSMStatus() {
        return this.dkcInfo.nDKCHWSM;
    }

    public int getDkcPSStatus() {
        return this.dkcInfo.nDKCHWPS;
    }

    public int getDkcBatteryStatus() {
        return this.dkcInfo.nDKCHWBattery;
    }

    public int getDkcFanStatus() {
        return this.dkcInfo.nDKCHWFan;
    }

    public int getDkcEnvStatus() {
        return this.dkcInfo.nDKCHWEnvironment;
    }

    public int getSvpAuditLogStatus() {
        return this.dkcInfo.nDKCAuditLog;
    }

    public int getConfCheck() {
        return this.dkcInfo.nDKCConfCheck;
    }

    public int getDkcAuditLogStatus() {
        return this.dkcInfo.nDKCAuditLogDKC;
    }

    public int getSvpAuditLogUsage() {
        return this.dkcInfo.nDKCAuditLogUsage;
    }

    public int getDkcAuditLogUsage() {
        return this.dkcInfo.nDKCAuditLogDKCUsage;
    }

    public int getDkcLockStatus() {
        return this.dkcInfo.nDKCLockStatus;
    }

    public int getDkuPSStatus() {
        return this.dkuInfo.nDKUHWPS;
    }

    public int getDkuFanStatus() {
        return this.dkuInfo.nDKCHWFan;
    }

    public int getDkuEnvStatus() {
        return this.dkuInfo.nDKCHWEnvironment;
    }

    public int getDkuDriveStatus() {
        return this.dkuInfo.nDKUHWDrive;
    }

    public SanResponse getAllDkcLockList() {
        return this.allLockList;
    }

    public int getMergeResult(ArrayList<Integer> alLv) {
        int iRet = 6;
        if (null != alLv) {
            for (int iLv = 0; iLv < alLv.size(); ++iLv) {
                int iTmpLv = alLv.get(iLv);
                if (this.isValidPartState(iTmpLv)) {
                    if (1 == iTmpLv || iRet <= iTmpLv) continue;
                    iRet = iTmpLv;
                    continue;
                }
                SJmoUtility.putLogDetail("SJmoSubsystemStatusMgr", "getMergeResult", "Invalid Status:" + iTmpLv);
                iRet = -1;
                break;
            }
            if (-1 != iRet && 6 == iRet) {
                iRet = 1;
            }
        } else {
            SJmoUtility.putLogDetail("SJmoSubsystemStatusMgr", "getMergeResult", "Invalid parameter");
            iRet = -1;
        }
        if (5 == iRet) {
            iRet = 1;
        }
        return iRet;
    }

    public boolean isValidPartState(int iChkLv) {
        boolean bRet = false;
        if (1 <= iChkLv && 5 >= iChkLv) {
            bRet = true;
        }
        return bRet;
    }

    public boolean isValidAuditLogState(int iAdtLv) {
        boolean bRet = false;
        switch (iAdtLv) {
            case 1: 
            case 6: 
            case 7: {
                bRet = true;
                break;
            }
            default: {
                bRet = false;
            }
        }
        return bRet;
    }

    public int getSIMStatus() {
        return this.dkcInfo.nUnconfirmedSIMStatus;
    }
}

