/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.util;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.volume.SJmoDriveBoxInfo;

public class SJmoDriveBoxInfoUtility {
    private static final int ERROR_PART_DIGIT = 100;

    public static List<SJmoDriveBoxInfo> makeAlDriveBoxInfo(SanResponse rmiData) throws SJmoException {
        ArrayList<SJmoDriveBoxInfo> alDriveBoxInfo = new ArrayList<SJmoDriveBoxInfo>();
        if (null != rmiData) {
            try {
                SanList list = rmiData.getList("DriveBoxes");
                for (int i = 0; i < list.size(); ++i) {
                    SanObject obj = list.getObj(i);
                    SJmoDriveBoxInfo driveBoxInfo = new SJmoDriveBoxInfo(obj);
                    alDriveBoxInfo.add(driveBoxInfo);
                }
            }
            catch (SanDataException e) {
                throw SJmoDriveBoxInfoUtility.getException();
            }
        } else {
            throw SJmoDriveBoxInfoUtility.getException();
        }
        return alDriveBoxInfo;
    }

    private static SJmoException getException() {
        return SJmoUtility.getException(201, 23, 107000, "SJmoDriveBoxInfoUtility", "makeAlDriveBoxInfo");
    }

    public static void checkErrorInfo(SanResponse response, String strClass, String strMethod) {
        block5: {
            try {
                SanObject errInfo = response.getObj("ErrorInfo");
                if (errInfo != null) {
                    int errorCode = errInfo.getInt("ErrorCode");
                    int[] msgIdList = errInfo.getIntArray("MessageId");
                    if (msgIdList != null && msgIdList.length == 2) {
                        int funcModCode = msgIdList[0];
                        int msgErrorCode = msgIdList[1];
                        if (errorCode != 0) {
                            throw SJmoUtility.getException(funcModCode / 100, funcModCode % 100, msgErrorCode, strClass, strMethod);
                        }
                        break block5;
                    }
                    SJmoUtility.putLog("[SJmoDriveBoxInfoUtility][checkErrorInfo]Error information array is invalid.");
                    throw SJmoUtility.getException(201, 23, 107000, strClass, strMethod);
                }
                SJmoUtility.putLog("[SJmoDriveBoxInfoUtility][checkErrorInfo]Error information is null.");
                throw SJmoUtility.getException(201, 23, 107000, strClass, strMethod);
            }
            catch (SanDataException sde) {
                SJmoUtility.putLog("[SJmoDriveBoxInfoUtility][checkErrorInfo]SanDataException occurred. [code:" + sde.getCode() + "]" + sde.getMessage());
                throw SJmoUtility.getException(201, 23, 107000, strClass, strMethod);
            }
        }
    }
}

