/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import sanproject.common.Robj_interface_RJiPGIndex;
import sanproject.common.Robj_interface_RJiPGInfoDetail2;
import sanproject.common.Robj_interface_RJiPGLDEVIndex;
import sanproject.common.Robj_interface_RJiVDEVIndex;
import sanproject.common.Robj_interface_RJiVDEVInfoDetail;
import sanproject.serversx.data.RJiPGIndex;
import sanproject.serverux.dataimpl.CVSgetDVInfo;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.connector.kind.SJmoGetExdVolumeInfoFb4Pg;
import sanproject.sn2.model.connector.kind.SJmoGetPgDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPgLdevInfo;
import sanproject.sn2.model.connector.kind.SJmoGetVdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetVdevDvInfo;
import sanproject.sn2.model.data.util.SJmoDataUtility;
import sanproject.sn2.model.data.util.SJmoPgComparator;
import sanproject.sn2.model.data.util.SJmoRenewMappedExdVolPg;
import sanproject.sn2.model.data.util.SJmoVdevComparator;
import sanproject.sn2.model.data.volume.SJmoFbIndex;
import sanproject.sn2.model.data.volume.SJmoFbPgInfo;
import sanproject.sn2.model.data.volume.SJmoFbPgVdevInfo;
import sanproject.sn2.model.data.volume.SJmoPgIndex;
import sanproject.sn2.model.data.volume.SJmoVdevIndex;

public class SJmoFbPgVdevUtility {
    public static HashMap makeHashPgInfo(Robj_interface_RJiPGIndex[] rmiData) throws SJmoException {
        HashMap<Object, Object> pgInfoHash = new HashMap();
        if (null != rmiData) {
            if (rmiData instanceof Robj_interface_RJiVDEVIndex[]) {
                pgInfoHash = SJmoFbPgVdevUtility.makeHashVdevInfo((Robj_interface_RJiVDEVIndex[])rmiData);
            } else {
                for (int iObjCnt = 0; iObjCnt < rmiData.length; ++iObjCnt) {
                    if (null != rmiData[iObjCnt]) {
                        String strKey = SJmoFbPgVdevUtility.getStrPgKey(rmiData[iObjCnt].getIFB4(), rmiData[iObjCnt].getIPG());
                        pgInfoHash.put(strKey, rmiData[iObjCnt]);
                        continue;
                    }
                    SJmoUtility.putLog("The array element is illegal. Array element number = [" + iObjCnt + "] : makeHashPgInfo");
                }
            }
        } else {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoFbPgVdevUtility", "makeHashPgInfo");
        }
        return pgInfoHash;
    }

    public static HashMap<String, ArrayList<Object>> makeHashVdevInfo(Robj_interface_RJiVDEVIndex[] rmiData) throws SJmoException {
        HashMap<String, ArrayList<Object>> vdHash = new HashMap<String, ArrayList<Object>>();
        if (null != rmiData) {
            try {
                Arrays.sort(rmiData, new SJmoVdevComparator());
            }
            catch (Exception jvExp) {
                throw SJmoUtility.getException(201, 23, 107001, "SJmoFbPgVdevUtility", "makeHashVdevInfo");
            }
            for (int iObjCnt = 0; iObjCnt < rmiData.length; ++iObjCnt) {
                ArrayList<Object> alVdev = null;
                if (null != rmiData[iObjCnt]) {
                    SJmoVdevIndex vdInf = (SJmoVdevIndex)SJmoDataUtility.makeModelObject(rmiData[iObjCnt]);
                    if (vdInf.isValidIndex()) {
                        alVdev = vdHash.get(SJmoFbPgVdevUtility.getStrPgKey(vdInf.getFB4(), vdInf.getPG()));
                        if (null != alVdev) {
                            int iInsertPoint = Collections.binarySearch(alVdev, vdInf);
                            if (iInsertPoint >= 0) {
                                SJmoUtility.putLogDetail("SJmoFbPgVdevUtility", "makeHashVdevInfo", "VDEV Index Error:Index =" + vdInf.getIndex());
                                continue;
                            }
                            iInsertPoint = -iInsertPoint - 1;
                            alVdev.add(iInsertPoint, vdInf);
                            continue;
                        }
                        alVdev = new ArrayList();
                        alVdev.add(vdInf);
                        vdHash.put(SJmoFbPgVdevUtility.getStrPgKey(vdInf.getFB4(), vdInf.getPG()), alVdev);
                        continue;
                    }
                    SJmoUtility.putLogDetail("SJmoFbPgVdevUtility", "makeHashVdevInfo", "VDEV Index Invalid:Index =" + vdInf.getIndex());
                    continue;
                }
                SJmoUtility.putLogDetail("SJmoFbPgVdevUtility", "makeHashVdevInfo", "The array element is null. Array element number = " + iObjCnt);
            }
        } else {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoFbPgVdevUtility", "makeHashVdevInfo");
        }
        return vdHash;
    }

    public static ArrayList<SJmoFbPgInfo> makeAlFbPgInfo(Robj_interface_RJiPGIndex[] rmiData) throws SJmoException {
        ArrayList<SJmoFbPgInfo> alRet = new ArrayList();
        if (null != rmiData) {
            if (rmiData instanceof Robj_interface_RJiVDEVIndex[]) {
                alRet = SJmoFbPgVdevUtility.makeAlFbPgVdevInfo((Robj_interface_RJiVDEVIndex[])rmiData);
            } else {
                try {
                    Arrays.sort(rmiData, new SJmoPgComparator());
                }
                catch (Exception jvExp) {
                    throw SJmoUtility.getException(201, 23, 107001, "SJmoFbPgVdevUtility", "makeAlFbPgInfo");
                }
                for (int iObjCnt = 0; iObjCnt < rmiData.length; ++iObjCnt) {
                    SJmoFbPgInfo fbPgInfo = null;
                    if (null != rmiData[iObjCnt]) {
                        SJmoPgIndex pgInf = (SJmoPgIndex)SJmoDataUtility.makeModelObject(rmiData[iObjCnt]);
                        if (pgInf.isValidIndex()) {
                            SJmoFbIndex fbComp = new SJmoFbIndex();
                            fbComp.setFB4(pgInf.getFB4());
                            int iFbSetPoint = Collections.binarySearch(alRet, fbComp);
                            if (iFbSetPoint >= 0) {
                                fbPgInfo = alRet.get(iFbSetPoint);
                                int iPgSetPoint = Collections.binarySearch(fbPgInfo.getPgInfo(), pgInf);
                                if (iPgSetPoint >= 0) {
                                    SJmoUtility.putLogDetail("SJmoFbPgVdevUtility", "makeAlFbPgInfo", "PGIndex Error Index = " + pgInf.getIndex());
                                    continue;
                                }
                                iPgSetPoint = -iPgSetPoint - 1;
                                fbPgInfo.getPgInfo().add(iPgSetPoint, pgInf);
                                continue;
                            }
                            fbPgInfo = new SJmoFbPgInfo();
                            ArrayList<SJmoPgIndex> alPgInfo = new ArrayList<SJmoPgIndex>();
                            alPgInfo.add(pgInf);
                            fbPgInfo.setFB4(pgInf.getFB4());
                            fbPgInfo.setPgInfo(alPgInfo);
                            iFbSetPoint = -iFbSetPoint - 1;
                            alRet.add(iFbSetPoint, fbPgInfo);
                            continue;
                        }
                        SJmoUtility.putLogDetail("SJmoFbPgVdevUtility", "makeHashVdevInfo", "PG Index Invalid:Index =" + pgInf.getIndex());
                        continue;
                    }
                    SJmoUtility.putLogDetail("SJmoFbPgVdevUtility", "makeAlFbPgInfo", "The array element is illegal. Array element number = " + iObjCnt);
                }
            }
        } else {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoFbPgVdevUtility", "makeAlFbPgInfo");
        }
        return alRet;
    }

    public static ArrayList<SJmoFbPgInfo> makeAlFbPgVdevInfo(Robj_interface_RJiVDEVIndex[] rmiData) throws SJmoException {
        ArrayList<SJmoFbPgInfo> alRet = new ArrayList<SJmoFbPgInfo>();
        if (null != rmiData) {
            try {
                Arrays.sort(rmiData, new SJmoVdevComparator());
            }
            catch (Exception jvExp) {
                throw SJmoUtility.getException(201, 23, 107001, "SJmoFbPgVdevUtility", "makeAlFbPgVdevInfo");
            }
            for (int iObjCnt = 0; iObjCnt < rmiData.length; ++iObjCnt) {
                SJmoFbPgInfo fbPgInfo = null;
                SJmoFbPgVdevInfo fbPgVdevInfo = null;
                if (null != rmiData[iObjCnt]) {
                    SJmoVdevIndex vdInf = (SJmoVdevIndex)SJmoDataUtility.makeModelObject(rmiData[iObjCnt]);
                    if (vdInf.isValidIndex()) {
                        SJmoFbIndex fbComp = new SJmoFbIndex();
                        fbComp.setFB4(vdInf.getFB4());
                        int iFbSetPoint = Collections.binarySearch(alRet, fbComp);
                        if (iFbSetPoint >= 0) {
                            fbPgInfo = alRet.get(iFbSetPoint);
                            SJmoPgIndex pgComp = new SJmoPgIndex();
                            pgComp.setFB4(vdInf.getFB4());
                            pgComp.setPG(vdInf.getPG());
                            int iPgSetPoint = Collections.binarySearch(fbPgInfo.getPgInfo(), pgComp);
                            if (iPgSetPoint >= 0) {
                                fbPgVdevInfo = (SJmoFbPgVdevInfo)fbPgInfo.getPgInfo().get(iPgSetPoint);
                                int iVdSetPoint = Collections.binarySearch(fbPgVdevInfo.getAlVdevInfo(), vdInf);
                                if (iVdSetPoint >= 0) {
                                    SJmoUtility.putLogDetail("SJmoFbPgVdevUtility", "makeAlFbPgVdevInfo", "VDEVIndex Error Index = " + vdInf.getIndex());
                                    continue;
                                }
                                iVdSetPoint = -iVdSetPoint - 1;
                                fbPgVdevInfo.getAlVdevInfo().add(iVdSetPoint, vdInf);
                                continue;
                            }
                            fbPgVdevInfo = new SJmoFbPgVdevInfo();
                            ArrayList<SJmoVdevIndex> alVdevInfo = new ArrayList<SJmoVdevIndex>();
                            alVdevInfo.add(vdInf);
                            fbPgVdevInfo.setFB4(vdInf.getFB4());
                            fbPgVdevInfo.setPG(vdInf.getPG());
                            fbPgVdevInfo.setAlVdevInfo(alVdevInfo);
                            iPgSetPoint = -iPgSetPoint - 1;
                            fbPgInfo.getPgInfo().add(iPgSetPoint, fbPgVdevInfo);
                            continue;
                        }
                        fbPgInfo = new SJmoFbPgInfo();
                        fbPgVdevInfo = new SJmoFbPgVdevInfo();
                        ArrayList<SJmoFbPgVdevInfo> alPgInfo = new ArrayList<SJmoFbPgVdevInfo>();
                        ArrayList<SJmoVdevIndex> alVdevInfo = new ArrayList<SJmoVdevIndex>();
                        alVdevInfo.add(vdInf);
                        fbPgVdevInfo.setFB4(vdInf.getFB4());
                        fbPgVdevInfo.setPG(vdInf.getPG());
                        fbPgVdevInfo.setAlVdevInfo(alVdevInfo);
                        alPgInfo.add(fbPgVdevInfo);
                        fbPgInfo.setFB4(vdInf.getFB4());
                        fbPgInfo.setPgInfo(alPgInfo);
                        iFbSetPoint = -iFbSetPoint - 1;
                        alRet.add(iFbSetPoint, fbPgInfo);
                        continue;
                    }
                    SJmoUtility.putLogDetail("SJmoFbPgVdevUtility", "makeHashVdevInfo", "VDEV Index Invalid:Index =" + vdInf.getIndex());
                    continue;
                }
                SJmoUtility.putLogDetail("SJmoFbPgVdevUtility", "makeAlFbPgVdevInfo", "The array element is illegal. Array element number = " + iObjCnt);
            }
        } else {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoFbPgVdevUtility", "makeAlFbPgVdevInfo");
        }
        return alRet;
    }

    public static String getStrPgKey(int iFb4, int iPg) {
        StringBuffer strBuf = new StringBuffer();
        String strWork = new String("");
        strWork = SJmoUtility.itoh(iFb4, 4);
        strBuf.append(strWork);
        strWork = SJmoUtility.itoh(iPg, 4);
        strBuf.append(strWork);
        return strBuf.toString();
    }

    public static String getStrVdevKey(int iFb4, int iPg, int iVdev) {
        StringBuffer strBuf = new StringBuffer();
        String strWork = new String("");
        strWork = SJmoUtility.itoh(iFb4, 4);
        strBuf.append(strWork);
        strWork = SJmoUtility.itoh(iPg, 4);
        strBuf.append(strWork);
        strWork = SJmoUtility.itoh(iVdev, 2);
        strBuf.append(strWork);
        return strBuf.toString();
    }

    public static String makePgDataKey(Robj_interface_RJiPGIndex[] rmiData) throws SJmoException {
        String strKey = null;
        if (null != rmiData) {
            if (rmiData instanceof Robj_interface_RJiPGInfoDetail2[]) {
                strKey = SJmoGetPgDetail.class.getName();
            }
            if (rmiData instanceof Robj_interface_RJiPGLDEVIndex[]) {
                strKey = SJmoGetPgLdevInfo.class.getName();
            }
            if (rmiData instanceof Robj_interface_RJiVDEVInfoDetail[]) {
                strKey = SJmoGetVdevDetail.class.getName();
            }
            if (rmiData instanceof CVSgetDVInfo[]) {
                strKey = SJmoGetVdevDvInfo.class.getName();
            }
            if (rmiData instanceof SJmoRenewMappedExdVolPg[]) {
                strKey = SJmoGetExdVolumeInfoFb4Pg.class.getName();
            }
            if (null == strKey) {
                throw SJmoUtility.getException(201, 23, 107000, "SJmoFbPgVdevUtility", "makePgDataKey");
            }
        } else {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoFbPgVdevUtility", "makePgDataKey");
        }
        return strKey;
    }

    public static RJiPGIndex[] getExdPgIndex(RJiPGIndex[] allData) {
        RJiPGIndex[] retData = null;
        ArrayList<RJiPGIndex> alPgTmp = new ArrayList<RJiPGIndex>();
        if (null != allData) {
            for (int iAll = 0; iAll < allData.length; ++iAll) {
                if (null == allData[iAll] || 101 > allData[iAll].getIFB4() || 16484 < allData[iAll].getIFB4()) continue;
                alPgTmp.add(allData[iAll]);
            }
        } else {
            SJmoUtility.putLogDetail("SJmoFbPgVdevUtility", "getExdPgIndex", "ExdPg has not equiped");
        }
        retData = new RJiPGIndex[alPgTmp.size()];
        retData = alPgTmp.toArray(retData);
        return retData;
    }
}

