/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.modelrc.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.data.system.SJmoClprIndex;
import sanproject.sn2.model.data.system.SJmoClprInfo;
import sanproject.sn2.modelrc.util.SJmoRscUtil;

public class SJmoRscUtilClpr
extends SJmoRscUtil {
    private List clprBase = new ArrayList(32);
    private List clprRsv = new ArrayList(32);
    private List clprDiff = new ArrayList(32);

    @Override
    public void setModelData(List lsModelData) {
        if (!this.clprBase.isEmpty()) {
            return;
        }
        try {
            this.clprBase = (ArrayList)lsModelData.get(0);
        }
        catch (Exception e) {
            SJmoUtility.putLogDetail("SJmoRscUtilClpr", "setModelData", "err: Parameter is invalid.");
            throw SJmoUtility.getException(201, 23, 107021, "SJmoRscUtilClpr", "setModelData");
        }
    }

    @Override
    public void setRsvData(List lsRsvData) {
        this.editRsvData(lsRsvData, 1);
    }

    @Override
    public void delRsvData(List lsRsvData) {
        this.editRsvData(lsRsvData, 2);
    }

    private void editRsvData(List lsRsvData, int iexecflag) {
        ArrayList lsClpr;
        try {
            lsClpr = (ArrayList)lsRsvData.get(0);
        }
        catch (Exception e) {
            SJmoUtility.putLogDetail("SJmoRscUtilClpr", "editRsvData", "err: Parameter is invalid.");
            throw SJmoUtility.getException(201, 23, 107021, "SJmoRscUtilClpr", "editRsvData");
        }
        Collections.sort(lsClpr);
        lsClpr.trimToSize();
        StringBuffer logMsg = new StringBuffer();
        for (SJmoClprInfo clpr : lsClpr) {
            int index = Collections.binarySearch(this.clprRsv, clpr);
            if (index < 0) {
                if (iexecflag == 1) {
                    this.clprRsv.add(clpr);
                    continue;
                }
                logMsg.append(clpr.getSClpr());
                logMsg.append(",");
                continue;
            }
            if (iexecflag == 1) {
                this.clprRsv.set(index, clpr);
                continue;
            }
            this.clprRsv.remove(index);
        }
        if (logMsg.length() > 0) {
            SJmoUtility.putLogDetail("SJmoRscUtilClpr", "editRsvData", "Search is failure:" + logMsg.toString());
        }
    }

    @Override
    public void clearRsvData() {
        this.clprRsv = new ArrayList(32);
    }

    @Override
    public List getRsvData() {
        ArrayList<List> retList = new ArrayList<List>();
        retList.add(this.clprRsv);
        return retList;
    }

    @Override
    public void setDiffData(List lsDiffData) {
        try {
            this.clprDiff = (ArrayList)lsDiffData.get(0);
        }
        catch (Exception e) {
            SJmoUtility.putLogDetail("SJmoRscUtilClpr", "setModelData", "err: Parameter is invalid.");
            throw SJmoUtility.getException(201, 23, 107021, "SJmoRscUtilClpr", "setDiffData");
        }
    }

    @Override
    public List getNeccessityCls() {
        ArrayList<SJmoGetDirect> lsGetDirect = new ArrayList<SJmoGetDirect>();
        SJmoGetDirect direct = new SJmoGetDirect();
        direct.setGetKind(new SJmoGetClprInfo());
        direct.setGetRange(null);
        lsGetDirect.add(direct);
        return lsGetDirect;
    }

    public int chkClprID(SJmoClprIndex clprId) {
        int iRet = 1;
        if (clprId == null || clprId.getSClpr() < 0 || clprId.getSClpr() > 31) {
            throw SJmoUtility.getException(201, 23, 107022, "SJmoRscUtilClpr", "chkClprID(SJmoClprIndex)");
        }
        Collections.sort(this.clprBase);
        Collections.sort(this.clprRsv);
        Collections.sort(this.clprDiff);
        if (0 > Collections.binarySearch(this.clprBase, clprId) && 0 > Collections.binarySearch(this.clprRsv, clprId) && 0 > Collections.binarySearch(this.clprDiff, clprId)) {
            iRet = 0;
        }
        return iRet;
    }

    public int chkClprID(short sClpr) {
        SJmoClprIndex clprId = new SJmoClprIndex();
        clprId.setSClpr(sClpr);
        return this.chkClprID(clprId);
    }

    @Override
    protected List getModelData() {
        return this.clprBase;
    }
}

