/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.report.generator;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import sanproject.sn2.rptdt.csv.SJdtCSVWrapperManager;
import sanproject.sn2.rptdt.csv.wrapper.SJdtCacheInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtDkcInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtLdevCapaInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtLdevCountInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtMicroVersionCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtMpPcbStatusCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtPdevCapaInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtSysoptInfoCSVWrapper;
import sanproject.sn2.rptdt.exception.SJdtRPTDTException;
import sanproject.sn2.rptdt.report.SJdtReportGeneratorManager;
import sanproject.sn2.rptdt.report.generator.SJdtReportGeneratorBase;

public class SJdtArrayglobalReportGenerator
extends SJdtReportGeneratorBase {
    private static final String REPORT_NAME = "Arrayglobal";
    private static final boolean IS_GRAPHIC_REPORT = false;
    private static final boolean USE_TABLE_SORT = false;
    private static final boolean USE_CONTENTS_FOOTER = false;
    private static final String MENU_LINK_VIEW_KEY = "Common.menu.Arrayglobal";
    private static final String EXPLANATION_KEY = "Common.explanation.Arrayglobal";
    private static final String CONTENTS_BODY_VM_FILE_PATH = "/sanproject/sn2/rptdt/template/arrayglobal/vm/contentsBody_Arrayglobal.vm";
    private static final String REPORT_FRAMESET_HTML_FILE_NAME = "Arrayglobal.html";
    private static final String MENU_FRAMESET_HTML_FILE_NAME = "menuFrameset_Arrayglobal.html";
    private static final String MENU_BODY_HTML_FILE_NAME = "menuBody_Arrayglobal.html";
    private static final String CONTENTS_FRAMESET_HTML_FILE_NAME = "contentsFrameset_Arrayglobal.html";
    private static final String CONTENTS_TITLE_HTML_FILE_NAME = "contentsTitle_Arrayglobal.html";
    private static final String CONTENTS_BODY_HTML_FILE_NAME = "contentsBody_Arrayglobal.html";

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    @Override
    public boolean isGraphicReport() {
        return false;
    }

    @Override
    public boolean useTableSort() {
        return false;
    }

    @Override
    public boolean useContentsFooter() {
        return false;
    }

    @Override
    public String getMenuLinkViewKey() {
        return MENU_LINK_VIEW_KEY;
    }

    @Override
    public String getExplanationKey() {
        return EXPLANATION_KEY;
    }

    @Override
    public String getReportFramesetHtmlFileName() {
        return REPORT_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuFramesetHtmlFileName() {
        return MENU_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuBodyHtmlFileName() {
        return MENU_BODY_HTML_FILE_NAME;
    }

    @Override
    public String getContentsFramesetHtmlFileName() {
        return CONTENTS_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getContentsTitleHtmlFileName() {
        return CONTENTS_TITLE_HTML_FILE_NAME;
    }

    @Override
    public String getContentsBodyHtmlFileName() {
        return CONTENTS_BODY_HTML_FILE_NAME;
    }

    @Override
    public void generateContentsBody() throws SJdtRPTDTException {
        VelocityContext context = SJdtReportGeneratorManager.getVelocityContext();
        this.setFixedStr(context);
        this.setVariableStr(context);
        String generateFilePath = this.OUTPUT_HTML_DIR + this.getContentsBodyHtmlFileName();
        SJdtReportGeneratorManager.generateFile(context, CONTENTS_BODY_VM_FILE_PATH, generateFilePath);
    }

    public void setFixedStr(VelocityContext context) {
        context.put("storageSystemType", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.storageSystemType"));
        context.put("serialNumber", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.serialNumber"));
        context.put("fullSerialNumber", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.fullSerialNumber"));
        context.put("ipAddress", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.ipAddress"));
        context.put("microProgramVersions", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.microProgramVersions"));
        context.put("main", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.main"));
        context.put("svp", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.svp"));
        context.put("ssvp", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.ssvp"));
        context.put("htp", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.htp"));
        context.put("dkaf", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.dkaf"));
        context.put("fcdg", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.fcdg"));
        context.put("cudg4", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.cudg4"));
        context.put("ramBoot", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.ramBoot"));
        context.put("romBoot", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.romBoot"));
        context.put("cmbk", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.cmbk"));
        context.put("config", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.config"));
        context.put("hdd", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.hdd"));
        context.put("hddSvp", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.hddSvp"));
        context.put("expander", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.expander"));
        context.put("expanderFmu", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.expanderFmu"));
        context.put("cfm", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.cfm"));
        context.put("printoutTool", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.printoutTool"));
        context.put("fchf", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.fchf"));
        context.put("btcl", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.btcl"));
        context.put("numberOfCus", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.numberOfCus"));
        context.put("cacheSize", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.cacheSize"));
        context.put("sharedMemorySize", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.sharedMemorySize"));
        context.put("module0", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.module0"));
        context.put("module1", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.module1"));
        context.put("numberOfDkas", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.numberOfDkas"));
        context.put("systemOptions", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.systemOptions"));
        context.put("driveCapacity", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.driveCapacity"));
        context.put("spareDriveCapacity", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.spareDriveCapacity"));
        context.put("openVolumeCapacity", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.openVolumeCapacity"));
        context.put("allocated", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.allocated"));
        context.put("unallocated", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.unallocated"));
        context.put("reserved", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.reserved"));
        context.put("free", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.free"));
        context.put("total", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.total"));
        context.put("internalVolumes", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.internalVolumes"));
        context.put("externalVolumes", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.externalVolumes"));
        context.put("totalVolumes", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.totalVolumes"));
        context.put("openAllocated", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.openAllocated"));
        context.put("openUnallocated", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.openUnallocated"));
        context.put("openReserved", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.openReserved"));
        context.put("mfAllocated", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.mfAllocated"));
        context.put("mfReserved", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.mfReserved"));
        context.put("vvol", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.vvol"));
        context.put("mfVolumeCapacity", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.mfVolumeCapacity"));
        context.put("numberOfLdevs", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.numberOfLdevs"));
    }

    public void setVariableStr(VelocityContext context) {
        SJdtMicroVersionCSVWrapper microVersion = (SJdtMicroVersionCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("MicroVersion.csv");
        SJdtDkcInfoCSVWrapper dkcInfo = (SJdtDkcInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("DkcInfo.csv");
        SJdtCacheInfoCSVWrapper cacheInfo = (SJdtCacheInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("CacheInfo.csv");
        SJdtSysoptInfoCSVWrapper sysoptInfo = (SJdtSysoptInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("SysoptInfo.csv");
        SJdtLdevCapaInfoCSVWrapper ldevCapaInfo = (SJdtLdevCapaInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("LdevCapaInfo.csv");
        SJdtLdevCountInfoCSVWrapper ldevCountInfo = (SJdtLdevCountInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("LdevCountInfo.csv");
        SJdtPdevCapaInfoCSVWrapper pdevCapaInfo = (SJdtPdevCapaInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("PdevCapaInfo.csv");
        SJdtMpPcbStatusCSVWrapper mpPcbStatus = (SJdtMpPcbStatusCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("MpPcbStatus.csv");
        String[] dkcInfoRecord = dkcInfo.getRecord(0);
        String storageSystemType = dkcInfo.getValue(dkcInfoRecord, "Storage System Type");
        context.put("valueOfStorageSystemType", (Object)storageSystemType);
        String serialNumber = dkcInfo.getValue(dkcInfoRecord, "Serial Number#");
        if (serialNumber.length() == 10) {
            context.put("serialNumber", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.fullSerialNumber"));
        } else {
            context.put("serialNumber", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.serialNumber"));
        }
        context.put("valueOfSerialNumber", (Object)serialNumber);
        String ipAddress = dkcInfo.getValue(dkcInfoRecord, "IP Address");
        context.put("valueOfIpAddress", (Object)ipAddress);
        String numberOfCus = dkcInfo.getValue(dkcInfoRecord, "Number of CUs");
        context.put("valueOfNumberOfCus", (Object)numberOfCus);
        String[] microVersionRecord = microVersion.getRecord(0);
        String dkcmain = microVersion.getValue(microVersionRecord, "DKCMAIN");
        context.put("valueOfMain", (Object)dkcmain);
        String svp = microVersion.getValue(microVersionRecord, "SVP");
        context.put("valueOfSvp", (Object)svp);
        String ssvp = microVersion.getValue(microVersionRecord, "SSVP");
        context.put("valueOfSsvp", (Object)ssvp);
        String htp = microVersion.getValue(microVersionRecord, "HTP");
        context.put("valueOfHtp", (Object)htp);
        String dkaf = microVersion.getValue(microVersionRecord, "DKAF");
        context.put("valueOfDkaf", (Object)dkaf);
        String fcdg = microVersion.getValue(microVersionRecord, "FCDG");
        context.put("valueOfFcdg", (Object)fcdg);
        String ramBoot = microVersion.getValue(microVersionRecord, "RAM BOOT");
        context.put("valueOfRamBoot", (Object)ramBoot);
        String romBoot = microVersion.getValue(microVersionRecord, "ROM BOOT");
        context.put("valueOfRomBoot", (Object)romBoot);
        String cudg4 = microVersion.getValue(microVersionRecord, "CUDG4");
        context.put("valueOfCudg4", (Object)cudg4);
        String cmbk = microVersion.getValue(microVersionRecord, "CMBK");
        context.put("valueOfCmbk", (Object)cmbk);
        String config = microVersion.getValue(microVersionRecord, "Config");
        context.put("valueOfConfig", (Object)config);
        ArrayList<String> hdd = new ArrayList<String>();
        ArrayList<String> hddSvp = new ArrayList<String>();
        ArrayList<String> cfm = new ArrayList<String>();
        for (int i = 0; i < microVersion.getCsvDataListSize(); ++i) {
            String cfmStr;
            String hddSvpStr;
            String hddStr = microVersion.getValue(i, "HDD");
            if (StringUtils.isNotEmpty((String)hddStr)) {
                hdd.add(hddStr);
            }
            if (StringUtils.isNotEmpty((String)(hddSvpStr = microVersion.getValue(i, "HDD(SVP)")))) {
                hddSvp.add(hddSvpStr);
            }
            if (!StringUtils.isNotEmpty((String)(cfmStr = microVersion.getValue(i, "CFM")))) continue;
            cfm.add(cfmStr);
        }
        if (hdd.size() == 0) {
            hdd.add("");
        }
        if (hddSvp.size() == 0) {
            hddSvp.add("");
        }
        if (cfm.size() == 0) {
            cfm.add("");
        }
        context.put("valueOfHdd", hdd);
        context.put("valueOfHddSvp", hddSvp);
        context.put("valueOfCfm", cfm);
        String expander = microVersion.getValue(microVersionRecord, "Expander");
        context.put("valueOfExpander", (Object)expander);
        String expanderFmu = microVersion.getValue(microVersionRecord, "Expander(FMU)");
        context.put("valueOfExpanderFmu", (Object)expanderFmu);
        String printoutTool = microVersion.getValue(microVersionRecord, "Printout Tool");
        context.put("valueOfPrintoutTool", (Object)printoutTool);
        String fchf = microVersion.getValue(microVersionRecord, "FCHF");
        context.put("valueOfFchf", (Object)fchf);
        String btcl = microVersion.getValue(microVersionRecord, "BTCL");
        context.put("valueOfBtcl", (Object)btcl);
        List<String[]> cacheInfoModule0RecordList = cacheInfo.getMatchedAllRecord("0", "Module#");
        String cacheSizeModule0 = cacheInfo.getSumSize(cacheInfoModule0RecordList, "Cache Size(GB)");
        context.put("valueOfCacheSizeModule0", (Object)cacheSizeModule0);
        String sharedMemorySizeModule0 = cacheInfo.getSumSize(cacheInfoModule0RecordList, "SM Size(GB)");
        context.put("valueOfSharedMemorySizeModule0", (Object)sharedMemorySizeModule0);
        String numberOfDkasModule0 = dkcInfo.getMatchedOneRecordColumnValue("0", "Module#", "Number of DKAs");
        context.put("valueOfNumberOfDkasModule0", (Object)numberOfDkasModule0);
        boolean existsModule1DataFlg = mpPcbStatus.existsModule1Data();
        String notInstalledStr = SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.notInstalled");
        String cacheSizeModule1 = null;
        String sharedMemorySizeModule1 = null;
        String numberOfDkasModule1 = null;
        if (existsModule1DataFlg) {
            List<String[]> cacheInfoModule1RecordList = cacheInfo.getMatchedAllRecord("1", "Module#");
            cacheSizeModule1 = cacheInfo.getSumSize(cacheInfoModule1RecordList, "Cache Size(GB)");
            sharedMemorySizeModule1 = cacheInfo.getSumSize(cacheInfoModule1RecordList, "SM Size(GB)");
            numberOfDkasModule1 = dkcInfo.getMatchedOneRecordColumnValue("1", "Module#", "Number of DKAs");
        } else {
            cacheSizeModule1 = notInstalledStr;
            sharedMemorySizeModule1 = notInstalledStr;
            numberOfDkasModule1 = notInstalledStr;
        }
        context.put("valueOfCacheSizeModule1", (Object)cacheSizeModule1);
        context.put("valueOfSharedMemorySizeModule1", (Object)sharedMemorySizeModule1);
        context.put("valueOfNumberOfDkasModule1", (Object)numberOfDkasModule1);
        ArrayList<String> systemOptions = new ArrayList<String>();
        for (int i = 0; i < sysoptInfo.getCsvDataListSize(); ++i) {
            systemOptions.add(sysoptInfo.getValue(i, "System Option On"));
        }
        context.put("valueOfSystemOptions", systemOptions);
        String[] pdevCapaInfoRecord = pdevCapaInfo.getMatchedOneRecord("Total Capacity(TB)", "PDEV Kind");
        String driveCapacity = pdevCapaInfo.getDriveCapacity(pdevCapaInfoRecord);
        context.put("valueOfDriveCapacity", (Object)driveCapacity);
        String spareDriveCapacity = pdevCapaInfo.getValue(pdevCapaInfoRecord, "Spare Drive");
        spareDriveCapacity = StringUtils.defaultIfEmpty((String)spareDriveCapacity, (String)"0");
        context.put("valueOfSpareDriveCapacity", (Object)spareDriveCapacity);
        String[] openInternalRecord = ldevCapaInfo.getMatchedOneRecord("Internal OPEN Volumes", "Volume Kind");
        String openInternalAllocated = ldevCapaInfo.getValue(openInternalRecord, "Allocated LDEV Capacity(GB)");
        context.put("valueOfOpenInternalAllocated", (Object)openInternalAllocated);
        String openInternalUnallocated = ldevCapaInfo.getValue(openInternalRecord, "Unallocated LDEV Capacity(GB)");
        context.put("valueOfOpenInternalUnallocated", (Object)openInternalUnallocated);
        String openInternalReserved = ldevCapaInfo.getValue(openInternalRecord, "Reserved Capacity(GB)");
        context.put("valueOfOpenInternalReserved", (Object)openInternalReserved);
        String openInternalFree = ldevCapaInfo.getValue(openInternalRecord, "Free Space(GB)");
        context.put("valueOfOpenInternalFree", (Object)openInternalFree);
        String openInternalTotal = ldevCapaInfo.getValue(openInternalRecord, "Total Capacity(GB)");
        context.put("valueOfOpenInternalTotal", (Object)openInternalTotal);
        String[] openExternalRecord = ldevCapaInfo.getMatchedOneRecord("External OPEN Volumes", "Volume Kind");
        String openExternalAllocated = ldevCapaInfo.getValue(openExternalRecord, "Allocated LDEV Capacity(GB)");
        context.put("valueOfOpenExternalAllocated", (Object)openExternalAllocated);
        String openExternalUnallocated = ldevCapaInfo.getValue(openExternalRecord, "Unallocated LDEV Capacity(GB)");
        context.put("valueOfOpenExternalUnallocated", (Object)openExternalUnallocated);
        String openExternalReserved = ldevCapaInfo.getValue(openExternalRecord, "Reserved Capacity(GB)");
        context.put("valueOfOpenExternalReserved", (Object)openExternalReserved);
        String openExternalFree = ldevCapaInfo.getValue(openExternalRecord, "Free Space(GB)");
        context.put("valueOfOpenExternalFree", (Object)openExternalFree);
        String openExternalTotal = ldevCapaInfo.getValue(openExternalRecord, "Total Capacity(GB)");
        context.put("valueOfOpenExternalTotal", (Object)openExternalTotal);
        String[] openTotalRecord = ldevCapaInfo.getMatchedOneRecord("Total OPEN Volumes", "Volume Kind");
        String openTotalAllocated = ldevCapaInfo.getValue(openTotalRecord, "Allocated LDEV Capacity(GB)");
        context.put("valueOfOpenTotalAllocated", (Object)openTotalAllocated);
        String openTotalUnallocated = ldevCapaInfo.getValue(openTotalRecord, "Unallocated LDEV Capacity(GB)");
        context.put("valueOfOpenTotalUnallocated", (Object)openTotalUnallocated);
        String openTotalReserved = ldevCapaInfo.getValue(openTotalRecord, "Reserved Capacity(GB)");
        context.put("valueOfOpenTotalReserved", (Object)openTotalReserved);
        String openTotalFree = ldevCapaInfo.getValue(openTotalRecord, "Free Space(GB)");
        context.put("valueOfOpenTotalFree", (Object)openTotalFree);
        String openTotalTotal = ldevCapaInfo.getValue(openTotalRecord, "Total Capacity(GB)");
        context.put("valueOfOpenTotalTotal", (Object)openTotalTotal);
        String[] mfInternalRecord = ldevCapaInfo.getMatchedOneRecord("Internal Mainframe Volumes", "Volume Kind");
        String mfInternalAllocated = ldevCapaInfo.getValue(mfInternalRecord, "Allocated LDEV Capacity(GB)");
        context.put("valueOfMfInternalAllocated", (Object)mfInternalAllocated);
        String mfInternalReserved = ldevCapaInfo.getValue(mfInternalRecord, "Reserved Capacity(GB)");
        context.put("valueOfMfInternalReserved", (Object)mfInternalReserved);
        String mfInternalFree = ldevCapaInfo.getValue(mfInternalRecord, "Free Space(GB)");
        context.put("valueOfMfInternalFree", (Object)mfInternalFree);
        String mfInternalTotal = ldevCapaInfo.getValue(mfInternalRecord, "Total Capacity(GB)");
        context.put("valueOfMfInternalTotal", (Object)mfInternalTotal);
        String[] mfExternalRecord = ldevCapaInfo.getMatchedOneRecord("External Mainframe Volumes", "Volume Kind");
        String mfExternalAllocated = ldevCapaInfo.getValue(mfExternalRecord, "Allocated LDEV Capacity(GB)");
        context.put("valueOfMfExternalAllocated", (Object)mfExternalAllocated);
        String mfExternalReserved = ldevCapaInfo.getValue(mfExternalRecord, "Reserved Capacity(GB)");
        context.put("valueOfMfExternalReserved", (Object)mfExternalReserved);
        String mfExternalFree = ldevCapaInfo.getValue(mfExternalRecord, "Free Space(GB)");
        context.put("valueOfMfExternalFree", (Object)mfExternalFree);
        String mfExternalTotal = ldevCapaInfo.getValue(mfExternalRecord, "Total Capacity(GB)");
        context.put("valueOfMfExternalTotal", (Object)mfExternalTotal);
        String[] mfTotalRecord = ldevCapaInfo.getMatchedOneRecord("Total Mainframe Volumes", "Volume Kind");
        String mfTotalAllocated = ldevCapaInfo.getValue(mfTotalRecord, "Allocated LDEV Capacity(GB)");
        context.put("valueOfMfTotalAllocated", (Object)mfTotalAllocated);
        String mfTotalReserved = ldevCapaInfo.getValue(mfTotalRecord, "Reserved Capacity(GB)");
        context.put("valueOfMfTotalReserved", (Object)mfTotalReserved);
        String mfTotalFree = ldevCapaInfo.getValue(mfTotalRecord, "Free Space(GB)");
        context.put("valueOfMfTotalFree", (Object)mfTotalFree);
        String mfTotalTotal = ldevCapaInfo.getValue(mfTotalRecord, "Total Capacity(GB)");
        context.put("valueOfMfTotalTotal", (Object)mfTotalTotal);
        String[] numLdevsInternalRecord = ldevCountInfo.getMatchedOneRecord("Internal Volumes", "Volume Kind");
        String numLdevsInternalOpenAllocated = ldevCountInfo.getValue(numLdevsInternalRecord, "Allocated OPEN LDEVs");
        context.put("valueOfNumLdevsInternalOpenAllocated", (Object)numLdevsInternalOpenAllocated);
        String numLdevsInternalOpenUnallocated = ldevCountInfo.getValue(numLdevsInternalRecord, "Unallocated OPEN LDEVs");
        context.put("valueOfNumLdevsInternalOpenUnallocated", (Object)numLdevsInternalOpenUnallocated);
        String numLdevsInternalOpenReserved = ldevCountInfo.getValue(numLdevsInternalRecord, "Reserved OPEN LDEVs");
        context.put("valueOfNumLdevsInternalOpenReserved", (Object)numLdevsInternalOpenReserved);
        String numLdevsInternalMfAllocated = ldevCountInfo.getValue(numLdevsInternalRecord, "Allocated Mainframe LDEVs");
        context.put("valueOfNumLdevsInternalMfAllocated", (Object)numLdevsInternalMfAllocated);
        String numLdevsInternalMfReserved = ldevCountInfo.getValue(numLdevsInternalRecord, "Reserved Mainframe LDEVs");
        context.put("valueOfNumLdevsInternalMfReserved", (Object)numLdevsInternalMfReserved);
        String numLdevsInternalVvol = ldevCountInfo.getValue(numLdevsInternalRecord, "V-VOL");
        if (numLdevsInternalVvol.equals("")) {
            numLdevsInternalVvol = "-";
        }
        context.put("valueOfNumLdevsInternalVvol", (Object)numLdevsInternalVvol);
        String numLdevsInternalTotal = ldevCountInfo.getValue(numLdevsInternalRecord, "Total(All LDEVs)");
        context.put("valueOfNumLdevsInternalTotal", (Object)numLdevsInternalTotal);
        String[] numLdevsExternalRecord = ldevCountInfo.getMatchedOneRecord("External Volumes", "Volume Kind");
        String numLdevsExternalOpenAllocated = ldevCountInfo.getValue(numLdevsExternalRecord, "Allocated OPEN LDEVs");
        context.put("valueOfNumLdevsExternalOpenAllocated", (Object)numLdevsExternalOpenAllocated);
        String numLdevsExternalOpenUnallocated = ldevCountInfo.getValue(numLdevsExternalRecord, "Unallocated OPEN LDEVs");
        context.put("valueOfNumLdevsExternalOpenUnallocated", (Object)numLdevsExternalOpenUnallocated);
        String numLdevsExternalOpenReserved = ldevCountInfo.getValue(numLdevsExternalRecord, "Reserved OPEN LDEVs");
        context.put("valueOfNumLdevsExternalOpenReserved", (Object)numLdevsExternalOpenReserved);
        String numLdevsExternalMfAllocated = ldevCountInfo.getValue(numLdevsExternalRecord, "Allocated Mainframe LDEVs");
        context.put("valueOfNumLdevsExternalMfAllocated", (Object)numLdevsExternalMfAllocated);
        String numLdevsExternalMfReserved = ldevCountInfo.getValue(numLdevsExternalRecord, "Reserved Mainframe LDEVs");
        context.put("valueOfNumLdevsExternalMfReserved", (Object)numLdevsExternalMfReserved);
        String numLdevsExternalVvol = ldevCountInfo.getValue(numLdevsExternalRecord, "V-VOL");
        if (numLdevsExternalVvol.equals("")) {
            numLdevsExternalVvol = "-";
        }
        context.put("valueOfNumLdevsExternalVvol", (Object)numLdevsExternalVvol);
        String numLdevsExternalTotal = ldevCountInfo.getValue(numLdevsExternalRecord, "Total(All LDEVs)");
        context.put("valueOfNumLdevsExternalTotal", (Object)numLdevsExternalTotal);
        String[] numLdevsTotalRecord = ldevCountInfo.getMatchedOneRecord("Total Volumes", "Volume Kind");
        String numLdevsTotalOpenAllocated = ldevCountInfo.getValue(numLdevsTotalRecord, "Allocated OPEN LDEVs");
        context.put("valueOfNumLdevsTotalOpenAllocated", (Object)numLdevsTotalOpenAllocated);
        String numLdevsTotalOpenUnallocated = ldevCountInfo.getValue(numLdevsTotalRecord, "Unallocated OPEN LDEVs");
        context.put("valueOfNumLdevsTotalOpenUnallocated", (Object)numLdevsTotalOpenUnallocated);
        String numLdevsTotalOpenReserved = ldevCountInfo.getValue(numLdevsTotalRecord, "Reserved OPEN LDEVs");
        context.put("valueOfNumLdevsTotalOpenReserved", (Object)numLdevsTotalOpenReserved);
        String numLdevsTotalMfAllocated = ldevCountInfo.getValue(numLdevsTotalRecord, "Allocated Mainframe LDEVs");
        context.put("valueOfNumLdevsTotalMfAllocated", (Object)numLdevsTotalMfAllocated);
        String numLdevsTotalMfReserved = ldevCountInfo.getValue(numLdevsTotalRecord, "Reserved Mainframe LDEVs");
        context.put("valueOfNumLdevsTotalMfReserved", (Object)numLdevsTotalMfReserved);
        String numLdevsTotalVvol = ldevCountInfo.getValue(numLdevsTotalRecord, "V-VOL");
        context.put("valueOfNumLdevsTotalVvol", (Object)numLdevsTotalVvol);
        String numLdevsTotalTotal = ldevCountInfo.getValue(numLdevsTotalRecord, "Total(All LDEVs)");
        context.put("valueOfNumLdevsTotalTotal", (Object)numLdevsTotalTotal);
    }
}

