/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.report.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import sanproject.sn2.rptdt.csv.SJdtCSVWrapperManager;
import sanproject.sn2.rptdt.csv.wrapper.SJdtDkuTempInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtEnvMonInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtHduInfoCSVWrapper;
import sanproject.sn2.rptdt.report.generator.SJdtTableReportGenerator;
import sanproject.sn2.rptdt.util.SJdtRPTDTDevice;

public class SJdtPowerConsumptionReportGenerator
extends SJdtTableReportGenerator {
    private static final String REPORT_NAME = "Powerconsumption";
    private static final boolean IS_GRAPHIC_REPORT = false;
    private static final boolean USE_TABLE_SORT = true;
    private static final boolean USE_CONTENTS_FOOTER = false;
    private static final String[] HEADER_KEY_ARRAY = new String[]{"dateAndTime", "powerConsumptionAverage", "powerConsumptionMaximum", "powerConsumptionMinimum", "tempDkc0Cluster1Average", "tempDkc0Cluster1Maximum", "tempDkc0Cluster1Minimum", "tempDkc0Cluster2Average", "tempDkc0Cluster2Maximum", "tempDkc0Cluster2Minimum", "tempDkc1Cluster1Average", "tempDkc1Cluster1Maximum", "tempDkc1Cluster1Minimum", "tempDkc1Cluster2Average", "tempDkc1Cluster2Maximum", "tempDkc1Cluster2Minimum"};
    private static final String[] HM_HEADER_KEY_ARRAY = new String[]{"dateAndTime", "powerConsumptionAverage", "powerConsumptionMaximum", "powerConsumptionMinimum", "tempDkc0Cluster1Average", "tempDkc0Cluster1Maximum", "tempDkc0Cluster1Minimum", "tempDkc0Cluster2Average", "tempDkc0Cluster2Maximum", "tempDkc0Cluster2Minimum"};
    private static final String[] DKU_NUMBER = new String[]{"00", "01", "02", "03", "04", "05", "10", "11", "12", "13", "14", "15"};
    private static final String[] HDU_NUMBER = new String[]{"0", "1", "2", "3", "4", "5", "6", "7"};
    private static final String[] CL_NUMBER = new String[]{"1", "2"};
    private static final String[] DB_NUMBER = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47"};
    private static final int COLUMN_LENGTH = SJdtPowerConsumptionReportGenerator.getColumnLengthForKeySort(HEADER_KEY_ARRAY.length);
    private static final int HM_COLUMN_LENGTH = SJdtPowerConsumptionReportGenerator.getColumnLengthForKeySort(HM_HEADER_KEY_ARRAY.length);
    private static final String MENU_LINK_VIEW_KEY = "Common.menu.Powerconsumption";
    private static final String EXPLANATION_KEY = "Common.explanation.Powerconsumption";
    private static final String TABLE_HEADER_BASE_KEY = "Powerconsumption.table.header";
    private static final String REPORT_FRAMESET_HTML_FILE_NAME = "Powerconsumption.html";
    private static final String MENU_FRAMESET_HTML_FILE_NAME = "menuFrameset_Powerconsumption.html";
    private static final String MENU_BODY_HTML_FILE_NAME = "menuBody_Powerconsumption.html";
    private static final String CONTENTS_FRAMESET_HTML_FILE_NAME = "contentsFrameset_Powerconsumption.html";
    private static final String CONTENTS_TITLE_HTML_FILE_NAME = "contentsTitle_Powerconsumption.html";
    private static final String CONTENTS_BODY_HTML_FILE_NAME = "contentsBody_Powerconsumption.html";
    private static final String STR_DKUPS = "DKUPS";
    private static final String TEMP_AVE = "TemperatureAverage";
    private static final String TEMP_MAX = "TemperatureMaximum";
    private static final String TEMP_MIN = "TemperatureMinimum";
    private static final String STR_DBPS = "DBPS";
    private static final int S_MODEL_TABLE = 8;
    private static final int M_MODEL_TABLE = 24;
    private static final int H_MODEL_TABLE = 48;
    private static final String MODEL_VER_S = "S";
    private static final String MODEL_VER_M = "M";
    private static final String MODEL_VER_H = "H";

    @Override
    public HashMap<Integer, List<String>> getTableHeaderKeyArrayMulti(int cnt) {
        HashMap<Integer, List<String>> tableHeaderKeyMap = new HashMap<Integer, List<String>>();
        ArrayList<String> setHeaderKey = new ArrayList<String>();
        if (SJdtRPTDTDevice.isHmdev()) {
            setHeaderKey.add("dateAndTime");
            for (String cl : CL_NUMBER) {
                String setAveValueHm = STR_DBPS.toLowerCase() + DB_NUMBER[cnt] + cl + TEMP_AVE;
                String setMaxValueHm = STR_DBPS.toLowerCase() + DB_NUMBER[cnt] + cl + TEMP_MAX;
                String setMinValueHm = STR_DBPS.toLowerCase() + DB_NUMBER[cnt] + cl + TEMP_MIN;
                setHeaderKey.add(setAveValueHm);
                setHeaderKey.add(setMaxValueHm);
                setHeaderKey.add(setMinValueHm);
            }
        } else {
            setHeaderKey.add("dateAndTime");
            for (String hdu : HDU_NUMBER) {
                for (String cl : CL_NUMBER) {
                    String setAveValue = STR_DKUPS.toLowerCase() + DKU_NUMBER[cnt] + hdu + cl + TEMP_AVE;
                    String setMaxValue = STR_DKUPS.toLowerCase() + DKU_NUMBER[cnt] + hdu + cl + TEMP_MAX;
                    String setMinValue = STR_DKUPS.toLowerCase() + DKU_NUMBER[cnt] + hdu + cl + TEMP_MIN;
                    setHeaderKey.add(setAveValue);
                    setHeaderKey.add(setMaxValue);
                    setHeaderKey.add(setMinValue);
                }
            }
        }
        tableHeaderKeyMap.put(cnt, setHeaderKey);
        return tableHeaderKeyMap;
    }

    @Override
    public int numberOfTables() {
        if (SJdtRPTDTDevice.isHmdev()) {
            SJdtHduInfoCSVWrapper hduInfo = (SJdtHduInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("HduInfo.csv");
            return hduInfo.getCsvDataListSize();
        }
        return DKU_NUMBER.length;
    }

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    @Override
    public boolean isGraphicReport() {
        return false;
    }

    @Override
    public boolean useTableSort() {
        return true;
    }

    @Override
    public boolean useContentsFooter() {
        return false;
    }

    @Override
    public String[] getTableHeaderKeyArray() {
        if (SJdtRPTDTDevice.isHmdev()) {
            return HM_HEADER_KEY_ARRAY;
        }
        return HEADER_KEY_ARRAY;
    }

    @Override
    public String getMenuLinkViewKey() {
        return MENU_LINK_VIEW_KEY;
    }

    @Override
    public String getExplanationKey() {
        return EXPLANATION_KEY;
    }

    @Override
    public String getTableHeaderBaseKey() {
        return TABLE_HEADER_BASE_KEY;
    }

    @Override
    public String getReportFramesetHtmlFileName() {
        return REPORT_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuFramesetHtmlFileName() {
        return MENU_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuBodyHtmlFileName() {
        return MENU_BODY_HTML_FILE_NAME;
    }

    @Override
    public String getContentsFramesetHtmlFileName() {
        return CONTENTS_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getContentsTitleHtmlFileName() {
        return CONTENTS_TITLE_HTML_FILE_NAME;
    }

    @Override
    public String getContentsBodyHtmlFileName() {
        return CONTENTS_BODY_HTML_FILE_NAME;
    }

    @Override
    public boolean isEnableSortKey() {
        return true;
    }

    @Override
    public boolean isMultiTable() {
        SJdtDkuTempInfoCSVWrapper dkuTempInfoCsv = (SJdtDkuTempInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("DkuTempInfo.csv");
        return dkuTempInfoCsv.isFileExists();
    }

    @Override
    public List<String[]> getTableDataList() {
        ArrayList<String[]> tableDataList = new ArrayList<String[]>();
        SJdtEnvMonInfoCSVWrapper envMonInfo = (SJdtEnvMonInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("EnvMonInfo.csv");
        List<String[]> csvDataList = envMonInfo.getCsvDataList();
        for (String[] envMonInfoRecord : csvDataList) {
            String[] oneRecord = null;
            oneRecord = SJdtRPTDTDevice.isHmdev() ? new String[HM_COLUMN_LENGTH] : new String[COLUMN_LENGTH];
            oneRecord[((Integer)SJdtPowerConsumptionReportGenerator.headerMap.get((Object)"dateAndTime")).intValue()] = envMonInfo.getValue(envMonInfoRecord, "Date");
            oneRecord[((Integer)SJdtPowerConsumptionReportGenerator.headerMap.get((Object)"powerConsumptionAverage")).intValue()] = envMonInfo.getValue(envMonInfoRecord, "Electric power average");
            oneRecord[((Integer)SJdtPowerConsumptionReportGenerator.headerMap.get((Object)"powerConsumptionMaximum")).intValue()] = envMonInfo.getValue(envMonInfoRecord, "Electric power maximum value");
            oneRecord[((Integer)SJdtPowerConsumptionReportGenerator.headerMap.get((Object)"powerConsumptionMinimum")).intValue()] = envMonInfo.getValue(envMonInfoRecord, "Electric power minimum value");
            oneRecord[((Integer)SJdtPowerConsumptionReportGenerator.headerMap.get((Object)"tempDkc0Cluster1Average")).intValue()] = envMonInfo.getValue(envMonInfoRecord, "DKC0 CL1 Temperature average");
            oneRecord[((Integer)SJdtPowerConsumptionReportGenerator.headerMap.get((Object)"tempDkc0Cluster1Maximum")).intValue()] = envMonInfo.getValue(envMonInfoRecord, "DKC0 CL1 Temperature maximum value");
            oneRecord[((Integer)SJdtPowerConsumptionReportGenerator.headerMap.get((Object)"tempDkc0Cluster1Minimum")).intValue()] = envMonInfo.getValue(envMonInfoRecord, "DKC0 CL1 Temperature minimum value");
            oneRecord[((Integer)SJdtPowerConsumptionReportGenerator.headerMap.get((Object)"tempDkc0Cluster2Average")).intValue()] = envMonInfo.getValue(envMonInfoRecord, "DKC0 CL2 Temperature average");
            oneRecord[((Integer)SJdtPowerConsumptionReportGenerator.headerMap.get((Object)"tempDkc0Cluster2Maximum")).intValue()] = envMonInfo.getValue(envMonInfoRecord, "DKC0 CL2 Temperature maximum value");
            oneRecord[((Integer)SJdtPowerConsumptionReportGenerator.headerMap.get((Object)"tempDkc0Cluster2Minimum")).intValue()] = envMonInfo.getValue(envMonInfoRecord, "DKC0 CL2 Temperature minimum value");
            if (!SJdtRPTDTDevice.isHmdev()) {
                oneRecord[((Integer)SJdtPowerConsumptionReportGenerator.headerMap.get((Object)"tempDkc1Cluster1Average")).intValue()] = envMonInfo.getValue(envMonInfoRecord, "DKC1 CL1 Temperature average");
                oneRecord[((Integer)SJdtPowerConsumptionReportGenerator.headerMap.get((Object)"tempDkc1Cluster1Maximum")).intValue()] = envMonInfo.getValue(envMonInfoRecord, "DKC1 CL1 Temperature maximum value");
                oneRecord[((Integer)SJdtPowerConsumptionReportGenerator.headerMap.get((Object)"tempDkc1Cluster1Minimum")).intValue()] = envMonInfo.getValue(envMonInfoRecord, "DKC1 CL1 Temperature minimum value");
                oneRecord[((Integer)SJdtPowerConsumptionReportGenerator.headerMap.get((Object)"tempDkc1Cluster2Average")).intValue()] = envMonInfo.getValue(envMonInfoRecord, "DKC1 CL2 Temperature average");
                oneRecord[((Integer)SJdtPowerConsumptionReportGenerator.headerMap.get((Object)"tempDkc1Cluster2Maximum")).intValue()] = envMonInfo.getValue(envMonInfoRecord, "DKC1 CL2 Temperature maximum value");
                oneRecord[((Integer)SJdtPowerConsumptionReportGenerator.headerMap.get((Object)"tempDkc1Cluster2Minimum")).intValue()] = envMonInfo.getValue(envMonInfoRecord, "DKC1 CL2 Temperature minimum value");
            }
            tableDataList.add(oneRecord);
        }
        return tableDataList;
    }

    @Override
    public HashMap<Integer, List<String[]>> getTableDataListMulti(int cnt, String[] tableHeader) {
        ArrayList<String[]> tableDataList = new ArrayList<String[]>();
        HashMap<Integer, List<String[]>> tableDataListMap = new HashMap<Integer, List<String[]>>();
        SJdtDkuTempInfoCSVWrapper dkuTempInfo = (SJdtDkuTempInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("DkuTempInfo.csv");
        List<String[]> csvDataList = dkuTempInfo.getCsvDataList();
        SJdtHduInfoCSVWrapper hduInfo = (SJdtHduInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("HduInfo.csv");
        for (String[] dkuTempInfoRecord : csvDataList) {
            String[] oneRecord;
            if (SJdtRPTDTDevice.isHmdev()) {
                oneRecord = new String[tableHeader.length * 2];
                oneRecord[((Integer)SJdtPowerConsumptionReportGenerator.headerMap.get((Object)"dateAndTime")).intValue()] = dkuTempInfo.getValue(dkuTempInfoRecord, "Date");
                String dbType = hduInfo.getValue(cnt, "DB Type");
                for (String cl : CL_NUMBER) {
                    String getValueMin;
                    String getValueMax;
                    String getValueAve;
                    if (dbType.equals("DBF2")) {
                        getValueAve = hduInfo.getValue(cnt, "DB Location") + " " + STR_DBPS + DB_NUMBER[cnt] + cl + " Temperature average";
                        getValueMax = hduInfo.getValue(cnt, "DB Location") + " " + STR_DBPS + DB_NUMBER[cnt] + cl + " Temperature maximum value";
                        getValueMin = hduInfo.getValue(cnt, "DB Location") + " " + STR_DBPS + DB_NUMBER[cnt] + cl + " Temperature minimum value";
                        oneRecord[((Integer)SJdtPowerConsumptionReportGenerator.headerMap.get((Object)new StringBuilder().append((String)STR_DBPS.toLowerCase()).append((String)SJdtPowerConsumptionReportGenerator.DB_NUMBER[cnt]).append((String)cl).append((String)TEMP_AVE).toString())).intValue()] = dkuTempInfo.getValue(dkuTempInfoRecord, getValueAve);
                        oneRecord[((Integer)SJdtPowerConsumptionReportGenerator.headerMap.get((Object)new StringBuilder().append((String)STR_DBPS.toLowerCase()).append((String)SJdtPowerConsumptionReportGenerator.DB_NUMBER[cnt]).append((String)cl).append((String)TEMP_MAX).toString())).intValue()] = dkuTempInfo.getValue(dkuTempInfoRecord, getValueMax);
                        oneRecord[((Integer)SJdtPowerConsumptionReportGenerator.headerMap.get((Object)new StringBuilder().append((String)STR_DBPS.toLowerCase()).append((String)SJdtPowerConsumptionReportGenerator.DB_NUMBER[cnt]).append((String)cl).append((String)TEMP_MIN).toString())).intValue()] = dkuTempInfo.getValue(dkuTempInfoRecord, getValueMin);
                        continue;
                    }
                    getValueAve = "DB" + DB_NUMBER[cnt] + " " + STR_DBPS + DB_NUMBER[cnt] + cl + " Temperature average";
                    getValueMax = "DB" + DB_NUMBER[cnt] + " " + STR_DBPS + DB_NUMBER[cnt] + cl + " Temperature maximum value";
                    getValueMin = "DB" + DB_NUMBER[cnt] + " " + STR_DBPS + DB_NUMBER[cnt] + cl + " Temperature minimum value";
                    oneRecord[((Integer)SJdtPowerConsumptionReportGenerator.headerMap.get((Object)new StringBuilder().append((String)STR_DBPS.toLowerCase()).append((String)SJdtPowerConsumptionReportGenerator.DB_NUMBER[cnt]).append((String)cl).append((String)TEMP_AVE).toString())).intValue()] = dkuTempInfo.getValue(dkuTempInfoRecord, getValueAve);
                    oneRecord[((Integer)SJdtPowerConsumptionReportGenerator.headerMap.get((Object)new StringBuilder().append((String)STR_DBPS.toLowerCase()).append((String)SJdtPowerConsumptionReportGenerator.DB_NUMBER[cnt]).append((String)cl).append((String)TEMP_MAX).toString())).intValue()] = dkuTempInfo.getValue(dkuTempInfoRecord, getValueMax);
                    oneRecord[((Integer)SJdtPowerConsumptionReportGenerator.headerMap.get((Object)new StringBuilder().append((String)STR_DBPS.toLowerCase()).append((String)SJdtPowerConsumptionReportGenerator.DB_NUMBER[cnt]).append((String)cl).append((String)TEMP_MIN).toString())).intValue()] = dkuTempInfo.getValue(dkuTempInfoRecord, getValueMin);
                }
                tableDataList.add(oneRecord);
                continue;
            }
            oneRecord = new String[tableHeader.length * 2];
            oneRecord[((Integer)SJdtPowerConsumptionReportGenerator.headerMap.get((Object)"dateAndTime")).intValue()] = dkuTempInfo.getValue(dkuTempInfoRecord, "Date");
            for (String hdu : HDU_NUMBER) {
                for (String cl : CL_NUMBER) {
                    String getValueAve = "DKU" + DKU_NUMBER[cnt] + " " + STR_DKUPS + DKU_NUMBER[cnt] + hdu + cl + " Temperature average";
                    String getValueMax = "DKU" + DKU_NUMBER[cnt] + " " + STR_DKUPS + DKU_NUMBER[cnt] + hdu + cl + " Temperature maximum value";
                    String getValueMin = "DKU" + DKU_NUMBER[cnt] + " " + STR_DKUPS + DKU_NUMBER[cnt] + hdu + cl + " Temperature minimum value";
                    oneRecord[((Integer)SJdtPowerConsumptionReportGenerator.headerMap.get((Object)new StringBuilder().append((String)STR_DKUPS.toLowerCase()).append((String)SJdtPowerConsumptionReportGenerator.DKU_NUMBER[cnt]).append((String)hdu).append((String)cl).append((String)TEMP_AVE).toString())).intValue()] = dkuTempInfo.getValue(dkuTempInfoRecord, getValueAve);
                    oneRecord[((Integer)SJdtPowerConsumptionReportGenerator.headerMap.get((Object)new StringBuilder().append((String)STR_DKUPS.toLowerCase()).append((String)SJdtPowerConsumptionReportGenerator.DKU_NUMBER[cnt]).append((String)hdu).append((String)cl).append((String)TEMP_MAX).toString())).intValue()] = dkuTempInfo.getValue(dkuTempInfoRecord, getValueMax);
                    oneRecord[((Integer)SJdtPowerConsumptionReportGenerator.headerMap.get((Object)new StringBuilder().append((String)STR_DKUPS.toLowerCase()).append((String)SJdtPowerConsumptionReportGenerator.DKU_NUMBER[cnt]).append((String)hdu).append((String)cl).append((String)TEMP_MIN).toString())).intValue()] = dkuTempInfo.getValue(dkuTempInfoRecord, getValueMin);
                }
            }
            tableDataList.add(oneRecord);
        }
        tableDataListMap.put(cnt, tableDataList);
        return tableDataListMap;
    }

    @Override
    public String[] setHduInfo1(int cnt) {
        String[] DataList = new String[7];
        int Tbl_cnt = 0;
        SJdtHduInfoCSVWrapper hduInfo = (SJdtHduInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("HduInfo.csv");
        String dbType = hduInfo.getValue(cnt, "DB Type");
        DataList[Tbl_cnt] = "Date and Time,charSort,left";
        ++Tbl_cnt;
        for (String cl : CL_NUMBER) {
            DataList[Tbl_cnt] = "TEMP:" + hduInfo.getValue(cnt, "DB Location") + "-" + STR_DBPS + DB_NUMBER[cnt] + "-" + cl + " Average (degrees C),numSort,right";
            DataList[++Tbl_cnt] = "TEMP:" + hduInfo.getValue(cnt, "DB Location") + "-" + STR_DBPS + DB_NUMBER[cnt] + "-" + cl + " Maximum (degrees C),numSort,right";
            DataList[++Tbl_cnt] = "TEMP:" + hduInfo.getValue(cnt, "DB Location") + "-" + STR_DBPS + DB_NUMBER[cnt] + "-" + cl + " Minimum (degrees C),numSort,right";
            ++Tbl_cnt;
        }
        return DataList;
    }
}

