/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.report.generator;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.rptdt.csv.SJdtCSVWrapperManager;
import sanproject.sn2.rptdt.csv.wrapper.SJdtPdevInfoCSVWrapper;
import sanproject.sn2.rptdt.report.generator.SJdtTableReportGenerator;

public class SJdtSparediskReportGenerator
extends SJdtTableReportGenerator {
    private static final String REPORT_NAME = "Sparedisk";
    private static final boolean IS_GRAPHIC_REPORT = false;
    private static final boolean USE_TABLE_SORT = true;
    private static final boolean USE_CONTENTS_FOOTER = false;
    private static final String[] HEADER_KEY_ARRAY = new String[]{"driveTypeCode", "driveCapacity", "location"};
    private static final String MENU_LINK_VIEW_KEY = "Common.menu.Sparedisk";
    private static final String EXPLANATION_KEY = "Common.explanation.Sparedisk";
    private static final String TABLE_HEADER_BASE_KEY = "Sparedisk.table.header";
    private static final String REPORT_FRAMESET_HTML_FILE_NAME = "Sparedisk.html";
    private static final String MENU_FRAMESET_HTML_FILE_NAME = "menuFrameset_Sparedisk.html";
    private static final String MENU_BODY_HTML_FILE_NAME = "menuBody_Sparedisk.html";
    private static final String CONTENTS_FRAMESET_HTML_FILE_NAME = "contentsFrameset_Sparedisk.html";
    private static final String CONTENTS_TITLE_HTML_FILE_NAME = "contentsTitle_Sparedisk.html";
    private static final String CONTENTS_BODY_HTML_FILE_NAME = "contentsBody_Sparedisk.html";

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    @Override
    public boolean isGraphicReport() {
        return false;
    }

    @Override
    public boolean useTableSort() {
        return true;
    }

    @Override
    public boolean useContentsFooter() {
        return false;
    }

    @Override
    public String[] getTableHeaderKeyArray() {
        return HEADER_KEY_ARRAY;
    }

    @Override
    public String getMenuLinkViewKey() {
        return MENU_LINK_VIEW_KEY;
    }

    @Override
    public String getExplanationKey() {
        return EXPLANATION_KEY;
    }

    @Override
    public String getTableHeaderBaseKey() {
        return TABLE_HEADER_BASE_KEY;
    }

    @Override
    public String getReportFramesetHtmlFileName() {
        return REPORT_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuFramesetHtmlFileName() {
        return MENU_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuBodyHtmlFileName() {
        return MENU_BODY_HTML_FILE_NAME;
    }

    @Override
    public String getContentsFramesetHtmlFileName() {
        return CONTENTS_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getContentsTitleHtmlFileName() {
        return CONTENTS_TITLE_HTML_FILE_NAME;
    }

    @Override
    public String getContentsBodyHtmlFileName() {
        return CONTENTS_BODY_HTML_FILE_NAME;
    }

    @Override
    public List<String[]> getTableDataList() {
        ArrayList<String[]> tableDataList = new ArrayList<String[]>();
        SJdtPdevInfoCSVWrapper pdevInfo = (SJdtPdevInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("PdevInfo.csv");
        List<String[]> pdevInfoRecordList = pdevInfo.getMatchedAllRecord("Spare Drive", "ECC Group");
        for (String[] pdevInfoRecord : pdevInfoRecordList) {
            String[] oneRecord = new String[HEADER_KEY_ARRAY.length];
            oneRecord[((Integer)SJdtSparediskReportGenerator.headerMap.get((Object)"driveTypeCode")).intValue()] = pdevInfo.getValue(pdevInfoRecord, "Device Type-Code");
            oneRecord[((Integer)SJdtSparediskReportGenerator.headerMap.get((Object)"driveCapacity")).intValue()] = pdevInfo.getValue(pdevInfoRecord, "Device Capacity");
            oneRecord[((Integer)SJdtSparediskReportGenerator.headerMap.get((Object)"location")).intValue()] = pdevInfo.getValue(pdevInfoRecord, "PDEV Location");
            tableDataList.add(oneRecord);
        }
        return tableDataList;
    }
}

