/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.servlet;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sanproject.sn2.base.session.SJbaseUserSessionManager;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.base.system.SJbaseSystemAgent;
import sanproject.sn2.base.system.SJbaseSystemItem;
import sanproject.sn2.base.system.SJbaseSystemManager;
import sanproject.sn2.base.system.inf.SJbaseSystemStatusInterface;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.plugin.SJcPluginItem;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcSingletonManagerUty;
import sanproject.sn2.com.utility.SJcStringUty;
import sanproject.sn2.com.utility.SJcSystemUty;

public class SJsvlCheckServerStsServlet
extends HttpServlet {
    private final String LOG_FUNCTION = "ServerStsCheck";
    private final String LOG_TITLE = ((Object)((Object)this)).getClass().getSimpleName();
    private final String ENCODE_UTF8 = "UTF-8";
    private final String SYSTEM_PRESTART = "STATUS_PRESTART";
    private final String SYSTEM_ALLGREEN = "STATUS_ALLGREEN";
    private final String SYSTEM_RESTRICTED = "STATUS_RESTRICTED";
    private final String SYSTEM_STARTEXEC = "STATUS_STARTEXEC";
    private final String PRESTART = "PRESTART";
    private final String START = "START";
    private final String ALREADY = "ALREADY";
    private final String STOP = "STOP";
    private final String STOPEND = "STOPEND";
    private final String KEY_INPUTPRM_TYPE = "Type";
    private final String KEY_ESSENTIAL = "essential";
    private final String KEY_NAME = "name";
    private final String KEY_PHASE = "phase";
    private final String KEY_FATAL = "fatal";
    private final String KEY_RETRY = "retry";
    private final String KEY_ERRORCODE = "errorcode";
    private final String PARAM_STSLIST = "stsList";
    private final String PARAM_LOGIN_STSLIST = "svpLoginSts";
    private final String FORWARD_JSP = "/jsp/SJsvlSystemStatusView.jsp";
    private final String MODE_XML = "xml";
    private SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger("SN_System.log");

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String LOG_SUBTITLE = "doGet";
        this.STD_LOGGER.trace("ServerStsCheck", this.LOG_TITLE, "doGet", "Start.");
        this.doPost(request, response);
        this.STD_LOGGER.trace("ServerStsCheck", this.LOG_TITLE, "doGet", "End.");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String LOG_SUBTITLE = "doPost";
        this.STD_LOGGER.trace("ServerStsCheck", this.LOG_TITLE, "doPost", "Start.");
        InetAddress ipAddress = InetAddress.getByName(request.getRemoteAddr());
        if (!SJcSystemUty.chkIP_Myself(ipAddress)) {
            response.sendError(403);
            return;
        }
        request.setCharacterEncoding("UTF-8");
        String mode = request.getParameter("Type");
        this.STD_LOGGER.info("ServerStsCheck", this.LOG_TITLE, "doPost", "Type : " + mode);
        if (mode == null) {
            String systemSts = this.getSystemManagerSts();
            response.setContentType("text/html;charset=UTF-8");
            response.getWriter().print(systemSts);
        } else if (mode.equals("xml")) {
            ArrayList<HashMap<String, String>> mapList = this.getAllSystemSts();
            request.setAttribute("stsList", mapList);
            String svpLoginSts = this.getSvpLoginSts();
            request.setAttribute("svpLoginSts", (Object)svpLoginSts);
            ServletContext sc = this.getServletContext();
            RequestDispatcher rd = sc.getRequestDispatcher("/jsp/SJsvlSystemStatusView.jsp");
            rd.forward((ServletRequest)request, (ServletResponse)response);
        } else {
            String systemSts = this.getSystemManagerSts();
            response.setContentType("text/html;charset=UTF-8");
            response.getWriter().print(systemSts);
        }
        this.STD_LOGGER.trace("ServerStsCheck", this.LOG_TITLE, "doPost", "End.");
    }

    private String getSystemManagerSts() throws IOException {
        String LOG_SUBTITLE = "getSystemManagerSts";
        this.STD_LOGGER.info("ServerStsCheck", this.LOG_TITLE, "getSystemManagerSts", "Start.");
        SJbaseSystemManager systemManager = (SJbaseSystemManager)SJcSingletonManagerUty.getSingleton(SJbaseSystemManager.class);
        String returnSts = "STATUS_PRESTART";
        if (systemManager != null) {
            int startupStatus = systemManager.getStartupStatus();
            returnSts = this.getStartupStatusString(startupStatus);
        }
        this.STD_LOGGER.info("ServerStsCheck", this.LOG_TITLE, "getSystemManagerSts", "End.");
        return returnSts;
    }

    private ArrayList<HashMap<String, String>> getAllSystemSts() throws IOException {
        List<SJcPluginItem> itemList;
        String LOG_SUBTITLE = "getAllSystemSts";
        this.STD_LOGGER.trace("ServerStsCheck", this.LOG_TITLE, "getAllSystemSts", "Start.");
        ArrayList<HashMap<String, String>> mapList = new ArrayList<HashMap<String, String>>();
        SJbaseSystemManager systemManager = (SJbaseSystemManager)SJcSingletonManagerUty.getSingleton(SJbaseSystemManager.class);
        if (systemManager != null && (itemList = systemManager.getPluginItems()) != null) {
            ListIterator<SJcPluginItem> iterator = itemList.listIterator();
            String logStr = "";
            while (iterator.hasNext()) {
                SJbaseSystemItem item = null;
                try {
                    item = (SJbaseSystemItem)iterator.next();
                }
                catch (ClassCastException cce) {
                    this.STD_LOGGER.error("ServerStsCheck", this.LOG_TITLE, "getAllSystemSts", "Item class is invald.", cce);
                    continue;
                }
                boolean essential = item.isEssential();
                String name = this.nullToEmpty(item.getName());
                String systemName = SJcStringUty.filterEscape(name);
                SJbaseSystemAgent agent = item.getAgent();
                String phaseString = "PRESTART";
                boolean fatal = false;
                boolean retry = false;
                SJcMessage error = null;
                String errorCode = "";
                if (agent != null) {
                    SJbaseSystemStatusInterface systemStatus = agent.getStatus();
                    int phase = systemStatus.getPhase();
                    phaseString = this.getPhaseString(phase);
                    fatal = systemStatus.isFatal();
                    retry = systemStatus.isReqRetry();
                    error = systemStatus.getErrorCode();
                    if (null != error) {
                        errorCode = error.getFunctionID() + error.getModuleID() + "-" + error.getMsgID();
                    }
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("essential", String.valueOf(essential));
                map.put("name", systemName);
                map.put("phase", phaseString);
                map.put("fatal", String.valueOf(fatal));
                map.put("retry", String.valueOf(retry));
                map.put("errorcode", errorCode);
                mapList.add(map);
                logStr = logStr + "[" + systemName + ":" + String.valueOf(essential) + ":" + phaseString + ":" + String.valueOf(fatal) + ":" + String.valueOf(retry) + ":" + errorCode + "]";
            }
            this.STD_LOGGER.info("ServerStsCheck", this.LOG_TITLE, "getAllSystemSts", logStr);
        }
        this.STD_LOGGER.trace("ServerStsCheck", this.LOG_TITLE, "getAllSystemSts", "End.");
        return mapList;
    }

    private String getSvpLoginSts() {
        List<SJbaseUserSessionInterface> userSessionList;
        String LOG_SUBTITLE = "getSvpLoginSts";
        this.STD_LOGGER.trace("ServerStsCheck", this.LOG_TITLE, "getSvpLoginSts", "Start.");
        String strSvpLoginSts = "";
        SJbaseUserSessionManager userSessionManager = (SJbaseUserSessionManager)SJcSingletonManagerUty.getSingleton(SJbaseUserSessionManager.class);
        if (userSessionManager != null && (userSessionList = userSessionManager.getAllUserSession()) != null) {
            String logStr = "";
            boolean svpLoginFlg = false;
            for (SJbaseUserSessionInterface userSession : userSessionList) {
                String strLoginType;
                if (userSession == null || (strLoginType = userSession.getLoginType()) == null || !strLoginType.equals("SVP")) continue;
                svpLoginFlg = true;
                break;
            }
            strSvpLoginSts = String.valueOf(svpLoginFlg);
            logStr = logStr + "[" + strSvpLoginSts + "]";
            this.STD_LOGGER.info("ServerStsCheck", this.LOG_TITLE, "getSvpLoginSts", logStr);
        }
        this.STD_LOGGER.trace("ServerStsCheck", this.LOG_TITLE, "getSvpLoginSts", "End.");
        return strSvpLoginSts;
    }

    private String getStartupStatusString(int statusInt) {
        String LOG_SUBTITLE = "getStartupStatusString";
        this.STD_LOGGER.info("ServerStsCheck", this.LOG_TITLE, "getStartupStatusString", "Start. statusInt : " + statusInt);
        String statusString = null;
        switch (statusInt) {
            case -1: {
                statusString = "STATUS_PRESTART";
                break;
            }
            case 0: {
                statusString = "STATUS_ALLGREEN";
                break;
            }
            case 1: {
                statusString = "STATUS_RESTRICTED";
                break;
            }
            case 2: {
                statusString = "STATUS_STARTEXEC";
                break;
            }
            default: {
                statusString = "STATUS_PRESTART";
            }
        }
        this.STD_LOGGER.info("ServerStsCheck", this.LOG_TITLE, "getStartupStatusString", "End. -return : " + statusString);
        return statusString;
    }

    private String getPhaseString(int phase) {
        String LOG_SUBTITLE = "getPhaseString";
        this.STD_LOGGER.trace("ServerStsCheck", this.LOG_TITLE, "getPhaseString", "Start.");
        String phaseString = null;
        switch (phase) {
            case 0: {
                phaseString = "PRESTART";
                break;
            }
            case 1: {
                phaseString = "START";
                break;
            }
            case 2: {
                phaseString = "ALREADY";
                break;
            }
            case 3: {
                phaseString = "STOP";
                break;
            }
            case 4: {
                phaseString = "STOPEND";
                break;
            }
            default: {
                phaseString = "PRESTART";
            }
        }
        this.STD_LOGGER.trace("ServerStsCheck", this.LOG_TITLE, "getPhaseString", "End. -return : " + phaseString);
        return phaseString;
    }

    private String nullToEmpty(String str) {
        if (str == null) {
            str = "";
        }
        return str;
    }
}

