/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.systemcall.mappiniset.smis;

import java.io.File;
import java.util.Properties;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.systemcall.mappiniset.com.SJcmdMappDkcSetException;
import sanproject.sn2.systemcall.mappiniset.com.SJcmdMappDkcSetUtility;
import sanproject.sn2.systemcall.mappiniset.smis.SJcmdMappDkcSetSmisBaseFunction;

public class SJcmdMappDkcSetSmisConfUpload
extends SJcmdMappDkcSetSmisBaseFunction {
    private static final String LOG_FUNCTION = SJcmdMappDkcSetSmisConfUpload.class.getSimpleName();
    private static final int PARAM_COUNT = 2;
    private static final String FILE_NAME_SMIS_CONF = "array-setting-01.properties";
    private static final String FILE_NAME_SMIS_SUPPORT_KEY = "array-setting-01-key.properties";
    private static final String FILE_NAME_SMIS_CONF_BACK = "array-setting-01.properties_backup";
    private String strConfFilePath = "";

    public static synchronized void main(String[] argv) {
        SJcmdMappDkcSetSmisConfUpload cls = new SJcmdMappDkcSetSmisConfUpload();
        cls.calledExternal(argv);
    }

    @Override
    protected String makeStrFncDirName() {
        return "MpSmisConf" + File.separator;
    }

    @Override
    protected void checkArgvParameter(String[] argv) throws SJcmdMappDkcSetException {
        String LOG_METHOD = Thread.currentThread().getStackTrace()[1].getMethodName();
        this.checkNullArgvParameter(argv);
        if (argv.length != 2) {
            SJcLogUty.getLogger().error("MappIniSet", LOG_FUNCTION, LOG_METHOD, "argv.length:" + argv.length);
            throw new SJcmdMappDkcSetException("205500");
        }
        if (!new File(argv[1]).isFile()) {
            SJcLogUty.getLogger().error("MappIniSet", LOG_FUNCTION, LOG_METHOD, "argv[1]:" + argv[1]);
            throw new SJcmdMappDkcSetException("205501");
        }
        String fileName = SJcmdMappDkcSetUtility.getFileName(argv[1]);
        if (!fileName.equals(FILE_NAME_SMIS_CONF)) {
            SJcLogUty.getLogger().error("MappIniSet", LOG_FUNCTION, LOG_METHOD, "argv[1]:" + argv[1]);
            throw new SJcmdMappDkcSetException("205502");
        }
        this.strConfFilePath = argv[1];
    }

    @Override
    protected void execute() throws SJcmdMappDkcSetException {
        String LOG_METHOD = Thread.currentThread().getStackTrace()[1].getMethodName();
        SJcLogUty.getLogger().info("MappIniSet", LOG_FUNCTION, LOG_METHOD, "Start");
        SJcmdMappDkcSetUtility.copySingleFile(this.strConfFilePath, SJcmdMappDkcSetUtility.concatFilePath(this.strDkcWrkDirAbsPath, FILE_NAME_SMIS_CONF));
        this.checkConfiguration();
        this.updateConfiguration();
        SJcLogUty.getLogger().info("MappIniSet", LOG_FUNCTION, LOG_METHOD, "End");
    }

    private void checkConfiguration() throws SJcmdMappDkcSetException {
        String LOG_METHOD = Thread.currentThread().getStackTrace()[1].getMethodName();
        SJcLogUty.getLogger().info("MappIniSet", LOG_FUNCTION, LOG_METHOD, "Start");
        String propConfPath = SJcmdMappDkcSetUtility.concatFilePath(this.strDkcWrkDirAbsPath, FILE_NAME_SMIS_CONF);
        Properties propConf = SJcmdMappDkcSetUtility.loadProperties(propConfPath);
        String propConfKeyPath = SJcmdMappDkcSetUtility.concatFilePath(this.strDkcDirAbsPath, "SMI", "hitachi", FILE_NAME_SMIS_SUPPORT_KEY);
        Properties propConfKey = SJcmdMappDkcSetUtility.loadProperties(propConfKeyPath);
        for (String key : propConfKey.stringPropertyNames()) {
            boolean isExist;
            String value = propConfKey.getProperty(key);
            if (!value.equals("required") || (isExist = propConf.containsKey(key))) continue;
            SJcLogUty.getLogger().error("MappIniSet", LOG_FUNCTION, LOG_METHOD, "Required key:" + key + " is not exist.");
            throw new SJcmdMappDkcSetException("205503", true);
        }
        for (String key : propConf.stringPropertyNames()) {
            boolean isExist = propConfKey.containsKey(key);
            if (isExist) continue;
            SJcLogUty.getLogger().error("MappIniSet", LOG_FUNCTION, LOG_METHOD, "Key:" + key + " is not supported.");
            throw new SJcmdMappDkcSetException("205503", true);
        }
        SJcLogUty.getLogger().info("MappIniSet", LOG_FUNCTION, LOG_METHOD, "End");
    }

    private void updateConfiguration() throws SJcmdMappDkcSetException {
        String LOG_METHOD = Thread.currentThread().getStackTrace()[1].getMethodName();
        SJcLogUty.getLogger().info("MappIniSet", LOG_FUNCTION, LOG_METHOD, "Start");
        String smisDir = SJcmdMappDkcSetUtility.concatFilePath(this.strDkcDirAbsPath, "SMI", "hitachi");
        SJcmdMappDkcSetUtility.copySingleFile(SJcmdMappDkcSetUtility.concatFilePath(this.strDkcWrkDirAbsPath, FILE_NAME_SMIS_CONF), SJcmdMappDkcSetUtility.concatFilePath(smisDir, FILE_NAME_SMIS_CONF_BACK));
        SJcLogUty.getLogger().info("MappIniSet", LOG_FUNCTION, LOG_METHOD, "End");
    }
}

