/*
 * Decompiled with CFR 0.152.
 */
package sanproject.syslog.sender;

import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.syslog.sender.HandshakeException;
import sanproject.syslog.sender.KeyStoreException;
import sanproject.syslog.sender.SubjectAltNameIPException;
import sanproject.syslog.sender.TCPConnectException;
import sanproject.syslog.sender.TLSSenderException;
import sanproject.syslog.sender.TrustStoreException;
import sanproject.syslog.sender.WriteException;

public class TLSSender {
    private SSLSocket m_SSLsocket = null;
    private byte m_UpdateCertificate = 0;
    private String m_KeyStoreName = null;
    private String m_TrustStoreName = null;
    private SJcLoggerInterface m_Logger = null;
    private boolean m_bUpdateCheck = false;
    private long m_KeyStoreLastModified = 0L;
    private long m_TrustStoreLastModified = 0L;
    static final String TLS_VERSION = "TLSv1.2";
    static final int ALTNAME_IP = 7;
    static final String STORE_FILE_DIR_PATH = "san\\syslog\\";
    static final String KEY_STORE_PASSWORD = "hitachi2syslog1t0l0s2A3u1d0i0t2p";
    static final String TRUST_STORE_PASSWOR = "I2n1b0a0n2d3syslog1t0l0shitachip";
    static final int CLOCKS_PER_SEC = 1000;
    static final int SEND_BUFFER_SIZE = 1;
    static final byte[] CHECK_DATA = new byte[]{48};
    static final String DISABLED_CIPHERSUITES_3DES = "3DES";

    public TLSSender(String strKeyStoreName, String strTrustStoreName, String strLoggerName) {
        this.m_KeyStoreName = strKeyStoreName;
        this.m_TrustStoreName = strTrustStoreName;
        this.m_Logger = SJcLogUty.getLogger(strLoggerName);
    }

    public int Send(byte[] ucBuffer, byte[] ucIpAddress, int iPort, byte ucUpdateCertificate, byte ucTimeout) {
        int iRet = 0;
        boolean bUpdateCertificate = ucUpdateCertificate != this.m_UpdateCertificate;
        try {
            InetAddress serverAddress = InetAddress.getByAddress(ucIpAddress);
            if (bUpdateCertificate && 0L != this.m_KeyStoreLastModified && 0L != this.m_TrustStoreLastModified) {
                this.m_bUpdateCheck = true;
            }
            if (null != this.m_SSLsocket) {
                if (this.m_bUpdateCheck) {
                    File keyStoreFile = new File(SJcEnvUty.getSnBasePath() + STORE_FILE_DIR_PATH + this.m_KeyStoreName);
                    File trustStoreFile = new File(SJcEnvUty.getSnBasePath() + STORE_FILE_DIR_PATH + this.m_TrustStoreName);
                    if (this.m_KeyStoreLastModified != keyStoreFile.lastModified() || this.m_TrustStoreLastModified != trustStoreFile.lastModified()) {
                        bUpdateCertificate = true;
                        this.m_KeyStoreLastModified = 0L;
                        this.m_TrustStoreLastModified = 0L;
                        this.m_bUpdateCheck = false;
                    } else {
                        bUpdateCertificate = false;
                    }
                }
                if (!this.m_SSLsocket.getInetAddress().equals(serverAddress) || bUpdateCertificate || iPort != this.m_SSLsocket.getPort()) {
                    this.Shutdown();
                }
            }
            if (null == this.m_SSLsocket) {
                int iTimeout = ucTimeout * 1000;
                this.m_UpdateCertificate = ucUpdateCertificate;
                this.Connect(serverAddress, iPort, iTimeout);
            }
            this.Write(ucBuffer);
        }
        catch (TLSSenderException exception) {
            iRet = exception.GetErrID();
            this.m_Logger.error("TLSSender.Send", "TLSSenderException", "ErrId=" + String.valueOf(iRet), exception.getMessage());
            this.Shutdown();
        }
        catch (Exception exception) {
            iRet = 7;
            this.m_Logger.error("TLSSender.Send", "Exception", "ErrId=" + String.valueOf(iRet), "", exception);
            this.Shutdown();
        }
        return iRet;
    }

    public void Connect(InetAddress serverAddress, int iPort, int iTimeout) throws KeyStoreException, TrustStoreException, TCPConnectException, HandshakeException, SubjectAltNameIPException {
        KeyManager[] keyManager = this.GetKeyManager();
        TrustManager[] trustManager = this.GetTrustManager();
        try {
            SSLContext sslContext = SSLContext.getInstance(TLS_VERSION);
            sslContext.init(keyManager, trustManager, null);
            this.m_SSLsocket = (SSLSocket)sslContext.getSocketFactory().createSocket();
            InetSocketAddress socketAddress = new InetSocketAddress(serverAddress, iPort);
            this.m_SSLsocket.connect(socketAddress, iTimeout);
        }
        catch (Exception exception) {
            this.m_Logger.error("TLSSender.Connect", "Exception", "TCPConnectException", "", exception);
            throw new TCPConnectException("TCP Conncet Err.");
        }
        try {
            String[] supportsuites = this.getEnableSuites(this.m_SSLsocket.getSupportedCipherSuites());
            String[] enablesuites = new String[1 + supportsuites.length];
            enablesuites[0] = "TLS_RSA_WITH_AES_128_CBC_SHA";
            System.arraycopy(supportsuites, 0, enablesuites, 1, supportsuites.length);
            this.m_SSLsocket.setEnabledCipherSuites(enablesuites);
            this.m_SSLsocket.setUseClientMode(true);
            this.m_SSLsocket.startHandshake();
            this.m_SSLsocket.setSendBufferSize(1);
        }
        catch (Exception exception) {
            this.m_Logger.error("TLSSender.Connect", "Exception", "HandshakeException", "", exception);
            throw new HandshakeException("Handshake Err.");
        }
        this.CheckSubjectAltNameIP();
    }

    private String[] getEnableSuites(String[] strSupportSuites) {
        ArrayList<String> wkEnableSuites = new ArrayList<String>();
        for (int i = 0; i < strSupportSuites.length; ++i) {
            if (strSupportSuites[i].indexOf(DISABLED_CIPHERSUITES_3DES) != -1) continue;
            wkEnableSuites.add(strSupportSuites[i]);
        }
        String[] rtn = new String[wkEnableSuites.size()];
        for (int i = 0; i < wkEnableSuites.size(); ++i) {
            rtn[i] = (String)wkEnableSuites.get(i);
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Shutdown() {
        try {
            if (null != this.m_SSLsocket && this.m_SSLsocket.isConnected() && !this.m_SSLsocket.isClosed()) {
                this.m_SSLsocket.close();
            }
        }
        catch (Exception exception) {
            this.m_Logger.error("TLSSender.Shutdown", "Exception", "", "", exception);
        }
        finally {
            this.m_SSLsocket = null;
        }
    }

    private void Write(byte[] ucBuffer) throws WriteException {
        try {
            this.m_SSLsocket.getOutputStream().write(CHECK_DATA);
            this.m_SSLsocket.getOutputStream().flush();
            this.m_SSLsocket.getOutputStream().write(ucBuffer);
            this.m_SSLsocket.getOutputStream().flush();
        }
        catch (Exception exception) {
            this.m_Logger.error("TLSSender.Write", "Exception", "", "", exception);
            throw new WriteException("Write Err.");
        }
    }

    private KeyManager[] GetKeyManager() throws KeyStoreException {
        try {
            File keyStoreFile = new File(SJcEnvUty.getSnBasePath() + STORE_FILE_DIR_PATH + this.m_KeyStoreName);
            if (keyStoreFile.lastModified() != this.m_KeyStoreLastModified) {
                this.m_KeyStoreLastModified = keyStoreFile.lastModified();
                this.m_bUpdateCheck = false;
            }
            FileInputStream keyStoreStream = null;
            KeyStore keyStore = null;
            char[] password = KEY_STORE_PASSWORD.toCharArray();
            try {
                keyStoreStream = new FileInputStream(keyStoreFile);
                keyStore = KeyStore.getInstance("JKS");
                keyStore.load(keyStoreStream, password);
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                if (null != keyStoreStream) {
                    try {
                        keyStoreStream.close();
                    }
                    catch (Exception exception) {
                        this.m_Logger.error("TLSSender.GetKeyManager", "Exception", "keyStoreStream.close", "", exception);
                    }
                }
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(keyStore, password);
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception exception) {
            this.m_Logger.error("TLSSender.GetKeyManager", "Exception", "KeyStoreException", "", exception);
            throw new KeyStoreException("GetKeyManager Err.");
        }
    }

    private TrustManager[] GetTrustManager() throws TrustStoreException {
        try {
            File trustStoeFile = new File(STORE_FILE_DIR_PATH + this.m_TrustStoreName);
            if (trustStoeFile.lastModified() != this.m_TrustStoreLastModified) {
                this.m_TrustStoreLastModified = trustStoeFile.lastModified();
                this.m_bUpdateCheck = false;
            }
            FileInputStream trustStoreStream = null;
            KeyStore trustStore = null;
            char[] password = TRUST_STORE_PASSWOR.toCharArray();
            try {
                trustStoreStream = new FileInputStream(trustStoeFile);
                trustStore = KeyStore.getInstance("JKS");
                trustStore.load(trustStoreStream, password);
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                if (null != trustStoreStream) {
                    try {
                        trustStoreStream.close();
                    }
                    catch (Exception exception) {
                        this.m_Logger.error("TLSSender.GetTrustManager", "Exception", "trustStoreStream.close", "", exception);
                    }
                }
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            trustManagerFactory.init(trustStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (Exception exception) {
            this.m_Logger.error("TLSSender.GetTrustManager", "Exception", "TrustStoreException", "", exception);
            throw new TrustStoreException("GetTrustManager Err.");
        }
    }

    private void CheckSubjectAltNameIP() throws SubjectAltNameIPException {
        try {
            X509Certificate peerCertificate = (X509Certificate)this.m_SSLsocket.getSession().getPeerCertificates()[0];
            Collection<List<?>> subjAltNames = peerCertificate.getSubjectAlternativeNames();
            for (List<?> next : subjAltNames) {
                if (7 != (Integer)next.get(0)) continue;
                String altNameIp = (String)next.get(1);
                String inetAddress = this.m_SSLsocket.getInetAddress().getHostAddress();
                if (!inetAddress.equalsIgnoreCase(altNameIp)) continue;
                return;
            }
            throw new SubjectAltNameIPException("Check SubjectAltNameIP Err.");
        }
        catch (Exception exception) {
            if (exception instanceof SubjectAltNameIPException) {
                throw (SubjectAltNameIPException)exception;
            }
            this.m_Logger.error("TLSSender.CheckSubjectAltNameIP", "Exception", "SubjectAltNameIPException", "", exception);
            throw new SubjectAltNameIPException("Check SubjectAltNameIP Err.");
        }
    }
}

