@ECHO OFF
TITLE TomcatParamInitialize

REM ***********************************************************
REM  2013/08/05 Z80-0440:Y81E4401013 T.Muto(HS21)
REM  2013/11/07 Z80-0792:Y81E4401509 T.Muto(HS21)
REM ***********************************************************

SET LOG_FILE=C:\DKC200\san\SN2\logs\TomcatParamInitialize.log
SET TOMCAT_SERVICE_NAME=Tomcat7

SET REG_KEY=HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\Apache Software Foundation\Procrun 2.0\%TOMCAT_SERVICE_NAME%\Parameters\Java
SET VALUE_NAME_OPTIONS=Options
REM Y81E4401509
SET VALUE_NAME_JVMMX=JvmMx

SET SET_CONC_GC=-XX:+UseConcMarkSweepGC
SET SETPERM_GEN_SWEEP=-XX:+CMSPermGenSweepingEnabled
SET SET_PARALLEL_NEW_GC=-XX:+UseParNewGC
SET SET_SURVIVOR_RATIO=-XX:TargetSurvivorRatio=30

REM Y81E4401509
SET SET_JVMMX=0x5DC

SET SEPARATOR=\0

REM Options
FOR /F "tokens=1,2*" %%i IN ('reg query "%REG_KEY%" /v "%VALUE_NAME_OPTIONS%"') DO (
  IF "%%i"=="%VALUE_NAME_OPTIONS%" (
    SET VALUE_OPTIONS=%%k
  )
)

REM Additional Options
SET ADD_OPT=

ECHO "%VALUE_OPTIONS%" | find "%SET_CONC_GC%" >NUL
IF %ERRORLEVEL% NEQ 0 (SET ADD_OPT=%ADD_OPT%%SEPARATOR%%SET_CONC_GC%)

ECHO "%VALUE_OPTIONS%" | find "%SETPERM_GEN_SWEEP%" >NUL
IF %ERRORLEVEL% NEQ 0 (SET ADD_OPT=%ADD_OPT%%SEPARATOR%%SETPERM_GEN_SWEEP%)

ECHO "%VALUE_OPTIONS%" | find "%SET_PARALLEL_NEW_GC%" >NUL
IF %ERRORLEVEL% NEQ 0 (SET ADD_OPT=%ADD_OPT%%SEPARATOR%%SET_PARALLEL_NEW_GC%)

ECHO "%VALUE_OPTIONS%" | find "%SET_SURVIVOR_RATIO%" >NUL
IF %ERRORLEVEL% NEQ 0 (SET ADD_OPT=%ADD_OPT%%SEPARATOR%%SET_SURVIVOR_RATIO%)

SET VALUE_OPTIONS=%VALUE_OPTIONS%%ADD_OPT%

REM Y81E4401509
SET FLG=0
IF "%ADD_OPT%" NEQ "" (
REM Y81E4401509  del %LOG_FILE% /F /Q

REM Y81E4401509  echo [%date% %time%][Tomcat Service Stop][Start.] >> %LOG_FILE%
REM Y81E4401509  net stop %TOMCAT_SERVICE_NAME%
REM Y81E4401509  echo [%date% %time%][Tomcat Service Stop][End.] >> %LOG_FILE%

  reg add "%REG_KEY%" /v "%VALUE_NAME_OPTIONS%" /t REG_MULTI_SZ /d "%VALUE_OPTIONS%" /f
REM Y81E4401509  echo [%date% %time%][New Parameter Set][Value: "%VALUE_OPTIONS%"] >> %LOG_FILE%

REM Y81E4401509  echo [%date% %time%][Tomcat Service Start][Start.] >> %LOG_FILE%
REM Y81E4401509  net start %TOMCAT_SERVICE_NAME%
REM Y81E4401509  echo [%date% %time%][Tomcat Service Start][End.] >> %LOG_FILE%

REM Y81E4401509
  SET /a FLG+=1
)

REM Y81E4401509 from
REM JvmMx
SET VALUE_JVMMX=0x0
FOR /F "tokens=1,2*" %%i IN ('reg query "%REG_KEY%" /v "%VALUE_NAME_JVMMX%"') DO (
  IF "%%i"=="%VALUE_NAME_JVMMX%" (
    SET VALUE_JVMMX=%%k
  )
)

SETLOCAL ENABLEDELAYEDEXPANSION
IF %VALUE_JVMMX% NEQ %SET_JVMMX% (
  SET VALUE_JVMMX=%SET_JVMMX%
  reg add "%REG_KEY%" /v "%VALUE_NAME_JVMMX%" /t REG_DWORD /d !VALUE_JVMMX! /f
  SET /a FLG+=1
)

IF %FLG% NEQ 0 (
  del %LOG_FILE% /F /Q

  echo [!date! !time!][Tomcat Service Stop][Start.] >> %LOG_FILE%
  net stop %TOMCAT_SERVICE_NAME%
  echo [!date! !time!][Tomcat Service Stop][End.] >> %LOG_FILE%

  echo [!date! !time!][New Parameter Set][Value: "%VALUE_OPTIONS%"] >> %LOG_FILE%
  echo [!date! !time!][New Parameter Set][Value: !VALUE_JVMMX!] >> %LOG_FILE%

  echo [!date! !time!][Tomcat Service Start][Start.] >> %LOG_FILE%
  net start %TOMCAT_SERVICE_NAME%
  echo [!date! !time!][Tomcat Service Start][End.] >> %LOG_FILE%
)
ENDLOCAL
REM Y81E4401509 to

exit /b
