@echo off
setlocal ENABLEDELAYEDEXPANSION ENABLEEXTENSIONS
rem Copyright (c) 2015 Hitachi, Ltd. All rights reserved.

rem The Unix equivalent of the following is WBSERHOME=`cd ..;pwd`
@cd ..
for /f "tokens=*" %%i in ("%cd%") do set WBSERHOME=%%~si
set ldir=%CD%
@cd bin

set JSERVERDIR=%WBSERHOME%
set JSERVERBIN=%JSERVERDIR%\bin
set JSERVERLIB=%JSERVERDIR%\lib

rem use javaw so the cmd box can be exited without killing J Server process
set VM=..\..\..\..\..\..\OSS\java\bin\javaw.exe -classpath

set STARTUP=jserver.jar
set CLASSPATH=%STARTUP%;%WBSERHOME%\..\..\lib\JSanRmiApiUx.jar;%WBSERHOME%\..\..\lib\SanRmiApi.jar;%WBSERHOME%\..\..\lib\JSanRmiApiSx.jar;%WBSERHOME%\..\..\..\DKC200\san\libs\JSanSN2Tools.jar

set JSERVER_DEFINES=-XX:+UseConcMarkSweepGC -Xmx512m -Dhttps.protocols=TLSv1.2,TLSv1.1,TLSv1
set JVM_DEFINES=-Dcom.ws.jserver.basedir=%WBSERHOME%
set JSERVER=com.ws.wbem.jserver.StartJWBEMServer

rem Check for status file
call checkstatfile.bat
if %ERRORLEVEL% == 0 (
    rem J Server is running, but it is possible that it terminated unexpectedly
    rem and the status file is out of date. Perform a more rigorous check to
    rem determine if it is really running.
    call setstatus.bat -m validate -sdir %WBSERHOME% -ldir "%ldir%"
    if !ERRORLEVEL! neq 0 (
        exit /B 1
    )
)

@echo on

start "Hitachi SMI Provider" /B %VM% %CLASSPATH% %JVM_DEFINES% %JSERVER_DEFINES% %JSERVER% >jserver.out 2>&1

@echo off
endlocal
exit /B 0