/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen.jsr48.client;

import com.ws.cim.codegen.java.JavaCodeWriter;
import com.ws.cim.codegen.java.JavaDataConstant;
import com.ws.cim.codegen.java.JavaDataMember;
import com.ws.cim.codegen.java.JavaEnums;
import com.ws.cim.codegen.java.JavaMethod;
import com.ws.cim.codegen.jsr48.AbstractCodeGenerator;
import com.ws.cim.codegen.jsr48.CodeGeneratorUtils;
import com.ws.cim.codegen.jsr48.ImportManager;
import com.ws.cim.codegen.jsr48.MethodCodeGenerator;
import com.ws.cim.codegen.jsr48.PropertyCodeGenerator;
import com.ws.cim.codegen.jsr48.client.BaseClientGenerator;
import com.ws.cim.codegen.jsr48.client.CIMBaseCodeGenerator;
import com.ws.cim.codegen.jsr48.client.InterfaceCodeGenerator;
import java.io.File;
import java.util.ArrayList;
import javax.cim.CIMClass;
import javax.wbem.client.WBEMClient;

public class ClientCodeGenerator {
    private static final String COMMENT = "This interface is the base interface Class of all generated Java source code.";
    private CIMClass mCIMClass;
    private final ImportManager mImports;
    private JavaCodeWriter mCodeWriter;
    private String mOutdir;
    private final String mPackageName;

    private ClientCodeGenerator(String pOutdir, String pPackageName) {
        this.mOutdir = pOutdir;
        this.mImports = new ImportManager();
        this.mCodeWriter = new JavaCodeWriter(this.mOutdir);
        this.mPackageName = pPackageName;
        CIMBaseCodeGenerator cimBase = new CIMBaseCodeGenerator(this.mOutdir, this.mPackageName);
        ArrayList<String> interfaceImports = new ArrayList<String>();
        interfaceImports.add("javax.cim.CIMInstance");
        interfaceImports.add("javax.cim.CIMObjectPath");
        interfaceImports.add("javax.wbem.WBEMException");
        interfaceImports.add("javax.wbem.client.WBEMClient");
        InterfaceCodeGenerator cimBaseInterFace = new InterfaceCodeGenerator(interfaceImports, cimBase.getMethods(), cimBase.getEnums(), COMMENT, "CIMBaseInterface", null, this.mOutdir, this.mPackageName);
        try {
            cimBaseInterFace.generateCode();
            cimBase.generateCode();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ClientCodeGenerator(CIMClass pClass, String pOutdir, String pPackageName) throws Exception {
        this(pClass, null, pOutdir, pPackageName);
        this.mOutdir = pOutdir;
        this.mCIMClass = pClass;
        ClientCodeGenerator.setClassType("Client");
        String schemaName = this.mCIMClass.getName();
        schemaName = schemaName.substring(0, schemaName.indexOf("_")).toLowerCase();
        this.mOutdir = pOutdir + File.separator + schemaName;
        this.mCodeWriter = new JavaCodeWriter(this.mOutdir);
    }

    private static void setClassType(String type) {
        AbstractCodeGenerator.mClassType = type;
    }

    public ClientCodeGenerator(CIMClass pClass, WBEMClient pCc, String pOutdir, String pPackageName) throws Exception {
        this(pOutdir, pPackageName);
        this.mCIMClass = pClass;
        ClientCodeGenerator.setClassType("Client");
        String schemaName = this.mCIMClass.getName();
        schemaName = schemaName.substring(0, schemaName.indexOf("_")).toLowerCase();
        this.mOutdir = pOutdir + File.separator + schemaName;
        this.mCodeWriter = new JavaCodeWriter(this.mOutdir);
    }

    private ArrayList<String> getImplementedList() {
        ArrayList<String> iList = new ArrayList<String>();
        iList.add(this.mCIMClass.getName() + "Interface");
        return iList;
    }

    private void generateInterface(PropertyCodeGenerator pProperty, MethodCodeGenerator pMethod, String pDescription) {
        ArrayList<JavaMethod> methods = new ArrayList<JavaMethod>();
        ArrayList<String> imports = new ArrayList<String>();
        ArrayList<JavaEnums> enums = new ArrayList<JavaEnums>();
        String sprClassName = this.mCIMClass.getSuperClassName();
        if (sprClassName == null || sprClassName.isEmpty()) {
            sprClassName = "CIMBaseInterface";
        }
        methods.addAll(pProperty.getMethodList());
        imports.addAll(pProperty.getImportList());
        enums.addAll(pProperty.getEnums());
        if (this.mCIMClass.getMethodCount() > 0) {
            methods.addAll(pMethod.getCIMMethods());
            imports.addAll(pMethod.getCIMImports());
        }
        InterfaceCodeGenerator interface_code = new InterfaceCodeGenerator(imports, methods, enums, pDescription, this.mCIMClass.getName(), sprClassName, this.mOutdir, this.mPackageName);
        try {
            interface_code.setPackageName(this.mPackageName);
            interface_code.generateCode();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void generateSpecificCode(AbstractCodeGenerator pAbs) {
        for (String i : pAbs.getImports()) {
            this.mImports.addImport(i);
        }
        for (JavaDataConstant c : pAbs.getConstants()) {
            this.mCodeWriter.addDataConstant(c);
        }
        for (JavaDataMember m : pAbs.getDataMembers()) {
            this.mCodeWriter.addDataMember(m);
        }
        for (JavaMethod me : pAbs.getMethods()) {
            this.mCodeWriter.addMethod(me);
        }
    }

    public String getClassDescription() {
        StringBuffer description = new StringBuffer();
        if (this.mCIMClass.hasQualifier("Description")) {
            description.append(this.mCIMClass.getQualifierValue("Description"));
            if (this.mCIMClass.hasQualifier("Deprecated")) {
                description.append(" \n \n@deprecated\t");
                String[] deprecatedValues = (String[])this.mCIMClass.getQualifier("Deprecated").getValue();
                for (int i = 0; i < deprecatedValues.length; ++i) {
                    description.append(deprecatedValues[i]);
                    if (i >= deprecatedValues.length - 1) continue;
                    description.append(",");
                }
            }
        }
        return description.toString();
    }

    public void generateCode() throws Exception {
        try {
            String className = this.mCIMClass.getName();
            String sprClassName = this.mCIMClass.getSuperClassName();
            String schemaName = className.substring(0, className.indexOf("_")).toLowerCase();
            String classPackageName = this.mPackageName + "." + schemaName;
            if (null == sprClassName || sprClassName.isEmpty()) {
                sprClassName = "CIMBase";
                this.mImports.addImport(this.mPackageName + "." + sprClassName);
            } else {
                String sprClassPackageName = this.mPackageName + "." + CodeGeneratorUtils.getSchemaName(sprClassName).toLowerCase();
                if (!classPackageName.equalsIgnoreCase(sprClassPackageName)) {
                    this.mImports.addImport(sprClassPackageName + "." + sprClassName);
                }
            }
            this.mCodeWriter.setFileComment("This code was generated by WS SDK Pro");
            this.mCodeWriter.setPackageName(classPackageName);
            PropertyCodeGenerator property = new PropertyCodeGenerator(this.mCIMClass);
            BaseClientGenerator client = new BaseClientGenerator(property);
            MethodCodeGenerator method = new MethodCodeGenerator(this.mCIMClass);
            this.generateSpecificCode(client);
            this.generateSpecificCode(method);
            String description = this.getClassDescription();
            this.mCodeWriter.setClassInfo(true, description, className, sprClassName, this.getImplementedList());
            this.mCodeWriter.setImports(this.mImports.getImportList());
            this.generateInterface(property, method, description);
            this.mCodeWriter.write(className + ".java");
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }
}

