/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen.jsr48.provider;

import com.ws.cim.codegen.java.JavaCodeWriterConstants;
import com.ws.cim.codegen.java.JavaMethod;
import com.ws.cim.codegen.java.JavaMethodBody;
import com.ws.cim.codegen.java.JavaMethodVariable;
import com.ws.cim.codegen.jsr48.AbstractCodeGenerator;
import com.ws.cim.codegen.jsr48.CodeGeneratorConstants;
import com.ws.cim.codegen.jsr48.JavaArgument;
import java.util.ArrayList;
import javax.cim.CIMClassProperty;

class InstanceProviderGenerator
extends AbstractCodeGenerator {
    private final CIMClassProperty<?>[] mCIMProp;

    public InstanceProviderGenerator(CIMClassProperty<?>[] pCIMProp) {
        this.mCIMProp = pCIMProp;
        this.setImports();
        this.setConstants();
        this.setMethods();
    }

    @Override
    public void setImports() {
        this.setImports("javax.cim.CIMInstance");
        this.setImports("javax.cim.CIMObjectPath");
        this.setImports("javax.wbem.WBEMException");
        this.setImports("javax.wbem.provider.InstanceProvider");
        this.setImports("javax.wbem.provider.ProviderHandle");
        this.setImports("javax.cim.CIMProperty");
        this.setImports("javax.cim.CIMDataType");
        this.setImports("javax.wbem.CloseableIterator");
        this.setImports("java.util.ArrayList");
        this.setImports("java.util.Iterator");
        this.setImports("java.io.ByteArrayInputStream");
        this.setImports("org.wbemservices.wbem.query.SelectExp");
        this.setImports("org.wbemservices.wbem.query.SelectList");
        this.setImports("org.wbemservices.wbem.query.WQLParser");
        this.setImports("org.wbemservices.wbem.query.QueryExp");
        this.setImports("org.wbemservices.wbem.CloseableIteratorImpl");
    }

    @Override
    public void setMethods() {
        this.addCreateInstanceMethod();
        this.addDeleteInstanceMethod();
        this.addEnumerateInstanceNamesMethod();
        this.addEnumerateInstancesMethod();
        this.addExecQueryMethod();
        this.addGetInstanceMethod();
        this.addModifyInstance();
    }

    @Override
    public void setDataMembers() {
    }

    @Override
    public void setConstants() {
    }

    private void addCreateInstanceMethod() {
        ArrayList<String> throwList = new ArrayList<String>();
        throwList.add("WBEMException");
        ArrayList<JavaArgument> argList = new ArrayList<JavaArgument>();
        argList.add(new JavaArgument(false, "pCi", "CIMInstance"));
        ArrayList<String> bText = new ArrayList<String>();
        bText.add("try{");
        bText.add("\n\t\t\tcheckAccess(mProviderHandle);");
        bText.add("");
        bText.add("\n\t\t\t// TODO - REMOVE THE LINE BELOW IF YOU SUPPORT THIS METHOD.");
        bText.add("\n\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_NOT_SUPPORTED);");
        bText.add("");
        bText.add("\n\n\t\t\t// TODO - UNCOMMENT THE CODE BELOW IF YOU SUPPORT THIS METHOD.");
        bText.add("\n\t\t\t/*if (pCi == null) {");
        bText.add("\n\t\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_FAILED);");
        bText.add("\n\t\t\t}");
        bText.add("\n\t\t\ttry {");
        for (CIMClassProperty<?> ccp : this.mCIMProp) {
            String dataType = ccp.getDataType().isArray() ? CodeGeneratorConstants.DATATYPE[ccp.getDataType().getType()] + "[]" : CodeGeneratorConstants.DATATYPE[ccp.getDataType().getType()];
            String propName = ccp.getName();
            String propConstString = "CPN_" + propName.toUpperCase();
            if (ccp.isKey()) {
                bText.add("\n\t\t\t\t// NOTE: The variable defined for the Key qualified property below MUST");
                bText.add("\n\t\t\t\t// be populated with either the value specified by the client, or a");
                bText.add("\n\t\t\t\t// value determined by the Provider. This is necessary so that the");
                bText.add("\n\t\t\t\t// CIMObjectPath returned by the method that identifies the model path");
                bText.add("\n\t\t\t\t// of the instance created can be constructed.");
            }
            bText.add("\n\t\t\t\ttry {");
            bText.add("\n\t\t\t\t\tm" + propName + " = (" + dataType + ")pCi.getProperty(" + propConstString + ").getValue();");
            bText.add("\n\t\t\t\t} catch (NullPointerException npe) {");
            if (ccp.isKey()) {
                bText.add("\n\t\t\t\t\t// TODO - The Provider MUST either implement code here to");
                bText.add("\n\t\t\t\t\t// initialize the variable or uncomment the code below.");
                bText.add("\n\n\t\t\t\t\t// throw new CIMException(CIMException.CIM_ERR_FAILED);");
            }
            bText.add("\n\t\t\t\t}");
        }
        bText.add("\n\t\t\t\t// TODO - IMPLEMENT THE CODE HERE TO CREATE THE UNDERLYING MANAGED");
        bText.add("\n\t\t\t\t// ELEMENT WITH THE DATA INITIALIZED IN THE VARIABLES ABOVE.");
        bText.add("\n\t\t\t\t// TODO - UNCOMMENT THE CODE BELOW IF THE CREATION OF THE UNDERLYING");
        bText.add("\n\t\t\t\t// MANAGED ELEMENT FAILED BECAUSE IT ALREADY EXISTS.");
        bText.add("\n\n\t\t\t\t// throw new CIMException(CIMException.CIM_ERR_ALREADY_EXISTS);");
        bText.add("");
        bText.add("\n\n\t\t\t\t// TODO - UNCOMMENT THE CODE BELOW IF THE CREATION OF THE UNDERLYING");
        bText.add("\n\t\t\t\t// MANAGED ELEMENT FAILED FOR AN UNKNOWN REASON.");
        bText.add("");
        bText.add("\n\n\t\t\t\t// throw new CIMException(CIMException.CIM_ERR_FAILED);");
        bText.add("");
        bText.add("\n\n\t\t\t\t// A CIMObjectPath is constructed below that reflects the Key");
        bText.add("\n\t\t\t\t// property values of the managed element created. This is returned");
        bText.add("\n\t\t\t\t// to enable the client to locate the new managed element in the");
        bText.add("\n\t\t\t\t// case that Key values were initialized and/or modified by the");
        bText.add("\n\t\t\t\t// Provider.");
        bText.add("\n\n\t\t\t\tString objName = pCi.getObjectPath().getObjectName();");
        bText.add("\n\t\t\t\tString nameSpace = pCi.getObjectPath().getNamespace();");
        bText.add("\n\t\t\t\tCIMObjectPath cop = new CIMObjectPath(objName,nameSpace,pCi.getKeys());");
        bText.add("\n\t\t\t\treturn (cop);");
        bText.add("\n\t\t\t} catch (ClassCastException cce) {");
        bText.add("\n\t\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_FAILED);");
        bText.add("\n\t\t\t}*/");
        bText.add("\n\t\t} catch(Throwable t){");
        bText.add("\n\t\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_FAILED);");
        bText.add("\n\t\t}");
        JavaMethodBody body = new JavaMethodBody(null, bText);
        JavaMethod m = new JavaMethod("Create the specified instance. \n \n@param pCi \n\t\t\tThe instance to be created. Its keys and properties may be initialized \n\t\t\tby either the client or provider. \n \n@return the CIMObjectPath of the created instance. The provider should \n\t\t\treturn non-NULL ONLY IF it initializes or changes one or more keys. \n \n@throws WBEMException \n\t\t\tIf unsuccessful, one of the following status codes may be returned. \n\t\t\tThe ORDERED list is: \n\t\t\t<ul> \n\t\t\t\t<li>CIM_ERR_ACCESS_DENIED \n\t\t\t\t<li>CIM_ERR_NOT_SUPPORTED (provider does not support this method) \n\t\t\t\t<li>CIM_ERR_INVALID_NAMESPACE \n\t\t\t\t<li>CIM_ERR_INVALID_PARAMETER (for this method) \n\t\t\t\t<li>CIM_ERR_INVALID_CLASS (in this namespace) \n\t\t\t\t<li>CIM_ERR_ALREADY_EXISTS \n\t\t\t\t<li>CIM_ERR_FAILED (some other unspecified error occurred) \n\t\t\t</ul>", JavaCodeWriterConstants.TYPE.PUBLIC, false, "CIMObjectPath", "createInstance", argList, throwList, body.toString());
        this.mMethods.add(m);
    }

    private void addDeleteInstanceMethod() {
        ArrayList<String> throwList = new ArrayList<String>();
        throwList.add("WBEMException");
        ArrayList<JavaArgument> argList = new ArrayList<JavaArgument>();
        argList.add(new JavaArgument(true, "pOp", "CIMObjectPath"));
        ArrayList<String> bText = new ArrayList<String>();
        bText.add("try{");
        bText.add("\n\t\t\tcheckAccess(mProviderHandle);");
        bText.add("");
        bText.add("\n\t\t\t// TODO - REMOVE THE LINE BELOW IF YOU SUPPORT THIS METHOD.");
        bText.add("\n\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_NOT_SUPPORTED);");
        bText.add("");
        bText.add("\n\n\t\t\t// TODO - UNCOMMENT THE CODE BELOW IF YOU SUPPORT THIS METHOD.");
        bText.add("\n\t\t\t/*if (pOp == null || pOp.getKeys() == null || pOp.getKeys().length != 4) {");
        bText.add("\n\t\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_FAILED);");
        bText.add("\n\t\t\t}");
        bText.add("\n\t\t\t// METHOD VARIABLES ARE GENERATED AND INITIALIZED BELOW AS A");
        bText.add("\n\t\t\t// CONVENIENCE. GENERALLY PROVIDERS ARE ONLY INTERESTED IN A SUBSET OF");
        bText.add("\n\t\t\t// THE CIMCLASS'S KEY QUALIFIED PROPERTIES. DELETE ANY CODE BELOW");
        bText.add("\n\t\t\t// RELATED TO KEY PROPERTIES THAT ARE IRRELEVANT TO DELETING THE");
        bText.add("\n\t\t\t// UNDERLYING MANAGED ELEMENT.");
        if (this.mCIMProp != null) {
            bText.add("\n\n\t\t\tCIMProperty propArr[] = null;");
            bText.add("\n\t\t\tpropArr = pOp.getKeys();");
            bText.add("\n\t\t\tfor(CIMProperty cp:propArr) {");
            bText.add("\n\t\t\t\ttry {");
            String condition = "\n\t\t\t\t\tif";
            for (CIMClassProperty<?> ccp : this.mCIMProp) {
                if (!ccp.isKey()) continue;
                String dataType = ccp.getDataType().isArray() ? CodeGeneratorConstants.DATATYPE[ccp.getDataType().getType()] + "[]" : CodeGeneratorConstants.DATATYPE[ccp.getDataType().getType()];
                String propName = ccp.getName();
                String propConstString = "CPN_" + propName.toUpperCase();
                bText.add(condition + " (cp.getName().equalsIgnoreCase(" + propConstString + ")) {");
                condition = "\n\t\t\t\t\t} else if";
                bText.add("\n\t\t\t\t\t\tm" + propName + " = (" + dataType + ")cp.getValue();");
            }
            bText.add("\n\t\t\t\t\t}");
            bText.add("\n\t\t\t\t} catch (NullPointerException npe) {");
            bText.add("\n\t\t\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_FAILED);");
            bText.add("\n\t\t\t\t} catch (ClassCastException cce) {");
            bText.add("\n\t\t\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_FAILED);");
            bText.add("\n\t\t\t\t}");
            bText.add("\n\t\t\t}");
            bText.add("\n\t\t\t// TODO - INSERT THE CODE HERE THAT USES THE KEY PROPERTY VALUES");
            bText.add("\n\t\t\t// OBTAINED ABOVE TO DELETE THE UNDERLYING MANAGED ELEMENT.");
            bText.add("");
            bText.add("\n\n\t\t\t// TODO - UNCOMMENT THE CODE BELOW IF THE DELETION OF THE UNDERLYING");
            bText.add("\n\t\t\t// MANAGED ELEMENT FAILED BECAUSE IT DOES NOT EXIST OR CANNOT BE FOUND.");
            bText.add("");
            bText.add("\n\n\t\t\t// throw new WBEMException(WBEMException.CIM_ERR_NOT_FOUND);");
            bText.add("");
            bText.add("\n\n\t\t\t// TODO - UNCOMMENT THE CODE BELOW IF THE DELETION OF THE UNDERLYING");
            bText.add("\n\t\t\t// MANAGED ELEMENT FAILED FOR AN UNKNOWN REASON.");
            bText.add("");
            bText.add("\n\n\t\t\t// throw new WBEMException(WBEMException.CIM_ERR_FAILED);");
            bText.add("\n\t\t\t*/");
        }
        bText.add("\n\t\t} catch(Throwable t){");
        bText.add("\n\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_FAILED);");
        bText.add("\n\t\t}");
        JavaMethodBody body = new JavaMethodBody(null, bText);
        JavaMethod m = new JavaMethod("Delete the instance specified. \n \n@param pOp \n\t\t\tThe object path of the instance to be deleted. It must include all \n\t\t\tof the keys. \n \n@throws WBEMException \n\t\t\tIf unsuccessful, one of the following status codes may be returned. \n\t\t\tThe ORDERED list is: \n\t\t\t<ul> \n\t\t\t\t<li>CIM_ERR_ACCESS_DENIED \n\t\t\t\t<li>CIM_ERR_NOT_SUPPORTED (provider does not support this method) \n\t\t\t\t<li>CIM_ERR_INVALID_NAMESPACE \n\t\t\t\t<li>CIM_ERR_INVALID_PARAMETER (for this method) \n\t\t\t\t<li>CIM_ERR_INVALID_CLASS (in this namespace) \n\t\t\t\t<li>CIM_ERR_NOT_FOUND (if instance does not exist) \n\t\t\t\t<li>CIM_ERR_FAILED (some other unspecified error occurred) \n\t\t\t</ul>", JavaCodeWriterConstants.TYPE.PUBLIC, false, "void", "deleteInstance", argList, throwList, body.toString());
        this.mMethods.add(m);
    }

    private void addEnumerateInstanceNamesMethod() {
        ArrayList<String> throwList = new ArrayList<String>();
        throwList.add("WBEMException");
        ArrayList<JavaArgument> argList = new ArrayList<JavaArgument>();
        argList.add(new JavaArgument(true, "pOp", "CIMObjectPath"));
        ArrayList<String> bText = new ArrayList<String>();
        bText.add("try{");
        bText.add("\n\t\t\tcheckAccess(mProviderHandle);");
        bText.add("\n\t\t\tif (pOp == null) {");
        bText.add("\n\t\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_FAILED);");
        bText.add("\n\t\t\t}");
        bText.add("\n\t\t\t// TODO - RETRIEVE A CONTAINER OF MANAGED ELEMENT DATA TO POPULATE IN");
        bText.add("\n\t\t\t// THE KEY PROPERTY VALUES OF THE CIMOBJECTPATH OBJECTS TO BE RETURNED.");
        bText.add("\n\t\t\t// MODIFY THE ArrayList CONTAINER BELOW AS APPROPRIATE.");
        bText.add("\n\n\t\t\tArrayList dataObjArr = new ArrayList();");
        bText.add("\n\t\t\tArrayList<CIMObjectPath> retArr = new ArrayList<CIMObjectPath>();");
        bText.add("\n\t\t\tfor (int i = 0; i < dataObjArr.size(); i++) {");
        bText.add("\n\t\t\t\t// TODO - ADD CODE HERE TO GET A DATA FROM THE dataObjArr CONTAINER.");
        bText.add("\n\t\t\t\t// TODO - REPLACE THE VALUES FOR THE OBJECTS BELOW WITH THE");
        bText.add("\n\t\t\t\t// VALUES FROM dataObjArr CONTAINER.");
        bText.add("\n\t\t\t\tArrayList<CIMProperty<?>> propList = new ArrayList<CIMProperty<?>>();");
        if (this.mCIMProp != null) {
            for (CIMClassProperty<?> ccp : this.mCIMProp) {
                if (!ccp.isKey()) continue;
                String propName = ccp.getName();
                int type = ccp.getDataType().getType();
                String dataType = CodeGeneratorConstants.DATATYPE[type];
                if (type == 0 || type == 2 || type == 4 || type == 6 || type == 12) {
                    this.setImports("javax.cim." + dataType);
                }
                if (ccp.getDataType().isArray()) {
                    dataType = dataType + "[]";
                    bText.add("\n\t\t\t\t" + dataType + " cpv" + propName + " = null;");
                    continue;
                }
                if (dataType.equalsIgnoreCase("CIMObjectPath")) {
                    bText.add("\n\t\t\t\t" + dataType + " cpv" + propName + " = null;");
                    dataType = ccp.getDataType().getRefClassName();
                    bText.add("\n\t\t\t\tpropList.add(new CIMProperty<CIMObjectPath>(\"" + propName + "\", new CIMDataType(\"" + dataType + "\"), " + "cpv" + propName + "));");
                    continue;
                }
                bText.add("\n\t\t\t\t" + dataType + " cpv" + propName + " = null;");
            }
        }
        bText.add("\n\t\t\t\tCIMObjectPath cop = new CIMObjectPath(pOp.getObjectName(),pOp.getNamespace(),(CIMProperty[])propList.toArray());");
        bText.add("\n\t\t\t\tretArr.add(cop);");
        bText.add("\n\t\t\t}");
        bText.add("\n\t\t\treturn new CloseableIteratorImpl(retArr.iterator());");
        bText.add("\n\t\t} catch(Throwable t){");
        bText.add("\n\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_FAILED);");
        bText.add("\n\t\t}");
        JavaMethodBody body = new JavaMethodBody(null, bText);
        JavaMethod m = new JavaMethod("Enumerate the names of the instances for a specified class. The names of all subclass instances are returned. \n \n@param pOp \n\t\t\tThe object path of the instance to be deleted. It must include all \n\t\t\tof the keys. \n \n@return An WBEMIterator that references CIMObjectPaths. Each element is \n\t\t\tan object path to an enumerated instance. If none found, then the \n\t\t\tProvider returns NULL. \n \n@throws WBEMException \n\t\t\tIf unsuccessful, one of the following status codes may be returned. \n\t\t\tThe ORDERED list is: \n\t\t\t<ul> \n\t\t\t\t<li>CIM_ERR_ACCESS_DENIED \n\t\t\t\t<li>CIM_ERR_NOT_SUPPORTED (provider does not support this method) \n\t\t\t\t<li>CIM_ERR_INVALID_NAMESPACE \n\t\t\t\t<li>CIM_ERR_INVALID_PARAMETER (for this method) \n\t\t\t\t<li>CIM_ERR_INVALID_CLASS (in this namespace) \n\t\t\t\t<li>CIM_ERR_FAILED (some other unspecified error occurred) \n\t\t\t</ul>", JavaCodeWriterConstants.TYPE.PUBLIC, false, "CloseableIterator", "enumerateInstanceNames", argList, throwList, body.toString());
        this.mMethods.add(m);
    }

    private void addEnumerateInstancesMethod() {
        ArrayList<String> throwList = new ArrayList<String>();
        throwList.add("WBEMException");
        ArrayList<JavaArgument> argList = new ArrayList<JavaArgument>();
        argList.add(new JavaArgument(true, "pOp", "CIMObjectPath"));
        argList.add(new JavaArgument(false, "pLocalOnly", "boolean"));
        argList.add(new JavaArgument(false, "pIncludeClassOrigin", "boolean"));
        argList.add(new JavaArgument(false, "pPropertyList", "String[]"));
        ArrayList<String> bText = new ArrayList<String>();
        bText.add("try{");
        bText.add("\n\t\t\tcheckAccess(mProviderHandle);");
        bText.add("\n\t\t\tCloseableIteratorImpl copArr = (CloseableIteratorImpl)enumerateInstanceNames(pOp);");
        bText.add("\n\t\t\tArrayList<CIMInstance> retArr = new ArrayList<CIMInstance>();");
        bText.add("\n\t\t\twhile(copArr.hasNext()) {");
        bText.add("\n\t\t\t\tCIMInstance ci = new CIMInstance((CIMObjectPath)copArr.next(),null);");
        bText.add("\n\t\t\t\tretArr.add(ci.filterProperties(pLocalOnly, pIncludeClassOrigin, pPropertyList));");
        bText.add("\n\t\t\t}");
        bText.add("\n\t\t\treturn new CloseableIteratorImpl(retArr.iterator());");
        bText.add("\n\t\t} catch(Throwable t){");
        bText.add("\n\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_FAILED);");
        bText.add("\n\t\t}");
        JavaMethodBody body = new JavaMethodBody(null, bText);
        JavaMethod m = new JavaMethod("Enumerate the instances of a class. The instances of all subclasses are also returned. \n \n@param pOp \n\t\t\tThe object path of the class to be enumerated. Only the name space and \n\t\t\tclass name components are used. Any other information (e.g. keys) is \n\t\t\tignored. \n@param pLocalOnly \n\t\t\tIf true, only properties overridden or defined in the returned \n\t\t\tInstance are included in the response. If false, all properties \n\t\t\tof the returned Instance are returned. \n@param pIncludeClassOrigin \n\t\t\tThe class origin attribute is the name of the class that first defined \n\t\t\tthe property.If true, the class origin attribute will be present for \n\t\t\teach property on all returnedCIMInstances. If false, the class origin \n\t\t\twill not be present. \n@param pPropertyList \n\t\t\tIf the PropertyList input parameter is not NULL, the members of the \n\t\t\tarray define one or more Property names. Each returned Instance MUST \n\t\t\tNOT include elements for any Properties missing from this list. Note \n\t\t\tthat if localOnly is specified as true this acts as an additional \n\t\t\tfilter on the set of Properties returned (e.g. if Property A is \n\t\t\tincluded in the PropertyList but localOnly is set to true and A is \n\t\t\tnot local to a returned Instance, then it will not be included in \n\t\t\tthat Instance). If the PropertyListinput parameter is an empty array \n\t\t\tthis signifies that no Properties are included in each returned \n\t\t\tInstance. If the PropertyList input parameter is NULL this specifies \n\t\t\tthat all Properties (subject to the conditions expressed by the other \n\t\t\tparameters) are included in each returned Instance. The PropertyList \n\t\t\tmay contain duplicate or invalid Property names. The Provider must\t\n\t\t\tignore them but otherwise process the request normally; i.e. the \n\t\t\treturnedInstance(s) will not contain duplicate or invalid Property \n\t\t\tNames. \n \n@return An array of CIMInstances. Each element is the actual filtered \n\t\t\tinstance. The Provider must ensure that no duplicate instances are \n\t\t\treturned. If none found, then the Provider returns NULL. \n \n@throws WBEMException \n\t\t\tIf unsuccessful, one of the following status codes may be returned. \n\t\t\tThe ORDERED list is: \n\t\t\t<ul> \n\t\t\t\t<li>CIM_ERR_ACCESS_DENIED \n\t\t\t\t<li>CIM_ERR_NOT_SUPPORTED (provider does not support this method) \n\t\t\t\t<li>CIM_ERR_INVALID_NAMESPACE \n\t\t\t\t<li>CIM_ERR_INVALID_PARAMETER (for this method) \n\t\t\t\t<li>CIM_ERR_INVALID_CLASS (in this namespace) \n\t\t\t\t<li>CIM_ERR_FAILED (some other unspecified error occurred) \n\t\t\t</ul>", JavaCodeWriterConstants.TYPE.PUBLIC, false, "CloseableIterator", "enumerateInstances", argList, throwList, body.toString());
        this.mMethods.add(m);
    }

    private void addExecQueryMethod() {
        ArrayList<String> throwList = new ArrayList<String>();
        throwList.add("WBEMException");
        ArrayList<JavaArgument> argList = new ArrayList<JavaArgument>();
        argList.add(new JavaArgument(true, "pOp", "CIMObjectPath"));
        argList.add(new JavaArgument(false, "pQuery", "String"));
        argList.add(new JavaArgument(false, "pQl", "String"));
        ArrayList<String> bText = new ArrayList<String>();
        bText.add("try{");
        bText.add("\n\t\t\tcheckAccess(mProviderHandle);");
        bText.add("\n\t\t\tif (pQuery == null || pQuery.length() <= 0) {");
        bText.add("\n\t\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_INVALID_QUERY);");
        bText.add("\n\t\t\t}");
        bText.add("\n\t\t\tIterator<?> ciArr = this.enumerateInstances(pOp,false,false,null);");
        bText.add("\n\t\t\tByteArrayInputStream inStream = new ByteArrayInputStream(pQuery.getBytes());");
        bText.add("\n\t\t\tWQLParser parser = new WQLParser(inStream);");
        bText.add("\n\t\t\tArrayList<CIMInstance> resultArr = new ArrayList<CIMInstance>();");
        bText.add("\n\t\t\ttry {");
        bText.add("\n\t\t\t\tSelectExp selExp = (SelectExp) parser.querySpecification();");
        bText.add("\n\t\t\t\tQueryExp where = selExp.getWhereClause();");
        bText.add("\n\t\t\t\tSelectList attrs = selExp.getSelectList();");
        bText.add("\n\t\t\t\tif (ciArr == null) {");
        bText.add("\n\t\t\t\t\treturn new CloseableIteratorImpl(ciArr);");
        bText.add("\n\t\t\t\t}");
        bText.add("\n\t\t\t\twhile (ciArr.hasNext()) {");
        bText.add("\n\t\t\t\t\tCIMInstance ci = (CIMInstance) ciArr.next();");
        bText.add("\n\t\t\t\t\tif ((where == null) || (where.apply(ci) == true)) {");
        bText.add("\n\t\t\t\t\t\tresultArr.add(attrs.apply(ci));");
        bText.add("\n\t\t\t\t\t}");
        bText.add("\n\t\t\t\t}");
        bText.add("\n\t\t\t} catch (Exception ex) {");
        bText.add("\n\t\t\t\tif (ex instanceof WBEMException) {");
        bText.add("\n\t\t\t\t\tthrow (WBEMException) ex;");
        bText.add("\n\t\t\t\t}");
        bText.add("\n\t\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_FAILED);");
        bText.add("\n\t\t\t}");
        bText.add("\n\t\t\treturn new CloseableIteratorImpl(resultArr.iterator());");
        bText.add("\n\t\t} catch(Throwable t){");
        bText.add("\n\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_FAILED);");
        bText.add("\n\t\t}");
        JavaMethodBody body = new JavaMethodBody(null, bText);
        JavaMethod m = new JavaMethod("This method enumerates all instances of the class specified by the CIMObjectpath argument that satisfy the conditions defined by the query expression (query) in query language type (ql). The entire instances are returned, not just the object paths to them. NOTE: This method operates as if localOnly is false and propertyList is NULL; all local and inherited properties with the class origin attributes of each instance are returned. \n \nTypically, a provider parses the query string, enumerates the instances in the class (op), and then filters those instances to match the query string (query) expressed using the specified query language (ql).The provider then returns an array containing the instances that match the query string. \n \nProviders with access to an entity that handles indexing can pass the query string to that entity for parsing. For those providers who do not have any indexing/query filtering capabilities, the provider may ask the CIM object manager to handle the filtering. A return array of all CIMInstance which have a possibility of matching the filter may be returned (this can be the same result as an enumerate instances call), but with the first element of the array set to NULL. This NULL value indicates to the CIM object manager that it needs to handle the filtering. The filter is applied by the object manager and the filtered result is returned to the client. \n \n@param pOp \n\t\t\tThe object path of the class to enumerate and apply the query to. \n\t\t\tOnly the name space and class name components are used. Any other \n\t\t\tinformation (e.g. keys) is ignored. \n@param pQuery \n\t\t\tThe CIM query expression (e.g. SELECT *). \n@param pQl \n\t\t\tThe CIM query language type (e.g. WQL). \n \n@return An array of CIMInstances that met the specified criteria. Each \n\t\t\telement is an actual instance. The Provider must ensure that no \n\t\t\tduplicate instances are returned. If none found, then the Provider \n\t\t\treturns NULL. \n \n@throws WBEMException \n\t\t\tIf unsuccessful, one of the following status codes may be returned. \n\t\t\tThe ORDERED list is: \n\t\t\t<ul> \n\t\t\t\t<li>CIM_ERR_ACCESS_DENIED \n\t\t\t\t<li>CIM_ERR_NOT_SUPPORTED (provider does not support this method) \n\t\t\t\t<li>CIM_ERR_INVALID_NAMESPACE \n\t\t\t\t<li>CIM_ERR_INVALID_PARAMETER (for this method) \n\t\t\t\t<li>CIM_ERR_QUERY_LANGUAGE_NOT_SUPPORTED \n\t\t\t\t<li>CIM_ERR_INVALID_QUERY \n\t\t\t\t<li>CIM_ERR_FAILED (some other unspecified error occurred) \n\t\t\t</ul>", JavaCodeWriterConstants.TYPE.PUBLIC, false, "CloseableIterator", "execQuery", argList, throwList, body.toString());
        this.mMethods.add(m);
    }

    private void addGetInstanceMethod() {
        ArrayList<String> throwList = new ArrayList<String>();
        throwList.add("WBEMException");
        ArrayList<JavaArgument> argList = new ArrayList<JavaArgument>();
        argList.add(new JavaArgument(true, "pOp", "CIMObjectPath"));
        argList.add(new JavaArgument(false, "pLocalOnly", "boolean"));
        argList.add(new JavaArgument(false, "pIncludeClassOrigin", "boolean"));
        argList.add(new JavaArgument(false, "pPropertyList", "String[]"));
        ArrayList<JavaMethodVariable> variable = new ArrayList<JavaMethodVariable>();
        variable.add(new JavaMethodVariable(false, "CIMInstance", "oRet", "new CIMInstance(pOp,null)"));
        ArrayList<String> bText = new ArrayList<String>();
        bText.add("\t\ttry{");
        bText.add("\n\t\t\tcheckAccess(mProviderHandle);");
        int keyCtr = 0;
        for (CIMClassProperty<?> prop : this.mCIMProp) {
            if (!prop.isKey()) continue;
            ++keyCtr;
        }
        bText.add("\n\t\t\tif (pOp == null || pOp.getKeys() == null || pOp.getKeys().length !=" + keyCtr + ") {");
        bText.add("\n\t\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_FAILED);");
        bText.add("\n\t\t\t}");
        bText.add("\n\t\t\toRet = oRet.filterProperties(pLocalOnly, pIncludeClassOrigin, pPropertyList);");
        bText.add("\n\t\t\treturn oRet;");
        bText.add("\n\t\t} catch(Throwable t){");
        bText.add("\n\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_FAILED);");
        bText.add("\n\t\t}");
        JavaMethodBody body = new JavaMethodBody(variable, bText);
        JavaMethod m = new JavaMethod("Get the instance specified by the object path pOp. \n \n@param pOp \n\t\t\tThe object path of the instance to be retrieved. This must include \n\t\t\tall of the keys for the instance. \n@param pLocalOnly \n\t\t\tIf true, only properties overridden or defined in the returned \n\t\t\tInstance are included in the response. If false, all elements \n\t\t\tof the returned Instance are returned. \n@param pIncludeClassOrigin \n\t\t\tThe class origin attribute is the name of the class that first \n\t\t\tdefined the property. If true, the class origin attribute will \n\t\t\tbe present for each property returned for the CIMInstance. If \n\t\t\tfalse, the class origin will not be present. \n@param pPropertyList \n\t\t\tIf the PropertyList input parameter is not NULL, the members of \n\t\t\tthe array define one or more Property names. Each returned \n\t\t\tInstance MUST NOT include elements for any Properties missing \n\t\t\tfrom this list. Note that if localOnly is specified as true this \n\t\t\tacts as an additional filter on the set of Properties returned \n\t\t\t(e.g. if Property A is included in the PropertyList but localOnly \n\t\t\tis set to true and A is not local to a returned Instance, then it \n\t\t\twill not be included in that Instance). If the PropertyList input \n\t\t\tparameter is an empty array this signifies that no Properties are \n\t\t\tincluded in each returned Instance. If the PropertyList input \n\t\t\tparameter is NULL this specifies that all Properties (subject to \n\t\t\tthe conditions expressed by the other parameters) are included in \n\t\t\teach returned Instance. The PropertyList may contain duplicate or \n\t\t\tinvalid Property names. The Provider must ignore them but otherwise \n\t\t\tprocess the request normally; i.e. the returned Instance(s) will not \n\t\t\tcontain duplicate or invalid Property Names. This argument can be \n\t\t\tused to perform the GetProperty operation as defined by the CIM \n\t\t\toperations over HTTP spec at http://www.dmtf.org/. \n \n@return The retrieved filtered instance. \n \n@throws WBEMException \n\t\t\tIf unsuccessful, one of the following status codes may be returned. \n\t\t\tThe ORDERED list is: \n\t\t\t<ul> \n\t\t\t\t<li>CIM_ERR_ACCESS_DENIED \n\t\t\t\t<li>CIM_ERR_NOT_SUPPORTED (provider does not support this method) \n\t\t\t\t<li>CIM_ERR_INVALID_NAMESPACE \n\t\t\t\t<li>CIM_ERR_INVALID_PARAMETER (for this method) \n\t\t\t\t<li>CIM_ERR_INVALID_CLASS (in this namespace) \n\t\t\t\t<li>CIM_ERR_NOT_FOUND (if instance does not exist) \n\t\t\t\t<li>CIM_ERR_FAILED (some other unspecified error occurred) \n\t\t\t</ul>", JavaCodeWriterConstants.TYPE.PUBLIC, false, "CIMInstance", "getInstance", argList, throwList, body.toString());
        this.mMethods.add(m);
    }

    private void addModifyInstance() {
        ArrayList<String> throwList = new ArrayList<String>();
        throwList.add("WBEMException");
        ArrayList<JavaArgument> argList = new ArrayList<JavaArgument>();
        argList.add(new JavaArgument(false, "pCi", "CIMInstance"));
        argList.add(new JavaArgument(false, "pPropertyList", "String[]"));
        ArrayList<String> bText = new ArrayList<String>();
        bText.add("try{");
        bText.add("\n\t\t\tcheckAccess(mProviderHandle);");
        bText.add("\n\t\t\t// TODO - REMOVE THE LINE BELOW IF YOU SUPPORT THIS METHOD.");
        bText.add("\n\n\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_NOT_SUPPORTED);");
        bText.add("\n\n\t\t\t// TODO - UNCOMMENT THE CODE BELOW IF YOU SUPPORT THIS METHOD.");
        bText.add("\n\t\t\t/*if(pCi==null){");
        bText.add("\n\t\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_FAILED);");
        bText.add("\n\t\t\t}");
        if (this.mCIMProp != null) {
            bText.add("\n\t\t\tCIMProperty propArr[] = null;");
            bText.add("\n\t\t\tpropArr = pCi.getKeys();");
            bText.add("\n\t\t\tfor(CIMProperty cp:propArr) {");
            bText.add("\n\t\t\t\ttry {");
            String condition = "\n\t\t\t\t\tif";
            for (CIMClassProperty<?> ccp : this.mCIMProp) {
                if (!ccp.isKey()) continue;
                String dataType = ccp.getDataType().isArray() ? CodeGeneratorConstants.DATATYPE[ccp.getDataType().getType()] + "[]" : CodeGeneratorConstants.DATATYPE[ccp.getDataType().getType()];
                String propName = ccp.getName();
                String propConstString = "CPN_" + propName.toUpperCase();
                bText.add(condition + " (cp.getName().equalsIgnoreCase(" + propConstString + ")) {");
                condition = "\n\t\t\t\t\t} else if";
                bText.add("\n\t\t\t\t\t\tm" + propName + " = (" + dataType + ")cp.getValue();");
            }
            bText.add("\n\t\t\t\t\t}");
            bText.add("\n\t\t\t\t} catch (NullPointerException npe) {");
            bText.add("\n\t\t\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_FAILED);");
            bText.add("\n\t\t\t\t} catch (ClassCastException cce) {");
            bText.add("\n\t\t\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_FAILED);");
            bText.add("\n\t\t\t\t}");
            bText.add("\n\t\t\t}");
            bText.add("\n\t\t\tpCi = pCi.filterProperties(true, true,pPropertyList);");
            bText.add("\n\t\t\tpropArr = pCi.getProperties();");
            bText.add("\n\t\t\tfor(CIMProperty cp:propArr) {");
            StringBuffer conditionString = new StringBuffer();
            for (int i = 0; i < this.mCIMProp.length; ++i) {
                if (!this.mCIMProp[i].isKey()) continue;
                conditionString.append("!cp.getName().equalsIgnoreCase(CPN_" + this.mCIMProp[i].getName().toUpperCase() + ") || ");
            }
            bText.add("\n\t\t\t\tif(" + conditionString.toString().substring(0, conditionString.toString().length() - 4) + "){");
            bText.add("\n\t\t\t\t\t// TODO - IMPLEMENT CODE HERE TO GET THE OBJECT FROM THE");
            bText.add("\n\t\t\t\t\t// CIMPROPERTY ABOVE AND MODIFY THE MANAGED ELEMENT AS");
            bText.add("\n\t\t\t\t\t// APPROPRIATE.");
            bText.add("\n\t\t\t\t}");
            bText.add("\n\t\t\t}");
            bText.add("\n\t\t\t*/");
        }
        bText.add("\n\t\t} catch(Throwable t){");
        bText.add("\n\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_FAILED);");
        bText.add("\n\t\t}");
        JavaMethodBody body = new JavaMethodBody(null, bText);
        JavaMethod m = new JavaMethod("Modify the instance specified. \n \n@param pCi \n\t\t\tThe instance to be set. Its properties may be initialized by either \n\t\t\tthe client or Provider. \n@param pPropertyList \n\t\t\tIf the PropertyList input parameter is not NULL, the members of the \n\t\t\tarray define one or more Property names. The Provider will modify or \n\t\t\tinitialize only the values for the Property names in PropertyList. \n\t\t\tThe Provider will not affect any other Property. Order is not \n\t\t\timportant. The value of the specified Property is found in \n\t\t\tCIMInstance ci. If the specified Property value is not found in ci, \n\t\t\tthen it will be ignored by the Provider. If PropertyList contains \n\t\t\tinvalid Property names, the entire operation fails (i.e. no Property \n\t\t\tvalues of ci are modified). PropertyList may contain duplicate \n\t\t\tProperty names. The Provider must ignore them but otherwise process \n\t\t\tthe request normally. If PropertyList is an empty array, then no \n\t\t\tProperty values in ci are updated. If PropertyList is NULL, then ci \n\t\t\tcontains all Property values to be updated by the client or Provider. \n\t\t\tThis argument can be used to perform the SetProperty operation as \n\t\t\tdefined by the CIM operations over HTTP spec at http://www.dmtf.org/. \n \n@throws WBEMException \n\t\t\tIf unsuccessful, one of the following status codes may be returned. \n\t\t\tThe ORDERED list is: \n\t\t\t<ul> \n\t\t\t\t<li>CIM_ERR_ACCESS_DENIED \n\t\t\t\t<li>CIM_ERR_NOT_SUPPORTED (provider does not support this method) \n\t\t\t\t<li>CIM_ERR_INVALID_NAMESPACE \n\t\t\t\t<li>CIM_ERR_INVALID_PARAMETER (for this method) \n\t\t\t\t<li>CIM_ERR_INVALID_CLASS (in this namespace) \n\t\t\t\t<li>CIM_ERR_NOT_FOUND (if instance does not exist) \n\t\t\t\t<li>CIM_ERR_NO_SUCH_PROPERTY (in this instance) \n\t\t\t\t<li>CIM_ERR_FAILED (some other unspecified error occurred) \n\t\t\t</ul>", JavaCodeWriterConstants.TYPE.PUBLIC, false, "void", "modifyInstance", argList, throwList, body.toString());
        this.mMethods.add(m);
    }
}

