/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.xmi.metaclass;

import com.ws.cim.xmi.metaclass.ClassMetaClass;
import com.ws.utilities.Resources;
import java.text.MessageFormat;
import java.util.ArrayList;

public class XMIPackage {
    private static final String BUNDLE = "com.ws.cim.xmi.XMIGenerator";
    private String mName;
    private ArrayList<ClassMetaClass> mXMIClassInfo;
    private ArrayList<XMIPackage> mXMISubPackageList;
    private Resources mResourceHandle;

    public XMIPackage(String pName) {
        this.mName = pName;
        this.mResourceHandle = new Resources(BUNDLE);
        this.mXMIClassInfo = new ArrayList();
        this.mXMISubPackageList = new ArrayList();
    }

    public String getName() {
        return this.mName;
    }

    public ArrayList<XMIPackage> getPackages() {
        return this.mXMISubPackageList;
    }

    public XMIPackage getPackage(String pName) {
        for (XMIPackage p : this.mXMISubPackageList) {
            if (!p.getName().equalsIgnoreCase(pName)) continue;
            return p;
        }
        return null;
    }

    public void addClass(ClassMetaClass pClassInfo) {
        this.mXMIClassInfo.add(pClassInfo);
    }

    public void addSubPackage(XMIPackage pPackage) {
        this.mXMISubPackageList.add(pPackage);
    }

    public boolean isSubPackageExist(String pPackageName) {
        for (XMIPackage p : this.mXMISubPackageList) {
            if (!p.getName().equalsIgnoreCase(pPackageName)) continue;
            return true;
        }
        return false;
    }

    public String toString(String pTabs) {
        return MessageFormat.format(this.mResourceHandle.loadString("PACKAGE"), pTabs, this.mName, this.getSubPackagesStr(pTabs), this.getClassInfo(pTabs));
    }

    private String getSubPackagesStr(String pTabs) {
        StringBuilder strPackages = new StringBuilder();
        for (XMIPackage p : this.mXMISubPackageList) {
            strPackages.append(p.toString(pTabs + "\t"));
        }
        return strPackages.toString();
    }

    private String getClassInfo(String pTabs) {
        StringBuilder strClassInfo = new StringBuilder();
        for (ClassMetaClass classInfo : this.mXMIClassInfo) {
            strClassInfo.append(classInfo.toString(pTabs + "\t"));
        }
        return strClassInfo.toString();
    }
}

