/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.config.ConfigurationException;
import flex.messaging.config.ConfigurationFileResolver;
import flex.messaging.io.ArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.servlet.ServletContext;

public class ServletResourceResolver
implements ConfigurationFileResolver {
    private ServletContext context;
    private Stack configurationPathStack = new Stack();

    public ServletResourceResolver(ServletContext context) {
        this.context = context;
    }

    public boolean isAvailable(String path, boolean throwError) throws ConfigurationException {
        boolean available = false;
        InputStream is = this.context.getResourceAsStream(path);
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            this.pushConfigurationFile(path);
            available = true;
        } else if (throwError) {
            ConfigurationException e = new ConfigurationException();
            e.setMessage(11108, new Object[]{path});
            throw e;
        }
        return available;
    }

    public InputStream getConfigurationFile(String path) {
        InputStream is = this.context.getResourceAsStream(path);
        if (is != null) {
            this.pushConfigurationFile(path);
            return is;
        }
        ConfigurationException e = new ConfigurationException();
        e.setMessage(11108, new Object[]{path});
        throw e;
    }

    public InputStream getIncludedFile(String src) {
        String path = this.configurationPathStack.peek() + "/" + src;
        InputStream is = this.context.getResourceAsStream(path);
        if (is != null) {
            this.pushConfigurationFile(path);
            return is;
        }
        ConfigurationException e = new ConfigurationException();
        e.setMessage(11107, new Object[]{path});
        throw e;
    }

    public void popIncludedFile() {
        this.configurationPathStack.pop();
    }

    public List getFiles(String dir) {
        ArrayList result = new ArrayList();
        String prefix = this.configurationPathStack.peek() + "/";
        Set paths = this.context.getResourcePaths(prefix + dir);
        if (paths != null) {
            for (Object entry : paths) {
                String path = (String)entry;
                if (!path.endsWith(".xml")) continue;
                result.add(path.substring(prefix.length()));
            }
            return result;
        }
        ConfigurationException e = new ConfigurationException();
        e.setMessage(11113, new Object[]{dir});
        throw e;
    }

    private void pushConfigurationFile(String path) {
        String topLevelPath = path.substring(0, path.lastIndexOf(47));
        this.configurationPathStack.push(topLevelPath);
    }
}

