/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.sanproject.data;

import com.hitachi.sanproject.data.SanDataErrorCode;
import com.hitachi.sanproject.data.SanDataException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SanAttrs
implements Serializable {
    private static final long serialVersionUID = 7964925752494487871L;
    public static final String ATTR_MAXSIZE = "maxsize";
    public static final String ATTR_MAXVALUE = "maxvalue";
    public static final String ATTR_MINVALUE = "minvalue";
    public static final String ATTR_VALUES = "values";
    public static final String ATTR_MEANINGSOFVALUES = "meanings_of_values";
    public static final String ATTR_MAXLENGTH = "maxlength";
    public static final String ATTR_MINLENGTH = "minlength";
    public static final String ATTR_LENGTH = "length";
    public static final String ATTR_UNIT = "unit";
    public static final String ATTR_DISPLAYNAME = "displayname";
    public static final String ATTR_DISPLAYFORMAT = "displayformat";
    public static final String ATTR_FUNCNAME = "funcname";
    protected static final List<String> allTypes = Arrays.asList("Object", "List", "int", "long", "float", "double", "boolean", "String", "BitSet", "int[]", "byte[]", "Data");
    protected static final List<List<String>> allAttrs = Arrays.asList(Arrays.asList("displayname"), Arrays.asList("maxsize", "displayname"), Arrays.asList("maxvalue", "minvalue", "values", "meanings_of_values", "unit", "displayname", "displayformat"), Arrays.asList("maxvalue", "minvalue", "unit", "displayname", "displayformat"), Arrays.asList("maxvalue", "minvalue", "unit", "displayname", "displayformat"), Arrays.asList("maxvalue", "minvalue", "unit", "displayname", "displayformat"), Arrays.asList("displayname"), Arrays.asList("maxlength", "minlength", "displayname", "displayformat"), Arrays.asList("maxsize", "displayname"), Arrays.asList("length", "maxvalue", "minvalue", "unit", "displayname", "displayformat"), Arrays.asList("length", "displayname"), Arrays.asList("displayname", "funcname"));
    protected int typeId;
    protected ArrayList<Object> attrList;

    public static List<String> allTypes() {
        return new ArrayList<String>(allTypes);
    }

    protected static List<String> allAttrs(int n) {
        if (n < 0) {
            return new ArrayList<String>();
        }
        List<String> list = allAttrs.get(n);
        if (list == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(list);
    }

    public static List<String> allAttrs(String string) {
        if (string == null) {
            return new ArrayList<String>();
        }
        int n = allTypes.indexOf(string);
        return SanAttrs.allAttrs(n);
    }

    protected SanAttrs() {
    }

    protected SanAttrs(String string) throws SanDataException {
        this.typeId = allTypes.indexOf(string);
        if (this.typeId < 0) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_TYPE, String.format("type=%s", string));
        }
        int n = SanAttrs.allAttrs(string).size();
        this.attrList = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.attrList.add(null);
        }
    }

    protected SanAttrs clone() {
        SanAttrs sanAttrs = new SanAttrs();
        sanAttrs.typeId = this.typeId;
        sanAttrs.attrList = this.attrList;
        return sanAttrs;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.typeId;
        for (Object object : this.attrList) {
            if (object == null) {
                n = 31 * n + 0;
                continue;
            }
            if (object instanceof int[]) {
                n = 31 * n + Arrays.hashCode((int[])object);
                continue;
            }
            n = 31 * n + object.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SanAttrs)) {
            return false;
        }
        SanAttrs sanAttrs = (SanAttrs)object;
        if (this.typeId != sanAttrs.typeId) {
            return false;
        }
        ListIterator<Object> listIterator = this.attrList.listIterator();
        ListIterator<Object> listIterator2 = sanAttrs.attrList.listIterator();
        while (listIterator.hasNext() && listIterator2.hasNext()) {
            Object object2 = listIterator.next();
            Object object3 = listIterator2.next();
            if (object2 == null) {
                if (object3 == null) continue;
                return false;
            }
            if (object3 == null) {
                return false;
            }
            if (!object2.getClass().equals(object3.getClass())) {
                return false;
            }
            if (!(object2 instanceof int[] ? !Arrays.equals((int[])object2, (int[])object3) : !object2.equals(object3))) continue;
            return false;
        }
        return !listIterator.hasNext() && !listIterator2.hasNext();
    }

    public String type() {
        return allTypes.get(this.typeId);
    }

    public List<String> attrKeyList() {
        List<String> list = SanAttrs.allAttrs(this.typeId);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.attrList.size(); ++i) {
            if (this.attrList.get(i) == null) continue;
            arrayList.add(list.get(i));
        }
        return arrayList;
    }

    protected Object get(int n) {
        return this.attrList.get(n);
    }

    public Object get(String string) throws SanDataException {
        int n = SanAttrs.allAttrs(this.typeId).indexOf(string);
        if (n < 0) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_ATTR_KEY, String.format("type=%s, attrKey=%s", this.type(), string));
        }
        return this.attrList.get(n);
    }

    protected void put(String string, String string2) throws SanDataException {
        int n = SanAttrs.allAttrs(this.typeId).indexOf(string);
        Object[] objectArray = null;
        block0 : switch (this.typeId) {
            case 0: {
                switch (n) {
                    case 0: {
                        objectArray = string2;
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (n) {
                    case 0: {
                        objectArray = Integer.valueOf(string2);
                        break block0;
                    }
                    case 1: {
                        objectArray = string2;
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                block21 : switch (n) {
                    case 0: 
                    case 1: {
                        objectArray = Integer.valueOf(string2);
                        break;
                    }
                    case 2: {
                        String string3;
                        String[] stringArray;
                        Pattern pattern = Pattern.compile("\\s*\\[(.+)\\]\\s*");
                        Pattern pattern2 = Pattern.compile("\\s*(-?\\d+)");
                        Matcher matcher = pattern.matcher(string2);
                        if (!matcher.find() || (stringArray = (string3 = matcher.group(1)).split(",")).length == 0) break;
                        int[] nArray = new int[stringArray.length];
                        for (int i = 0; i < stringArray.length; ++i) {
                            Matcher matcher2 = pattern2.matcher(stringArray[i]);
                            if (!matcher2.find()) break block21;
                            nArray[i] = Integer.parseInt(matcher2.group(1));
                        }
                        objectArray = nArray;
                        break;
                    }
                    case 3: {
                        Pattern pattern = Pattern.compile("\\s*\\[(.+)\\]\\s*");
                        Pattern pattern3 = Pattern.compile("^\\s*([\\S]|[\\S][ \\S]*[\\S])\\s*$");
                        Matcher matcher = pattern.matcher(string2);
                        if (!matcher.find()) break;
                        String string4 = matcher.group(1);
                        String[] stringArray = string4.split(",");
                        String[] stringArray2 = new String[stringArray.length];
                        for (int i = 0; i < stringArray.length; ++i) {
                            Matcher matcher3 = pattern3.matcher(stringArray[i]);
                            if (!matcher3.find()) break block21;
                            stringArray2[i] = matcher3.group(1);
                        }
                        objectArray = stringArray2;
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = string2;
                        break;
                    }
                }
                break;
            }
            case 3: {
                switch (n) {
                    case 0: 
                    case 1: {
                        objectArray = Long.valueOf(string2);
                        break block0;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = string2;
                        break block0;
                    }
                }
                break;
            }
            case 4: {
                switch (n) {
                    case 0: 
                    case 1: {
                        objectArray = Float.valueOf(string2);
                        break block0;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = string2;
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                switch (n) {
                    case 0: 
                    case 1: {
                        objectArray = Double.valueOf(string2);
                        break block0;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = string2;
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                switch (n) {
                    case 0: {
                        objectArray = string2;
                        break block0;
                    }
                }
                break;
            }
            case 7: {
                switch (n) {
                    case 0: {
                        objectArray = Integer.valueOf(string2);
                        break;
                    }
                    case 1: {
                        objectArray = Integer.valueOf(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = string2;
                    }
                }
                break;
            }
            case 8: {
                switch (n) {
                    case 0: {
                        objectArray = Integer.valueOf(string2);
                        break;
                    }
                    case 1: {
                        objectArray = string2;
                    }
                }
                break;
            }
            case 9: {
                block51 : switch (n) {
                    case 0: {
                        objectArray = Integer.valueOf(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        String string5;
                        String[] stringArray;
                        Pattern pattern = Pattern.compile("\\s*\\[(.+)\\]\\s*");
                        Pattern pattern4 = Pattern.compile("\\s*(-?\\d+)");
                        Matcher matcher = pattern.matcher(string2);
                        if (!matcher.find() || (stringArray = (string5 = matcher.group(1)).split(",")).length == 0) break;
                        int[] nArray = new int[stringArray.length];
                        for (int i = 0; i < stringArray.length; ++i) {
                            Matcher matcher4 = pattern4.matcher(stringArray[i]);
                            if (!matcher4.find()) break block51;
                            nArray[i] = Integer.parseInt(matcher4.group(1));
                        }
                        objectArray = nArray;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = string2;
                        break;
                    }
                }
                break;
            }
            case 10: {
                switch (n) {
                    case 0: {
                        objectArray = Integer.valueOf(string2);
                        break block0;
                    }
                    case 1: {
                        objectArray = string2;
                        break block0;
                    }
                }
                break;
            }
            case 11: {
                switch (n) {
                    case 0: 
                    case 1: {
                        objectArray = string2;
                        break block0;
                    }
                }
                break;
            }
        }
        if (objectArray == null) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_ATTR_KEY, String.format("type=%s, attrKey=%s, value=%s", this.type(), string, string2));
        }
        this.attrList.set(n, objectArray);
    }
}

