/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.UIManager;
import sanproject.server.data.GetRmiException;
import sanproject.server.data.RmiObj_03_02_00;
import sanproject.server.data.SANRmiException;

public class JwsFTMainCtrl
extends JwsBaseCtrl
implements WindowListener {
    public RmiObj_03_02_00 m_RmiObj;
    public JwsFTMainParameters m_FTParam;
    public JwsFTErrChgClass m_FTErrChg;
    public JwsFTErrClass m_FTErr;
    private String m_strErrMessage = "";
    protected JwsDownloadPanel m_DownloadPanel;
    protected JwsUploadPanel m_UploadPanel;
    protected Thread m_healthThread = null;
    public static String UPLOAD_PANEL_CLIENTFILE_LABEL_TEXT;
    public static String DOWNLOAD_PANEL_CLIENTFILE_FIELD_TEXT;
    public static String UPLOAD_PANEL_CLIENTFILE_FIELD_TEXT;
    protected String m_strFrameDownload = "DOWNLOAD";
    protected String m_strFrameUpload = "UPLOAD";
    public JFrame m_frmMainFrame;
    protected Dimension m_dmFrameSize = new Dimension(605, 166);
    private Point m_pntFramePos = new Point(270, 300);
    public static String UPLOAD_PANEL_REFERENCE_BUTTON_TEXT;
    public static String UPLOAD_PANEL_UPLOAD_BUTTON_TEXT;
    public static String DOWNLOAD_PANEL_DOWNLOAD_BUTTON_TEXT;
    public static String UPLOAD_PANEL_EXIT_BUTTON_TEXT;
    public static final int ERROR_POS = 8111;
    public static final int ERROR_FILENAME_OVER = 5627;
    public static final int ERROR_INVALID_CHAR = 5628;
    public static final int ERROR_NON_EXIST = 5629;
    public static final int ERROR_NOT_READ = 5630;
    public static final int ERROR_NOT_FILE = 5631;
    public static final int ERROR_NOT_MODIFY = 5632;
    public static final int ERROR_FILEPATH_OVER = 5633;
    public static final int ERROR_SUPPORT_CENTER = 5634;
    public static final int ERROR_INVALID_FILEPATH = 5773;
    public static final int ERROR_NOT_WRITE = 5774;
    public static final int ERROR_FILE_ACCESS = 5775;
    public static final int ERROR_FILE_KIND = 5776;

    public JwsFTMainCtrl(JwsFTMainParameters jwsFTMainParameters) {
        this.m_FTParam = jwsFTMainParameters;
        JwsBaseCtrl.logWrite("JwsFTMainCtrl Start");
        try {
            jwsFTMainParameters.checkParam(this);
            this.initFTClient();
            this.startHealthCheck();
            this.readWordsValue("");
            JwsFTMainCtrl.changeLookAndFeel();
            this.initialize();
            JwsBaseCtrl.loadSettings();
            this.createMainFrame();
        }
        catch (Exception exception) {
            JwsBaseCtrl.logWrite(exception.getMessage());
        }
        JwsBaseCtrl.logWrite("JwsFTMainCtrl End");
    }

    protected void initFTClient() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new ArrayList();
        JwsBaseCtrl.logWrite("initFTClient() Start");
        try {
            this.m_RmiObj = (RmiObj_03_02_00)Naming.lookup(this.m_FTParam.m_strURL);
            JwsBaseCtrl.logWrite("RMI Object Get!!");
            arrayList.add("MsgIndex");
            arrayList.add(this.m_FTParam.m_strMessageFile);
            arrayList2 = this.m_RmiObj.getDataChangeTable(arrayList);
            this.m_FTErr = new JwsFTErrClass(arrayList2);
            this.m_FTErrChg = new JwsFTErrChgClass(arrayList2, this.m_FTErr);
            JwsBaseCtrl.logWrite("Call RMI I/F sendFTClientEvent( 2, " + this.m_FTParam.m_nFunc + " )");
            this.m_RmiObj.sendFTClientEvent(2, this.m_FTParam.m_nFunc);
        }
        catch (SANRmiException sANRmiException) {
            sANRmiException.printStackTrace();
            this.setErrMessage(this.m_FTErrChg.exchangeErrCode(sANRmiException.nErrCode, sANRmiException.nErrData));
            JwsBaseCtrl.logWrite(sANRmiException.getMessage());
            this.exitApplication(1);
        }
        catch (GetRmiException getRmiException) {
            getRmiException.printStackTrace();
            this.setErrMessage(this.m_FTErrChg.exchangeErrCode(getRmiException.nErrCode, getRmiException.nErrData));
            this.exitApplication(1);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            String string = this.m_FTErrChg.exchangeErrCode(8111, 5634);
            this.setErrMessage(string);
            JwsBaseCtrl.logWrite(string);
            this.exitApplication(1);
        }
        catch (NotBoundException notBoundException) {
            notBoundException.printStackTrace();
            String string = this.m_FTErrChg.exchangeErrCode(8111, 5634);
            this.setErrMessage(string);
            JwsBaseCtrl.logWrite(string);
            this.exitApplication(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JwsBaseCtrl.logWrite(exception.getMessage());
        }
        JwsBaseCtrl.logWrite("initFTClient() End");
    }

    protected void startHealthCheck() {
        this.m_healthThread = new Thread(){

            public void run() {
                JwsBaseCtrl.logWrite("Thread Start Timer=" + JwsFTMainCtrl.this.m_FTParam.m_nTimer);
                while (true) {
                    try {
                        while (true) {
                            JwsFTMainCtrl.this.m_RmiObj.FTHealthCheck(JwsFTMainCtrl.this.m_FTParam.m_nFunc);
                            Thread.sleep(JwsFTMainCtrl.this.m_FTParam.m_nTimer * 1000);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (SANRmiException sANRmiException) {
                        sANRmiException.printStackTrace();
                        JwsFTMainCtrl.this.setErrMessage(JwsFTMainCtrl.this.m_FTErrChg.exchangeErrCode(sANRmiException.nErrCode, sANRmiException.nErrData));
                        JwsBaseCtrl.logWrite(sANRmiException.getMessage());
                        JwsFTMainCtrl.this.exitApplication(1);
                    }
                    catch (RemoteException remoteException) {
                        remoteException.printStackTrace();
                        String string = JwsFTMainCtrl.this.m_FTErrChg.exchangeErrCode(8111, 5634);
                        JwsFTMainCtrl.this.setErrMessage(string);
                        JwsBaseCtrl.logWrite(remoteException.getMessage());
                        JwsBaseCtrl.logWrite(string);
                        JwsFTMainCtrl.this.exitApplication(1);
                    }
                    catch (NullPointerException nullPointerException) {
                        nullPointerException.printStackTrace();
                        String string = JwsFTMainCtrl.this.m_FTErrChg.exchangeErrCode(8111, 5634);
                        JwsFTMainCtrl.this.setErrMessage(string);
                        JwsBaseCtrl.logWrite(((Throwable)nullPointerException).getMessage());
                        JwsBaseCtrl.logWrite(string);
                        JwsFTMainCtrl.this.exitApplication(1);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        JwsBaseCtrl.logWrite(exception.getMessage());
                        continue;
                    }
                    break;
                }
            }
        };
        try {
            this.m_healthThread.start();
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            JwsBaseCtrl.logWrite(exception.getMessage());
        }
    }

    protected void initialize() {
        if (this.m_FTParam.m_nFunc == 1) {
            this.m_DownloadPanel = new JwsDownloadPanel(this);
        } else {
            this.m_UploadPanel = new JwsUploadPanel(this);
        }
    }

    protected void readWordsValue(String string) {
        UPLOAD_PANEL_CLIENTFILE_LABEL_TEXT = "File Name on Client : ";
        UPLOAD_PANEL_CLIENTFILE_FIELD_TEXT = JwsBaseCtrl.loadSettings();
        DOWNLOAD_PANEL_CLIENTFILE_FIELD_TEXT = JwsBaseCtrl.loadSettings();
        UPLOAD_PANEL_REFERENCE_BUTTON_TEXT = "Reference";
        UPLOAD_PANEL_UPLOAD_BUTTON_TEXT = "Upload";
        DOWNLOAD_PANEL_DOWNLOAD_BUTTON_TEXT = "Download";
        UPLOAD_PANEL_EXIT_BUTTON_TEXT = "Exit";
    }

    protected void createMainFrame() {
        if (this.m_FTParam.m_nFunc == 1) {
            this.m_frmMainFrame = new JFrame(this.m_strFrameDownload);
            this.m_frmMainFrame.getContentPane().add(this.m_DownloadPanel);
        } else {
            this.m_frmMainFrame = new JFrame(this.m_strFrameUpload);
            this.m_frmMainFrame.getContentPane().add(this.m_UploadPanel);
        }
        this.m_frmMainFrame.setDefaultCloseOperation(0);
        this.m_frmMainFrame.addWindowListener(this);
        ((Component)this.m_frmMainFrame).setSize(this.m_dmFrameSize);
        ((Component)this.m_frmMainFrame).setLocation(this.m_pntFramePos);
        this.m_frmMainFrame.setResizable(false);
        ((Component)this.m_frmMainFrame).setVisible(true);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.exitApplication(0);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exitApplication(int n) {
        block8: {
            JwsBaseCtrl.logWrite("exitApplication Status=" + n);
            try {
                try {
                    if (this.m_healthThread != null) {
                        JwsBaseCtrl.logWrite("Healthcheck End!!");
                        this.m_healthThread.interrupt();
                    }
                    JwsBaseCtrl.logWrite("Call RMI I/F sendFTClientEvent( 3, " + this.m_FTParam.m_nFunc + " )");
                    this.m_RmiObj.sendFTClientEvent(3, this.m_FTParam.m_nFunc);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JwsBaseCtrl.logWrite(exception.getMessage());
                    Object var4_3 = null;
                    this.m_healthThread = null;
                    if (n != 0) {
                        JwsBaseCtrl.showAlert("Error", this.m_strErrMessage);
                        JwsBaseCtrl.logWrite(this.m_strErrMessage);
                    }
                    System.exit(0);
                    return;
                }
                Object var4_2 = null;
                this.m_healthThread = null;
                if (n == 0) break block8;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.m_healthThread = null;
                if (n != 0) {
                    JwsBaseCtrl.showAlert("Error", this.m_strErrMessage);
                    JwsBaseCtrl.logWrite(this.m_strErrMessage);
                }
                System.exit(0);
                throw throwable;
            }
            JwsBaseCtrl.showAlert("Error", this.m_strErrMessage);
            JwsBaseCtrl.logWrite(this.m_strErrMessage);
        }
        System.exit(0);
    }

    public static void changeLookAndFeel() {
        String string = System.getProperty("os.name");
        JwsBaseCtrl.debug_logWrite("os.name = '" + string + "'");
        int n = 1;
        if (string != null && string.toLowerCase().indexOf("windows") != -1) {
            n = 3;
        }
        JwsLookAndFeelManager.setLookAndFeel(n);
        String string2 = UIManager.getLookAndFeel().getName();
        JwsBaseCtrl.debug_logWrite("use LookAndFeel : " + string2);
    }

    public void setErrMessage(String string) {
        this.m_strErrMessage = string;
    }
}

