/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat.group;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import sanproject.getmondat.com.RJMdCmdParser;
import sanproject.getmondat.com.RJMdContainer;
import sanproject.getmondat.com.RJMdRange;
import sanproject.getmondat.com.RJMdRmiException;
import sanproject.getmondat.com.RJMdTimeRange;
import sanproject.getmondat.data.RJMdDataControl;
import sanproject.getmondat.data.RJMdDataHostGroup;
import sanproject.getmondat.data.RJMdDataLU;
import sanproject.getmondat.data.RJMdDataPort;
import sanproject.getmondat.group.RJMdColumn;
import sanproject.getmondat.group.RJMdGroupData;
import sanproject.getmondat.group.RJMdUnitEntry;
import sanproject.getmondat.group.RJMdUnitParallelStream;
import sanproject.serverux.arg.monitor.ArgHRCLUEx;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.MonitorInfoCollection;
import sanproject.serverux.dataimpl.RJiLUPathIndex;
import sanproject.serverux.dataimpl.RMCPgetUsageLUInfEx;

public class RJMdGroupRCLU
extends RJMdGroupData {
    private static final String groupID = "RCLU";
    private static final String[] groupAlias = new String[0];
    private static final String groupName = "RCLU_dat";
    private static final String groupInfo = "RCLU data";
    private RJMdUnitParallelStream stream = null;
    public static final int LIMIT_PARAMS_RCLU = 512;
    public static final int KIND_TARGET = 1;
    private static final String EN_RCLU_All_RIO = "RCLU_All_RIO";
    private static final String EN_RCLU_All_Read = "RCLU_All_Read";
    private static final String EN_RCLU_All_Write = "RCLU_All_Write";
    private static final String EN_RCLU_RIO_Error = "RCLU_RIO_Error";
    private static final String EN_RCLU_Initial_Copy_RIO = "RCLU_Initial_Copy_RIO";
    private static final String EN_RCLU_Initial_Copy_Hit = "RCLU_Initial_Copy_Hit";
    private static final String EN_RCLU_Initial_Copy_Transfer = "RCLU_Initial_Copy_Transfer";
    private static final String EN_RCLU_Initial_Copy_Response = "RCLU_Initial_Copy_Response";
    private static final String EN_RCLU_Migration_Copy_RIO = "RCLU_Migration_Copy_RIO";
    private static final String EN_RCLU_Migration_Copy_Hit = "RCLU_Migration_Copy_Hit";
    private static final String EN_RCLU_Update_Copy_RIO = "RCLU_Update_Copy_RIO";
    private static final String EN_RCLU_Update_Copy_Hit = "RCLU_Update_Copy_Hit";
    private static final String EN_RCLU_Update_Copy_Transfer = "RCLU_Update_Copy_Transfer";
    private static final String EN_RCLU_Update_Copy_Response = "RCLU_Update_Copy_Response";
    private static final String EN_RCLU_Restore_Copy_RIO = "RCLU_Restore_Copy_RIO";
    private static final String EN_RCLU_Restore_Copy_Hit = "RCLU_Restore_Copy_Hit";
    private static final String EN_RCLU_Asynchronous_RIO = "RCLU_Asynchronous_RIO";
    private static final String EN_RCLU_Recordset = "RCLU_Recordset";
    private static final String EN_RCLU_Asynchronous_Copy_Transfer = "RCLU_Asynchronous_Copy_Transfer";
    private static final String EN_RCLU_Asynchronous_Copy_Response = "RCLU_Asynchronous_Copy_Response";
    private static final String EN_RCLU_Scheduling_Recordset = "RCLU_Scheduling_Recordset";
    private static final String EN_RCLU_Scheduling_Miss_Recordset = "RCLU_Scheduling_Miss_Recordset";
    private static final String EN_RCLU_Remained_Recordset = "RCLU_Remained_Recordset";
    private static final String EN_RCLU_Scheduling_Attempt = "RCLU_Scheduling_Attempt";
    private static final String EN_RCLU_Pair_Synchronized = "RCLU_Pair_Synchronized";
    private static final String EN_RCLU_Out_of_Tracks = "RCLU_Out_of_Tracks";
    private static final String[] entryNames = new String[]{"RCLU_All_RIO", "RCLU_All_Write", "RCLU_RIO_Error", "RCLU_Initial_Copy_RIO", "RCLU_Initial_Copy_Transfer", "RCLU_Initial_Copy_Response", "RCLU_Update_Copy_RIO", "RCLU_Update_Copy_Transfer", "RCLU_Update_Copy_Response", "RCLU_Pair_Synchronized", "RCLU_Out_of_Tracks"};

    public RJMdGroupRCLU(RJMdDataControl rJMdDataControl) {
        super(rJMdDataControl);
        this.allowPSA = false;
    }

    public void init() throws IOException {
        String string = this.parameter.getDirectory();
        File file = new File(string);
        this.stream = new RJMdUnitParallelStream(groupName, file);
        this.stream.setCompress(this.parameter.isCompless());
    }

    protected boolean isGroupExists() {
        boolean bl = this.stream.exists();
        return bl;
    }

    public void deleteGroup() {
        this.stream.deleteAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGroup() throws RJMdRmiException, IOException {
        try {
            this.createGroupRCLU();
        }
        finally {
            this.stream.close();
        }
    }

    private void createGroupRCLU() throws RJMdRmiException, IOException {
        Object object;
        this.putInfomation("INF006", this.getGroupInfo());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < entryNames.length; ++i) {
            object = this.stream.createEntry(entryNames[i], this.getTimeRange());
            hashMap.put(entryNames[i], object);
        }
        RJMdTimeRange rJMdTimeRange = this.parameter.getShortRange();
        object = new CollectParam(rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
        ArrayList arrayList = this.controller.getPort(1);
        this.initProgress(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataPort rJMdDataPort = (RJMdDataPort)iterator.next();
            int n = rJMdDataPort.getPortID();
            ArrayList arrayList2 = this.controller.getPortToHostGroup(n);
            Iterator iterator2 = arrayList2.iterator();
            while (iterator2.hasNext()) {
                RJMdDataHostGroup rJMdDataHostGroup = (RJMdDataHostGroup)iterator2.next();
                RJMdContainer rJMdContainer = new RJMdContainer(rJMdDataPort, rJMdDataHostGroup);
                if (!this.parameter.containsRange(this.getGroupID(), rJMdContainer)) continue;
                int n2 = rJMdDataHostGroup.getHostGroupID();
                ArrayList arrayList3 = this.controller.getHostGroupToLU(n, n2);
                Iterator iterator3 = arrayList3.iterator();
                while (iterator3.hasNext()) {
                    RJMdDataLU rJMdDataLU = (RJMdDataLU)iterator3.next();
                    if (((CollectParam)object).size() >= 512) {
                        this.collect(hashMap, (CollectParam)object);
                        this.addProgress(((CollectParam)object).size());
                        object = new CollectParam(rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
                    }
                    ((CollectParam)object).add(rJMdDataPort, rJMdDataHostGroup, rJMdDataLU);
                }
            }
        }
        this.collect(hashMap, (CollectParam)object);
        this.closeProgress();
        this.putInfomation("INF007", this.getGroupInfo());
    }

    private void initProgress(ArrayList arrayList) throws RJMdRmiException {
        int n = 0;
        int n2 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataPort rJMdDataPort = (RJMdDataPort)iterator.next();
            int n3 = rJMdDataPort.getPortID();
            ArrayList arrayList2 = this.controller.getPortToHostGroup(n3);
            Iterator iterator2 = arrayList2.iterator();
            while (iterator2.hasNext()) {
                RJMdDataHostGroup rJMdDataHostGroup = (RJMdDataHostGroup)iterator2.next();
                int n4 = rJMdDataHostGroup.getHostGroupID();
                ArrayList arrayList3 = this.controller.getHostGroupToLU(n3, n4);
                n2 += arrayList3.size();
                RJMdContainer rJMdContainer = new RJMdContainer(rJMdDataPort, rJMdDataHostGroup);
                if (!this.parameter.containsRange(this.getGroupID(), rJMdContainer)) continue;
                n += arrayList3.size();
            }
        }
        super.initProgress(n, n2);
    }

    public void collect(HashMap hashMap, CollectParam collectParam) throws RJMdRmiException, IOException {
        if (collectParam.size() > 0) {
            MonitorInfoCollection monitorInfoCollection = (MonitorInfoCollection)this.controller.getMonitorInfo((MonArg)collectParam.getArgument());
            for (int i = 0; i < monitorInfoCollection.size(); ++i) {
                RMCPgetUsageLUInfEx rMCPgetUsageLUInfEx = (RMCPgetUsageLUInfEx)monitorInfoCollection.get(i);
                String string = collectParam.toColumnName(rMCPgetUsageLUInfEx.getPortID(), rMCPgetUsageLUInfEx.getHostgroupID(), rMCPgetUsageLUInfEx.getLUN());
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_RCLU_All_RIO), new RJMdColumn(string, rMCPgetUsageLUInfEx.getAllRIO()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_RCLU_All_Write), new RJMdColumn(string, rMCPgetUsageLUInfEx.getAllWrite()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_RCLU_RIO_Error), new RJMdColumn(string, rMCPgetUsageLUInfEx.getRIOUCK()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_RCLU_Initial_Copy_RIO), new RJMdColumn(string, rMCPgetUsageLUInfEx.getIniRIO()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_RCLU_Initial_Copy_Transfer), new RJMdColumn(string, rMCPgetUsageLUInfEx.getIniLength()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_RCLU_Initial_Copy_Response), new RJMdColumn(string, rMCPgetUsageLUInfEx.getIniTime()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_RCLU_Update_Copy_RIO), new RJMdColumn(string, rMCPgetUsageLUInfEx.getRenewRIO()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_RCLU_Update_Copy_Transfer), new RJMdColumn(string, rMCPgetUsageLUInfEx.getRenewLength()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_RCLU_Update_Copy_Response), new RJMdColumn(string, rMCPgetUsageLUInfEx.getRenewTime()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_RCLU_Pair_Synchronized), new RJMdColumn(string, rMCPgetUsageLUInfEx.getPairSync()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_RCLU_Out_of_Tracks), new RJMdColumn(string, rMCPgetUsageLUInfEx.getOutOfSync()));
            }
        }
    }

    public String[] getGroupAlias() {
        return groupAlias;
    }

    public String getGroupID() {
        return groupID;
    }

    public String getGroupName() {
        return groupName;
    }

    public String getGroupInfo() {
        return groupInfo;
    }

    public RJMdTimeRange getTimeRange() {
        return this.parameter.getShortRange();
    }

    public void analyzeOperand(RJMdCmdParser rJMdCmdParser) throws ParseException {
        RJMdRange rJMdRange = null;
        char c = rJMdCmdParser.getKind();
        while ((rJMdRange = this.analyzePortHgRange(rJMdCmdParser)) != null) {
            RJMdDataControl.trace("\tPort.HostGroup =  " + rJMdRange);
            this.parameter.addGroupRange(this.getGroupID(), rJMdRange);
            if (rJMdCmdParser.getKind() != ' ') break;
            rJMdCmdParser.nextToken();
        }
    }

    class CollectParam {
        private ArrayList lunList = new ArrayList();
        private HashMap columnNames = new HashMap();
        private Date fromTime;
        private Date toTime;

        CollectParam(Date date, Date date2) {
            this.fromTime = date;
            this.toTime = date2;
        }

        public void add(RJMdDataPort rJMdDataPort, RJMdDataHostGroup rJMdDataHostGroup, RJMdDataLU rJMdDataLU) {
            String string = this.toKeyString(rJMdDataPort.getPortID(), rJMdDataHostGroup.getHostGroupID());
            this.columnNames.put(string, RJMdGroupRCLU.this.toPortHgString(rJMdDataPort, rJMdDataHostGroup));
            RJiLUPathIndex rJiLUPathIndex = new RJiLUPathIndex();
            rJiLUPathIndex.setSPort((short)rJMdDataPort.getPortID());
            rJiLUPathIndex.setSHostGroup((short)rJMdDataHostGroup.getHostGroupID());
            rJiLUPathIndex.setSLUN((short)rJMdDataLU.getLU());
            this.lunList.add(rJiLUPathIndex);
        }

        public int size() {
            return this.lunList.size();
        }

        private String toColumnName(int n, int n2, int n3) {
            String string = (String)this.columnNames.get(this.toKeyString(n, n2));
            String string2 = RJMdGroupRCLU.this.toPortLunString(string, n3);
            return string2;
        }

        private String toKeyString(int n, int n2) {
            String string = String.valueOf(n) + "." + String.valueOf(n2);
            return string;
        }

        public ArgHRCLUEx getArgument() {
            RJiLUPathIndex[] rJiLUPathIndexArray = this.lunList.toArray(new RJiLUPathIndex[0]);
            ArgHRCLUEx argHRCLUEx = new ArgHRCLUEx(this.fromTime, this.toTime, rJiLUPathIndexArray);
            return argHRCLUEx;
        }
    }
}

