/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat.group;

import java.io.File;
import java.io.IOException;
import sanproject.getmondat.com.RJMdTimeRange;
import sanproject.getmondat.data.RJMdDataControl;
import sanproject.getmondat.group.RJMdColumn;
import sanproject.getmondat.group.RJMdUnitEntry;
import sanproject.getmondat.group.RJMdUnitStream;

public class RJMdUnitSerialStream
extends RJMdUnitStream {
    private RJMdUnitEntry entry = null;

    public RJMdUnitSerialStream(String string, File file) {
        super(string, file);
    }

    public RJMdUnitEntry createEntry(String string, RJMdTimeRange rJMdTimeRange) {
        this.entry = new RJMdUnitEntry(string, this.streamPath, rJMdTimeRange);
        this.entries.add(this.entry);
        return this.entry;
    }

    public RJMdUnitEntry getCurrentEntry() {
        return this.entry;
    }

    public void write(RJMdColumn rJMdColumn) throws IOException {
        if (this.entry != null && !this.entry.write(rJMdColumn)) {
            this.flush(this.entry);
            this.entry.write(rJMdColumn);
        }
    }

    public void closeEntry() throws IOException {
        if (this.entry != null) {
            this.flush(this.entry);
            this.entry = null;
            if (this.compress && !this.indirect) {
                if (this.zipOut != null) {
                    this.zipOut.closeEntry();
                    this.zipEntry = null;
                }
            } else if (this.seqOut != null) {
                this.seqOut.close();
                this.seqOut = null;
            }
        }
    }

    public void flushAll() throws IOException {
        if (this.entry != null) {
            this.flush(this.entry);
        }
    }

    protected void flushZip(RJMdUnitEntry rJMdUnitEntry) throws IOException {
        super.flushZip(rJMdUnitEntry);
        RJMdDataControl.trace("flush " + this.getName() + ".ZIP (" + this.entry.getName() + ")", 2);
    }

    protected void flushNormal(RJMdUnitEntry rJMdUnitEntry) throws IOException {
        super.flushNormal(rJMdUnitEntry);
        RJMdDataControl.trace("flush " + this.getName() + " (" + this.entry.getName() + ")", 2);
    }
}

