/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat.group;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import sanproject.getmondat.com.RJMdTimeRange;
import sanproject.getmondat.data.RJMdDataControl;
import sanproject.getmondat.group.RJMdUnitEntry;

public abstract class RJMdUnitStream {
    public static final String SUFFIX_ZIP = ".ZIP";
    public static final String SUFFIX_CSV = ".csv";
    public static final String SUFFIX_TMP = "_tmp";
    protected ArrayList entries = new ArrayList();
    protected String streamName;
    protected File streamPath;
    protected File temp = null;
    protected boolean compress = true;
    protected ZipOutputStream zipOut = null;
    protected ZipEntry zipEntry = null;
    protected FileOutputStream seqOut = null;
    protected boolean indirect = false;

    public RJMdUnitStream(String string, File file) {
        this.streamName = string;
        this.streamPath = new File(file.getAbsolutePath(), string);
    }

    public String getName() {
        return this.streamName;
    }

    public void setCompress(boolean bl) {
        this.compress = bl;
    }

    public void setIndirect(boolean bl) {
        this.indirect = bl;
    }

    public abstract RJMdUnitEntry createEntry(String var1, RJMdTimeRange var2);

    public void close() throws IOException {
        this.flushAll();
        if (this.compress && this.indirect && this.zipOut == null) {
            this.compressFile();
            File file = new File(this.streamPath.getAbsolutePath() + SUFFIX_TMP);
            this.deletePath(file);
        }
        if (this.zipOut != null) {
            this.zipOut.close();
            this.zipOut = null;
        }
        if (this.seqOut != null) {
            this.seqOut.close();
            this.seqOut = null;
        }
        this.indirect = false;
    }

    public abstract void flushAll() throws IOException;

    public void flush(RJMdUnitEntry rJMdUnitEntry) throws IOException {
        if (!rJMdUnitEntry.isEmpty()) {
            if (this.compress && !this.indirect) {
                this.flushZip(rJMdUnitEntry);
            } else {
                this.flushNormal(rJMdUnitEntry);
            }
        }
    }

    protected void flushZip(RJMdUnitEntry rJMdUnitEntry) throws IOException {
        if (this.zipOut == null) {
            File file = this.streamPath.getParentFile();
            if (!file.exists()) {
                file.mkdirs();
            }
            File file2 = new File(this.streamPath.getAbsolutePath() + SUFFIX_ZIP);
            this.zipOut = new ZipOutputStream(new FileOutputStream(file2));
        }
        if (this.zipEntry == null) {
            this.zipEntry = new ZipEntry(this.streamName + "/" + rJMdUnitEntry.getName() + SUFFIX_CSV);
            this.zipOut.putNextEntry(this.zipEntry);
        }
        rJMdUnitEntry.flush(this.zipOut);
    }

    protected void flushNormal(RJMdUnitEntry rJMdUnitEntry) throws IOException {
        if (this.seqOut == null) {
            File file = this.streamPath;
            if (this.compress && this.indirect) {
                this.temp = file = new File(this.streamPath.getAbsolutePath() + SUFFIX_TMP);
            }
            if (!file.exists()) {
                file.mkdirs();
            }
            File file2 = new File(file.getAbsolutePath(), rJMdUnitEntry.getName() + SUFFIX_CSV);
            this.seqOut = new FileOutputStream(file2.getAbsolutePath(), rJMdUnitEntry.getAppendMode());
        }
        rJMdUnitEntry.flush(this.seqOut);
    }

    private void compressFile() throws IOException {
        File file = new File(this.streamPath.getAbsolutePath() + SUFFIX_ZIP);
        ZipOutputStream zipOutputStream = null;
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            int n;
            RJMdUnitEntry rJMdUnitEntry = (RJMdUnitEntry)iterator.next();
            String string = rJMdUnitEntry.getName() + SUFFIX_CSV;
            File file2 = new File(this.streamPath.getAbsolutePath() + SUFFIX_TMP, string);
            if (!file2.exists()) continue;
            if (zipOutputStream == null) {
                RJMdDataControl.trace("compress start [" + this.streamPath.getAbsolutePath() + SUFFIX_TMP + "]");
                zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            }
            FileInputStream fileInputStream = new FileInputStream(file2);
            byte[] byArray = new byte[4096];
            zipOutputStream.putNextEntry(new ZipEntry(this.streamName + "/" + string));
            while ((n = fileInputStream.read(byArray)) >= 0) {
                zipOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
            zipOutputStream.closeEntry();
        }
        if (zipOutputStream != null) {
            zipOutputStream.close();
            zipOutputStream = null;
            RJMdDataControl.trace("compress end ");
        }
    }

    public boolean exists() {
        File file = new File(this.streamPath.getAbsolutePath() + SUFFIX_ZIP);
        File file2 = new File(this.streamPath.getAbsolutePath() + SUFFIX_TMP);
        boolean bl = this.streamPath.exists() && this.streamPath.isDirectory() || file.exists() && file.isFile() || file2.exists() && file2.isDirectory();
        return bl;
    }

    public void deleteAll() {
        this.deletePath(this.streamPath);
        File file = new File(this.streamPath.getAbsolutePath() + SUFFIX_ZIP);
        this.deletePath(file);
        file = new File(this.streamPath.getAbsolutePath() + SUFFIX_TMP);
        this.deletePath(file);
    }

    public void deletePath(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                this.deleteDirectory(file);
            }
            if (file.delete()) {
                RJMdDataControl.trace("[" + file.getAbsolutePath() + "] deleted");
            }
        }
    }

    private void deleteDirectory(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].delete()) continue;
            RJMdDataControl.trace("[" + fileArray[i].getAbsolutePath() + "] deleted", 2);
        }
    }

    public void print(PrintStream printStream) {
        printStream.println("RJMdUnitStream.print start");
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            RJMdUnitEntry rJMdUnitEntry = (RJMdUnitEntry)iterator.next();
            rJMdUnitEntry.print(printStream);
        }
        printStream.println("RJMdUnitStream.print end");
    }
}

