/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.xmlcim;

import com.ws.cim.CIMMapping;
import com.ws.cim.xmlcim.CIMXMLWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.cim.CIMElement;
import javax.cim.CIMInstance;

public class XMLCIMMapping
implements CIMMapping {
    private static final String FORMAT_XML = "XML";
    private CIMXMLWriter xw;
    private boolean mQuiet;
    private String mOutdir;

    public void initialize(String outdir) {
        block2: {
            this.mOutdir = outdir;
            try {
                this.xw = new CIMXMLWriter(outdir);
                this.xw.recordAll();
            }
            catch (Exception e) {
                if (this.mQuiet) break block2;
                e.printStackTrace();
            }
        }
    }

    public void close() {
        block3: {
            try {
                this.xw.closeAll();
            }
            catch (Exception e) {
                if (this.mQuiet) break block3;
                e.printStackTrace();
            }
        }
        List<File> files = this.getFileListing(new File(this.mOutdir));
        for (File fName : files) {
            fName.deleteOnExit();
        }
    }

    private List<File> getFileListing(File aStartingDir) {
        ArrayList<File> result = new ArrayList<File>();
        File[] filesAndDirs = aStartingDir.listFiles();
        List<File> filesDirs = Arrays.asList(filesAndDirs);
        for (File file : filesDirs) {
            if (file.isDirectory()) {
                List<File> deeperList = this.getFileListing(file);
                result.addAll(deeperList);
                continue;
            }
            if (file.getName().endsWith(".xml")) continue;
            result.add(file);
        }
        Collections.sort(result);
        return result;
    }

    public void setFormat(String format) {
        if (!format.equalsIgnoreCase(FORMAT_XML)) {
            throw new IllegalArgumentException("Format not supported.");
        }
    }

    public void produceMappedElement(CIMElement element) {
        block2: {
            try {
                this.xw.writeElement(element);
            }
            catch (Exception e) {
                if (this.mQuiet) break block2;
                e.printStackTrace();
            }
        }
    }

    public void produceMappedInstance(CIMInstance instance) {
        block2: {
            try {
                this.xw.writeElement(instance);
            }
            catch (Exception e) {
                if (this.mQuiet) break block2;
                e.printStackTrace();
            }
        }
    }

    public void setProperty(String pName, String value) {
        if (pName.equalsIgnoreCase("q")) {
            this.mQuiet = true;
        }
        if (pName.equalsIgnoreCase("lo")) {
            this.xw.setLocalOnly(true);
        }
    }

    public String[] getCustomPropertyNames(String format) {
        if (FORMAT_XML.equalsIgnoreCase(format)) {
            return new String[]{"lo", "q"};
        }
        return null;
    }

    public String getCustomPropertyDescription(String cpName) {
        if ("q".equals(cpName)) {
            return "This option will supress all output (not including exceptions).";
        }
        if ("lo".equals(cpName)) {
            return "This option will provide a local only mapping (not all inherited objects on each sub class).";
        }
        return null;
    }
}

