/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.client.adapter.common;

import com.ws.logging.TraceDocument;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingOutputStream
extends OutputStream {
    private final Logger mLogger;
    private final OutputStream mStream;
    private StringBuffer mBuffer = new StringBuffer();

    public LoggingOutputStream(OutputStream stream) {
        this.mLogger = Logger.getLogger("com.ws.wbem.client");
        this.mStream = stream;
    }

    @Override
    public void close() throws IOException {
        this.mStream.close();
        if (this.mBuffer.length() > 0) {
            this.mLogger.log(Level.FINEST, this.mBuffer.toString());
            TraceDocument.trace((String)this.mBuffer.toString(), (boolean)true);
        }
        this.mBuffer = new StringBuffer();
    }

    @Override
    public void flush() throws IOException {
        this.mStream.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.mBuffer.append(new String(b, "UTF-8"));
        this.mStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.mStream.write(b, off, len);
        this.mBuffer.append(new String(b, "UTF-8"), off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.mStream.write(b);
        this.mBuffer.append((char)b);
    }
}

