/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.mof.compiler;

import java.util.HashMap;
import javax.cim.CIMObjectPath;
import javax.cim.CIMQualifierType;
import javax.wbem.WBEMException;
import javax.wbem.client.WBEMClient;

public class QualifierTypeCache {
    private static HashMap<String, CIMQualifierType<?>> qtCache = new HashMap();
    private WBEMClient mClient;

    public QualifierTypeCache(WBEMClient pClient) {
        this.mClient = pClient;
    }

    public CIMQualifierType<?> get(CIMObjectPath op) throws WBEMException {
        String qtName = op.getObjectName();
        CIMQualifierType<?> qt = qtCache.get(qtName.toLowerCase());
        if (qt == null) {
            qt = this.add(op);
        }
        return qt;
    }

    public void putType(CIMQualifierType<?> cqt) {
        qtCache.put(cqt.getObjectPath().getObjectName().toLowerCase(), cqt);
    }

    private CIMQualifierType<?> add(CIMObjectPath op) throws WBEMException {
        if (this.mClient == null) {
            return null;
        }
        CIMQualifierType<?> q = this.mClient.getQualifierType(op);
        if (q != null) {
            this.putType(q);
        }
        return q;
    }
}

