/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.apps.mofcompiler;

import com.ws.cim.mof.compiler.CIMMutableClass;
import com.ws.cim.mof.compiler.CIMMutableInstance;
import com.ws.cim.mof.compiler.CIMMutablePragma;
import com.ws.cim.mof.compiler.CIMMutableProperty;
import com.ws.cim.mof.compiler.CIMMutableQualifierType;
import com.ws.cim.mof.compiler.ClassCache;
import com.ws.cim.mof.compiler.MOFCompilerCIMClient;
import com.ws.cim.mof.compiler.MOFParserHandler;
import com.ws.cim.mof.compiler.QualifierTypeCache;
import com.ws.utilities.WSIStandardMessages;
import com.ws.utilities.wbem.client.LocaleHelper;
import com.ws.utilities.wbem.client.WBEMServerNamespace;
import com.ws.wbem.jserver.CIMRepository;
import java.util.Hashtable;
import java.util.Locale;
import javax.cim.CIMClass;
import javax.cim.CIMClassProperty;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMQualifierType;
import javax.security.auth.Subject;
import javax.wbem.WBEMException;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;
import javax.wbem.client.WBEMClient;
import javax.wbem.client.WBEMClientFactory;
import org.wbemservices.wbem.repository.PSRlogImpl;

public class MOFCompilerHandler
implements MOFParserHandler {
    private static final String CREATED_NAMESPACE = "Created namespace: ";
    private final boolean mIsVerbose;
    private final WBEMClient mCallBack;
    private boolean mIsInvoked = false;
    private boolean mIgnoreInstance = false;
    private final Locale[] mLocales;
    private WBEMClient mClientHandle;
    private final UserPrincipal mUserPrincipal;
    private final PasswordCredential mPasswordCredential;
    private Boolean mCompile;
    private boolean setQual = false;
    private boolean setClass = false;
    private boolean setInstance = false;
    private boolean connectToCimom = true;
    private CIMObjectPath curNameSpace;
    private String mInteropNamespace = "interop";
    private String mProtocol = "CIM-XML";
    private static QualifierTypeCache mQualifierTypeCache;
    private static ClassCache mClassCache;
    private static int mInt_NumQTStat;
    private static int mInt_NumClassStats;
    private static int mInt_NumInstStats;
    private final MOFParserHandler mParseCallBack;
    private String mDebugLevel = "10000";
    private String mRepositoryDirectory;

    public MOFCompilerHandler(Hashtable<String, String> clht, WBEMClient pCallback, boolean pVerbose, boolean pInvoked, MOFParserHandler pParseCallBack) throws Exception {
        String namespace;
        String standalone;
        this.mIsInvoked = pInvoked;
        this.mIsVerbose = pVerbose;
        this.mCallBack = pCallback;
        this.mCompile = true;
        this.mParseCallBack = pParseCallBack;
        if (clht.get("-c") != null) {
            this.mCompile = false;
        }
        this.mLocales = LocaleHelper.getLocaleArray((String)clht.get("-l"));
        this.mProtocol = clht.get("protocol");
        if (clht.get("-i") != null) {
            this.mInteropNamespace = clht.get("-i");
        }
        if ((standalone = clht.get("standalone")) != null) {
            boolean bl = this.connectToCimom = standalone.compareToIgnoreCase("true") != 0;
            if (!this.connectToCimom) {
                this.mRepositoryDirectory = clht.get("logdir");
                System.setProperty("passAllProviderCheck", "true");
            }
        }
        this.connectToCimom &= !this.mIsInvoked;
        String username = clht.get("username");
        String password = clht.get("password");
        this.mUserPrincipal = new UserPrincipal(username);
        this.mPasswordCredential = new PasswordCredential(password);
        String cimhost = clht.get("cimhost");
        CIMObjectPath cimHost = cimhost == null || cimhost.length() == 0 ? new CIMObjectPath("https://localhost/interop") : new CIMObjectPath(cimhost);
        if (clht.get("-Q") != null) {
            this.setQual = true;
        }
        if (clht.get("-C") != null) {
            this.setClass = true;
        }
        if (clht.get("-I") != null) {
            this.setInstance = true;
        }
        if (clht.get("-II") != null) {
            this.mIgnoreInstance = true;
        }
        if ((namespace = clht.get("namespace")) == null) {
            namespace = cimHost.getNamespace();
        }
        if (namespace == null || namespace.length() == 0) {
            throw new WBEMException(1, "The namespace was not specified. The namespace must be specified using either the -n option or as part of the -s option");
        }
        try {
            this.curNameSpace = new CIMObjectPath(cimHost.getScheme(), cimHost.getHost(), cimHost.getPort(), namespace, "", null);
        }
        catch (Exception e) {
            if (!this.mIsInvoked) {
                System.err.println("The -s argument is not formatted correctly: " + cimhost);
                System.exit(-1);
            }
            throw new WBEMException(1, "Invalid Command Line: the -s argument is not formatted correctly");
        }
        if (clht.get("-d") != null) {
            this.mDebugLevel = clht.get("-d");
        }
        this.connect();
    }

    private void addQualifierTypeToCache(CIMQualifierType<?> cqt) {
        mQualifierTypeCache.putType(cqt);
    }

    private void connect() throws WBEMException {
        Subject s = new Subject();
        s.getPrincipals().add(this.mUserPrincipal);
        s.getPrivateCredentials().add(this.mPasswordCredential);
        try {
            this.mClientHandle = null;
            if (this.connectToCimom) {
                this.mClientHandle = WBEMClientFactory.getClient(this.mProtocol);
                this.mClientHandle.setProperty("javax.wbem.client.log.console.enabled", this.mDebugLevel);
                this.mClientHandle.initialize(this.curNameSpace, s, this.mLocales);
            } else {
                this.mClientHandle = new MOFCompilerCIMClient(this.mCallBack, this.mRepositoryDirectory);
            }
            mQualifierTypeCache = new QualifierTypeCache(this.mClientHandle);
            mClassCache = new ClassCache(this.mClientHandle);
            if (this.mCompile.booleanValue()) {
                CIMObjectPath nsPath = new CIMObjectPath(this.curNameSpace.getScheme(), this.curNameSpace.getHost(), this.curNameSpace.getPort(), this.mInteropNamespace, "", null);
                if (this.connectToCimom) {
                    CIMObjectPath res;
                    if (!WBEMServerNamespace.namespaceExist((WBEMClient)this.mClientHandle, (CIMObjectPath)this.curNameSpace) && null != (res = WBEMServerNamespace.createNamespace((WBEMClient)this.mClientHandle, (CIMObjectPath)nsPath, (String)this.curNameSpace.getNamespace())) && this.mIsVerbose) {
                        System.out.println(CREATED_NAMESPACE + this.curNameSpace.getNamespace());
                    }
                } else {
                    CIMRepository r = PSRlogImpl.getRepository();
                    r.createNamespace(this.curNameSpace.getNamespace());
                }
            }
        }
        catch (WBEMException e) {
            if (e.getID() != 11) {
                throw e;
            }
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString());
        }
    }

    @Override
    public void fixInstanceProperty(String className, CIMMutableProperty pName) throws WBEMException {
        if (this.mIgnoreInstance) {
            return;
        }
        if (this.mCompile.booleanValue()) {
            CIMClass cClass = mClassCache.get(new CIMObjectPath(null, null, null, this.curNameSpace.getNamespace(), className, null, null));
            CIMClassProperty<?> cp = cClass.getProperty(pName.getName());
            if (cp == null) {
                Object[] o = new Object[]{pName.getName(), className};
                String data = WSIStandardMessages.getMessage((String)"MOFCOMP_ERROR_INVALID_PROPERTY_INSTANCE", (Object[])o);
                throw new WBEMException(1, data);
            }
            pName.setType(cp.getDataType());
            pName.setKey(cp.isKey());
        }
    }

    protected int getClassStats() {
        return mInt_NumClassStats;
    }

    protected int getInstanceStats() {
        return mInt_NumInstStats;
    }

    @Override
    public String getNamespace(String pNamespace) {
        return this.curNameSpace.getNamespace();
    }

    private CIMQualifierType<?> getQualifierType(CIMObjectPath op) throws WBEMException {
        return mQualifierTypeCache.get(op);
    }

    @Override
    public CIMDataType getQualifierTypeDataType(String name) throws WBEMException {
        block3: {
            try {
                CIMQualifierType<?> cqt;
                if (this.curNameSpace != null && this.mCompile.booleanValue() && (cqt = this.getQualifierType(new CIMObjectPath(null, null, null, this.curNameSpace.getNamespace(), name, null, null))) != null) {
                    return cqt.getDataType();
                }
            }
            catch (WBEMException e) {
                if (!this.mCompile.booleanValue()) break block3;
                Object[] o = new Object[]{name, this.curNameSpace.getNamespace()};
                throw new WBEMException(6, WSIStandardMessages.getMessage((String)"MOFCOMP.ERROR_QUALIFIER_TYPE_NOT_EXIST", (Object[])o));
            }
        }
        return null;
    }

    protected int getQualifierTypeStats() {
        return mInt_NumQTStat;
    }

    @Override
    public void processClass(CIMMutableClass pClass) throws WBEMException {
        block12: {
            Object[] o = new Object[]{pClass.getName()};
            if (this.mIsVerbose) {
                if (this.setClass) {
                    System.out.println(WSIStandardMessages.getMessage((String)"MESSAGE_MODIFY_CLASS", (Object[])o));
                } else {
                    System.out.println(WSIStandardMessages.getMessage((String)"MESSAGE_CREATE_CLASS", (Object[])o));
                }
            }
            if (this.mCompile.booleanValue()) {
                try {
                    pClass.setNamespace(this.curNameSpace.getNamespace());
                    if (this.setClass) {
                        CIMClass cClass = pClass.getCIMClass();
                        try {
                            this.mClientHandle.modifyClass(cClass);
                            break block12;
                        }
                        catch (WBEMException e) {
                            if (e.getID() == 6) {
                                this.mClientHandle.createClass(cClass);
                                break block12;
                            }
                            throw e;
                        }
                    }
                    CIMClass cClass = pClass.getCIMClass();
                    this.mClientHandle.createClass(cClass);
                }
                catch (WBEMException e) {
                    if (e.getID() == 11 && !this.setClass) {
                        this.reportWarning(e.getMessage());
                    }
                    throw e;
                }
            }
        }
        ++mInt_NumClassStats;
        if (this.mParseCallBack != null) {
            this.mParseCallBack.processClass(pClass);
        }
    }

    @Override
    public void processInstance(CIMMutableInstance pInstance) throws WBEMException {
        block13: {
            if (this.mIgnoreInstance) {
                return;
            }
            if (this.mIsVerbose) {
                Object[] o = new Object[]{pInstance.getObjectPath()};
                if (this.setInstance) {
                    System.out.println(WSIStandardMessages.getMessage((String)"MESSAGE_MODIFY_INSTANCE", (Object[])o));
                } else {
                    System.out.println(WSIStandardMessages.getMessage((String)"MESSAGE_CREATE_INSTANCE", (Object[])o));
                }
            }
            if (this.mCompile.booleanValue()) {
                try {
                    CIMInstance ci;
                    if (this.setInstance) {
                        ci = pInstance.getCIMInstance();
                        try {
                            this.mClientHandle.modifyInstance(ci, null);
                            break block13;
                        }
                        catch (WBEMException e) {
                            if (e.getID() == 6) {
                                this.mClientHandle.createInstance(ci);
                                break block13;
                            }
                            throw e;
                        }
                    }
                    ci = pInstance.getCIMInstance();
                    this.mClientHandle.createInstance(ci);
                }
                catch (WBEMException e) {
                    if (e.getID() == 11 && !this.setInstance) {
                        this.reportWarning(e.getMessage());
                    }
                    throw e;
                }
            }
        }
        ++mInt_NumInstStats;
        if (this.mParseCallBack != null) {
            this.mParseCallBack.processInstance(pInstance);
        }
    }

    @Override
    public boolean processPragma(CIMMutablePragma pPragma) throws WBEMException {
        if (pPragma == null || pPragma.getName() == null) {
            return true;
        }
        String name = pPragma.getName();
        if (name.equalsIgnoreCase("namespace")) {
            this.switchNamespace(pPragma.getValue());
        }
        return true;
    }

    @Override
    public void processQualifierType(CIMMutableQualifierType pCIMQT) throws WBEMException {
        this.addQualifierTypeToCache(pCIMQT.getCIMQualifierType());
        try {
            if (this.mIsVerbose) {
                Object[] o = new Object[]{pCIMQT.getName()};
                System.out.println(WSIStandardMessages.getMessage((String)"MESSAGE_ADDING_QUALIFIERTYPE", (Object[])o));
            }
            pCIMQT.setNamespace(this.curNameSpace.getNamespace());
            if (this.mCompile.booleanValue()) {
                this.mClientHandle.createQualifierType(pCIMQT.getCIMQualifierType());
            }
        }
        catch (WBEMException e) {
            if (e.getID() == 11 && !this.setQual || e.getID() == 6 && this.setQual) {
                this.reportWarning(e.getMessage());
            }
            throw e;
        }
        ++mInt_NumQTStat;
        if (this.mParseCallBack != null) {
            this.mParseCallBack.processQualifierType(pCIMQT);
        }
    }

    private void reportWarning(String data) {
        if (this.mIsVerbose) {
            System.err.println(data);
        }
    }

    private void switchNamespace(String newNamespace) throws WBEMException {
        this.curNameSpace = new CIMObjectPath(this.curNameSpace.getScheme(), this.curNameSpace.getHost(), this.curNameSpace.getPort(), newNamespace, "", null);
        if (this.mCompile.booleanValue()) {
            this.connect();
        }
    }

    public void close() {
        this.mClientHandle.close();
    }

    static {
        mInt_NumQTStat = 0;
        mInt_NumClassStats = 0;
        mInt_NumInstStats = 0;
    }
}

