/*
 * Decompiled with CFR 0.152.
 */
package javax.cim3;

import com.ws.cim3.mof.MOFStyle;
import java.io.Serializable;
import javax.cim3.CIMDataType;
import javax.cim3.CIMNamedElementInterface;
import javax.cim3.CIMObjectPath;
import javax.cim3.CIMPolicyKind;
import javax.cim3.CIMQualifiedElementInterface;
import javax.cim3.CIMQualifier;
import javax.cim3.CIMValuedElement;

public class CIMQualifierType<E>
extends CIMValuedElement<E>
implements CIMQualifiedElementInterface,
CIMNamedElementInterface,
Serializable {
    private static final long serialVersionUID = -2239207940395476695L;
    private final CIMObjectPath mPath;
    private final CIMPolicyKind mPolicy;
    private final CIMQualifier<?>[] mQualifiers;
    private final int mScope;

    public CIMQualifierType(CIMObjectPath path, CIMDataType type, E value, int scope, CIMPolicyKind policy, CIMQualifier<?>[] qualifiers) {
        super(path == null ? null : path.getObjectName(), type, value);
        this.mScope = scope;
        this.mPolicy = policy;
        this.mPath = path;
        this.mQualifiers = qualifiers;
    }

    @Override
    public boolean equals(Object o) {
        try {
            CIMQualifierType qt;
            return o instanceof CIMQualifierType && super.equals(o) && this.mPolicy == (qt = (CIMQualifierType)o).getPolicy() && this.mScope == qt.getScope() && this.mPath.equals(qt.getObjectPath());
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public CIMObjectPath getObjectPath() {
        return this.mPath;
    }

    public CIMPolicyKind getPolicy() {
        return this.mPolicy;
    }

    @Override
    public CIMQualifier<?> getQualifier(int index) throws ArrayIndexOutOfBoundsException {
        return this.mQualifiers[index];
    }

    @Override
    public CIMQualifier<?> getQualifier(String name) {
        if (name != null) {
            for (CIMQualifier<?> mQualifier : this.mQualifiers) {
                if (!mQualifier.getName().equalsIgnoreCase(name)) continue;
                return mQualifier;
            }
        }
        return null;
    }

    @Override
    public int getQualifierCount() {
        return this.mQualifiers.length;
    }

    @Override
    public CIMQualifier<?>[] getQualifiers() {
        return this.mQualifiers;
    }

    @Override
    public Object getQualifierValue(String name) {
        CIMQualifier<?> q = this.getQualifier(name);
        if (q != null) {
            return q.getValue();
        }
        return null;
    }

    public int getScope() {
        return this.mScope;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash ^= this.mPolicy.hashCode();
        hash ^= this.mScope;
        return hash ^= this.mPath.hashCode();
    }

    @Override
    public boolean hasQualifier(String name) {
        return this.getQualifier(name) != null;
    }

    @Override
    public boolean hasQualifierValue(String name, Object value) {
        CIMQualifier<?> q = this.getQualifier(name);
        return q != null && q.getValue() != null && q.getValue().equals(value);
    }

    @Override
    public String toString() {
        MOFStyle mf = new MOFStyle();
        return mf.generateMOF(this);
    }
}

