/*
 * Decompiled with CFR 0.152.
 */
package javax.cim3;

import com.ws.cim3.mof.MOFStyle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.cim3.CIMClassProperty;
import javax.cim3.CIMElement;
import javax.cim3.CIMEnumeration;
import javax.cim3.CIMNamedElementInterface;
import javax.cim3.CIMObjectPath;
import javax.cim3.CIMProperty;
import javax.cim3.CIMQualifiedElementInterface;
import javax.cim3.CIMQualifier;
import javax.cim3.SharedMethods;

public class CIMStructure
extends CIMElement
implements CIMQualifiedElementInterface,
CIMNamedElementInterface,
Serializable {
    private static final long serialVersionUID = -5634561913210025100L;
    private final CIMObjectPath mObjectPath;
    private final CIMClassProperty<?>[] mProperties;
    private final CIMQualifier<?>[] mQualifiers;
    private final CIMEnumeration<?>[] mEnumerations;
    private final CIMStructure[] mStructures;
    private final String mSuperClass;

    public CIMStructure(CIMObjectPath path, String superclass, CIMQualifier<?>[] qualifiers, CIMClassProperty<?>[] properties, CIMStructure[] structures, CIMEnumeration<?>[] enumerations) {
        super(path.getObjectName());
        this.mObjectPath = path;
        this.mSuperClass = superclass;
        this.mQualifiers = qualifiers != null ? qualifiers : new CIMQualifier[]{};
        this.mProperties = properties != null ? properties : new CIMClassProperty[]{};
        this.mStructures = structures != null ? structures : new CIMStructure[]{};
        this.mEnumerations = enumerations != null ? enumerations : new CIMEnumeration[]{};
    }

    @Override
    public boolean equals(Object obj) {
        CIMStructure clazz;
        if (obj instanceof CIMStructure && super.equals(obj) && this.mObjectPath.equals((clazz = (CIMStructure)obj).getObjectPath()) && (this.mSuperClass == null ? clazz.mSuperClass == null : this.mSuperClass.equalsIgnoreCase(clazz.mSuperClass))) {
            Object[] props = (CIMProperty[])this.mProperties.clone();
            Object[] clazzprops = (CIMProperty[])clazz.mProperties.clone();
            Arrays.sort(props);
            Arrays.sort(clazzprops);
            if (Arrays.equals(props, clazzprops)) {
                Object[] quals = (CIMQualifier[])this.mQualifiers.clone();
                Object[] clazzquals = (CIMQualifier[])clazz.mQualifiers.clone();
                Arrays.sort(quals);
                Arrays.sort(clazzquals);
                if (Arrays.equals(quals, clazzquals)) {
                    return true;
                }
            }
        }
        return false;
    }

    public CIMStructure filterProperties(boolean localOnly, boolean includeQualifiers, String[] propertyList) {
        if (!localOnly && includeQualifiers && propertyList == null) {
            return this;
        }
        CIMQualifier<?>[] qualList = includeQualifiers ? SharedMethods.getFilteredQualifiers(localOnly, this.mQualifiers) : null;
        CIMClassProperty<?>[] propList = this.getFilteredProperties(localOnly, includeQualifiers, propertyList);
        CIMStructure cc = new CIMStructure(this.getObjectPath(), this.mSuperClass, qualList, propList, this.mStructures, this.mEnumerations);
        return cc;
    }

    protected CIMClassProperty<?>[] getFilteredProperties(boolean localOnly, boolean includeQualifier, String[] propertyList) {
        ArrayList propList = new ArrayList();
        if (propertyList == null) {
            if (this.mProperties != null && this.mProperties.length > 0) {
                CIMClassProperty<?>[] arr$ = this.mProperties;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    CIMClassProperty<?> mPropertie;
                    CIMClassProperty<?> cp = mPropertie = arr$[i$];
                    if ((!localOnly || cp.isPropagated()) && localOnly) continue;
                    propList.add(cp.filter(includeQualifier, localOnly));
                }
            }
        } else {
            HashSet<String> hm = new HashSet<String>();
            for (String element : propertyList) {
                String propName;
                CIMClassProperty<?> cp = this.getProperty(element);
                if (cp == null || hm.contains(propName = cp.getName())) continue;
                hm.add(propName);
                if ((!localOnly || cp.isPropagated()) && localOnly) continue;
                propList.add(cp.filter(includeQualifier));
            }
        }
        if (!propList.isEmpty()) {
            return propList.toArray(new CIMClassProperty[propList.size()]);
        }
        return null;
    }

    @Override
    public CIMObjectPath getObjectPath() {
        return this.mObjectPath;
    }

    public CIMClassProperty<?>[] getProperties() {
        return this.mProperties;
    }

    public CIMEnumeration<?>[] getEnumerations() {
        return this.mEnumerations;
    }

    public CIMStructure[] getStructures() {
        return this.mStructures;
    }

    public CIMClassProperty<?> getProperty(int index) throws ArrayIndexOutOfBoundsException {
        return this.mProperties[index];
    }

    public CIMClassProperty<?> getProperty(String name) {
        if (this.mProperties == null || name == null) {
            return null;
        }
        for (CIMClassProperty<?> mPropertie : this.mProperties) {
            if (!mPropertie.getName().equalsIgnoreCase(name)) continue;
            return mPropertie;
        }
        return null;
    }

    public int getPropertyCount() {
        return this.mProperties.length;
    }

    @Override
    public CIMQualifier<?> getQualifier(int index) throws ArrayIndexOutOfBoundsException {
        return this.mQualifiers[index];
    }

    @Override
    public CIMQualifier<?> getQualifier(String name) {
        if (name != null) {
            for (CIMQualifier<?> mQualifier : this.mQualifiers) {
                if (!mQualifier.getName().equalsIgnoreCase(name)) continue;
                return mQualifier;
            }
        }
        return null;
    }

    @Override
    public int getQualifierCount() {
        return this.mQualifiers.length;
    }

    @Override
    public CIMQualifier<?>[] getQualifiers() {
        return this.mQualifiers;
    }

    @Override
    public Object getQualifierValue(String name) {
        CIMQualifier<?> q = this.getQualifier(name);
        if (q != null) {
            return q.getValue();
        }
        return null;
    }

    public String getSuperClassName() {
        return this.mSuperClass;
    }

    @Override
    public boolean hasQualifier(String name) {
        return this.getQualifier(name) != null;
    }

    @Override
    public boolean hasQualifierValue(String name, Object value) {
        CIMQualifier<?> q = this.getQualifier(name);
        return q != null && q.getValue() != null && q.getValue().equals(value);
    }

    @Override
    public String toString() {
        MOFStyle mf = new MOFStyle();
        return mf.generateMOF(this);
    }
}

