/*
 * Decompiled with CFR 0.152.
 */
package javax.cim3;

import com.ws.cim3.mof.MOFStyle;
import java.text.MessageFormat;
import java.util.Arrays;
import javax.cim.CIMDateTime;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.cim.UnsignedInteger8;
import javax.cim3.CIMClass;
import javax.cim3.CIMDataType;
import javax.cim3.CIMInstance;
import javax.cim3.CIMObjectPath;
import javax.cim3.CIMTypedElement;
import javax.cim3.Messages;

public abstract class CIMValuedElement<E>
extends CIMTypedElement<E> {
    private static final String DT_CLASS = "Class";
    private static final String DT_OBJECT = "Object";
    private static final long serialVersionUID = -5535931215586890247L;
    private final E mValue;

    public CIMValuedElement(String pName, CIMDataType pType, E pValue) throws IllegalArgumentException {
        super(pName, pType);
        this.mValue = pValue;
        if (pType != null && !this.verifyValueHasType(pValue, pType)) {
            String type = pType.toString();
            if (pType.getType() == 15) {
                type = DT_OBJECT;
            } else if (pType.getType() == 16) {
                type = DT_CLASS;
            }
            Object[] args = new Object[]{pValue, type, pName};
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CIMValuedElement.0"), args));
        }
    }

    @Override
    public boolean equals(Object obj) {
        try {
            E o;
            if (obj instanceof CIMValuedElement && super.equals(obj) && (this.getValue() != null ? this.equalsValueHasType(o = ((CIMValuedElement)obj).getValue(), this.getDataType()) : ((CIMValuedElement)obj).getValue() == null)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private boolean equalsValueHasType(Object pValue, CIMDataType pType) {
        if (pValue == null) {
            return this.mValue == null;
        }
        if (pType == null) {
            if (pValue instanceof Object[]) {
                Object[] pVal = (Object[])((Object[])pValue).clone();
                Object[] mVal = (Object[])((Object[])this.mValue).clone();
                return Arrays.equals(pVal, mVal);
            }
            return pValue.equals(this.mValue);
        }
        if (!pType.isArray()) {
            switch (pType.getType()) {
                case 9: {
                    return ((Boolean)pValue).equals(this.mValue);
                }
                case 13: {
                    return ((Character)pValue).equals(this.mValue);
                }
                case 16: {
                    return ((CIMClass)pValue).equals(this.mValue);
                }
                case 12: {
                    return ((CIMDateTime)pValue).equals(this.mValue);
                }
                case 10: {
                    return ((Float)pValue).equals(this.mValue);
                }
                case 11: {
                    return ((Double)pValue).equals(this.mValue);
                }
                case 14: {
                    return ((CIMObjectPath)pValue).equals(this.mValue);
                }
                case 1: {
                    return ((Byte)pValue).equals(this.mValue);
                }
                case 3: {
                    return ((Short)pValue).equals(this.mValue);
                }
                case 5: {
                    return ((Integer)pValue).equals(this.mValue);
                }
                case 7: {
                    return ((Long)pValue).equals(this.mValue);
                }
                case 0: {
                    return ((UnsignedInteger8)pValue).equals(this.mValue);
                }
                case 2: {
                    return ((UnsignedInteger16)pValue).equals(this.mValue);
                }
                case 4: {
                    return ((UnsignedInteger32)pValue).equals(this.mValue);
                }
                case 6: {
                    return ((UnsignedInteger64)pValue).equals(this.mValue);
                }
                case 8: {
                    return ((String)pValue).equals(this.mValue);
                }
                case 15: {
                    return ((CIMInstance)pValue).equals(this.mValue);
                }
            }
            return false;
        }
        Object[] pVal = (Object[])((Object[])pValue).clone();
        Object[] mVal = (Object[])((Object[])this.mValue).clone();
        return Arrays.equals(pVal, mVal);
    }

    public E getValue() {
        return this.mValue;
    }

    @Override
    public String toString() {
        MOFStyle mf = new MOFStyle();
        return mf.generateMOF(this);
    }

    private boolean verifyValueHasType(E value, CIMDataType type) {
        if (null == value || type.getType() == 20 || type.getType() == 18) {
            return true;
        }
        if (!type.isArray()) {
            switch (type.getType()) {
                case 9: {
                    return value instanceof Boolean;
                }
                case 13: {
                    return value instanceof Character;
                }
                case 16: {
                    return value instanceof CIMClass;
                }
                case 12: {
                    return value instanceof CIMDateTime;
                }
                case 10: {
                    return value instanceof Float;
                }
                case 11: {
                    return value instanceof Double;
                }
                case 14: {
                    return value instanceof CIMObjectPath;
                }
                case 1: {
                    return value instanceof Byte;
                }
                case 3: {
                    return value instanceof Short;
                }
                case 5: {
                    return value instanceof Integer;
                }
                case 7: {
                    return value instanceof Long;
                }
                case 0: {
                    return value instanceof UnsignedInteger8;
                }
                case 2: {
                    return value instanceof UnsignedInteger16;
                }
                case 4: {
                    return value instanceof UnsignedInteger32;
                }
                case 6: {
                    return value instanceof UnsignedInteger64;
                }
                case 8: {
                    return value instanceof String;
                }
                case 15: {
                    return value instanceof CIMInstance;
                }
            }
            return false;
        }
        switch (type.getType()) {
            case 9: {
                return value instanceof Boolean[];
            }
            case 13: {
                return value instanceof Character[];
            }
            case 16: {
                return value instanceof CIMClass[];
            }
            case 12: {
                return value instanceof CIMDateTime[];
            }
            case 10: {
                return value instanceof Float[];
            }
            case 11: {
                return value instanceof Double[];
            }
            case 14: {
                return value instanceof CIMObjectPath[];
            }
            case 1: {
                return value instanceof Byte[];
            }
            case 3: {
                return value instanceof Short[];
            }
            case 5: {
                return value instanceof Integer[];
            }
            case 7: {
                return value instanceof Long[];
            }
            case 0: {
                return value instanceof UnsignedInteger8[];
            }
            case 2: {
                return value instanceof UnsignedInteger16[];
            }
            case 4: {
                return value instanceof UnsignedInteger32[];
            }
            case 6: {
                return value instanceof UnsignedInteger64[];
            }
            case 8: {
                return value instanceof String[];
            }
            case 15: {
                return value instanceof CIMInstance[];
            }
        }
        return false;
    }
}

