/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.sanproject.rmi.server.managers;

import com.hitachi.sanproject.data.SanClass;
import com.hitachi.sanproject.data.SanData;
import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanDataUtility;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanInterface;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import com.hitachi.sanproject.rmi.SanRmiException;
import com.hitachi.sanproject.rmi.server.SanRemoteObject;
import com.hitachi.sanproject.rmi.server.SanRmiServer;
import com.hitachi.sanproject.util.SanLogger;
import java.util.logging.Logger;

public class SanAuditLog
extends Thread {
    protected static Logger logger;
    protected static SanRemoteObject robj;
    protected SanData data;
    protected SanData auditLogData;
    protected static SanInterface _i;
    protected static SanInterface icreatehandle;
    protected static SanInterface iwritelog;
    protected static SanInterface iclosehandle;
    protected String funcname;
    protected String operation;
    protected String parameter;
    protected String result;
    protected SanRequest requestData;
    protected SanResponse responseData;
    protected int[] messageId = new int[2];
    protected static final int PARAM_SIZE = 1024;
    protected StringBuilder param;
    protected long audithandle;
    protected boolean flg = true;
    private static final String[] portlocation_s;
    private static final String[] portlocation_m;
    private static final String[] portlocation_h;

    public SanAuditLog(SanInterface sanInterface, SanData sanData, SanRequest sanRequest, SanResponse sanResponse, SanData sanData2) throws SanDataException {
        logger = SanRmiServer.getLogger();
        this.data = sanData.clone();
        this.requestData = sanRequest.clone();
        this.responseData = sanResponse.clone();
        this.operation = this.requestData.id();
        this.auditLogData = sanData2.clone();
        if (this.auditLogData.attrs().get("displayname") != null) {
            this.operation = (String)this.auditLogData.attrs().get("displayname");
        }
        this.funcname = new String();
        if (this.auditLogData.attrs().get("funcname") != null) {
            this.funcname = (String)this.auditLogData.attrs().get("funcname");
        }
    }

    public static void initialize() {
        robj = SanRmiServer.getRemoteObject();
        icreatehandle = robj.getInterface("SANcreateAuditLogHandle");
        _i = robj.getInterface("SANsetAuditLogDetail");
        iwritelog = robj.getInterface("SANwriteAuditLog");
        iclosehandle = robj.getInterface("SANcloseAuditLogHandle");
    }

    @Override
    public void run() {
        try {
            this.writeAuditLogInfo();
        }
        catch (SanDataException | SanRmiException throwable) {
            logger.warning(SanLogger.getStackTrace((Throwable)throwable));
        }
    }

    protected void writeAuditLogInfo() throws SanDataException, SanRmiException {
        logger.info("auditlog start");
        this.param = new StringBuilder(1024);
        SanResponse sanResponse = robj.privateinvoke(icreatehandle, this.data, icreatehandle.getRequest().clone());
        this.audithandle = sanResponse.getLong("AuditLogHandle");
        logger.info("create requestdata");
        this.createAuditLogData((SanObject)this.requestData, this.auditLogData);
        logger.info("create responsedata");
        this.createAuditLogData((SanObject)this.responseData, this.auditLogData);
        logger.info("set auditlog");
        this.writeAuditLogData(this.auditLogData);
        SanRequest sanRequest = iwritelog.getRequest().clone();
        sanRequest.putString("FunctionName", this.funcname);
        sanRequest.putString("OperationName", this.operation);
        sanRequest.putLong("AuditLogHandle", this.audithandle);
        sanRequest.putString("Result", this.result);
        logger.info("write auditlog");
        SanResponse sanResponse2 = robj.privateinvoke(iwritelog, this.data, sanRequest);
        if (sanResponse2.getObj("ErrorInfo").getInt("ErrorCode") == 0) {
            logger.info("close auditlog handle");
            SanRequest sanRequest2 = iclosehandle.getRequest().clone();
            sanRequest2.putLong("AuditLogHandle", this.audithandle);
            robj.privateinvoke(iclosehandle, this.data, sanRequest2);
        }
        logger.info("auditlog end");
    }

    private void writeAuditLogData(SanData sanData) throws SanRmiException {
        try {
            this.param.append("{");
            boolean bl = true;
            boolean bl2 = true;
            for (SanClass sanClass : sanData.memberClassList()) {
                Object object;
                Object object2;
                if (sanClass.type().equals("Object")) {
                    object2 = sanData.getObj(sanClass.key());
                    if (object2 != null) {
                        if (object2.key().equals("ErrorInfo")) {
                            bl = false;
                            this.topErrInfo((SanObject)object2);
                            continue;
                        }
                        bl = true;
                        if (sanData != null && !bl2) {
                            this.checkParamSize();
                            this.param.append(",");
                        }
                        object = (String)object2.attrs().get("displayname");
                        this.checkParamSize();
                        if (object == null) {
                            this.param.append(String.format("%s{", object2.key()));
                        } else {
                            this.param.append(String.format("%s{", object));
                        }
                        this.writeAuditLogObjValue((SanObject)object2);
                        bl2 = false;
                        continue;
                    }
                    bl = true;
                    if (!bl2) {
                        this.checkParamSize();
                        this.param.append(",");
                    }
                    if ((object = (String)sanClass.attrs().get("displayname")) == null) {
                        this.param.append(String.format("%s{", sanClass.key()));
                    } else {
                        this.param.append(String.format("%s{", object));
                    }
                    this.checkParamSize();
                    this.writeKeyName(sanClass);
                    bl2 = false;
                    continue;
                }
                if (sanClass.type().equals("List")) {
                    bl = true;
                    object2 = sanData.getList(sanClass.key());
                    this.checkParamSize();
                    if (object2 != null) {
                        if (!bl2) {
                            this.checkParamSize();
                            this.param.append(",");
                        }
                        this.writeAuditLogListValue((SanList)object2);
                        bl2 = false;
                        continue;
                    }
                    if (!bl2) {
                        this.checkParamSize();
                        this.param.append(",");
                    }
                    if ((object = (String)sanClass.attrs().get("displayname")) == null) {
                        this.param.append(String.format("%s[]{", sanClass.key()));
                    } else {
                        this.param.append(String.format("%s[]{", object));
                    }
                    this.checkParamSize();
                    this.writeKeyName(sanClass);
                    bl2 = false;
                    continue;
                }
                bl = true;
                object2 = sanClass.key();
                if (!bl2) {
                    this.checkParamSize();
                    this.param.append(",");
                }
                object = sanData.getMember((String)object2);
                String string = sanData.getMemberToString((String)object2);
                this.valueType(sanClass, (String)object2, object, string);
                bl2 = false;
            }
            this.checkParamSize();
            this.param.append("}");
            if (!bl) {
                this.param.setLength(0);
            }
            if (this.param.length() > 0) {
                this.checkParamSize();
                if (this.param.length() > 0) {
                    this.parameter = String.format("%s", this.param);
                    this.param.setLength(0);
                    this.writeAuditLog();
                }
            }
        }
        catch (SanDataException sanDataException) {
            logger.warning(SanLogger.getStackTrace((Throwable)sanDataException));
        }
    }

    private void writeKeyName(SanClass sanClass) throws SanDataException, SanRmiException {
        boolean bl = true;
        for (SanClass sanClass2 : sanClass.memberClassList()) {
            String string;
            if (sanClass2.type().equals("Object")) {
                if (sanClass2.key().equals("ErrorInfo")) {
                    if (!bl) {
                        this.checkParamSize();
                        this.param.append(",");
                    }
                    this.param.append("Result=null");
                    bl = false;
                    continue;
                }
                if (!bl) {
                    this.checkParamSize();
                    this.param.append(",");
                }
                string = (String)sanClass2.attrs().get("displayname");
                this.checkParamSize();
                if (string == null) {
                    this.param.append(String.format("%s{", sanClass2.key()));
                } else {
                    this.param.append(String.format("%s{", string));
                }
                this.writeKeyName(sanClass2);
                bl = false;
                continue;
            }
            if (sanClass2.type().equals("List")) {
                if (!bl) {
                    this.checkParamSize();
                    this.param.append(",");
                }
                if ((string = (String)sanClass2.attrs().get("displayname")) == null) {
                    this.param.append(String.format("%s[]{", sanClass2.key()));
                } else {
                    this.param.append(String.format("%s[]{", string));
                }
                this.writeKeyName(sanClass2);
                bl = false;
                continue;
            }
            if (sanClass2.key().equals("ErrorCode") || sanClass2.key().equals("MessageId")) continue;
            if (!bl) {
                this.checkParamSize();
                this.param.append(",");
            }
            this.valueType(sanClass2, sanClass2.key(), null, null);
            bl = false;
        }
        this.checkParamSize();
        this.param.append("}");
    }

    private void topErrInfo(SanObject sanObject) throws SanDataException, SanRmiException {
        int n = sanObject.getInt("ErrorCode");
        if (n != 0) {
            this.messageId = sanObject.getIntArray("MessageId");
            this.result = "Error(" + String.format("%05d", this.messageId[0]) + "-" + String.format("%06d", this.messageId[1]) + ")";
        } else if (n == 0) {
            this.result = "Normal end";
        }
    }

    private void valueType(SanClass sanClass, String string, Object object, String object2) throws SanDataException, SanRmiException {
        String string2 = (String)sanClass.attrs().get("displayname");
        if (string2 != null) {
            string = string2;
        }
        this.checkParamSize();
        if (object == null) {
            this.param.append(String.format("%s=%s", string, null));
        } else if (sanClass.type().equals("int")) {
            Object object3;
            String string3 = (String)sanClass.attrs().get("displayformat");
            int n = (Integer)object;
            if (string3 != null) {
                if (string3.equals("%[Port]")) {
                    object3 = new String();
                    int n2 = this.data.getObj("StorageInfo").getInt("Model");
                    if (n2 == 8320) {
                        object3 = portlocation_s[n];
                    } else if (n2 == 8340) {
                        object3 = portlocation_m[n];
                    } else if (n2 == 8360) {
                        object3 = portlocation_h[n];
                    }
                    object2 = object3;
                } else {
                    object2 = String.format(string3, n);
                }
            }
            object3 = (int[])sanClass.attrs().get("values");
            String[] stringArray = (String[])sanClass.attrs().get("meanings_of_values");
            if (object3 != null && stringArray != null) {
                object2 = SanDataUtility.convertToMeaning((int)n, (int[])object3, (String[])stringArray);
            }
            this.param.append(String.format("%s=%s", string, object2));
        } else if (sanClass.type().equals("long")) {
            String string4 = (String)sanClass.attrs().get("displayformat");
            long l = (Long)object;
            if (string4 != null) {
                object2 = String.format(string4, l);
            }
            this.param.append(String.format("%s=%s", string, object2));
        } else if (sanClass.type().equals("float")) {
            String string5 = (String)sanClass.attrs().get("displayformat");
            float f = ((Float)object).floatValue();
            if (string5 != null) {
                object2 = String.format(string5, Float.valueOf(f));
            }
            this.param.append(String.format("%s=%s", string, object2));
        } else if (sanClass.type().equals("double")) {
            String string6 = (String)sanClass.attrs().get("displayformat");
            double d = (Double)object;
            if (string6 != null) {
                object2 = String.format(string6, d);
            }
            this.param.append(String.format("%s=%s", string, object2));
        } else if (sanClass.type().equals("String")) {
            String string7 = (String)sanClass.attrs().get("displayformat");
            String string8 = (String)object;
            if (string7 != null) {
                object2 = String.format(string7, string8);
            }
            this.param.append(String.format("%s=\"%s\"", string, object2));
        } else if (sanClass.type().equals("int[]")) {
            int n = (Integer)sanClass.attrs().get("length");
            int[] nArray = new int[n];
            Object[] objectArray = new Object[n];
            nArray = (int[])object;
            for (int i = 0; i < n; ++i) {
                objectArray[i] = nArray[i];
            }
            String string9 = (String)sanClass.attrs().get("displayformat");
            if (string9 != null) {
                object2 = String.format(string9, objectArray);
            }
            this.param.append(String.format("%s=%s", string, object2));
        } else if (sanClass.type().equals("byte[]")) {
            this.param.append(String.format("%s=\"%s\"", string, object2));
        } else if (sanClass.type().equals("boolean") || sanClass.type().equals("BitSet") || sanClass.type().equals("Data")) {
            this.param.append(String.format("%s=%s", string, object2));
        }
    }

    protected void writeAuditLogObjValue(SanObject sanObject) throws SanDataException, SanRmiException {
        boolean bl = true;
        for (SanClass sanClass : sanObject.memberClassList()) {
            String string;
            Object object;
            if (sanClass.type().equals("Object")) {
                object = sanObject.getObj(sanClass.key());
                if (object != null) {
                    if (object.key().equals("ErrorInfo")) {
                        if (!bl) {
                            this.checkParamSize();
                            this.param.append(",");
                        }
                        this.checkResult((SanObject)object);
                        bl = false;
                        continue;
                    }
                    if (sanObject != null && !bl) {
                        this.checkParamSize();
                        this.param.append(",");
                    }
                    string = (String)object.attrs().get("displayname");
                    this.checkParamSize();
                    if (string == null) {
                        this.param.append(String.format("%s{", object.key()));
                    } else {
                        this.param.append(String.format("%s{", string));
                    }
                    this.writeAuditLogObjValue((SanObject)object);
                    bl = false;
                    continue;
                }
                if (!bl) {
                    this.checkParamSize();
                    this.param.append(",");
                }
                if (sanClass.key().equals("ErrorInfo")) {
                    this.checkParamSize();
                    this.param.append("Result=null");
                    bl = false;
                    continue;
                }
                string = (String)sanClass.attrs().get("displayname");
                this.checkParamSize();
                if (string == null) {
                    this.param.append(String.format("%s{", sanClass.key()));
                } else {
                    this.param.append(String.format("%s{", string));
                }
                this.checkParamSize();
                this.writeKeyName(sanClass);
                bl = false;
                continue;
            }
            if (sanClass.type().equals("List")) {
                object = sanObject.getList(sanClass.key());
                if (object != null) {
                    if (!bl) {
                        this.checkParamSize();
                        this.param.append(",");
                    }
                    this.writeAuditLogListValue((SanList)object);
                    bl = false;
                    continue;
                }
                if (!bl) {
                    this.checkParamSize();
                    this.param.append(",");
                }
                this.checkParamSize();
                string = (String)sanClass.attrs().get("displayname");
                if (string == null) {
                    this.param.append(String.format("%s[]{", sanClass.key()));
                } else {
                    this.param.append(String.format("%s[]{", string));
                }
                this.checkParamSize();
                this.writeKeyName(sanClass);
                bl = false;
                continue;
            }
            if (!bl) {
                this.checkParamSize();
                this.param.append(",");
            }
            object = sanObject.getMember(sanClass.key());
            string = sanObject.getMemberToString(sanClass.key());
            this.valueType(sanClass, sanClass.key(), object, string);
            bl = false;
        }
        this.checkParamSize();
        this.param.append(String.format("}", new Object[0]));
    }

    private void checkResult(SanObject sanObject) throws SanDataException, SanRmiException {
        this.checkParamSize();
        String string = new String();
        if (sanObject.getMember("ErrorCode") != null) {
            int n = sanObject.getInt("ErrorCode");
            if (n != 0) {
                this.messageId = sanObject.getIntArray("MessageId");
                string = "Result=Error(" + String.format("%05d", this.messageId[0]) + "-" + String.format("%06d", this.messageId[1]) + ")";
            } else if (n == 0) {
                string = "Result=Normal end";
            }
            this.param.append(string);
        } else {
            this.param.append(string);
        }
    }

    protected void writeAuditLogListValue(SanList sanList) throws SanDataException, SanRmiException {
        boolean bl = true;
        for (int i = 0; i < sanList.size(); ++i) {
            SanObject sanObject = sanList.getObj(i);
            if (sanObject == null) continue;
            if (!bl) {
                this.checkParamSize();
                this.param.append(",");
            }
            String string = (String)sanList.attrs().get("displayname");
            this.checkParamSize();
            if (string == null) {
                this.param.append(String.format("%s[%d]{", sanList.key(), i));
            } else {
                this.param.append(String.format("%s[%d]{", string, i));
            }
            this.writeElementObjValue(sanObject);
            bl = false;
            this.checkParamSize();
            this.param.append("}");
        }
        if (sanList.size() == 0) {
            String string = (String)sanList.attrs().get("displayname");
            this.checkParamSize();
            if (string == null) {
                this.param.append(String.format("%s[]{", sanList.key()));
            } else {
                this.param.append(String.format("%s[]{", string));
            }
            this.writeKeyName((SanClass)sanList);
            bl = false;
        }
    }

    protected void writeElementObjValue(SanObject sanObject) throws SanDataException, SanRmiException {
        boolean bl = true;
        for (SanClass sanClass : sanObject.memberClassList()) {
            String string;
            Object object;
            if (sanClass.type().equals("Object")) {
                object = sanObject.getObj(sanClass.key());
                if (object != null) {
                    if (sanClass.key().equals("ErrorInfo")) {
                        if (!bl) {
                            this.checkParamSize();
                            this.param.append(",");
                        }
                        this.checkResult((SanObject)object);
                        bl = false;
                        continue;
                    }
                    if (!bl) {
                        this.checkParamSize();
                        this.param.append(",");
                    }
                    string = (String)object.attrs().get("displayname");
                    this.checkParamSize();
                    if (string == null) {
                        this.param.append(String.format("%s{", object.key()));
                    } else {
                        this.param.append(String.format("%s{", string));
                    }
                    if (object == null) continue;
                    this.writeAuditLogObjValue((SanObject)object);
                    bl = false;
                    continue;
                }
                if (!bl) {
                    this.checkParamSize();
                    this.param.append(",");
                }
                if (sanClass.key().equals("ErrorInfo")) {
                    this.checkParamSize();
                    this.param.append("Result=null");
                    bl = false;
                    continue;
                }
                string = (String)sanClass.attrs().get("displayname");
                if (string == null) {
                    this.param.append(String.format("%s{", sanClass.key()));
                } else {
                    this.param.append(String.format("%s{", string));
                }
                this.writeKeyName(sanClass);
                bl = false;
                continue;
            }
            if (sanClass.type().equals("List")) {
                object = sanObject.getList(sanClass.key());
                if (object != null) {
                    if (!bl) {
                        this.checkParamSize();
                        this.param.append(",");
                    }
                    this.writeAuditLogListValue((SanList)object);
                    bl = false;
                    continue;
                }
                if (!bl) {
                    this.checkParamSize();
                    this.param.append(",");
                }
                if ((string = (String)sanClass.attrs().get("displayname")) == null) {
                    this.param.append(String.format("%s[]{", sanClass.key()));
                } else {
                    this.param.append(String.format("%s[]{", string));
                }
                this.writeKeyName(sanClass);
                bl = false;
                continue;
            }
            if (!bl) {
                this.checkParamSize();
                this.param.append(",");
            }
            object = sanObject.getMember(sanClass.key());
            string = sanObject.getMemberToString(sanClass.key());
            this.valueType(sanClass, sanClass.key(), object, string);
            bl = false;
        }
    }

    protected void checkParamSize() throws SanDataException, SanRmiException {
        if (this.param.length() >= 511) {
            this.parameter = String.format("%.511s", this.param);
            this.param.delete(0, 511);
            this.writeAuditLog();
        }
    }

    private void writeAuditLog() throws SanDataException, SanRmiException {
        SanRequest sanRequest = _i.getRequest().clone();
        sanRequest.putLong("AuditLogHandle", this.audithandle);
        sanRequest.putString("Parameter", this.parameter);
        sanRequest.putBoolean("FirstFlg", this.flg);
        this.flg = false;
        robj.privateinvoke(_i, this.data, sanRequest);
    }

    private void createAuditLogData(SanObject sanObject, SanData sanData) throws SanDataException, SanRmiException {
        for (SanClass sanClass : sanObject.memberClassList()) {
            for (SanClass sanClass2 : sanData.memberClassList()) {
                SanObject sanObject2;
                SanObject sanObject3;
                if (sanClass2.type().equals("Object")) {
                    if (!sanClass.key().equals(sanClass2.key()) || (sanObject3 = sanObject.getObj(sanClass.key())) == null) continue;
                    sanObject2 = sanData.getObj(sanClass2.key());
                    if (sanObject2 == null) {
                        sanObject2 = sanData.newObj(sanClass2.key());
                    }
                    this.createObjValue(sanObject3, sanObject2);
                    continue;
                }
                if (sanClass2.type().equals("List")) {
                    if (!sanClass.key().equals(sanClass2.key()) || (sanObject3 = sanObject.getList(sanClass.key())) == null) continue;
                    sanObject2 = sanData.getList(sanClass2.key());
                    if (sanObject2 == null) {
                        sanObject2 = sanData.newList(sanClass2.key());
                    }
                    this.createListValue((SanList)sanObject3, (SanList)sanObject2);
                    continue;
                }
                if (!sanClass.key().equals(sanClass2.key())) continue;
                this.createValue(sanClass2, sanObject, (SanObject)sanData);
            }
        }
    }

    private void createValue(SanClass sanClass, SanObject sanObject, SanObject sanObject2) throws SanDataException {
        if (sanObject.getMember(sanClass.key()) != null) {
            if (sanClass.type().equals("int")) {
                sanObject2.putInt(sanClass.key(), sanObject.getInt(sanClass.key()));
            } else if (sanClass.type().equals("long")) {
                sanObject2.putLong(sanClass.key(), sanObject.getLong(sanClass.key()));
            } else if (sanClass.type().equals("float")) {
                sanObject2.putFloat(sanClass.key(), sanObject.getFloat(sanClass.key()));
            } else if (sanClass.type().equals("double")) {
                sanObject2.putDouble(sanClass.key(), sanObject.getDouble(sanClass.key()));
            } else if (sanClass.type().equals("boolean")) {
                sanObject2.putBoolean(sanClass.key(), sanObject.getBoolean(sanClass.key()));
            } else if (sanClass.type().equals("String")) {
                sanObject2.putString(sanClass.key(), sanObject.getString(sanClass.key()));
            } else if (sanClass.type().equals("BitSet")) {
                sanObject2.putBitSet(sanClass.key(), sanObject.getBitSet(sanClass.key()));
            } else if (sanClass.type().equals("int[]")) {
                sanObject2.putIntArray(sanClass.key(), sanObject.getIntArray(sanClass.key()));
            } else if (sanClass.type().equals("byte[]")) {
                sanObject2.putByteArray(sanClass.key(), sanObject.getByteArray(sanClass.key()));
            }
        }
    }

    protected void createObjValue(SanObject sanObject, SanObject sanObject2) throws SanDataException, SanRmiException {
        for (SanClass sanClass : sanObject.memberClassList()) {
            for (SanClass sanClass2 : sanObject2.memberClassList()) {
                SanObject sanObject3;
                SanObject sanObject4;
                if (sanClass.type().equals("Object")) {
                    if (!sanClass.key().equals(sanClass2.key()) || (sanObject4 = sanObject.getObj(sanClass.key())) == null) continue;
                    sanObject3 = sanObject2.getObj(sanClass2.key());
                    if (sanObject3 == null) {
                        sanObject3 = sanObject2.newObj(sanClass2.key());
                    }
                    this.createObjValue(sanObject4, sanObject3);
                    continue;
                }
                if (sanClass.type().equals("List")) {
                    if (!sanClass.key().equals(sanClass2.key()) || (sanObject4 = sanObject.getList(sanClass.key())) == null) continue;
                    sanObject3 = sanObject2.getList(sanClass2.key());
                    if (sanObject3 == null) {
                        sanObject3 = sanObject2.newList(sanClass2.key());
                    }
                    this.createListValue((SanList)sanObject4, (SanList)sanObject3);
                    continue;
                }
                if (!sanClass.key().equals(sanClass2.key())) continue;
                this.createValue(sanClass, sanObject, sanObject2);
            }
        }
    }

    protected void createListValue(SanList sanList, SanList sanList2) throws SanDataException, SanRmiException {
        for (int i = 0; i < sanList.size(); ++i) {
            SanObject sanObject = sanList.getObj(i);
            SanObject sanObject2 = null;
            if (sanList2.size() == 0) {
                sanObject2 = sanList2.addObj(i);
            }
            if (sanList2.size() != 0 && sanList2.size() > i) {
                sanObject2 = sanList2.getObj(i);
            }
            if (sanObject2 == null) {
                sanObject2 = sanList2.addObj(i);
            }
            if (sanObject == null || sanObject2 == null) continue;
            this.createElementObjValue(sanObject, sanObject2);
        }
    }

    protected void createElementObjValue(SanObject sanObject, SanObject sanObject2) throws SanDataException, SanRmiException {
        for (SanClass sanClass : sanObject.memberClassList()) {
            for (SanClass sanClass2 : sanObject2.memberClassList()) {
                SanObject sanObject3;
                SanObject sanObject4;
                if (sanClass.type().equals("Object")) {
                    if (!sanClass.key().equals(sanClass2.key()) || (sanObject4 = sanObject.getObj(sanClass.key())) == null) continue;
                    sanObject3 = sanObject2.getObj(sanClass2.key());
                    if (sanObject3 == null) {
                        sanObject3 = sanObject2.newObj(sanClass2.key());
                    }
                    this.createObjValue(sanObject4, sanObject3);
                    continue;
                }
                if (sanClass.type().equals("List")) {
                    if (!sanClass.key().equals(sanClass2.key()) || (sanObject4 = sanObject.getList(sanClass.key())) == null) continue;
                    sanObject3 = sanObject2.getList(sanClass2.key());
                    if (sanObject3 == null) {
                        sanObject3 = sanObject2.newList(sanClass2.key());
                    }
                    this.createListValue((SanList)sanObject4, (SanList)sanObject3);
                    continue;
                }
                if (!sanClass.key().equals(sanClass2.key())) continue;
                this.createValue(sanClass, sanObject, sanObject2);
            }
        }
    }

    static {
        portlocation_s = new String[]{"1A", "3A", "5A", "7A", "1B", "3B", "5B", "7B", "2A", "4A", "6A", "8A", "2B", "4B", "6B", "8B"};
        portlocation_m = new String[]{"1A", "3A", "5A", "7A", "1B", "3B", "5B", "7B", "1C", "3C", "5C", "7C", "1D", "3D", "5D", "7D", "1E", "3E", "5E", "7E", "1F", "3F", "5F", "7F", "1G", "3G", "5G", "7G", "1H", "3H", "5H", "7H", "2A", "4A", "6A", "8A", "2B", "4B", "6B", "8B", "2C", "4C", "6C", "8C", "2D", "4D", "6D", "8D", "2E", "4E", "6E", "8E", "2F", "4F", "6F", "8F", "2G", "4G", "6G", "8G", "2H", "4H", "6H", "8H"};
        portlocation_h = new String[]{"1A", "3A", "5A", "7A", "1B", "3B", "5B", "7B", "1C", "3C", "5C", "7C", "1D", "3D", "5D", "7D", "1E", "3E", "5E", "7E", "1F", "3F", "5F", "7F", "1G", "3G", "5G", "7G", "1H", "3H", "5H", "7H", "1J", "3J", "5J", "7J", "1K", "3K", "5K", "7K", "1L", "3L", "5L", "7L", "1M", "3M", "5M", "7M", "1N", "3N", "5N", "7N", "1P", "3P", "5P", "7P", "1Q", "3Q", "5Q", "7Q", "1R", "3R", "5R", "7R", "2A", "4A", "6A", "8A", "2B", "4B", "6B", "8B", "2C", "4C", "6C", "8C", "2D", "4D", "6D", "8D", "2E", "4E", "6E", "8E", "2F", "4F", "6F", "8F", "2G", "4G", "6G", "8G", "2H", "4H", "6H", "8H", "2J", "4J", "6J", "8J", "2K", "4K", "6K", "8K", "2L", "4L", "6L", "8L", "2M", "4M", "6M", "8M", "2N", "4N", "6N", "8N", "2P", "4P", "6P", "8P", "2Q", "4Q", "6Q", "8Q", "2R", "4R", "6R", "8R"};
    }
}

