/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.data;

import com.klg.jclass.chart.ChartDataManageable;
import com.klg.jclass.chart.ChartDataManager;
import com.klg.jclass.chart.ChartDataSupport;
import com.klg.jclass.chart.EditableChartDataModel;
import com.klg.jclass.chart.HoleValueChartDataModel;
import com.klg.jclass.chart.LabelledChartDataModel;
import com.klg.jclass.chart.data.ChartDataSourceUtil;
import java.io.Serializable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class JCChartSwingDataSource
extends ChartDataSupport
implements EditableChartDataModel,
LabelledChartDataModel,
HoleValueChartDataModel,
TableModelListener,
ChartDataManageable,
Serializable {
    protected TableModel tableModel = null;
    protected String[] pLabels = null;
    protected String dsName = "Legend";

    public JCChartSwingDataSource() {
    }

    public JCChartSwingDataSource(TableModel tableModel) {
        this.tableModel = tableModel;
        this.tableModel.addTableModelListener(this);
    }

    public JCChartSwingDataSource(TableModel tableModel, String[] stringArray, String string) {
        this.tableModel = tableModel;
        this.tableModel.addTableModelListener(this);
        this.pLabels = stringArray;
        this.dsName = string;
    }

    public ChartDataManager getChartDataManager() {
        return this;
    }

    public String getDataSourceName() {
        return this.dsName;
    }

    public double getHoleValue() {
        return Double.MAX_VALUE;
    }

    public int getNumSeries() {
        if (this.tableModel == null) {
            return 0;
        }
        return this.tableModel.getColumnCount();
    }

    public String[] getPointLabels() {
        return this.pLabels;
    }

    public String[] getSeriesLabels() {
        if (this.tableModel == null) {
            return null;
        }
        int n = this.tableModel.getColumnCount();
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = this.tableModel.getColumnName(n2);
            if (string.trim().length() == 0) {
                stringArray[n2] = null;
            }
            stringArray[n2] = string;
            ++n2;
        }
        return stringArray;
    }

    public double[] getXSeries(int n) {
        if (this.tableModel == null) {
            return null;
        }
        int n2 = this.tableModel.getRowCount();
        return ChartDataSourceUtil.generateSingleXSeries(n2)[0];
    }

    public double[] getYSeries(int n) {
        if (this.tableModel == null) {
            return null;
        }
        int n2 = this.tableModel.getRowCount();
        if (n2 == 0) {
            return null;
        }
        double[] dArray = new double[n2];
        int n3 = 0;
        while (n3 < n2) {
            Object object = this.tableModel.getValueAt(n3, n);
            if (object == null) {
                dArray[n3] = this.getHoleValue();
            } else if (object instanceof Number) {
                dArray[n3] = ((Number)object).doubleValue();
            } else {
                try {
                    dArray[n3] = object instanceof String ? Double.parseDouble((String)object) : Double.parseDouble(object.toString());
                }
                catch (Exception exception) {
                    dArray[n3] = 0.0;
                }
            }
            ++n3;
        }
        return dArray;
    }

    public synchronized boolean setDataItem(int n, int n2, double d) {
        if (this.tableModel == null || n < 0) {
            return false;
        }
        this.tableModel.setValueAt(new Double(d), n2, n);
        return true;
    }

    public void setDataSourceName(String string) {
        this.dsName = string;
    }

    public void setPointLabels(String[] stringArray) {
        this.pLabels = stringArray;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getFirstRow();
        if (n == -1) {
            this.fireChartDataEvent(12, 0, 0);
            return;
        }
        int n2 = tableModelEvent.getType();
        int n3 = tableModelEvent.getColumn();
        boolean bl = false;
        int n4 = 0;
        if (tableModelEvent.getLastRow() == Integer.MAX_VALUE) {
            bl = true;
        } else {
            n4 = tableModelEvent.getLastRow() - n + 1;
        }
        if (n2 == 0) {
            if (n3 == -1) {
                this.fireChartDataEvent(12, 0, 0);
            } else if (bl) {
                this.fireChartDataEvent(1, n3, 0);
            } else {
                this.fireChartDataEvent(1, n3, 0);
            }
        } else if (n2 == 1) {
            this.fireChartDataEvent(12, 0, 0);
        } else if (n2 == -1) {
            this.fireChartDataEvent(12, 0, 0);
        }
    }
}

