/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.data;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import sanproject.client.exdevice.data.AbstractDataControl;
import sanproject.client.exdevice.data.EXDException;
import sanproject.client.exdevice.data.PathGroupInfo;
import sanproject.client.exdevice.data.ProductInfo;
import sanproject.client.exdevice.data.ProductManager;
import sanproject.client.exdevice.data.Singleton;
import sanproject.client.exdevice.data.SingletonManager;
import sanproject.client.exdevice.data.Utility;
import sanproject.client.exdevice.data.VpgInfo;
import sanproject.client.exdevice.data.VpgManager;
import sanproject.serverux.dataimpl.EXDPathGroup;

public class PathGroupManager
implements Singleton {
    private static final String LOG_NAME = "PathGroupManager";
    private ArrayList mPathGroups = new ArrayList();
    private int mInsertIndex = 0;
    static Comparator mPathGroupIdComparator = new PathGroupIdComparator();
    static /* synthetic */ Class class$sanproject$client$exdevice$data$PathGroupManager;

    PathGroupManager() {
    }

    public static PathGroupManager getInstance() {
        return (PathGroupManager)SingletonManager.getInstance(class$sanproject$client$exdevice$data$PathGroupManager == null ? (class$sanproject$client$exdevice$data$PathGroupManager = PathGroupManager.class$("sanproject.client.exdevice.data.PathGroupManager")) : class$sanproject$client$exdevice$data$PathGroupManager);
    }

    public void destroy() {
    }

    void initialize(EXDPathGroup[] eXDPathGroupArray) {
        Utility.putLog(LOG_NAME, "initialize");
        int n = eXDPathGroupArray.length;
        this.mPathGroups = new ArrayList(n);
        this.mInsertIndex = 0;
        for (int i = 0; i < n; ++i) {
            EXDPathGroup eXDPathGroup = eXDPathGroupArray[i];
            if (eXDPathGroup == null) continue;
            PathGroupInfo pathGroupInfo = new PathGroupInfo(eXDPathGroup);
            pathGroupInfo.setConfiguard(true);
            this.mPathGroups.add(pathGroupInfo);
        }
        Collections.sort(this.mPathGroups, mPathGroupIdComparator);
    }

    void update(EXDPathGroup[] eXDPathGroupArray) throws EXDException {
        int n;
        BitSet bitSet = new BitSet(this.mPathGroups.size());
        for (n = 0; n < eXDPathGroupArray.length; ++n) {
            Comparable<StringBuffer> comparable;
            EXDPathGroup eXDPathGroup = eXDPathGroupArray[n];
            if (eXDPathGroup == null) continue;
            int n2 = Collections.binarySearch(this.mPathGroups, eXDPathGroup, mPathGroupIdComparator);
            if (n2 >= 0) {
                bitSet.set(n2);
                comparable = (PathGroupInfo)this.mPathGroups.get(n2);
                if (((PathGroupInfo)comparable).isConfiguard()) continue;
                ((PathGroupInfo)comparable).setEXDPathGroup(eXDPathGroup);
                ((PathGroupInfo)comparable).setConfiguard(true);
                continue;
            }
            comparable = new StringBuffer("Increase Data ->");
            ((StringBuffer)comparable).append(" Path Group ").append(eXDPathGroup.getPathGroupID());
            Utility.putLog(LOG_NAME, ((StringBuffer)comparable).toString());
            throw new EXDException(AbstractDataControl.ERP_CLIENT, 69041);
        }
        n = this.mPathGroups.size();
        int n3 = bitSet.nextClearBit(0);
        while (n3 < n) {
            PathGroupInfo pathGroupInfo = (PathGroupInfo)this.mPathGroups.get(n3);
            if (!pathGroupInfo.isConfiguard() && !this.hasConfiguardVpg(pathGroupInfo)) {
                bitSet.set(n3);
            }
            n3 = bitSet.nextClearBit(n3 + 1);
        }
        if (bitSet.cardinality() != this.mPathGroups.size()) {
            StringBuffer stringBuffer = new StringBuffer("Decrease Data -> ");
            stringBuffer.append(this.mPathGroups.get(bitSet.nextClearBit(0)));
            Utility.putLog(LOG_NAME, stringBuffer.toString());
            throw new EXDException(AbstractDataControl.ERP_CLIENT, 69041);
        }
    }

    boolean hasConfiguardVpg(PathGroupInfo pathGroupInfo) {
        boolean bl = false;
        VpgManager vpgManager = VpgManager.getInstance();
        Iterator iterator = vpgManager.getVpgInfo(pathGroupInfo).iterator();
        while (iterator.hasNext()) {
            VpgInfo vpgInfo = (VpgInfo)iterator.next();
            if (vpgInfo.getEXDVpg().getId() == 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public PathGroupInfo[] getPathGroupInfo() {
        PathGroupInfo[] pathGroupInfoArray = new PathGroupInfo[]{};
        pathGroupInfoArray = this.mPathGroups.toArray(pathGroupInfoArray);
        return pathGroupInfoArray;
    }

    public PathGroupInfo getPathGroupInfo(int n) {
        Integer n2 = new Integer(n);
        int n3 = Collections.binarySearch(this.mPathGroups, n2, mPathGroupIdComparator);
        PathGroupInfo pathGroupInfo = null;
        if (n3 >= 0) {
            pathGroupInfo = (PathGroupInfo)this.mPathGroups.get(n3);
        }
        return pathGroupInfo;
    }

    public Collection getPathGroupInfoOfProductId(int n) {
        ArrayList<PathGroupInfo> arrayList = new ArrayList<PathGroupInfo>(this.mPathGroups.size());
        ProductInfo productInfo = ProductManager.getInstance().getProductInfo(n);
        Iterator iterator = this.mPathGroups.iterator();
        while (iterator.hasNext()) {
            PathGroupInfo pathGroupInfo = (PathGroupInfo)iterator.next();
            ProductInfo productInfo2 = pathGroupInfo.getProductInfo();
            if (productInfo != productInfo2) continue;
            arrayList.add(pathGroupInfo);
        }
        return arrayList;
    }

    public PathGroupInfo createPathGroup(int n) {
        PathGroupInfo pathGroupInfo;
        while (this.mInsertIndex < this.mPathGroups.size() && this.mInsertIndex >= (pathGroupInfo = (PathGroupInfo)this.mPathGroups.get(this.mInsertIndex)).getId()) {
            ++this.mInsertIndex;
        }
        pathGroupInfo = new EXDPathGroup(this.mInsertIndex, "", n, 0);
        PathGroupInfo pathGroupInfo2 = new PathGroupInfo((EXDPathGroup)pathGroupInfo);
        pathGroupInfo2.getProductInfo();
        this.mPathGroups.add(this.mInsertIndex, pathGroupInfo2);
        return pathGroupInfo2;
    }

    void removePathGroup(PathGroupInfo pathGroupInfo) {
        boolean bl;
        if (pathGroupInfo.isModify()) {
            return;
        }
        Integer n = new Integer(pathGroupInfo.getId());
        int n2 = Collections.binarySearch(this.mPathGroups, n, mPathGroupIdComparator);
        boolean bl2 = bl = 0 <= n2;
        if (bl && !pathGroupInfo.isConfiguard()) {
            this.mPathGroups.remove(n2);
            if (this.mInsertIndex > n2) {
                this.mInsertIndex = n2;
            }
        }
    }

    void deletePathGroup(PathGroupInfo pathGroupInfo) {
        int n;
        ProductInfo productInfo = pathGroupInfo.getProductInfo();
        Collection collection = this.getPathGroupInfoOfProductId(productInfo.getId());
        if (collection.size() == 1 && collection.contains(pathGroupInfo)) {
            ProductManager.getInstance().deleteProductInfo(productInfo);
        }
        if ((n = Collections.binarySearch(this.mPathGroups, pathGroupInfo, mPathGroupIdComparator)) >= 0) {
            this.mPathGroups.remove(n);
            if (this.mInsertIndex > n) {
                this.mInsertIndex = n;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class PathGroupIdComparator
    implements Comparator {
        PathGroupIdComparator() {
        }

        public int compare(Object object, Object object2) {
            int n = this.getPathGroupId(object);
            int n2 = this.getPathGroupId(object2);
            return n - n2;
        }

        private int getPathGroupId(Object object) {
            int n = object instanceof PathGroupInfo ? ((PathGroupInfo)object).getId() : (object instanceof EXDPathGroup ? ((EXDPathGroup)object).getPathGroupID() : ((Integer)object).intValue());
            return n;
        }
    }
}

