/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import sanproject.client.exdevice.data.AbstractDataControl;
import sanproject.client.exdevice.data.EXDException;
import sanproject.client.exdevice.data.FilterManager;
import sanproject.client.exdevice.data.ProductInfo;
import sanproject.client.exdevice.data.Singleton;
import sanproject.client.exdevice.data.SingletonManager;
import sanproject.client.exdevice.data.TargetPortInfo;
import sanproject.client.exdevice.data.TargetPortManager;
import sanproject.client.exdevice.data.Utility;
import sanproject.client.exdevice.data.VpgInfo;
import sanproject.client.exdevice.data.VpgManager;
import sanproject.serverux.dataimpl.EXDSubsystem;

public class ProductManager
implements Singleton {
    private static final String LOG_NAME = "ProductManager";
    private ProductInfo mOwnProduct = null;
    private ArrayList mProducts = new ArrayList();
    static final int ID_OFFSET_UNCONFIGURED = Integer.MIN_VALUE;
    ArrayList mDiscoveryProducts = new ArrayList();
    static Comparator mProductIdComparator = new ProductIdComparator();
    static final Comparator COMP_PRODUCT = new Comparator(){

        public int compare(Object object, Object object2) {
            String string;
            EXDSubsystem eXDSubsystem = this.getObject(object);
            EXDSubsystem eXDSubsystem2 = this.getObject(object2);
            String string2 = eXDSubsystem.getSerialId();
            int n = string2.compareTo(string = eXDSubsystem2.getSerialId());
            if (n == 0) {
                n = eXDSubsystem.referProfileId() - eXDSubsystem2.referProfileId();
            }
            return n;
        }

        private EXDSubsystem getObject(Object object) {
            EXDSubsystem eXDSubsystem;
            if (object instanceof ProductInfo) {
                ProductInfo productInfo = (ProductInfo)object;
                eXDSubsystem = productInfo.getEXDSubsystem();
            } else {
                eXDSubsystem = (EXDSubsystem)object;
            }
            return eXDSubsystem;
        }
    };
    static /* synthetic */ Class class$sanproject$client$exdevice$data$ProductManager;

    ProductManager() {
    }

    public static synchronized ProductManager getInstance() {
        return (ProductManager)SingletonManager.getInstance(class$sanproject$client$exdevice$data$ProductManager == null ? (class$sanproject$client$exdevice$data$ProductManager = ProductManager.class$("sanproject.client.exdevice.data.ProductManager")) : class$sanproject$client$exdevice$data$ProductManager);
    }

    public void destroy() {
    }

    public void initialize(EXDSubsystem[] eXDSubsystemArray) {
        Utility.putLog(LOG_NAME, "initialize");
        this.mDiscoveryProducts.clear();
        int n = eXDSubsystemArray.length;
        this.mProducts = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            EXDSubsystem eXDSubsystem = eXDSubsystemArray[i];
            if (eXDSubsystem == null) continue;
            ProductInfo productInfo = new ProductInfo(eXDSubsystemArray[i]);
            this.addProductInfo(productInfo);
        }
    }

    void update(EXDSubsystem[] eXDSubsystemArray) throws EXDException {
        int n;
        Collections.sort(this.mProducts, COMP_PRODUCT);
        Collections.sort(this.mDiscoveryProducts, COMP_PRODUCT);
        BitSet bitSet = new BitSet(this.mProducts.size());
        boolean bl = false;
        for (n = 0; n < eXDSubsystemArray.length; ++n) {
            Comparable<StringBuffer> comparable;
            EXDSubsystem eXDSubsystem = eXDSubsystemArray[n];
            if (eXDSubsystem == null) continue;
            int n2 = Collections.binarySearch(this.mProducts, eXDSubsystem, COMP_PRODUCT);
            if (n2 >= 0) {
                bitSet.set(n2);
                comparable = (ProductInfo)this.mProducts.get(n2);
                if (((ProductInfo)comparable).getEXDSubsystem().isConfigured()) continue;
                ((ProductInfo)comparable).setEXDSubsystem(eXDSubsystem);
                int n3 = Collections.binarySearch(this.mDiscoveryProducts, eXDSubsystem, COMP_PRODUCT);
                if (n3 < 0) continue;
                this.mDiscoveryProducts.remove(n3);
                continue;
            }
            if (eXDSubsystem.isOwnSubsystem()) {
                bl = true;
                continue;
            }
            comparable = new StringBuffer("Increase Data ->");
            ((StringBuffer)comparable).append(" Serial:").append(eXDSubsystem.getSerialId());
            ((StringBuffer)comparable).append(" Profile:").append(eXDSubsystem.referProfileId());
            Utility.putLog(LOG_NAME, ((StringBuffer)comparable).toString());
            throw new EXDException(AbstractDataControl.ERP_CLIENT, 69041);
        }
        n = this.mProducts.size();
        int n4 = bitSet.nextClearBit(0);
        while (n4 < n) {
            ProductInfo productInfo = (ProductInfo)this.mProducts.get(n4);
            if (!productInfo.getEXDSubsystem().isConfigured() && !this.hasConfiguardVpg(productInfo)) {
                bitSet.set(n4);
            }
            n4 = bitSet.nextClearBit(n4 + 1);
        }
        if (bitSet.cardinality() != this.mProducts.size()) {
            StringBuffer stringBuffer = new StringBuffer("Decrease Data -> ");
            stringBuffer.append(this.mProducts.get(bitSet.nextClearBit(0)));
            Utility.putLog(LOG_NAME, stringBuffer.toString());
            throw new EXDException(AbstractDataControl.ERP_CLIENT, 69041);
        }
        if (!bl) {
            StringBuffer stringBuffer = new StringBuffer("Decrease Data -> ");
            stringBuffer.append(this.mOwnProduct);
            Utility.putLog(LOG_NAME, stringBuffer.toString());
            throw new EXDException(AbstractDataControl.ERP_CLIENT, 69041);
        }
        Collections.sort(this.mProducts, mProductIdComparator);
        Collections.sort(this.mDiscoveryProducts, mProductIdComparator);
    }

    boolean hasConfiguardVpg(ProductInfo productInfo) {
        boolean bl = false;
        VpgManager vpgManager = VpgManager.getInstance();
        Iterator iterator = vpgManager.getVpgInfo(productInfo).iterator();
        while (iterator.hasNext()) {
            VpgInfo vpgInfo = (VpgInfo)iterator.next();
            if (vpgInfo.getEXDVpg().getId() == 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    void addProductInfo(ProductInfo productInfo) {
        Integer n = new Integer(productInfo.getId());
        if (productInfo.isOwn()) {
            if (this.mOwnProduct == null) {
                this.mOwnProduct = productInfo;
            }
            return;
        }
        int n2 = Collections.binarySearch(this.mProducts, n, mProductIdComparator);
        if (n2 < 0) {
            n2 = -(n2 + 1);
            this.mProducts.add(n2, productInfo);
        }
    }

    public ProductInfo[] getProductInfo() {
        ArrayList<ProductInfo> arrayList = new ArrayList<ProductInfo>(this.mProducts);
        if (FilterManager.doShowOwnDevice() && this.mOwnProduct != null) {
            arrayList.add(this.mOwnProduct);
        }
        Object[] objectArray = new ProductInfo[]{};
        objectArray = arrayList.toArray(objectArray);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public ProductInfo getProductInfo(int n) {
        if (n == 0) {
            return this.mOwnProduct;
        }
        ArrayList arrayList = n >= 0 ? this.mProducts : this.mDiscoveryProducts;
        Integer n2 = new Integer(n);
        int n3 = Collections.binarySearch(arrayList, n2, mProductIdComparator);
        ProductInfo productInfo = null;
        if (n3 >= 0) {
            productInfo = (ProductInfo)arrayList.get(n3);
        }
        return productInfo;
    }

    ProductInfo createDiscoveryProductInfo(EXDSubsystem eXDSubsystem) {
        ProductInfo productInfo = null;
        if (eXDSubsystem.isConfigured()) {
            int n = eXDSubsystem.getId();
            productInfo = this.getProductInfo(n);
        } else {
            int n;
            int n2 = eXDSubsystem.referProfileId();
            String string = eXDSubsystem.getSerialId();
            for (n = 0; n < this.mDiscoveryProducts.size(); ++n) {
                ProductInfo productInfo2 = (ProductInfo)this.mDiscoveryProducts.get(n);
                int n3 = productInfo2.referProfileId();
                String string2 = productInfo2.getSerial();
                if (n2 != n3 || !string.equals(string2)) continue;
                productInfo = productInfo2;
                break;
            }
            if (productInfo == null) {
                n = Integer.MIN_VALUE + this.mDiscoveryProducts.size();
                eXDSubsystem.setId(n);
                productInfo = new ProductInfo(eXDSubsystem);
                this.mDiscoveryProducts.add(productInfo);
            }
        }
        return productInfo;
    }

    void clearDiscoveryInfo() {
        this.mDiscoveryProducts.clear();
    }

    void removeProductInfo(ProductInfo productInfo) {
        Integer n;
        int n2;
        int n3 = productInfo.getId();
        if (n3 < 0 && !productInfo.isModify() && (n2 = Collections.binarySearch(this.mProducts, n = new Integer(n3), mProductIdComparator)) >= 0) {
            this.mProducts.remove(n2);
        }
    }

    void deleteProductInfo(ProductInfo productInfo) {
        int n = Collections.binarySearch(this.mProducts, productInfo, mProductIdComparator);
        if (n >= 0) {
            TargetPortManager targetPortManager = TargetPortManager.getInstance();
            TargetPortInfo[] targetPortInfoArray = targetPortManager.getTargetPortList(productInfo);
            for (int i = 0; i < targetPortInfoArray.length; ++i) {
                targetPortManager.deleteTargetPortInfo(targetPortInfoArray[i]);
            }
            this.mProducts.remove(n);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ProductIdComparator
    implements Comparator {
        ProductIdComparator() {
        }

        public int compare(Object object, Object object2) {
            int n = this.getValue(object);
            int n2 = this.getValue(object2);
            return n - n2;
        }

        private int getValue(Object object) {
            int n = object instanceof ProductInfo ? ((ProductInfo)object).getId() : ((Integer)object).intValue();
            return n;
        }
    }
}

