/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.luoperation;

import java.util.ArrayList;
import sanproject.client.com.RJcElement;
import sanproject.client.com.RJcTableModel;
import sanproject.client.com.abs.RJaTableDataModel;
import sanproject.client.exdevice.com.AbstractElement;
import sanproject.client.exdevice.com.AbstractTableDataModel;
import sanproject.client.exdevice.data.AddVolumeData;
import sanproject.client.exdevice.data.AddVolumeDirector;
import sanproject.client.exdevice.data.EXDException;
import sanproject.client.exdevice.data.PathDirector;
import sanproject.client.exdevice.data.PathGroupInfo;
import sanproject.client.exdevice.data.PolicyInfo;
import sanproject.client.exdevice.data.SsidInfo;
import sanproject.client.exdevice.data.SsidManager;
import sanproject.client.exdevice.event.ElementEvent;
import sanproject.client.exdevice.luoperation.AddLUPolicyElement;
import sanproject.client.exdevice.luoperation.AddVolumeConfigElement;
import sanproject.client.exdevice.luoperation.AddVolumeConfigTableDataModel;
import sanproject.client.exdevice.luoperation.PathGroupElement;
import sanproject.client.exdevice.luoperation.PhysicalPathDirectorElement;
import sanproject.client.exdevice.luoperation.SSIDBoundaryElement;
import sanproject.client.exdevice.luoperation.SSIDBoundaryTableDataModel;
import sanproject.client.exdevice.luoperation.VPGSettingPanel;

public class AddVolumeDirectorElement
extends AbstractElement {
    public static final AbstractElement.DetailType SSIDLIST_DETAILTYPE = new AbstractElement.DetailType("SSID List detail type."){

        public void createChildElements(AbstractElement abstractElement) {
        }
    };
    private PathGroupElement pathGroup;
    private transient AddVolumeDirector volumeDirector;
    private AddLUPolicyElement.TempPolicyElement tempPolicy = null;
    private Integer ssidsSLPR = new Integer(0);
    private boolean isSLPRLimited;
    private boolean isExceptOPENV;

    public AddVolumeDirectorElement(AddLUPolicyElement addLUPolicyElement, PathGroupElement pathGroupElement) throws EXDException {
        PolicyInfo policyInfo = addLUPolicyElement.getPolicyInfo();
        this.volumeDirector = new AddVolumeDirector(policyInfo);
        this.pathGroup = pathGroupElement;
    }

    public boolean hasDisplayLimitation() {
        boolean bl = true;
        return bl;
    }

    public boolean getAllowsChildren() {
        boolean bl = false;
        return bl;
    }

    public void createChildElements(AbstractElement.DetailType detailType) {
        this.fireStateChanged(ElementEvent.CREATE_CHILDELEMENT_STARTED);
        if (SSIDLIST_DETAILTYPE.equals(detailType)) {
            SsidInfo[] ssidInfoArray = this.getSSIDBoundaries();
            if (ssidInfoArray != null) {
                int n = ssidInfoArray.length;
                for (int i = 0; i < n; ++i) {
                    SsidInfo ssidInfo = ssidInfoArray[i];
                    SSIDBoundaryElement sSIDBoundaryElement = new SSIDBoundaryElement(ssidInfo);
                    this.addChildElement(SSIDLIST_DETAILTYPE, sSIDBoundaryElement);
                }
            }
        } else {
            AddVolumeData[] addVolumeDataArray = this.getTargetVolumes();
            if (addVolumeDataArray != null) {
                int n = addVolumeDataArray.length;
                for (int i = 0; i < n; ++i) {
                    AddVolumeData addVolumeData = addVolumeDataArray[i];
                    AddVolumeConfigElement addVolumeConfigElement = new AddVolumeConfigElement(addVolumeData);
                    this.addChildElement(null, addVolumeConfigElement);
                }
            }
        }
        this.fireStateChanged(ElementEvent.CREATE_CHILDELEMENT_ENDED);
    }

    public PhysicalPathDirectorElement getPhysicalPathDirector() throws EXDException {
        PathDirector pathDirector = this.volumeDirector.getPathDirector();
        PhysicalPathDirectorElement physicalPathDirectorElement = new PhysicalPathDirectorElement(pathDirector);
        return physicalPathDirectorElement;
    }

    public boolean canVPGSetting(AddVolumeConfigElement[] addVolumeConfigElementArray) {
        boolean bl = false;
        if (addVolumeConfigElementArray != null) {
            ArrayList<AddVolumeData> arrayList = new ArrayList<AddVolumeData>();
            arrayList.ensureCapacity(addVolumeConfigElementArray.length);
            for (int i = 0; i < addVolumeConfigElementArray.length; ++i) {
                AddVolumeConfigElement addVolumeConfigElement = addVolumeConfigElementArray[i];
                AddVolumeData addVolumeData = addVolumeConfigElement.getConfigData();
                arrayList.add(addVolumeData);
            }
            AddVolumeData[] addVolumeDataArray = new AddVolumeData[]{};
            addVolumeDataArray = arrayList.toArray(addVolumeDataArray);
            bl = this.volumeDirector.canVpgSetting(addVolumeDataArray);
        }
        return bl;
    }

    public boolean canLDEVMapping(AddVolumeConfigElement[] addVolumeConfigElementArray) {
        boolean bl = false;
        if (addVolumeConfigElementArray != null) {
            ArrayList<AddVolumeData> arrayList = new ArrayList<AddVolumeData>();
            arrayList.ensureCapacity(addVolumeConfigElementArray.length);
            for (int i = 0; i < addVolumeConfigElementArray.length; ++i) {
                AddVolumeConfigElement addVolumeConfigElement = addVolumeConfigElementArray[i];
                AddVolumeData addVolumeData = addVolumeConfigElement.getConfigData();
                arrayList.add(addVolumeData);
            }
            AddVolumeData[] addVolumeDataArray = new AddVolumeData[]{};
            addVolumeDataArray = arrayList.toArray(addVolumeDataArray);
            bl = this.volumeDirector.canLdevMapping(addVolumeDataArray);
        }
        return bl;
    }

    public void requestRemoveVolume(AddVolumeConfigElement addVolumeConfigElement) {
        if (addVolumeConfigElement != null) {
            AddVolumeData addVolumeData = addVolumeConfigElement.getConfigData();
            this.volumeDirector.removeExtDev(addVolumeData);
        }
    }

    public void requestTransferException(EXDException eXDException) {
        ElementEvent elementEvent = new ElementEvent((RJcElement)this, eXDException);
        this.fireStateChanged(elementEvent);
    }

    public void executeDiscoveryVolume() throws EXDException {
        PathGroupElement pathGroupElement;
        Comparable comparable;
        if (this.pathGroup == null) {
            comparable = this.getPhysicalPathDirector();
            pathGroupElement = comparable.createPathGroup();
        } else {
            pathGroupElement = this.pathGroup;
        }
        comparable = pathGroupElement.getGroupInfo();
        this.volumeDirector.doDiscoveryVolume((PathGroupInfo)comparable);
    }

    public void checkSettings() throws EXDException {
        if (!this.volumeDirector.chkCompVpgSetting()) {
            EXDException eXDException = new EXDException(610, 69006);
            throw eXDException;
        }
        if (!this.volumeDirector.chkCompLdevMapping()) {
            EXDException eXDException = new EXDException(610, 69006);
            throw eXDException;
        }
        this.volumeDirector.compLdevMapping();
    }

    public void commitSettings() throws EXDException {
        this.volumeDirector.commit();
    }

    public void cancelAllSetting() {
        this.volumeDirector.cancel();
    }

    public RJcTableModel getTableModel(AbstractElement.DetailType detailType) {
        AbstractTableDataModel abstractTableDataModel = SSIDLIST_DETAILTYPE.equals(detailType) ? new SSIDBoundaryTableDataModel(this) : new AddVolumeConfigTableDataModel(this);
        if (abstractTableDataModel != null) {
            ((RJaTableDataModel)abstractTableDataModel).removeAll();
            AbstractElement[] abstractElementArray = this.getChildElements(detailType);
            if (abstractElementArray != null) {
                int n = abstractElementArray.length;
                for (int i = 0; i < n; ++i) {
                    AbstractElement abstractElement = abstractElementArray[i];
                    ((RJcTableModel)abstractTableDataModel).addRow(abstractElement);
                }
            }
        }
        return abstractTableDataModel;
    }

    public AddLUPolicyElement getPolicy() {
        PolicyInfo policyInfo = this.volumeDirector.getPolicyInfo();
        AddLUPolicyElement addLUPolicyElement = new AddLUPolicyElement(policyInfo);
        return addLUPolicyElement;
    }

    public AddLUPolicyElement.TempPolicyElement getTempPolicy() {
        return this.tempPolicy;
    }

    public void setTempPolicy(VPGSettingPanel.SettingValues settingValues) {
        if (this.tempPolicy == null) {
            this.tempPolicy = new AddLUPolicyElement.TempPolicyElement();
        }
        this.tempPolicy.setExg(settingValues.getExG());
        this.tempPolicy.setEmulationType(settingValues.getEmulationType());
        this.tempPolicy.setLDEVCount(settingValues.getLDEVCount());
        this.tempPolicy.setCLPRNumber(settingValues.getCLPR());
        this.tempPolicy.setCacheMode(settingValues.isEnabledCacheMode());
        this.tempPolicy.setInflowControl(settingValues.isEnabledInflowControl());
    }

    public void setSSIDSLPR(Integer n) {
        if (n != null) {
            this.ssidsSLPR = n;
            this.removeChildElements(SSIDLIST_DETAILTYPE);
        }
    }

    public Integer getSSIDSLPR() {
        Integer n = this.ssidsSLPR;
        return n;
    }

    public void setSSIDSLPRLimit(boolean bl) {
        this.isSLPRLimited = bl;
        this.removeChildElements(SSIDLIST_DETAILTYPE);
    }

    public boolean isSLPRLimited() {
        boolean bl = this.isSLPRLimited;
        return bl;
    }

    public boolean isEnableExceptOPENV() {
        boolean bl = this.tempPolicy == null ? this.volumeDirector.getPolicyInfo().isEnableExceptOpenV() : this.isExceptOPENV;
        return bl;
    }

    public void setExceptOPENV(boolean bl) {
        this.isExceptOPENV = bl;
    }

    private AddVolumeData[] getTargetVolumes() {
        AddVolumeData[] addVolumeDataArray = this.volumeDirector.getExtDev();
        return addVolumeDataArray;
    }

    private SsidInfo[] getSSIDBoundaries() {
        SsidInfo[] ssidInfoArray = new SsidInfo[]{};
        int n = this.ssidsSLPR;
        SsidManager ssidManager = SsidManager.getInstance();
        SsidInfo[] ssidInfoArray2 = ssidManager.getSsidInfoList(n, this.isSLPRLimited);
        if (ssidInfoArray2 != null) {
            ssidInfoArray = ssidInfoArray2;
        }
        return ssidInfoArray;
    }
}

