/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.horc;

import java.util.ArrayList;
import sanproject.client.com.RJComUty;
import sanproject.client.data.RJDataRmcp1PairSummary;
import sanproject.client.horc.RJRmcpDataControl;
import sanproject.client.horc.RJRmcpGuide;
import sanproject.client.horc.RJRmcpMacro;
import sanproject.client.horc.RJRmcpPairDataForDisplay;
import sanproject.serverux.dataimpl.RMCPHorcLU;

public class RJHorcPairData
implements RJRmcpMacro {
    public static final int RJRCREF_PSKIND_SIMPLEX = 0;
    public static final int RJRCREF_PSKIND_PRIMARY = 1;
    public static final int RJRCREF_PSKIND_SECONDARY = 2;
    public static final int RJRCREF_SYNCMODE_SIMPLEX = 0;
    public static final int RJRCREF_SYNCMODE_SYNC = 1;
    public static final int RJRCREF_SYNCMODE_ASYNC = 2;
    public static final int RJRCREF_SYNCMODE_PERIODIC = 3;
    public static final int RJRCREF_SYNCMODE_UNKNOWN = 4;
    public static final int RJRCREF_SYNCMODE_OSW = 5;
    public static final int RJRCREF_PAIRSTAT_SIMPLEX = 0;
    public static final int RJRCREF_PAIRSTAT_PENDING = 1;
    public static final int RJRCREF_PAIRSTAT_DUPLEX = 2;
    public static final int RJRCREF_PAIRSTAT_DUPLEX_SFOV = 193;
    public static final int RJRCREF_PAIRSTAT_SUSPEND_POPE = 3;
    public static final int RJRCREF_PAIRSTAT_SUSPEND_SOPE = 4;
    public static final int RJRCREF_PAIRSTAT_SUSPEND_MCU = 5;
    public static final int RJRCREF_PAIRSTAT_SUSPEND_RCU = 6;
    public static final int RJRCREF_PAIRSTAT_SUSPEND_DELR = 7;
    public static final int RJRCREF_PAIRSTAT_SUSPEND_SFLT = 8;
    public static final int RJRCREF_PAIRSTAT_SUSPEND_MIPL = 9;
    public static final int RJRCREF_PAIRSTAT_SUSPEND_FREZ = 10;
    public static final int RJRCREF_PAIRSTAT_SIMPLEX_MIGI = 64;
    public static final int RJRCREF_PAIRSTAT_SIMPLEX_MIGC = 65;
    public static final int RJRCREF_PAIRSTAT_SIMPLEX_ERAI = 66;
    public static final int RJRCREF_PAIRSTAT_SIMPLEX_ERAE = 67;
    public static final int RJRCREF_PAIRSTAT_PENDING_MIGI = 68;
    public static final int RJRCREF_PAIRSTAT_SUSPEND_MIGP = 69;
    public static final int RJRCREF_PAIRSTAT_SUSPEND_MIGS = 70;
    public static final int RJRCREF_PAIRSTAT_SUSPEND_INIE = 80;
    public static final int RJRCREF_PAIRSTAT_SUSPENDING = 96;
    public static final int RJRCREF_PAIRSTAT_DELETING = 97;
    public static final int RJRCREF_PAIRSTAT_SUSPEND_PSOF = 98;
    public static final int RJRCREF_PAIRSTAT_SUSPEND_SFOV = 99;
    public static final int RJRCREF_PAIRSTAT_SUSPEND_TODE = 160;
    public static final int RJRCREF_PAIRSTAT_SUSPEND_CONT = 161;
    public static final int RJRCREF_PAIRSTAT_SUSPEND_COMP = 162;
    public static final int RJRCREF_PAIRSTATSUB_MASK = 204;
    public static final int RJRCREF_PAIRSTATSUB_PDUBSMPL = 128;
    public static final int RJRCREF_PAIRSTATSUB_PDUBPSUE = 64;
    public static final int RJRCREF_PAIRSTATSUB_MIGW_SUS = 8;
    public static final int RJRCREF_PAIRSTATSUB_MIGW_ERA = 4;
    public static final int RJRCREF_PRIORITY_MIN = 1;
    public static final int RJRCREF_PRIORITY_HRC_MIN = 0;
    public static final int RJRCREF_PRIORITY_MAX = 256;
    public static final int RJRCREF_HORCCOPYPACE_MIN = 1;
    public static final int RJRCREF_HORCCOPYPACE_MAX = 15;
    public static final int RJRCREF_OPTIONCFW_COPY = 0;
    public static final int RJRCREF_OPTIONCFW_ONLYPVOL = 1;
    public static final int RJRCREF_OPTIONCFW_UNKNOWN = -1;
    public static final int RJRCREF_OPTIONDFW_NOREQ = 0;
    public static final int RJRCREF_OPTIONDFW_REQ = 1;
    public static final int RJRCREF_OPTIONDFW_UNKNOWN = -1;
    public static final int RJRCREF_FENCE_NEVER = 0;
    public static final int RJRCREF_FENCE_DATA = 1;
    public static final int RJRCREF_FENCE_STATUS = 2;
    public static final int RJRCREF_FENCE_UNKNOWN = -1;
    public static final int RJRCREF_ERRLVL_GRP = 0;
    public static final int RJRCREF_ERRLVL_LU = 1;
    public static final int RJRCREF_ERRLVL_UNKNOWN = -1;
    public static final int RJRCREF_CFW_RVOL = 0;
    public static final int RJRCREF_CFW_MVOL = 1;
    public static final int RJRCREF_CFW_UNKNOWN = -1;
    public static final int RJRCREF_DFW_NOT = 0;
    public static final int RJRCREF_DFW_REQ = 1;
    public static final int RJRCREF_DFW_UNKNOWN = -1;
    public static final int RJRCREF_CTG_MIN = 0;
    public static final int RJRCREF_CTG_MAX = 127;
    public static final int RJRCREF_PAIREXTERNAL_NO = 0;
    public static final int RJRCREF_PAIREXTERNAL_YES = 1;
    public static final int RJRCREF_PAIRHDP_NO = 0;
    public static final int RJRCREF_PAIRHDP_YES = 1;

    public static String convertLUToString(RJRmcpDataControl rJRmcpDataControl, RMCPHorcLU rMCPHorcLU) {
        String string;
        RJRmcpGuide rJRmcpGuide = rJRmcpDataControl.getRmcpGuide();
        String string2 = rJRmcpGuide.getTRCKey();
        if (0 <= rMCPHorcLU.PortNo && rMCPHorcLU.PortNo < 256) {
            string = rJRmcpDataControl.getPortNamefromInternalPortID(rMCPHorcLU.PortNo);
        } else {
            string = RJRmcpGuide.Get4Asterisk.getGuidance();
            System.out.println(string2 + ", Rmcp1PairSummary check port#=" + rMCPHorcLU.PortNo);
        }
        string = string + " - " + RJComUty.itoh(rMCPHorcLU.GroupNo, 2) + " - " + rJRmcpDataControl.getLUNDisplayString(rMCPHorcLU.LUN);
        return string;
    }

    public static String convertLUToString(RJRmcpDataControl rJRmcpDataControl, RMCPHorcLU rMCPHorcLU, String string) {
        String string2;
        RJRmcpGuide rJRmcpGuide = rJRmcpDataControl.getRmcpGuide();
        if (0 <= rMCPHorcLU.PortNo && rMCPHorcLU.PortNo < 256) {
            string2 = rJRmcpDataControl.getPortNamefromInternalPortID(rMCPHorcLU.PortNo);
        } else {
            string2 = RJRmcpGuide.Get4Asterisk.getGuidance();
            String string3 = rJRmcpGuide.getTRCKey();
            System.out.println(string3 + ", Rmcp1PairSummary check port# = " + rMCPHorcLU.PortNo);
        }
        string2 = string2 + " - " + RJComUty.itoh(rMCPHorcLU.GroupNo, 2);
        if (string != null) {
            string2 = string2 + "(";
            string2 = string2 + string;
            string2 = string2 + ")";
        }
        string2 = string2 + " - " + rJRmcpDataControl.getLUNDisplayString(rMCPHorcLU.LUN);
        return string2;
    }

    public static String convertLDEVToString(int n, int n2) {
        String string = RJComUty.itoh(n, 2) + ":" + RJComUty.itoh(n2, 2);
        return string;
    }

    public static String convertLDEVToString(int n, int n2, int n3) {
        String string = RJComUty.itoh(n, 2) + ":" + RJComUty.itoh(n2, 2) + ":" + RJComUty.itoh(n3, 2);
        return string;
    }

    public static String convertLDEVToStringPair(RJDataRmcp1PairSummary rJDataRmcp1PairSummary) {
        String string = RJComUty.getLDEVDisplayName(rJDataRmcp1PairSummary.getPairLDKC(), rJDataRmcp1PairSummary.getPairCU(), rJDataRmcp1PairSummary.getPairLDEV());
        if (RJHorcPairData.convertPairExternalFromSummary(rJDataRmcp1PairSummary) == 1) {
            string = string + " #";
        }
        if (RJHorcPairData.convertPairHDPFromSummary(rJDataRmcp1PairSummary) == 1) {
            string = string + " X";
        }
        return string;
    }

    public static String convertLDEVToStringPair(RJRmcpPairDataForDisplay rJRmcpPairDataForDisplay) {
        String string = RJComUty.getLDEVDisplayName(rJRmcpPairDataForDisplay.getPairLDKC(), rJRmcpPairDataForDisplay.getPairCU(), rJRmcpPairDataForDisplay.getPairLDEV());
        if (rJRmcpPairDataForDisplay.getPairExternal() == 1) {
            string = string + " #";
        }
        if (rJRmcpPairDataForDisplay.getPairHDP() == 1) {
            string = string + " X";
        }
        return string;
    }

    public static int convertPSKindFromSummary(RJDataRmcp1PairSummary rJDataRmcp1PairSummary) {
        int n = rJDataRmcp1PairSummary.getPairStatus() == 0 ? 0 : ((rJDataRmcp1PairSummary.getType() & 2) == 0 ? 1 : 2);
        return n;
    }

    public static int convertPSKindFromSummary(RJDataRmcp1PairSummary rJDataRmcp1PairSummary, int n) {
        int n2 = rJDataRmcp1PairSummary.getPairLU().getPortNo();
        int n3 = rJDataRmcp1PairSummary.getPairStatus() == 0 || n2 < 0 || 256 <= n2 ? 0 : ((rJDataRmcp1PairSummary.getType() & 2) == 0 ? 1 : 2);
        return n3;
    }

    public static String convertPSKindToString(RJRmcpDataControl rJRmcpDataControl, int n) {
        String string;
        RJRmcpGuide rJRmcpGuide = rJRmcpDataControl.getRmcpGuide();
        String string2 = rJRmcpGuide.getTRCKey();
        switch (n) {
            case 1: {
                string = RJRmcpGuide.PsKind_Primary.getGuidance();
                break;
            }
            case 2: {
                string = RJRmcpGuide.PsKind_Secondary.getGuidance();
                break;
            }
            case 0: {
                string = RJRmcpGuide.PsKind_Simplex.getGuidance();
                break;
            }
            default: {
                System.out.println(string2 + ", PSKind check pskind=" + n);
                string = RJRmcpGuide.Get3Asterisk.getGuidance();
            }
        }
        return string;
    }

    public static int convertSyncModeFromSummary(RJDataRmcp1PairSummary rJDataRmcp1PairSummary) {
        int n;
        if (rJDataRmcp1PairSummary.getPairStatus() == 0) {
            n = 0;
        } else {
            int n2 = rJDataRmcp1PairSummary.getType();
            switch (n2 & 0x70) {
                case 0: {
                    n = 1;
                    break;
                }
                case 32: {
                    n = 3;
                    break;
                }
                case 48: {
                    n = 5;
                    break;
                }
                default: {
                    n = 4;
                    System.out.println("RJHORC Rmcp1PairSummary check sync=" + n2);
                }
            }
        }
        return n;
    }

    public static int convertSyncModeFromSummary(RJDataRmcp1PairSummary rJDataRmcp1PairSummary, int n) {
        int n2;
        int n3 = rJDataRmcp1PairSummary.getPairLU().getPortNo();
        if (rJDataRmcp1PairSummary.getPairStatus() == 0 || n3 < 0 || 256 <= n3) {
            n2 = 0;
        } else {
            int n4 = rJDataRmcp1PairSummary.getType();
            switch (n4 & 0x70) {
                case 0: {
                    n2 = 1;
                    break;
                }
                case 32: {
                    n2 = 3;
                    break;
                }
                case 48: {
                    n2 = 5;
                    break;
                }
                default: {
                    n2 = 4;
                    System.out.println("RJHORC Rmcp1PairSummary check sync=" + n4);
                }
            }
        }
        return n2;
    }

    public static String convertSyncModeToString(RJRmcpDataControl rJRmcpDataControl, int n, int n2) {
        String string;
        RJRmcpGuide rJRmcpGuide = rJRmcpDataControl.getRmcpGuide();
        String string2 = rJRmcpGuide.getTRCKey();
        switch (n) {
            case 0: {
                string = RJRmcpGuide.SyncMode_Simplex.getGuidance();
                break;
            }
            case 1: {
                if (n2 != -1) {
                    if (n2 != 1) {
                        string = RJRmcpGuide.SyncMode_MultiC.getGuidance();
                        break;
                    }
                    string = RJRmcpGuide.SyncMode_SynchronousC.getGuidance();
                    break;
                }
                string = RJRmcpGuide.SyncMode_Synchronous.getGuidance();
                break;
            }
            case 3: {
                string = RJRmcpGuide.SyncMode_Periodic.getGuidance();
                break;
            }
            case 5: {
                string = RJRmcpGuide.SyncMode_OSW.getGuidance();
                break;
            }
            default: {
                System.out.println(string2 + ", Rmcp1PairSummary check syncmod=" + n);
                string = RJRmcpGuide.Get3Asterisk.getGuidance();
            }
        }
        return string;
    }

    public static String convertPairStatToString(RJRmcpDataControl rJRmcpDataControl, int n, int n2) {
        String string;
        RJRmcpGuide rJRmcpGuide = rJRmcpDataControl.getRmcpGuide();
        String string2 = rJRmcpGuide.getTRCKey();
        switch (n) {
            case 0: {
                string = RJRmcpGuide.PairStat_SMPL.getGuidance();
                break;
            }
            case 1: {
                if (n2 != 0) {
                    string = RJRmcpGuide.PairStat_PDUB.getGuidance();
                    break;
                }
                string = RJRmcpGuide.PairStat_COPY.getGuidance();
                break;
            }
            case 2: 
            case 193: {
                if (n2 != 0) {
                    string = RJRmcpGuide.PairStat_PDUB.getGuidance();
                    break;
                }
                string = RJRmcpGuide.PairStat_PAIR.getGuidance();
                break;
            }
            case 3: {
                string = RJRmcpGuide.PairStat_PSUS_POPE.getGuidance();
                break;
            }
            case 4: {
                string = RJRmcpGuide.PairStat_PSUS_SOPE.getGuidance();
                break;
            }
            case 5: {
                string = RJRmcpGuide.PairStat_PSUS_MCU.getGuidance();
                break;
            }
            case 6: {
                string = RJRmcpGuide.PairStat_PSUS_RCU.getGuidance();
                break;
            }
            case 7: {
                string = RJRmcpGuide.PairStat_PSUS_DELR.getGuidance();
                break;
            }
            case 8: {
                string = RJRmcpGuide.PairStat_PSUS_SFLT.getGuidance();
                break;
            }
            case 9: {
                string = RJRmcpGuide.PairStat_PSUS_MIPL.getGuidance();
                break;
            }
            case 10: {
                string = RJRmcpGuide.PairStat_PSUS_FREZ.getGuidance();
                break;
            }
            case 64: {
                string = RJRmcpGuide.PairStat_SMPL_MIGI.getGuidance();
                break;
            }
            case 65: {
                string = RJRmcpGuide.PairStat_SMPL_MIGC.getGuidance();
                break;
            }
            case 66: {
                string = RJRmcpGuide.PairStat_SMPL_ERAI.getGuidance();
                break;
            }
            case 67: {
                string = RJRmcpGuide.PairStat_SMPL_ERAE.getGuidance();
                break;
            }
            case 68: {
                string = RJRmcpGuide.PairStat_COPY.getGuidance();
                break;
            }
            case 69: {
                string = RJRmcpGuide.PairStat_PSUS_MIGP.getGuidance();
                break;
            }
            case 70: {
                string = RJRmcpGuide.PairStat_PSUS_MIGS.getGuidance();
                break;
            }
            case 80: {
                string = RJRmcpGuide.PairStat_PSUS_INIE.getGuidance();
                break;
            }
            case 96: {
                string = RJRmcpGuide.PairStat_Suspending.getGuidance();
                break;
            }
            case 97: {
                string = RJRmcpGuide.PairStat_Deleting.getGuidance();
                break;
            }
            case 98: {
                string = RJRmcpGuide.PairStat_PSUS_PSOF.getGuidance();
                break;
            }
            case 99: {
                string = RJRmcpGuide.PairStat_PSUS_SFOV.getGuidance();
                break;
            }
            case 160: {
                string = RJRmcpGuide.PairStat_PSUS_TODE.getGuidance();
                break;
            }
            case 161: {
                string = RJRmcpGuide.PairStat_PSUS_CONT.getGuidance();
                break;
            }
            case 162: {
                string = RJRmcpGuide.PairStat_PSUS_COMP.getGuidance();
                break;
            }
            default: {
                string = RJRmcpGuide.Get3Asterisk.getGuidance();
                System.out.println(string2 + ", Rmcp1PairSummary check stat=" + n + ",s1=" + n2);
            }
        }
        return string;
    }

    public static String convertPairStatDetailToString(RJRmcpDataControl rJRmcpDataControl, int n) {
        int n2 = n & 0xFF;
        int n3 = (n & 0xFF00) >> 8;
        String string = RJHorcPairData.convertPairStatToString(rJRmcpDataControl, n2, n3);
        RJRmcpGuide rJRmcpGuide = rJRmcpDataControl.getRmcpGuide();
        String string2 = rJRmcpGuide.getTRCKey();
        switch (n3 & 0xCC) {
            case 0: {
                break;
            }
            case 128: {
                string = string + RJRmcpGuide.PairStatSUB_PDUBSMPL.getGuidance();
                break;
            }
            case 64: {
                string = string + RJRmcpGuide.PairStatSUB_PDUBPSUE.getGuidance();
                break;
            }
            case 8: {
                string = string + RJRmcpGuide.PairStatSUB_MIGW_SUS.getGuidance();
                break;
            }
            case 4: {
                string = string + RJRmcpGuide.PairStatSUB_MIGW_ERA.getGuidance();
                break;
            }
            default: {
                string = string + RJRmcpGuide.GetSubAsterisk.getGuidance();
                System.out.println(string2 + ", Rmcp1PairDetail check stat=" + n);
            }
        }
        return string;
    }

    public static int convertPriorityFromSummary(RJRmcpDataControl rJRmcpDataControl, RJDataRmcp1PairSummary rJDataRmcp1PairSummary) {
        int n;
        int n2 = rJDataRmcp1PairSummary.getPriority();
        int n3 = 1;
        RJRmcpGuide rJRmcpGuide = rJRmcpDataControl.getRmcpGuide();
        if (1 == rJRmcpGuide.getApiKind()) {
            n3 = 0;
        }
        if (n3 <= n2 && n2 <= 256) {
            n = n2;
        } else {
            n = -1;
            System.out.println("RJHORC Rmcp1PairSummary check priority=" + n2);
        }
        return n;
    }

    public static int convertTracksFromSummary(RJRmcpDataControl rJRmcpDataControl, RJDataRmcp1PairSummary rJDataRmcp1PairSummary) {
        int n;
        int n2 = rJDataRmcp1PairSummary.getTracks();
        RJRmcpGuide rJRmcpGuide = rJRmcpDataControl.getRmcpGuide();
        String string = rJRmcpGuide.getTRCKey();
        if (2 == rJRmcpGuide.getApiKind()) {
            n2 -= 128;
        } else {
            switch (n2) {
                case 129: {
                    n2 = 1;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 15;
                    break;
                }
                default: {
                    n2 = 15;
                }
            }
        }
        if (1 <= n2 && n2 <= 15) {
            n = n2;
        } else {
            n = -1;
            System.out.println(string + ", Rmcp1PairSummary check copypace=" + n2);
        }
        return n;
    }

    public static int convertFenceFromSummary(RJDataRmcp1PairSummary rJDataRmcp1PairSummary) {
        int n;
        int n2 = rJDataRmcp1PairSummary.getPairOption().getBehavior();
        switch (n2 & 0x1C) {
            case 0: {
                n = 0;
                break;
            }
            case 4: {
                n = 1;
                break;
            }
            case 8: {
                n = 2;
                break;
            }
            default: {
                System.out.println("RJHORC Rmcp1PairSummary check fence=" + n2);
                n = -1;
            }
        }
        return n;
    }

    public static String convertFenceToString(RJRmcpDataControl rJRmcpDataControl, int n) {
        String string;
        RJRmcpGuide rJRmcpGuide = rJRmcpDataControl.getRmcpGuide();
        String string2 = rJRmcpGuide.getTRCKey();
        switch (n) {
            case 0: {
                string = RJRmcpGuide.FenceLvl_Never.getGuidance();
                break;
            }
            case 1: {
                string = RJRmcpGuide.FenceLvl_Data.getGuidance();
                break;
            }
            case 2: {
                string = RJRmcpGuide.FenceLvl_Status.getGuidance();
                break;
            }
            default: {
                System.out.println(string2 + ", Rmcp1PairSummary check fence2=" + n);
                string = RJRmcpGuide.Get3Asterisk.getGuidance();
            }
        }
        return string;
    }

    public static int convertErrLvlFromSummary(RJDataRmcp1PairSummary rJDataRmcp1PairSummary) {
        int n;
        int n2 = rJDataRmcp1PairSummary.getPairOption().getBehavior();
        switch (n2 & 0xC0) {
            case 0: {
                n = 0;
                break;
            }
            case 64: {
                n = 1;
                break;
            }
            default: {
                System.out.println("RJHORC Rmcp1PairSummary check errlvl=" + n2);
                n = -1;
            }
        }
        return n;
    }

    public static String convertErrLvlToString(RJRmcpDataControl rJRmcpDataControl, int n) {
        String string;
        RJRmcpGuide rJRmcpGuide = rJRmcpDataControl.getRmcpGuide();
        String string2 = rJRmcpGuide.getTRCKey();
        switch (n) {
            case 0: {
                string = RJRmcpGuide.ErrLvl_Group.getGuidance();
                break;
            }
            case 1: {
                string = RJRmcpGuide.ErrLvl_LU.getGuidance();
                break;
            }
            default: {
                System.out.println(string2 + ", Rmcp1PairSummary check errlvl2=" + n);
                string = RJRmcpGuide.Get3Asterisk.getGuidance();
            }
        }
        return string;
    }

    public static String convertVolumeToString(int n) {
        String string = RJComUty.itoh(n, 2);
        return string;
    }

    public static int convertCfwFromSummary(RJDataRmcp1PairSummary rJDataRmcp1PairSummary) {
        int n;
        int n2 = rJDataRmcp1PairSummary.getPairOption().getBehavior();
        switch (n2 & 1) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            default: {
                System.out.println("RJHRC Rmcp1PairSummary check cfw=" + n2);
                n = -1;
            }
        }
        return n;
    }

    public static String convertCfwToString(RJRmcpDataControl rJRmcpDataControl, int n) {
        String string;
        RJRmcpGuide rJRmcpGuide = rJRmcpDataControl.getRmcpGuide();
        String string2 = rJRmcpGuide.getTRCKey();
        switch (n) {
            case 0: {
                string = RJRmcpGuide.PairCfw_Rvol.getGuidance();
                break;
            }
            case 1: {
                string = RJRmcpGuide.PairCfw_Mvol.getGuidance();
                break;
            }
            default: {
                System.out.println(string2 + ", Rmcp1PairSummary check cfw2=" + n);
                string = RJRmcpGuide.Get3Asterisk.getGuidance();
            }
        }
        return string;
    }

    public static int convertDfwFromSummary(RJDataRmcp1PairSummary rJDataRmcp1PairSummary) {
        int n;
        int n2 = rJDataRmcp1PairSummary.getPairOption().getBehavior();
        switch (n2 & 2) {
            case 0: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            default: {
                System.out.println("RJHRC Rmcp1PairSummary check dfw=" + n2);
                n = -1;
            }
        }
        return n;
    }

    public static String convertDfwToString(RJRmcpDataControl rJRmcpDataControl, int n) {
        String string;
        RJRmcpGuide rJRmcpGuide = rJRmcpDataControl.getRmcpGuide();
        String string2 = rJRmcpGuide.getTRCKey();
        switch (n) {
            case 0: {
                string = RJRmcpGuide.PairDfw_Not.getGuidance();
                break;
            }
            case 1: {
                string = RJRmcpGuide.PairDfw_Req.getGuidance();
                break;
            }
            default: {
                System.out.println(string2 + ", Rmcp1PairSummary check dfw2=" + n);
                string = RJRmcpGuide.Get3Asterisk.getGuidance();
            }
        }
        return string;
    }

    public static int convertCTGFromSummary(RJDataRmcp1PairSummary rJDataRmcp1PairSummary) {
        int n = rJDataRmcp1PairSummary.getAsync();
        int n2 = n & 0x3FF;
        if (0 > n2 || n2 > 127) {
            System.out.println("RJHORC Rmcp1PairSummary check CTG=" + n2);
        }
        return n2;
    }

    public static boolean checkPVolCtl(RJRmcpDataControl rJRmcpDataControl, RJHorcPairToEdit rJHorcPairToEdit, int n) {
        boolean bl = false;
        if (RJHorcPairData.checkPVolCtlFromCU(rJRmcpDataControl, rJHorcPairToEdit.CUNo, n) && RJHorcPairData.checkPVolCtlFromPort(rJRmcpDataControl, rJHorcPairToEdit.LU.PortNo, n) && RJHorcPairData.checkPVolCtlFromGID(rJRmcpDataControl, rJHorcPairToEdit.LU.GroupNo, n) && RJHorcPairData.checkPVolCtlFromLun(rJRmcpDataControl, rJHorcPairToEdit.LU.LUN, n)) {
            bl = true;
        }
        return bl;
    }

    public static boolean checkPVolCtlFromCU(RJRmcpDataControl rJRmcpDataControl, int n, int n2) {
        boolean bl = false;
        switch (n2) {
            case 4: {
                if (n < 0 || n >= 64) break;
                bl = true;
                break;
            }
            case 5: 
            case 6: {
                bl = true;
                break;
            }
            case 19: {
                if (n < 0 || n >= 64) break;
                bl = true;
                break;
            }
            default: {
                System.out.println("RJHorcPairData, checkPVolCtlFromCU, iCtl = " + n2);
                bl = true;
            }
        }
        return bl;
    }

    public static boolean checkPVolCtlFromPort(RJRmcpDataControl rJRmcpDataControl, int n, int n2) {
        RJRmcpGuide rJRmcpGuide = rJRmcpDataControl.getRmcpGuide();
        boolean bl = false;
        switch (n2) {
            case 4: 
            case 5: 
            case 6: 
            case 19: {
                bl = true;
                break;
            }
            default: {
                System.out.println("RJHorcPairData, checkPVolCtlFromPort, iCtl = " + n2);
                bl = true;
            }
        }
        return bl;
    }

    public static int getStringArrayIndex(String string, String[] stringArray) {
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            n = i;
            break;
        }
        return n;
    }

    public static boolean checkPVolCtlFromGID(RJRmcpDataControl rJRmcpDataControl, int n, int n2) {
        boolean bl = false;
        switch (n2) {
            case 4: 
            case 5: 
            case 6: 
            case 19: {
                bl = true;
                break;
            }
            default: {
                System.out.println("RJHorcPairData, checkPVolCtlFromGID, iCtl = " + n2);
                bl = true;
            }
        }
        return bl;
    }

    public static boolean checkPVolCtlFromLun(RJRmcpDataControl rJRmcpDataControl, int n, int n2) {
        boolean bl = false;
        switch (n2) {
            case 4: {
                if (n < 0 || n >= 1024) break;
                bl = true;
                break;
            }
            case 5: 
            case 6: 
            case 19: {
                bl = true;
                break;
            }
            default: {
                System.out.println("RJHorcPairData, checkPVolCtlFromLun, iCtl = " + n2);
                bl = true;
            }
        }
        return bl;
    }

    public static boolean checkSVolCtl(RJRmcpDataControl rJRmcpDataControl, int n, int n2, int n3, int n4) {
        boolean bl = false;
        if (RJHorcPairData.checkSVolCtlFromPort(rJRmcpDataControl, n, n4) && RJHorcPairData.checkSVolCtlFromGID(n2, n4) && RJHorcPairData.checkSVolCtlFromLun(n3, n4)) {
            bl = true;
        }
        return bl;
    }

    public static boolean checkSVolCtlFromPort(RJRmcpDataControl rJRmcpDataControl, int n, int n2) {
        RJRmcpGuide rJRmcpGuide = rJRmcpDataControl.getRmcpGuide();
        boolean bl = false;
        block0 : switch (n2) {
            case 5: {
                bl = true;
                break;
            }
            case 6: {
                String string = rJRmcpDataControl.getPortNamefromInternalPortID(n);
                for (int i = 0; i < rJRmcpGuide.R700_deletePortList.length; ++i) {
                    if (string.compareTo(rJRmcpGuide.R700_deletePortList[i]) == 0) {
                        bl = false;
                        break block0;
                    }
                    bl = true;
                }
                break;
            }
            case 19: {
                String string = rJRmcpDataControl.getPortNamefromInternalPortID(n);
                for (int i = 0; i < rJRmcpGuide.HM700_deletePortList.length; ++i) {
                    if (string.compareTo(rJRmcpGuide.HM700_deletePortList[i]) == 0) {
                        bl = false;
                        break block0;
                    }
                    bl = true;
                }
                break;
            }
            default: {
                System.out.println("RJHorcPairData, checkSVolCtlFromPort, iCtl = " + n2);
            }
        }
        return bl;
    }

    public static boolean checkSVolCtlFromGID(int n, int n2) {
        boolean bl = false;
        switch (n2) {
            case 4: 
            case 5: 
            case 6: 
            case 19: {
                bl = true;
                break;
            }
            default: {
                System.out.println("RJHorcPairData, checkSVolCtlFromGID, iCtl = " + n2);
                bl = true;
            }
        }
        return bl;
    }

    public static boolean checkSVolCtlFromLun(int n, int n2) {
        boolean bl = false;
        switch (n2) {
            case 4: {
                if (n < 0 || n >= 1024) break;
                bl = true;
                break;
            }
            case 5: 
            case 6: 
            case 19: {
                bl = true;
                break;
            }
            default: {
                System.out.println("RJHorcPairData, checkSVolCtlFromLun, iCtl = " + n2);
                bl = true;
            }
        }
        return bl;
    }

    public static boolean checkPVolCtlHrc(RJRmcpDataControl rJRmcpDataControl, RJHorcPairToEdit rJHorcPairToEdit, int n) {
        boolean bl = false;
        if (RJHorcPairData.checkPVolCtlFromCU(rJRmcpDataControl, rJHorcPairToEdit.CUNo, n)) {
            bl = true;
        }
        return bl;
    }

    public static int convertPairExternalFromSummary(RJDataRmcp1PairSummary rJDataRmcp1PairSummary) {
        int n = 0;
        int n2 = rJDataRmcp1PairSummary.getPairOption().getBehavior();
        if ((n2 & 0x200) != 0) {
            n = 1;
        }
        return n;
    }

    public static int convertPairHDPFromSummary(RJDataRmcp1PairSummary rJDataRmcp1PairSummary) {
        int n = 0;
        int n2 = rJDataRmcp1PairSummary.getPairOption().getBehavior();
        if ((n2 & 0x800) != 0) {
            n = 1;
        }
        return n;
    }

    public static String convertPairVolAttrbFromSummary(RJDataRmcp1PairSummary rJDataRmcp1PairSummary) {
        String string = "";
        if (RJHorcPairData.convertPairExternalFromSummary(rJDataRmcp1PairSummary) == 1) {
            string = string + " #";
        }
        if (RJHorcPairData.convertPairHDPFromSummary(rJDataRmcp1PairSummary) == 1) {
            string = string + " X";
        }
        return string;
    }

    public static final class RJHorcPairToEdit {
        int CUNo;
        RMCPHorcLU LU;
        int Ldev;
        int PairCUNo;
        RJDataRmcp1PairSummary Ref;
        Object Obj;
        ArrayList ErrorList = new ArrayList();
        String ldevDispName;

        public ArrayList getErrorList() {
            return this.ErrorList;
        }

        public void addErrorList(int n, int n2) {
            int[] nArray;
            if (n == 0) {
                this.ErrorList.clear();
            } else if (this.ErrorList.size() == 1 && (nArray = (int[])this.ErrorList.get(0))[0] == 0) {
                this.ErrorList.clear();
            }
            nArray = new int[]{n, n2};
            this.ErrorList.add(nArray);
            nArray = null;
        }

        public boolean removeErrorList(int n, int n2) {
            boolean bl = false;
            if (n == -1) {
                this.ErrorList.clear();
                bl = true;
            } else {
                int[] nArray;
                for (int i = this.ErrorList.size() - 1; i >= 0; --i) {
                    nArray = (int[])this.ErrorList.get(i);
                    if (nArray[0] != n || nArray[1] != n2) continue;
                    this.ErrorList.remove(i);
                    bl = true;
                }
                if (bl && this.ErrorList.size() == 0) {
                    this.addErrorList(0, 0);
                }
                nArray = null;
            }
            return bl;
        }

        public String convertErrorListToString(RJRmcpDataControl rJRmcpDataControl) {
            String string;
            RJRmcpGuide rJRmcpGuide = rJRmcpDataControl.getRmcpGuide();
            int n = this.ErrorList.size();
            switch (n) {
                case 0: {
                    string = "";
                    break;
                }
                default: {
                    int[] nArray = (int[])this.ErrorList.get(0);
                    string = "" + nArray[0] + " " + nArray[1];
                    if (n > 1) {
                        string = string + RJRmcpGuide.GuidstrTooLong.getGuidance();
                    }
                    nArray = null;
                }
            }
            return string;
        }
    }
}

