/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.hpav.com;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sanproject.client.data.RJDataException;
import sanproject.client.hpav.com.RJcCacheSupplierGetInterface;

public abstract class RJaDefaultCache {
    private RJcCacheSupplierGetInterface supplier;
    private int cacheWidth;
    private Comparator cmp = null;
    private Map cache = null;

    public RJaDefaultCache(RJcCacheSupplierGetInterface rJcCacheSupplierGetInterface, int n) {
        this.supplier = rJcCacheSupplierGetInterface;
        this.cacheWidth = n;
        this.cache = this.createCache();
    }

    public RJaDefaultCache(RJcCacheSupplierGetInterface rJcCacheSupplierGetInterface, int n, Comparator comparator) {
        this.supplier = rJcCacheSupplierGetInterface;
        this.cacheWidth = n;
        this.cmp = comparator;
        this.cache = this.createCache();
    }

    public Object get(Object object) throws RJDataException {
        Object object2 = null;
        if (this.getCache().containsKey(object)) {
            object2 = this.getFromCache(object);
        } else {
            List list = this.getKeyToCache(object);
            List list2 = this.getKeyToDispose(list);
            if (list2 != null && list2.size() > 0) {
                this.removeFromCache(list2);
            }
            List list3 = this.getSupplier().getData(list);
            this.addIntoCache(list3);
            object2 = this.getFromCache(object);
        }
        return object2;
    }

    public void clear() {
        this.removeAllCache();
    }

    public int compare(Object object, Object object2) {
        int n = 0;
        if (this.cmp != null) {
            n = this.cmp.compare(object, object2);
        } else {
            Comparable comparable = (Comparable)object;
            n = comparable.compareTo(object2);
        }
        return n;
    }

    public static RJcCacheSupplierGetInterface.Entry createEntry(Object object, Object object2) {
        class Entry
        implements RJcCacheSupplierGetInterface.Entry {
            private Object key;
            private Object object;

            Entry() {
            }

            public void set(Object object, Object object2) {
                this.key = object;
                this.object = object2;
            }

            public Object getKey() {
                return this.key;
            }

            public Object getObject() {
                return this.object;
            }
        }
        Entry entry = new Entry();
        entry.set(object, object2);
        return entry;
    }

    protected abstract Map createCache();

    protected abstract List getKeyToCache(Object var1);

    protected abstract List getKeyToDispose(List var1);

    protected Object getFromCache(Object object) {
        Object var2_2 = null;
        var2_2 = this.getCache().get(object);
        return var2_2;
    }

    protected void addIntoCache(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RJcCacheSupplierGetInterface.Entry entry = (RJcCacheSupplierGetInterface.Entry)iterator.next();
            this.getCache().put(entry.getKey(), entry.getObject());
        }
    }

    protected List removeFromCache(List list) {
        ArrayList<RJcCacheSupplierGetInterface.Entry> arrayList = new ArrayList<RJcCacheSupplierGetInterface.Entry>();
        Map map = this.getCache();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object v;
            Object e = iterator.next();
            if (!map.containsKey(e) || (v = map.remove(e)) == null) continue;
            arrayList.add(RJaDefaultCache.createEntry(e, v));
        }
        return arrayList;
    }

    protected void removeAllCache() {
        this.getCache().clear();
    }

    protected int getCacheWidth() {
        return this.cacheWidth;
    }

    protected RJcCacheSupplierGetInterface getSupplier() {
        return this.supplier;
    }

    protected Map getCache() {
        return this.cache;
    }

    protected Comparator getComparator() {
        return this.cmp;
    }
}

