/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.com;

import com.klg.jclass.chart.ChartDataModel;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCAxisTitle;
import com.klg.jclass.chart.JCBarChartFormat;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCValueLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import sanproject.client.com.RJcConst;
import sanproject.client.monitor.com.RJHihChartBarModel;
import sanproject.client.monitor.com.RJHihChartData;
import sanproject.client.monitor.com.RJHihChartDataCollection;
import sanproject.client.monitor.com.RJHihChartPlotModel;
import sanproject.client.monitor.com.RJHihDataSupplier;
import sanproject.client.monitor.com.RJHihDateFormat;
import sanproject.client.monitor.com.RJHihDef;
import sanproject.client.monitor.com.RJHihTimePair;

public class RJHihChartPanel
extends JPanel
implements RJHihDef {
    protected RJHihDataSupplier supplier = null;
    protected JCChart chart = new JCChart(0);
    protected JCAxis shareY = null;
    protected ChartDataView volumeView = new ChartDataView();
    protected static Color bgcolor = new Color(204, 204, 204);
    protected static Color bg_gray = new Color(229, 229, 229);
    public static final long MINUTE = 60000L;
    public static final int MAX_TICK = 12;
    public static final int MAX_LABEL = 6;
    protected RJHihDateFormat[] formats = new RJHihDateFormat[]{new RJHihDateFormat("'<html><font face=Monospace><small>'HH:mm'</small></font></html>'"), new RJHihDateFormat("'<html><font face=Monospace><small><p>'M/d'<br>'HH:mm'</p></small></font></html>'"), new RJHihDateFormat("'<html><font face=Monospace><small>'M/d'</small></font></html>'")};

    public RJHihChartPanel() {
        this.setLayout(new BorderLayout());
    }

    public void init(RJHihDataSupplier rJHihDataSupplier) {
        this.supplier = rJHihDataSupplier;
        this.chart.getChartArea().setVisible(false);
        this.chart.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add((Component)this.chart, "Center");
    }

    public void drawScale(RJHihChartDataCollection rJHihChartDataCollection) {
        RJHihChartData rJHihChartData = (RJHihChartData)rJHihChartDataCollection.get(rJHihChartDataCollection.getAvailKey());
        this.drawScale(rJHihChartData);
    }

    public void drawScale(RJHihChartData rJHihChartData) {
        this.remove((Component)this.chart);
        this.chart = new JCChart(0);
        this.chart.getChartArea().setVisible(false);
        this.chart.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add((Component)this.chart, "Center");
        this.chart = this.createChart();
        this.createYAxis(rJHihChartData);
        this.createXAxis(rJHihChartData);
        this.createXAxisScale(rJHihChartData);
        this.chart.setBatched(true);
        this.chart.getChartArea().setFastAction(true);
    }

    public JCChart createChart() {
        this.chart.getChartArea().setVisible(true);
        this.chart.getChartArea().setOpaque(true);
        this.chart.getChartArea().getPlotArea().setBackground(bgcolor);
        this.chart.getChartArea().setAxisBoundingBox(false);
        this.chart.getLegend().setVisible(true);
        this.volumeView.setChartType(9);
        JCBarChartFormat jCBarChartFormat = (JCBarChartFormat)this.volumeView.getChartFormat(9);
        jCBarChartFormat.setClusterWidth(1);
        this.volumeView.setVisibleInLegend(false);
        return this.chart;
    }

    public void createYAxis(RJHihChartData rJHihChartData) {
        this.shareY = this.chart.getChartArea().getYAxis(0);
        JCAxisTitle jCAxisTitle = new JCAxisTitle(this.getYAxisTitle(rJHihChartData));
        jCAxisTitle.setPlacement(16);
        this.shareY.setTitle(jCAxisTitle);
        this.shareY.setGridVisible(true);
        this.shareY.getGridStyle().getLineStyle().setColor(bg_gray);
        this.chart.getChartArea().getYAxis(0).setMaxIsDefault(false);
        this.chart.getChartArea().getYAxis(0).setMax(this.getYAxisMax());
        this.chart.getChartArea().getYAxis(0).setNumSpacingIsDefault(false);
        this.chart.getChartArea().getYAxis(0).setNumSpacing(this.getYAxisNumSpacing());
        this.chart.getChartArea().getYAxis(0).setMinIsDefault(false);
        this.chart.getChartArea().getYAxis(0).setMin(this.getYAxisMin());
        this.chart.getChartArea().getYAxis(0).setTickSpacingIsDefault(false);
        this.chart.getChartArea().getYAxis(0).setTickSpacing(this.getYAxisTickSpacing());
    }

    protected String getYAxisTitle(RJHihChartData rJHihChartData) {
        String string = "";
        if (rJHihChartData != null && rJHihChartData.getAxisYTitle() != null) {
            string = rJHihChartData.getAxisYTitle();
        }
        return string;
    }

    protected double getYAxisMax() {
        return 100.0;
    }

    protected double getYAxisMin() {
        return 0.0;
    }

    protected double getYAxisNumSpacing() {
        return this.getYAxisMax() / 10.0;
    }

    protected double getYAxisTickSpacing() {
        return this.getYAxisMax() / 10.0;
    }

    public void createXAxis(RJHihChartData rJHihChartData) {
        this.chart.getChartArea().getXAxis(0).setGap(0);
        this.chart.getChartArea().getXAxis(0).setGridSpacingIsDefault(false);
        this.chart.getChartArea().getXAxis(0).setGridSpacing(10.0);
        this.chart.getChartArea().getXAxis(0).setTickSpacingIsDefault(false);
        this.chart.getChartArea().getXAxis(0).setMaxIsDefault(false);
        this.chart.getChartArea().getXAxis(0).setNumSpacingIsDefault(false);
        this.chart.getChartArea().getXAxis(0).setNumSpacing(0.0);
        this.chart.getChartArea().getXAxis(0).setMinIsDefault(false);
        this.chart.getChartArea().getXAxis(0).setMin(0.0);
        this.chart.getChartArea().getXAxis(0).setEditable(false);
        this.chart.getChartArea().getXAxis(0).setAnnotationMethod(1);
        this.chart.getChartArea().getXAxis(0).setFont(new Font("Dialog", 0, 10));
        JCAxisTitle jCAxisTitle = new JCAxisTitle(this.getXAxisTitle(rJHihChartData));
        this.chart.getChartArea().getXAxis(0).setTitle(jCAxisTitle);
    }

    protected String getXAxisTitle(RJHihChartData rJHihChartData) {
        String string = "";
        if (rJHihChartData != null && rJHihChartData.getAxisXTitle() != null) {
            string = rJHihChartData.getAxisXTitle();
        }
        return string;
    }

    protected void createXAxisScale(RJHihChartData rJHihChartData) {
        RJHihTimePair rJHihTimePair = rJHihChartData.getDrawTerm();
        int n = rJHihTimePair.getIntervalTime();
        long l = rJHihTimePair.getFromTime().getTime() + (long)n * 60000L;
        System.out.println("\u25a0 PlotCount " + rJHihChartData.getPlotCount());
        if (rJHihChartData.getPlotCount() <= 1) {
            Date date = new Date(l);
            String string = this.formats[1].format(date);
            this.chart.getChartArea().getXAxis(0).setValueLabels(0, new JCValueLabel(0.0, string));
        } else {
            long l2 = rJHihTimePair.getToTime().getTime();
            long l3 = l2 - l;
            int n2 = (int)(l3 / 60000L);
            int n3 = n;
            long l4 = (long)n3 * 60000L;
            long l5 = l;
            if (n2 > n * 12) {
                n3 = this.getMinutePerScale((int)(l3 / 60000L));
                l4 = (long)n3 * 60000L;
                l5 = (l + l4 - 60000L) / l4 * l4;
            }
            long l6 = l5;
            int n4 = n3;
            long l7 = (long)n4 * 60000L;
            if (n2 / n3 > 6) {
                n4 = n3 * 2;
                l7 = (long)n4 * 60000L;
                if (n2 > n * 12) {
                    l6 = (l + l7 - 60000L) / l7 * l7;
                }
            }
            int n5 = (int)((l5 - l) / 60000L);
            int n6 = (int)((l6 - l) / 60000L);
            String string = "";
            Date date = null;
            int n7 = 0;
            while (n5 <= n2) {
                String string2 = "";
                if (n5 >= n6) {
                    int n8;
                    Date date2 = new Date(l5 + l4 * (long)n7);
                    int n9 = n8 = n3 < 1440 ? 0 : 2;
                    if (!(n8 != 0 || date != null && this.isSameDay(date2, date))) {
                        n8 = 1;
                    }
                    string2 = this.formats[n8].format(date2);
                    date = date2;
                    n6 += n4;
                }
                string = string + "[" + n7 + ", " + n5 + "] ";
                this.chart.getChartArea().getXAxis(0).setValueLabels(n7, new JCValueLabel((double)n5, string2));
                n5 += n3;
                ++n7;
            }
            string = string + "<" + n5 + ">";
            this.chart.getChartArea().getXAxis(0).setTickSpacingIsDefault(true);
            this.supplier.putLog("[Monitor]", "[Chart]", string);
        }
    }

    private int getMinutePerScale(int n) {
        int[][] nArrayArray = new int[][]{{24, 2}, {60, 5}, {120, 10}, {180, 15}, {360, 30}, {720, 60}, {1440, 120}, {2880, 240}, {4320, 360}, {8640, 720}, {17280, 1440}, {34560, 2880}, {64800, 7200}, {172800, 14400}};
        int n2 = 0;
        for (int i = 0; i < nArrayArray.length; ++i) {
            if (n > nArrayArray[i][0]) continue;
            n2 = nArrayArray[i][1];
            break;
        }
        return n2;
    }

    private boolean isSameDay(Date date, Date date2) {
        boolean bl = false;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(RJcConst.tz);
        gregorianCalendar.setTime(date);
        int n = gregorianCalendar.get(6);
        gregorianCalendar.setTime(date2);
        int n2 = gregorianCalendar.get(6);
        if (n == n2) {
            bl = true;
        }
        return bl;
    }

    public void drawChart(RJHihChartDataCollection rJHihChartDataCollection) {
        RJHihChartData rJHihChartData = (RJHihChartData)rJHihChartDataCollection.get(rJHihChartDataCollection.getAvailKey());
        this.drawChart(rJHihChartData);
    }

    public void drawChart(RJHihChartData rJHihChartData) {
        if (rJHihChartData != null) {
            RJHihChartPlotModel rJHihChartPlotModel = new RJHihChartPlotModel(this.chart, rJHihChartData);
            this.chart.getDataView(0).setDataSource((ChartDataModel)rJHihChartPlotModel);
            int n = rJHihChartData.getPlotCount();
            this.chart.getDataView(0).getSeries(0).getStyle().setLineColor(Color.red);
            int n2 = this.chart.getDataView(0).getNumSeries();
            ArrayList arrayList = rJHihChartData.getColorList();
            int n3 = n == 1 ? 1 : 0;
            for (int i = 0; i < n2; ++i) {
                Color color;
                this.chart.getDataView(0).getSeries(i).getStyle().getSymbolStyle().setShape(n3);
                if (i >= arrayList.size() || (color = (Color)arrayList.get(i)) == null) continue;
                this.chart.getDataView(0).getSeries(i).getStyle().setLineColor(color);
            }
            this.chart.update();
            if (this.chart.getDataView(1) != null) {
                this.chart.getDataView(1).setVisible(false);
            }
            if (rJHihChartData.getBarValues() != null) {
                RJHihChartBarModel rJHihChartBarModel = new RJHihChartBarModel(this.chart, rJHihChartData);
                this.volumeView.setDataSource((ChartDataModel)rJHihChartBarModel);
                this.chart.setDataView(1, this.volumeView);
                this.chart.getDataView(1).setVisible(true);
                for (int i = 0; i < n2; ++i) {
                    this.volumeView.getSeries(i).getStyle().setFillColor(this.chart.getDataView(0).getSeries(i).getStyle().getLineColor());
                }
            }
        } else {
            this.clearChart();
        }
    }

    public void clearChart() {
        this.chart.getChartArea().setVisible(false);
        this.chart.getLegend().setVisible(false);
    }

    public static int getValueCount(RJHihTimePair rJHihTimePair) {
        Date date = rJHihTimePair.getFromTime();
        Date date2 = rJHihTimePair.getToTime();
        long l = date2.getTime() - date.getTime();
        int n = (int)(l / (long)(rJHihTimePair.getIntervalTime() * 60 * 1000));
        System.out.println("plotcount = " + n);
        return n;
    }
}

